# Distractor Writing Guide

This reference provides detailed guidance on creating high-quality distractors (wrong answer options) for multiple-choice quiz questions.

## What Makes a Good Distractor?

Good distractors serve an educational purpose: they test understanding and reveal common misconceptions rather than just providing filler options.

### The Four Qualities of Effective Distractors

1. **Plausibility** - Seems reasonable to someone who hasn't mastered the content
2. **Educational Value** - Tests understanding or reveals misconceptions
3. **Discrimination** - Helps distinguish between different levels of knowledge
4. **Fairness** - Not trick questions or unfair traps

## Plausibility

### Definition

A plausible distractor is one that appears correct to someone who has not fully learned the material, but is clearly wrong to someone who has mastered it.

### Techniques for Creating Plausible Distractors

**1. Use Related Terminology**

❌ **Implausible:**
Question: "What is a learning graph?"
- A) A graph made of learned behavior
- B) A directed graph showing concept dependencies ✓
- C) A banana
- D) The alphabet

✓ **Plausible:**
- A) A graph showing student learning over time
- B) A directed graph showing concept dependencies ✓
- C) A taxonomy of educational objectives
- D) A visual representation of course grades

**2. Similar Length and Structure**

All options should be roughly the same length to avoid the "longest answer is correct" tell.

❌ **Implausible (length gives it away):**
- A) Yes ✓
- B) No
- C) Sometimes, depending on specific contextual factors and prerequisites
- D) Maybe

✓ **Plausible (balanced lengths):**
- A) When all prerequisites are met ✓
- B) When the instructor approves
- C) When the student requests it
- D) When the semester begins

**3. Grammatically Consistent**

All options should fit grammatically with the question stem.

❌ **Implausible (grammar mismatch):**
Question: "A learning graph is best described as..."
- A) map prerequisite relationships ✓
- B) showing relationships
- C) to organize
- D) visual

✓ **Plausible (grammatically parallel):**
Question: "A learning graph is best described as..."
- A) a structure that maps prerequisites ✓
- B) a tool that visualizes progress
- C) a system that organizes content
- D) a framework that sequences topics

## Educational Value

### Definition

An educationally valuable distractor addresses common misconceptions, tests related concepts, or helps differentiate between levels of understanding.

### Common Misconception Patterns

**1. Partial Truth (Correct in Different Context)**

This distractor is true but doesn't answer the specific question being asked.

Example:
Question: "What is the PRIMARY purpose of a learning graph?"
- A) To create visual aids for presentations
- B) To map prerequisite relationships ✓
- C) To assess student performance
- D) To organize course materials

Analysis: A, C, and D might be benefits or uses of learning-related tools, but B is the primary purpose.

**2. Reversal (Opposite or Inverse)**

This distractor reverses the correct relationship or concept.

Example:
Question: "In a learning graph, an arrow from Concept A to Concept B indicates..."
- A) Concept A must be learned before Concept B ✓
- B) Concept B must be learned before Concept A
- C) Concepts A and B are unrelated
- D) Concepts A and B are equivalent

Analysis: B is the opposite of the correct answer, testing whether students understand the direction of dependencies.

**3. Similar Terminology (Related but Distinct)**

Use terms from related concepts that students might confuse.

Example:
Question: "What structure prevents cycles in a learning graph?"
- A) Linked list
- B) Directed acyclic graph ✓
- C) Directed cyclic graph
- D) Undirected graph

Analysis: C is very similar to B but critically different (cyclic vs. acyclic).

**4. Common Student Error**

Based on typical misunderstandings or mistakes students make.

Example:
Question: "When should scaffolding be removed?"
- A) At the beginning of instruction
- B) Gradually as competence increases ✓
- C) Never, it should remain permanent
- D) Immediately after introduction

Analysis: A and D reflect a common misunderstanding that scaffolding should be removed too quickly. C reflects the opposite error.

---

## Discrimination

### Definition

Discriminating distractors help identify different levels of student understanding, from no knowledge to partial understanding to mastery.

### Levels of Distractor Discrimination

**No Knowledge → Partial Understanding → Mastery**

Create distractors that appeal to different knowledge levels:

**Example:**

Question: "What does ISO 11179 compliance require for glossary definitions?"

- A) Definitions must be in alphabetical order (No knowledge - confuses organization with quality)
- B) Definitions must be long and detailed (Partial understanding - knows definitions need detail but not the specific requirements)
- C) Definitions must be precise, concise, distinct, and non-circular ✓ (Mastery - knows the four criteria)
- D) Definitions must include examples (Partial understanding - knows examples are helpful but confuses with requirements)

**Knowledge Levels Tested:**
- **A** appeals to someone with no knowledge of ISO 11179
- **B** and **D** appeal to someone with partial understanding
- **C** requires mastery of the specific criteria

---

## Fairness

### Definition

Fair distractors test knowledge of the subject matter, not test-taking skills, reading comprehension, or trivial details.

### Unfair Distractor Patterns to Avoid

**1. Trick Questions**

❌ **Unfair:**
Question: "What is the BEST data structure for a learning graph?"
- A) Directed acyclic graph ✓
- B) Directed acyclic graph

Analysis: Having two identical options is a trick, not a test of knowledge.

**2. Trick Wording**

❌ **Unfair:**
Question: "Which of the following is NOT not important?"
- A) Prerequisites
- B) Dependencies ✓
- C) Scaffolding
- D) Examples

Analysis: Double negatives make this confusing and test reading comprehension rather than knowledge.

**3. "All of the Above" / "None of the Above"**

❌ **Avoid:**
- A) Learning graphs
- B) Concept dependencies
- C) Scaffolding
- D) All of the above

Why avoid: Reduces the question to binary (all vs. not all) rather than testing specific knowledge.

**Exception:** Can be used if it has educational value, but generally avoid.

**4. Overly Specific or Trivial Details**

❌ **Unfair:**
Question: "On what page of the textbook is the learning graph definition?"
- A) Page 42
- B) Page 45 ✓
- C) Page 48
- D) Page 51

Analysis: Tests memorization of trivial details, not understanding.

**5. Absolute Words**

❌ **Too obvious:**
- A) Learning graphs ALWAYS solve every educational problem
- B) Learning graphs NEVER have any issues
- C) Learning graphs can help organize concept dependencies ✓
- D) Learning graphs are COMPLETELY unnecessary

Analysis: "Always," "never," "completely" signal obviously wrong answers.

---

## Distractor Construction Patterns

### Pattern 1: Related Concepts

Use concepts from the same domain that students might confuse.

**Example (Educational Technology):**
Question: "What is a MicroSim?"
- A) A small-scale embedded simulation ✓
- B) A microscopic organism studied in biology
- C) A simulation of microprocessor operations
- D) A miniature physical model

All options contain "micro" and "sim" but only A is correct in context.

### Pattern 2: Partial Definitions

Take parts of the correct definition and combine with incorrect elements.

**Example:**
Correct definition: "A directed graph that maps prerequisite relationships between concepts"

Distractor options:
- "A directed graph that visualizes student progress" (right structure, wrong purpose)
- "An undirected graph that maps prerequisite relationships" (right purpose, wrong structure)
- "A directed list that shows learning order" (wrong structure, related purpose)

### Pattern 3: Degree or Extent

Vary the strength or extent of a statement.

**Example:**
Question: "How much of a chapter's concepts should be covered in a quiz?"
- A) 25-50%
- B) 50-75%
- C) 75-85% ✓
- D) 100%

All plausible, but C represents the recommended target.

### Pattern 4: Timing or Sequence

Vary when or in what order something occurs.

**Example:**
Question: "When should scaffolding begin to be removed?"
- A) Before instruction starts
- B) During initial instruction
- C) As competence develops ✓
- D) Long after mastery is achieved

---

## Quality Checklist

For each distractor, verify:

- [ ] **Plausible:** Would seem correct to someone who hasn't learned the material?
- [ ] **Educational:** Tests understanding or reveals misconception?
- [ ] **Grammatical:** Fits with question stem grammatically?
- [ ] **Appropriate Length:** Similar length to correct answer?
- [ ] **Fair:** Not a trick or trivial detail?
- [ ] **Distinct:** Doesn't overlap with other options?
- [ ] **Consistent Style:** Uses same terminology/voice as other options?
- [ ] **No Absolutes:** Avoids "always," "never," "all," "none" (unless correct)?

---

## Common Mistakes

### Mistake 1: Nonsensical Options

❌ "What is a learning graph?"
- A) Purple elephants dancing
- B) The number 42
- C) A directed graph showing concept dependencies ✓
- D) My grandmother's recipe

**Why wrong:** Not plausible, has no educational value, insults students.

### Mistake 2: One Distractor Much Longer

❌ "What is ISO 11179?"
- A) A car model
- B) A metadata registry standard that provides guidance for creating precise, concise, distinct, and non-circular definitions for use in glossaries and data dictionaries across organizations ✓
- C) A number
- D) A graph

**Why wrong:** Length signals the correct answer.

### Mistake 3: Multiple Correct Answers

❌ "Which is important for learning?"
- A) Prerequisites ✓
- B) Practice ✓
- C) Examples ✓
- D) Sleep ✓

**Why wrong:** All could be defended as correct, making question ambiguous.

### Mistake 4: Overlapping Options

❌ "What percentage is good concept coverage?"
- A) 50-70%
- B) 60-80% ✓
- C) 70-90%
- D) 80-100%

**Why wrong:** Options overlap; 70% could be B or C.

---

## Distractor Quality Score

Rate each distractor on a 0-1 scale:

**1.0 (Excellent):**
- Highly plausible
- Tests understanding
- Discriminates knowledge levels
- Fair and educational

**0.8 (Good):**
- Plausible
- Has educational value
- Fair
- Minor issues

**0.6 (Adequate):**
- Somewhat plausible
- Some educational value
- Fair but could be better

**0.4 (Poor):**
- Not very plausible
- Limited educational value
- May be slightly unfair

**0.2 (Very Poor):**
- Implausible
- No educational value
- Potentially unfair

**0.0 (Unacceptable):**
- Nonsensical
- Trick question
- Clearly unfair

**Overall Question Distractor Quality:**
Average the three distractor scores.

Target: 0.80+ average distractor quality

---

## Examples by Bloom's Level

### Remember Level

Good distractors use related terms or similar concepts.

Question: "What does DAG stand for?"
- A) Data Analysis Graph
- B) Directed Acyclic Graph ✓
- C) Digital Academic Guide
- D) Dynamic Assessment Grid

All distractors use the same initials with plausible terms.

### Understand Level

Good distractors test depth of understanding.

Question: "Why is a learning graph directed?"
- A) To make it look more professional
- B) To show which concepts depend on others ✓
- C) To save storage space
- D) To make it easier to draw

B requires understanding the purpose; others are plausible to non-learners.

### Apply Level

Good distractors present plausible but incorrect applications.

Question: "When creating a learning graph for a new course, what should you do first?"
- A) Draw the visual layout
- B) Choose graph visualization software
- C) Identify core concepts ✓
- D) Determine the color scheme

All sound like reasonable steps, but C must come first.

### Analyze Level

Good distractors require distinguishing between related elements.

Question: "What indicates a poorly structured learning graph?"
- A) More than 100 concepts
- B) Cycles in the dependency structure ✓
- C) Use of technical terminology
- D) Complex visual layout

Requires analyzing what makes a learning graph valid vs. invalid.

---

## Revision Strategies

If a distractor is too obvious or not plausible:

1. **Add specificity:** Make it more detailed and realistic
2. **Use domain terminology:** Incorporate correct vocabulary
3. **Base on misconceptions:** Research common student errors
4. **Check parallel structure:** Ensure grammatical consistency
5. **Adjust length:** Match other options
6. **Test plausibility:** Would a non-learner choose this?

---

## Final Advice

**The Golden Rule:**

> Every distractor should be something a reasonable student who hasn't learned the material might genuinely believe to be correct.

**The Educational Rule:**

> Every distractor should help you understand what the student does or doesn't know.

**The Fairness Rule:**

> Every distractor should test subject knowledge, not test-taking skills.
