# App Store Optimization Guidelines

## iOS App Store Character Limits

### Primary Metadata Fields
- **App Name**: 30 characters maximum
  - Most important for ASO ranking
  - Should include primary keyword
  - Examples: "Instagram - Photo & Video", "Spotify - Music & Podcasts"

- **Subtitle**: 30 characters maximum
  - Appears below app name in search
  - Good for secondary keywords
  - Examples: "Share your story", "Discover new music"

- **Keyword Field**: 100 characters maximum (not visible to users)
  - Comma-separated, no spaces after commas
  - No repeated words (already in name/subtitle)
  - Plurals often not needed (iOS includes automatically)
  - Example: "photo,edit,filter,collage,beauty,selfie,camera,pic"

- **Promotional Text**: 170 characters (not indexed)
  - Can be updated without new version
  - For announcements, sales, events

- **Description**: 4000 characters maximum (not indexed by App Store search)
  - First 2-3 lines crucial (visible without "more")
  - Focus on benefits, not features
  - Include social proof

### Screenshots & Preview Video
- First 2-3 screenshots most important
- Show key features and value proposition
- Preview video: first 3 seconds crucial

## Google Play Store Character Limits

### Primary Metadata Fields
- **App Title**: 30 characters maximum
  - Similar to iOS App Name
  - Include main keyword

- **Short Description**: 80 characters maximum
  - Appears in search results
  - Should entice clicks
  - Include primary keywords

- **Long Description**: 4000 characters maximum
  - IS indexed by Google Play search
  - First 250 characters visible without expansion
  - Use keywords naturally throughout
  - Format with bullet points, line breaks

### Feature Graphic & Screenshots
- Feature graphic appears in store listing
- At least 2 screenshots required
- First 2 most important

## Universal ASO Best Practices

### Keyword Strategy
1. **Primary Keywords** (1-3)
   - High volume, highly relevant
   - Goes in app name/title

2. **Secondary Keywords** (5-10)
   - Medium volume, relevant
   - Goes in subtitle/short description

3. **Long-tail Keywords** (10-20)
   - Lower volume, very specific
   - Goes in keyword field/long description

### Keyword Research Process
1. Brainstorm seed keywords
2. Analyze competitor keywords
3. Check search volume and difficulty
4. Identify keyword gaps
5. Test and iterate

### Localization Strategy
- Translate keywords, not just descriptions
- Research local search behavior
- Consider cultural differences
- Test performance per market

### Conversion Optimization
- Icon: Simple, recognizable, stands out
- Screenshots: Show value in first 2-3
- Reviews: Maintain 4.0+ rating
- Description: Clear value proposition in first lines

## Keyword Optimization Tips

### What Works
- Specific, descriptive terms
- Action verbs (edit, create, track)
- Problem-solving words (easy, fast, simple)
- Category-relevant terms

### What to Avoid
- Competitor names (against guidelines)
- Trademark violations
- Irrelevant keywords (hurts conversion)
- Keyword stuffing
- Special characters in keyword field

## Competitive Analysis Framework

### What to Analyze in Competitors
1. **Keyword Usage**
   - What keywords in title/subtitle?
   - Common themes across top apps?
   - Gaps in keyword coverage?

2. **Positioning**
   - What's their unique value proposition?
   - Which features do they highlight?
   - What's their target audience?

3. **Visual Strategy**
   - Icon style and colors
   - Screenshot approach
   - Video preview style

4. **Performance Indicators**
   - Rankings for target keywords
   - Number and quality of reviews
   - Update frequency

### Top Apps to Analyze
- Top 10 in your category
- Top 5 for each target keyword
- Direct competitors
- Aspirational competitors (next tier up)
