theme: Plain Jane, 1
footer: Simple Presentation Example
slidenumbers: true

---

# Welcome
## Creating Your First Deckset Presentation

---

## What You'll Learn

- Basic markdown syntax for slides
- How to structure content
- Working with lists and text
- Simple formatting techniques

^ This is a presenter note. It won't appear on the slide.
^ Remember to speak slowly and clearly.
^ Engage with the audience between points.

---

## Slide Basics

Use three dashes to separate slides:

```markdown
---
```

**Important**: Always include blank lines before and after!

---

## Headings

# Large Heading

## Regular Heading

### Small Heading

^ Use # for title slides
^ Use ## for regular slide titles
^ Use ### for subtitles and sections

---

## Text Formatting

You can make text **bold** or *italic*.

You can also combine them: ***bold italic***.

Use `inline code` for technical terms.

---

## Lists Work Great

- First point
- Second point
  - Sub-point with indent
  - Another sub-point
- Third point

^ Lists are perfect for key takeaways
^ Keep bullet points short and focused

---

## Numbered Lists Too

1. First step
2. Second step
3. Third step
   1. Sub-step
   2. Another sub-step

---

## Quotes

> "The best way to predict the future is to invent it."
> — Alan Kay

---

## Code Blocks

```python
def greet(name):
    return f"Hello, {name}!"

print(greet("Deckset"))
```

^ Code blocks support syntax highlighting
^ Great for technical presentations

---

## Links

Visit [Deckset](https://www.decksetapp.com) to learn more.

Or use a link with a title: [Deckset Documentation](https://docs.deckset.com "Official Docs")

---

## Tables

| Feature      | Benefit           | Priority |
|--------------|-------------------|----------|
| Simple       | Easy to learn     | High     |
| Fast         | Quick to create   | High     |
| Version Control | Git friendly   | Medium   |

---

## Emojis 🎉

You can use emojis in your presentations:

- ✅ Checkmarks for completed items
- 🚀 Rockets for launches
- 💡 Light bulbs for ideas
- 📊 Charts for data

Or type them: :smile: :tada: :rocket:

---

## Pro Tips

1. **Keep it simple** - Less is more
2. **One idea per slide** - Focus attention
3. **Use visuals** - Images speak louder than words
4. **Practice** - Rehearse with presenter notes
5. **Version control** - Use git for your .md files

^ These tips will help you create better presentations
^ Always test your slides before the actual presentation

---

# Questions?
## Thank you for watching!

---

## Additional Resources

- Official documentation: docs.deckset.com
- Keyboard shortcuts: ⌘K
- Rehearsal mode: ⌘R
- Export as PDF: ⌘E

^ Be prepared to answer questions about markdown
^ Have backup slides ready if needed
