# BTC 动能理论分析器 - 使用示例

本文档提供 btc-momentum-analyzer Skill 的实际使用示例。

---

## 目录

1. [基本用法](#基本用法)
2. [问答示例](#问答示例)
3. [典型场景](#典型场景)
4. [输出示例](#输出示例)

---

## 基本用法

### 示例 1：快速分析当前 BTC 动能

**你的问题**：
```
分析当前 BTC 的动能状态
```

**Skill 执行**：
1. 自动获取 8 个时间级别的最新数据（OKX API）
2. 计算所有指标（EMA26/52, MACD）
3. 进行嵌套动能分析
4. 生成完整报告

**预期输出**：
- 每个时间级别的线段状态
- 单位调整周期判断
- 背离检测结果
- 多时间级别联动总结
- 交易建议

---

### 示例 2：检查特定时间级别

**你的问题**：
```
BTC 1小时线段现在是上涨还是下跌？
```

**Skill 执行**：
- 获取 1h 数据
- 分析 DEA 与 0 轴关系
- 判断线段状态

**预期输出**：
```
【1小时级别】
线段状态：上涨线段
- DEA: +245.3 (0轴上方，确认上涨趋势)
- 线段持续时间：18 根 K 线
- EMA 排列：EMA26 > EMA52 (多头排列)
```

---

### 示例 3：检测背离

**你的问题**：
```
最近 50 根 K 线有没有 MACD 背离？
```

**Skill 执行**：
- 获取最近 50 根 1h K 线
- 运行背离检测算法（根据 THEORY.md 规则）
- 检测连续跳空背离、黄白线背离

**预期输出**：
```
【背离分析】

✓ 检测到黄白线顶背离
- 位置：K线 #42
- 类型：DIF 下穿 DEA（死叉）
- 特征：价格创新高，但 DIF 未创新高
- 解读：短期动能衰竭，警惕回调

✗ 未检测到连续跳空背离
```

---

### 示例 4：买点查询

**你的问题**：
```
现在 BTC 有买点吗？
```

**Skill 执行**：
- 获取多时间级别数据
- 根据 THEORY.md 中定义的买点规则进行判断
- 检查多时间级别联动条件

**预期输出**：
```
【买点分析】

✓ 检测到潜在买点（买点类型：线段确认买点）

触发条件确认：
1. 1h DEA 上穿 0 轴 ✓
2. EMA26 > EMA52 ✓
3. 4h 线段为上涨线段 ✓
4. 无黄白线顶背离 ✓

入场建议：
- 入场价位：当前价 97,500 附近
- 止损位：96,200 (EMA52 - 300)
- 止盈位 1：前高 99,000
- 止盈位 2：EMA26 破位

置信度：80% (高)
风险等级：中等
```

---

## 问答示例

### Q1：判断线段状态

**问题**：
```
BTC 现在是上涨线段还是下跌线段？
```

**回答示例**：
```
【多时间级别线段状态】

2日线：上涨线段 (DEA +1250)
1日线：上涨线段 (DEA +850)
12小时：上涨线段 (DEA +420)
6小时：过渡期 (DEA +180)
4小时：过渡期 (DEA +80)
2小时：下跌线段 (DEA -20) ⚠️
1小时：下跌线段 (DEA -35)
30分钟：下跌线段 (DEA -45)

综合判断：大周期多头，小周期回调
建议：等待小周期企稳后顺大周期做多
```

---

### Q2：单位调整周期

**问题**：
```
BTC 1小时现在处于第几个单位调整周期？
```

**回答示例**：
```
【1小时级别 - 单位调整周期分析】

当前线段：上涨线段（从 K线 #10 开始）

周期编号：第 2 个单位调整周期

第 1 个周期（K线 #10-22）：
- Histogram 从 +10 扩张至 +55（峰值）
- 然后收缩至 +18
- 持续时间：13 根 K 线

第 2 个周期（K线 #23-当前）：
- Histogram 从 +18 再次扩张
- 当前值：+42
- 持续时间：6 根 K 线（进行中）

特征：第 2 个周期的扩张幅度弱于第 1 个周期，需警惕动能衰竭
```

---

### Q3：分立调控检测

**问题**：
```
检测 BTC 6小时是否有分立调控
```

**回答示例**：
```
【6小时级别 - 分立调控分析】

✓ 检测到分立调控

位置：K线 #18-23（共 6 根 K 线）

模式特征：
- K线 #18: Histogram +45 (正柱)
- K线 #19: Histogram +30 (收缩)
- K线 #20: Histogram +38 (反弹)
- K线 #21: Histogram +25 (再次收缩)
- K线 #22: Histogram +32 (再次反弹)
- K线 #23: Histogram +20 (持续收缩)

解读：市场在高位出现犹豫，多空争夺激烈，需警惕线段即将转换
```

---

### Q4：时间级别联动

**问题**：
```
分析 BTC 1小时和 4小时的联动关系
```

**回答示例**：
```
【1小时 vs 4小时 联动分析】

4小时（上级周期）：
- 线段：上涨线段
- DEA: +380
- 单位周期：第 2 个
- 趋势：向上但动能减弱

1小时（下级周期）：
- 线段：下跌线段 ⚠️
- DEA: -35
- 单位周期：第 1 个（下跌刚开始）

联动关系：矛盾状态
- 4h 上涨，1h 下跌
- 解读：4h 的第 2 个周期出现正常回调，1h 体现为下跌线段

建议：
1. 如果 1h DEA 在 -50 附近止跌反弹，确认为 4h 的浅回调，可顺 4h 做多
2. 如果 1h DEA 继续下探至 -100 以下，需警惕 4h 线段即将转换为下跌
```

---

## 典型场景

### 场景 1：多周期共振买点

**问题**：
```
给我一个详细的 BTC 买点分析
```

**完整输出示例**：
```
=========================
BTC 动能分析报告 - 买点分析
分析时间: 2025-12-10 17:00:00
=========================

## 当前市场状态

【大周期】(2日线 - 1日线)
✓ 上涨线段确认
- 2日线：处于第 2 个单位调整周期，强势上涨
- 1日线：处于第 1 个单位调整周期，上涨初期

【中周期】(12h - 6h - 4h)
✓ 上涨线段
- 12h：无背离，动能健康
- 6h：无分立调控，趋势稳定
- 4h：EMA26 > EMA52，多头排列

【小周期】(2h - 1h - 30m)
✓ 小周期调整结束，即将反转
- 2h：DEA 从 -50 回升至 -20
- 1h：DEA 即将上穿 0 轴（当前 -5）
- 30m：已确认上涨线段

---

## 买点信号

✓ 检测到高置信度买点

买点类型：多周期共振买点（参考 THEORY.md）

触发条件确认：
1. 大周期（2日线、1日线）：上涨线段 ✓
2. 中周期（4h）：上涨线段 ✓
3. 小周期（1h）：即将上穿 0 轴 ✓
4. 多周期共振：3 个级别同时看多 ✓
5. 无重大背离：各级别无顶背离 ✓

---

## 入场策略

建议操作：做多（Long）

入场时机：
- 最佳：1h DEA 确认上穿 0 轴后 1-2 根 K 线内
- 备选：价格回踩 EMA26 支撑位入场

入场价位：
- 主要价位：97,500 (当前价)
- 备选价位：97,200 (EMA26 支撑)

仓位管理：
- 初始仓位：账户的 15%（中等仓位）
- 加仓条件：4h 突破前高时加 5%

止损设置：
- 止损价位：96,200 (EMA52 - 300)
- 止损幅度：1.3%
- 止损类型：收盘价跌破

止盈设置：
- 止盈 1：99,000 (前高压力位)，平仓 50%
- 止盈 2：100,500 (心理关口)，平仓 30%
- 止盈 3：EMA26 破位，平仓剩余 20%

---

## 风险提示

1. 12h 级别处于第 2 个单位调整周期，需警惕大周期回调
2. 1h DEA 尚未确认上穿 0 轴，存在假突破风险
3. 建议等待 1h 收盘确认后入场

---

## 置信度评估

总体置信度：85% (高)

评分依据：
- 大周期趋势：+30%
- 中周期共振：+25%
- 小周期反转确认：+20%
- 无背离风险：+10%

风险等级：中等

---

## 监控指标

入场后需重点关注：
1. 1h DEA 是否稳定在 0 轴上方
2. 4h Histogram 是否持续扩张
3. 12h 是否出现黄白线背离

=========================
报告生成时间: 2025-12-10 17:00:15
数据来源: OKX API
理论依据: THEORY.md
=========================
```

---

### 场景 2：背离预警

**问题**：
```
检测 BTC 是否有背离信号
```

**输出示例**：
```
【多时间级别背离扫描】

⚠️ 检测到 2 个背离信号

---

1. 黄白线背离（12小时级别）

类型：顶背离（死叉背离）
位置：K线 #45
确认状态：已确认 3 根 K 线

特征：
- DIF 下穿 DEA（死叉）
- 价格创新高 99,500
- DIF 未创新高（前高点 DIF 更高）
- Histogram 由正转负

市场含义：12h 动能转弱，短期可能回调
影响范围：4h, 2h, 1h 级别

建议：
- 多单持有者：考虑部分止盈
- 空单观望者：等待小周期确认后入场

---

2. 连续跳空背离（4小时级别）

类型：负向连续跳空 + 价格背离
位置：K线 #22-25
确认状态：进行中

特征：
- Histogram 连续 4 根 K 线负向跳空
- 跳空幅度：[-8, -12, -15, -10]
- 价格仍在高位震荡
- DEA 仍 > 0 但快速下降

市场含义：动能急速衰竭，可能是顶部信号
影响范围：2h, 1h, 30m 级别

建议：
- 立即减仓或平仓多单
- 等待 4h 线段转为下跌后考虑做空

---

综合判断：
- 中大周期（12h, 4h）出现明显背离信号
- 小周期尚未确认反转
- 建议：降低多单仓位，观望为主
```

---

## 输出示例

### 简化报告（--detail simple）

```
【BTC 动能快速扫描】

大周期：上涨 (2d ✓, 1d ✓)
中周期：调整 (12h ⚠️, 6h ⚠️, 4h ✗)
小周期：下跌 (2h ✗, 1h ✗, 30m ✗)

背离：12h 黄白线顶背离 ⚠️

建议：观望（大周期多头，小周期回调）

置信度：60%
```

---

### JSON 格式输出（--format json）

```json
{
  "symbol": "BTC-USDT",
  "analysis_time": "2025-12-10 17:00:00",
  "timeframes": {
    "2d": {
      "segment": "uptrend",
      "dea": 1250.3,
      "cycle_number": 2,
      "divergence": null
    },
    "1h": {
      "segment": "downtrend",
      "dea": -35.8,
      "cycle_number": 1,
      "divergence": null
    }
  },
  "multi_timeframe_summary": {
    "large_cycle": "uptrend",
    "medium_cycle": "adjustment",
    "small_cycle": "downtrend",
    "resonance": false
  },
  "signals": {
    "buy": null,
    "sell": null,
    "wait": {
      "reason": "small cycle pullback in large uptrend",
      "confidence": 0.6
    }
  }
}
```

---

## 常见问题

### Q：Skill 何时自动激活？

包含以下关键词时自动激活：
- BTC 动能、比特币动能
- 上涨线段、下跌线段
- MACD 分析、背离
- 买点、卖点、交易信号
- 单位调整周期、分立调控

### Q：如何获取更详细的分析？

在问题中明确要求：
```
给我一个完整的 BTC 动能分析，包含所有时间级别和详细判断
```

### Q：分析需要多长时间？

- 数据获取：5-10 秒（8 个时间级别）
- 指标计算：2-3 秒
- 动能分析：3-5 秒
- 总计：约 10-20 秒

### Q：数据有延迟吗？

- OKX API 数据延迟：1-2 秒
- 分析基于最新收盘价，不包含当前未完成 K 线

---

## 进阶使用

### 自定义分析参数

如果 THEORY.md 中定义了可调参数，可以在问题中指定：

```
分析 BTC 动能，使用更严格的背离检测参数
```

Skill 会根据你的要求调整参数（如果 THEORY.md 支持）。

### 历史回测

```
回测 2025-10 月的 BTC 动能表现
```

（需要手动导出历史数据到 data/ 目录）

---

## 反馈和改进

如果 Skill 的分析结果与你的预期不符：

1. 检查 THEORY.md 是否完整填写
2. 确认你的动能理论规则是否明确
3. 根据实盘表现调整 THEORY.md 中的参数

Skill 会严格按照 THEORY.md 中定义的规则执行分析，不会添加任何主观判断。
