---
name: btc-momentum-analyzer
description: 使用自定义动能理论分析 BTC 市场，多时间级别嵌套分析（2日线/1日/12h/6h/4h/2h/1h/30min），识别上涨线段、下跌线段、分立调控、单位调整周期、连续跳空背离、黄白线背离，生成包含详细属性判断的动能报告和交易信号。当用户询问 BTC 动能、线段状态、MACD 分析、周期判断、背离检测时自动激活。
allowed-tools: Read, Bash, Grep
---

# BTC 动能理论分析器

## 功能概述

本 Skill 实现基于 MACD 的多时间级别嵌套动能理论分析系统，提供：

1. **多时间级别数据获取**: 从 OKX API 获取 8 个时间级别的 BTC K线数据
   - 2日线 (2d), 1日线 (1d), 12小时 (12h), 6小时 (6h)
   - 4小时 (4h), 2小时 (2h), 1小时 (1h), 30分钟 (30m)

2. **技术指标计算**:
   - EMA26, EMA52（短期和中期趋势线）
   - MACD(12, 26, 9): DIF（黄线）, DEA（白线）, Histogram（柱状图）

3. **线段分类**: 每个时间级别的市场状态识别
   - 上涨线段（DEA > 0）
   - 下跌线段（DEA < 0）
   - 过渡期和突破尝试

4. **动能理论分析**（详见 THEORY.md）:
   - **单位调整周期**：判断处于第几个调整周期
   - **分立调控**：检测离散的动能调整模式
   - **连续跳空背离**：价格与柱状图的背离 + 跳空
   - **黄白线背离**：DIF 与 DEA 的背离检测
   - **隐形信号**：隐藏的动能变化

5. **多时间级别联动**:
   - 上级周期对下级周期的影响
   - 多周期共振确认
   - 嵌套关系的递归分析

6. **交易信号生成**:
   - 买卖点识别（规则定义在 THEORY.md）
   - 止损止盈建议
   - 置信度评估

## 动能理论体系

完整的理论定义请参考 [THEORY.md](THEORY.md)，包括：

- 上涨线段 / 下跌线段的精确定义
- 单位调整周期的识别方法
- 分立调控的检测算法
- 连续跳空背离的判断标准
- 黄白线背离的分析规则
- 买点 / 卖点的触发条件
- 时间级别联动的分析框架

**重要**：所有交易参数、阈值、规则均在 THEORY.md 中定义，本 Skill 不包含硬编码的交易逻辑。

## 使用指南

### 一键分析（推荐）

Claude 会自动执行完整的分析流程，你只需提问：

**示例问题**：
- "分析当前 BTC 的动能状态"
- "BTC 现在处于哪个单位调整周期？"
- "检测 BTC 多时间级别的背离情况"
- "BTC 有买点吗？给我详细分析"

Skill 会自动：
1. 获取 8 个时间级别的实时数据（OKX API）
2. 计算所有指标（EMA26/52, MACD）
3. 进行嵌套动能分析
4. 生成详细报告

### 手动执行步骤（高级用户）

如需手动控制分析流程，可按以下步骤执行：

#### 第一步：获取多时间级别数据

```bash
python3 /Users/adrian/Desktop/BA/MACD/.claude/skills/btc-momentum-analyzer/scripts/fetch_btc_data.py \
  --symbol BTC-USDT \
  --timeframes 2d,1d,12h,6h,4h,2h,1h,30m \
  --limit 200 \
  --exchange okx
```

参数说明：
- `--symbol`: 交易对（OKX 格式：BTC-USDT）
- `--timeframes`: 逗号分隔的时间级别列表
- `--limit`: 每个时间级别获取的 K 线数量
- `--exchange`: 交易所（okx, binance, bybit）

输出：JSON 文件，包含所有时间级别的 OHLCV 数据

#### 第二步：计算技术指标

```bash
python3 /Users/adrian/Desktop/BA/MACD/.claude/skills/btc-momentum-analyzer/scripts/calculate_indicators.py \
  /Users/adrian/Desktop/BA/MACD/data/btc_multi_timeframe.json \
  --ema-periods 26,52 \
  --macd-params 12,26,9
```

输出：带有 EMA 和 MACD 指标的注释数据

#### 第三步：动能理论分析

```bash
python3 /Users/adrian/Desktop/BA/MACD/.claude/skills/btc-momentum-analyzer/scripts/analyze_momentum.py \
  /Users/adrian/Desktop/BA/MACD/data/btc_indicators.json \
  --theory-file /Users/adrian/Desktop/BA/MACD/.claude/skills/btc-momentum-analyzer/THEORY.md
```

输出：
- 每个时间级别的线段分类
- 单位调整周期判断
- 分立调控检测结果
- 背离分析（连续跳空背离、黄白线背离）
- 多时间级别联动关系

#### 第四步：生成交易报告

```bash
python3 /Users/adrian/Desktop/BA/MACD/.claude/skills/btc-momentum-analyzer/scripts/generate_report.py \
  /Users/adrian/Desktop/BA/MACD/data/btc_analysis.json \
  --format text \
  --detail full
```

输出：结构化的多时间级别嵌套分析报告

## 典型输出示例

### 完整动能分析报告

```
=========================
BTC 动能理论分析报告
分析时间: 2025-12-10 16:30:00 UTC
=========================

## 多时间级别嵌套分析

【2日线级别】
线段状态: 上涨线段
- DEA: +1250.3 (0轴上方，强势多头)
- DIF: +1580.7
- Histogram: +330.4 (持续扩张)
- 线段持续时间: 8 根 K 线
- EMA 排列: EMA26 (98,500) > EMA52 (96,200) ✓
- 单位调整周期: 第 2 个周期
- 周期间背离: 无
- 黄白线背离: 无（DIF 和 DEA 同向上升）

【1日线级别】
线段状态: 上涨线段
- DEA: +850.5 (0轴上方)
- DIF: +920.3
- Histogram: +69.8 (正柱，动能减弱)
- 线段持续时间: 12 根 K 线
- EMA 排列: EMA26 (98,200) > EMA52 (96,800) ✓
- 单位调整周期: 第 1 个周期
- 周期间背离: 无
- 黄白线背离: ⚠️ 轻微背离（价格新高，DIF 未新高）
- 与上级关系: 与 2日线 共振向上

【12小时级别】
线段状态: 上涨线段
- DEA: +420.8
- DIF: +380.2
- Histogram: -40.6 (负柱，动能转弱)
- 线段持续时间: 18 根 K 线
- EMA 排列: EMA26 (98,100) > EMA52 (97,200) ✓
- 单位调整周期: 第 2 个周期
- 周期间背离: ✓ 检测到背离（第1周期高点 vs 第2周期）
- 黄白线背离: ✓ 顶背离（DIF 下穿 DEA，死叉）
- 分立调控: 无
- 与上级关系: 1日线 上涨，但 12h 动能衰竭

【6小时级别】
线段状态: 过渡期（上涨线段后调整）
- DEA: +180.3
- DIF: +120.5
- Histogram: -59.8 (负柱，回调)
- 线段持续时间: 6 根 K 线（过渡期）
- EMA 排列: EMA26 (97,800) < EMA52 (97,850) ✗ (短期破位)
- 单位调整周期: N/A（处于过渡期）
- 分立调控: ✓ 检测到（第 3-5 根 K 线出现离散调整）
- 与上级关系: 12h 背离警告，6h 进入调整

【4小时级别】
线段状态: 过渡期
- DEA: +80.2
- DIF: +50.1
- Histogram: -30.1
- 线段持续时间: 10 根 K 线
- EMA 排列: EMA26 (97,600) < EMA52 (97,700) ✗
- 连续跳空背离: 无
- 黄白线背离: ✓ 死叉背离
- 与上级关系: 6h 调整延续至 4h

【2小时级别】
线段状态: 下跌线段（警告）
- DEA: -20.5 (已下穿 0 轴)
- DIF: -45.3
- Histogram: -24.8
- 线段持续时间: 4 根 K 线
- EMA 排列: EMA26 (97,400) < EMA52 (97,650) ✗
- 单位调整周期: 第 1 个周期（下跌段开始）
- 与上级关系: 4h 调整转为 2h 下跌

【1小时级别】
线段状态: 下跌线段
- DEA: -35.8
- DIF: -50.2
- Histogram: -14.4
- 线段持续时间: 8 根 K 线
- EMA 排列: EMA26 (97,350) < EMA52 (97,550) ✗
- 单位调整周期: 第 1 个周期
- 连续跳空背离: 无
- 黄白线背离: 无（同向下跌）
- 与上级关系: 2h 下跌延续至 1h

【30分钟级别】
线段状态: 下跌线段
- DEA: -45.2
- DIF: -55.8
- Histogram: -10.6
- 线段持续时间: 12 根 K 线
- EMA 排列: EMA26 (97,300) < EMA52 (97,500) ✗
- 单位调整周期: 第 1 个周期
- 隐形信号: ⚠️ 柱状图收敛（可能即将反转）
- 与上级关系: 1h 下跌延续

---

## 多时间级别联动总结

【大周期趋势】(2日线 - 1日线)
✓ 上涨线段确认
- 2日线 处于第 2 个单位调整周期，强势上涨
- 1日线 出现轻微黄白线背离，需警惕

【中周期调整】(12h - 6h - 4h)
⚠️ 调整期
- 12h 检测到周期间背离 + 黄白线死叉背离
- 6h 发现分立调控，进入过渡期
- 4h 延续调整，动能持续减弱

【小周期下跌】(2h - 1h - 30m)
✗ 短期下跌
- 2h 已确认下跌线段（DEA 下穿 0 轴）
- 1h, 30m 延续下跌，但 30m 出现柱状图收敛（隐形反转信号）

---

## 交易信号与建议

【当前市场状态】
多空分歧：大周期多头 vs 小周期空头

【买点分析】
❌ 不建议立即开多单
原因：
1. 12h 级别出现明显顶背离（价格新高，DIF 未新高）
2. 6h 检测到分立调控，市场处于调整期
3. 2h/1h 已确认下跌线段，短期趋势向下
4. 需等待小周期企稳后再考虑入场

【潜在买点触发条件】（参考 THEORY.md 规则）
1. 30m 级别 DEA 上穿 0 轴，确认反转
2. 1h 级别 EMA26 重新上穿 EMA52
3. 2h 级别调整结束，与 4h 恢复共振
4. 大周期 1日线、2日线 保持上涨线段

【卖点分析】
⚠️ 空单风险提示
原因：
1. 大周期（2日线、1日线）仍处于强势上涨线段
2. 当前下跌可能只是大周期的正常回调
3. 30m 柱状图收敛，可能即将反弹

【建议操作】
观望为主，等待以下情况之一：
1. 30m 反转信号确认 → 小仓位做多（顺大周期）
2. 2h DEA 继续下穿至 -100 以下 → 考虑短线空单
3. 1日线 DEA 下穿 0 轴 → 大周期转向，谨慎做空

【风险等级】: 中等
【置信度】: 60% (观望建议)

---

## 关键监控指标

1. **30分钟 Histogram**: 收敛后是否放量反转
2. **2小时 DEA**: 是否继续下探或企稳
3. **12小时 黄白线**: 背离后是否形成新的多头排列
4. **1日线 EMA26/EMA52**: 是否保持多头排列

=========================
报告生成时间: 2025-12-10 16:30:12 UTC
数据来源: OKX API
理论依据: THEORY.md (用户自定义动能理论)
=========================
```

## 数据来源说明

### OKX API

本 Skill 使用 OKX 交易所的免费公开 API：

**优势**：
- 免费，无需 API Key（公开数据）
- 支持所有需要的时间级别（2d, 1d, 12h, 6h, 4h, 2h, 1h, 30m）
- 数据质量高，延迟低
- 限制：20 请求/2秒

**API 端点**：
```
https://www.okx.com/api/v5/market/candles
```

**时间级别映射**：
- 2d → `2D`
- 1d → `1D`
- 12h → `12H`
- 6h → `6H`
- 4h → `4H`
- 2h → `2H`
- 1h → `1H`
- 30m → `30m`

### 备用数据源

1. **本地缓存**：
   - 位置：`/Users/adrian/Desktop/BA/MACD/data/btc_cache_{timeframe}.json`
   - 缓存有效期：根据时间级别动态调整（30m 缓存 5 分钟，2d 缓存 1 小时）

2. **Binance API**（降级）：
   - 如果 OKX API 不可用，自动切换
   - 注意：Binance 的时间级别名称略有不同

3. **手动导出**：
   - 从 TradingView 或其他平台导出 CSV
   - 放置在 `data/` 目录
   - 脚本可自动识别并解析

## 输出格式

### 文本报告（默认）

结构化的多时间级别嵌套报告，包含：
- 每个时间级别的详细分析
- 线段状态、单位周期、背离检测
- 多时间级别联动总结
- 交易信号和操作建议
- 关键监控指标

### JSON 报告

```bash
--format json
```

机器可读格式，适合进一步处理或存储。

### 简化报告

```bash
--detail simple
```

仅包含关键信息和交易建议，适合快速查看。

## 分析深度控制

根据需要调整分析的详细程度：

### 完整分析（默认）

```bash
python3 scripts/analyze_momentum.py data.json --detail full
```

包含所有 8 个时间级别的完整分析

### 重点分析

```bash
python3 scripts/analyze_momentum.py data.json --focus 1h,4h,1d
```

仅分析指定的时间级别，但仍考虑上下级联动关系

### 快速扫描

```bash
python3 scripts/analyze_momentum.py data.json --mode quick
```

仅输出当前线段状态和关键信号，跳过详细分析

## 错误处理

脚本内置多层错误处理：

1. **API 限流**：自动等待并重试
2. **网络错误**：自动重试 3 次，失败后降级到缓存
3. **数据缺失**：跳过缺失的时间级别，记录警告
4. **计算异常**：返回 null 值，不中断流程
5. **THEORY.md 解析错误**：使用默认规则并警告用户

## 性能优化

1. **并行获取数据**：8 个时间级别并行请求，缩短等待时间
2. **增量更新**：只获取新增 K 线，减少数据传输
3. **智能缓存**：根据时间级别动态设置缓存过期时间
4. **懒加载**：仅在需要时计算详细指标

## 相关文件

- **[THEORY.md](THEORY.md)** - 动能理论完整定义（核心，需用户填写）
- **[EXAMPLES.md](EXAMPLES.md)** - 使用示例和问答
- [MACD.pine](/Users/adrian/Desktop/BA/MACD/MACD.pine) - 参考的 Pine Script 策略（仅供参考）
- [README.md](/Users/adrian/Desktop/BA/MACD/README.md) - 原有策略文档

## 支持的问题类型

本 Skill 会在检测到以下关键词时自动激活：

**动能分析类**：
- "BTC 动能"、"比特币动能状态"
- "分析 BTC"、"BTC 行情分析"

**线段和周期类**：
- "上涨线段"、"下跌线段"、"线段状态"
- "单位调整周期"、"第几个周期"
- "周期间背离"

**背离和信号类**：
- "连续跳空背离"、"柱状图背离"
- "黄白线背离"、"DIF DEA 背离"
- "分立调控"、"隐形信号"

**交易相关**：
- "买点"、"卖点"、"交易信号"
- "开多"、"开空"、"止损"

**时间级别**：
- "1小时"、"4小时"、"日线"
- "多时间级别"、"时间级别联动"

## 限制和注意事项

1. **THEORY.md 必须完善**：
   - 本 Skill 不包含任何硬编码的交易逻辑
   - 所有规则、参数、阈值均从 THEORY.md 读取
   - 如果 THEORY.md 不完整，分析结果可能不准确

2. **数据延迟**：
   - OKX API 数据可能有 1-2 秒延迟
   - 大周期（2日线）数据更新较慢

3. **指标精度**：
   - Python 计算的 MACD 与 TradingView 可能有微小差异
   - EMA 初始值计算方式需与你的理论一致

4. **API 限制**：
   - OKX: 20 请求/2秒
   - 8 个时间级别 = 8 个请求，约 1 秒完成

5. **风险提示**：
   - 本 Skill 仅提供分析参考，不构成投资建议
   - 多时间级别可能出现矛盾信号，需综合判断

## 维护和更新

- **脚本位置**：`.claude/skills/btc-momentum-analyzer/scripts/`
- **理论更新**：修改 THEORY.md 后立即生效，无需重启
- **参数调整**：所有参数在 THEORY.md 中配置
- **版本控制**：通过 git 提交更新，团队成员自动同步

## 下一步

1. **完善 THEORY.md**：
   - 定义所有动能理论概念
   - 指定买卖点触发条件
   - 配置所有阈值和参数

2. **测试数据获取**：
   ```bash
   python3 scripts/fetch_btc_data.py --symbol BTC-USDT --timeframes 1h --limit 10
   ```

3. **验证指标计算**：
   - 对比 Python 计算结果与 TradingView
   - 确保 EMA26/52 和 MACD 数值一致

4. **完整分析测试**：
   - 运行完整分析流程
   - 检查报告格式和内容
   - 根据实际交易经验调整 THEORY.md

---

**重要提示**：本 Skill 的核心是 THEORY.md，请务必完整填写该文件中的所有规则和定义。Skill 会严格按照你定义的理论进行分析，不会添加任何主观判断。
