# BTC 动能理论体系

> **重要**：本文件定义了 BTC 动能分析的完整理论框架。所有分析脚本都会读取此文件中的规则和参数。请根据你的交易系统完整填写所有章节。

---

## 目录

1. [核心原理](#核心原理)
2. [基础概念定义](#基础概念定义)
   - 上涨线段
   - 下跌线段
   - 过渡期
3. [高级概念定义](#高级概念定义)
   - 单位调整周期
   - 分立跳空
   - 连续跳空
   - 隐形信号
   - 击破跳空
   - 归零轴
4. [背离分析](#背离分析)
   - 连续跳空背离
   - 分立跳空背离
   - 黄白线背离
5. [买卖点规则](#买卖点规则)
6. [时间级别联动](#时间级别联动)
7. [参数配置](#参数配置)

---

## 核心原理

### MACD 动力学本质

> K 线动能理论的本质是比较发现背离,而判断每个时间级别MACD归零轴的时候是否可以产生有效的反弹还是穿零轴
核心要素: 
1. 任何时候 DIF DEA 一旦远离零轴就有可能产生回归零轴的动力
2. DIF DEA 远离零轴的距离决定了回归零轴反弹的力度
3. 柱状图的连续变化揭示动能的持续性和衰竭

### 线段理论与 MACD 的关系

> 线段是市场趋势的基本单元，通过 MACD 的 DEA 指标与 0 轴的关系来定义：
```
上涨线段 = DEA 持续在 0 轴上方 + [DEA 慢线稍微穿过0轴 但马上收回仍然可以仍为是上涨线段]
下跌线段 = DEA 持续在 0 轴下方 + [DEA 慢线稍微穿过0轴 但马上收回仍然可以仍为是下跌线段]
线段内部包含多个"单位调整周期"，每个周期代表一次动能的释放和调整过程。
```


## 基础概念定义

### 1. 上涨线段

#### 定义

```
上涨线段是指 MACD 的 DEA（白线）上穿 0 轴，并满足以下条件的市场阶段：

必要条件：
1. DEA > 0（必须）
2. [持续时间 >= N 根 K 线,N 根据时间级别进行调整, 大大时间级别N较小, 较小时间级别N 较大]
3. [条件2:DEA 慢线稍微穿过0轴 但马上收回仍然可以仍为是上涨线段, 这个需要进行一些模糊处理,一半情况下慢线的数值不要比柱高高]

```

#### 识别算法

>  不要有确认的代码去判断, 你根据MACD 的形态进行判断. DEA> 0 and  持续[N]根k线不破一定是上涨线段, 但是有一些特殊情况需要考虑, 例如DEA 慢线稍微穿过0轴 但马上收回仍然可以仍为是上涨线段


#### 子阶段划分（可选）

上涨线段可细分为：
1. 初期加速阶段：DEA 刚上穿 0 轴，Histogram 快速扩张
2. 中期持续阶段：DEA 稳定在高位，Histogram 波动但保持正值
3. 晚期衰竭阶段：DEA 仍 > 0，但 Histogram 开始收缩, DEA 数值缩小

### 2. 下跌线段

#### 定义

> 下跌线段是指 MACD 的 DEA（白线）下穿 0 轴，并满足以下条件的市场阶段：

必要条件：
1. DEA < 0（必须）
2. [持续时间 >= N 根 K 线,N 根据时间级别进行调整, 大大时间级别N较小, 较小时间级别N 较大]
3. [条件2:DEA 慢线稍微穿过0轴 但马上收回仍然可以仍为是下跌线段, 这个需要进行一些模糊处理,一半情况下慢线DEA的数值不要比柱高高]

#### 识别算法

> 不要有确认的代码去判断, 你根据MACD 的形态进行判断. DEA < 0 and  持续N根k线不破一定是下跌线段, 但是有一些特殊情况需要考虑, 例如DEA 慢线稍微穿过0轴 但马上收回仍然可以仍为是下跌线段


### 3. 过渡期

#### 定义

> 过渡期是指从一个线段转向另一个线段的中间状态：
```
上涨 → 下跌的过渡期：
- 触发：DEA 下穿 0 轴
- 持续时间：[N] 根 K 线
- 特征：[当DEA 超过 柱高的时候确认为下跌线段], [当DEA 具有一定高度的时候,确认为上涨线段]

下跌 → 上涨的过渡期：
- 触发：DEA 上穿 0 轴
- 持续时间：[M] 根 K 线
- 特征：[当DEA 超过 柱高的时候确认为上涨线段], [当DEA 具有一定高度的时候,确认为下跌线段]
```


---

## 高级概念定义

### 1. 单位调整周期 unit

#### 定义

> 单位调整周期是指在一个上涨线段 or 下跌线段内部，从DEA穿零轴开始到DEA再次穿零轴的完整过程，期间可包含多个子周期。

识别标准（**正确定义**）：
1. **第一个单位调整周期（Unit 1）**：
   - 起点：DEA 穿过零轴（上穿或下穿，取决于线段方向）
   - 进行中：价格运行，MACD柱状图扩张-收缩-再扩张
   - 转折点：**当价格触及到 EMA52 附近的时候**

2. **第二个单位调整周期（Unit 2）**：
   - 起点：价格触及 EMA52 附近（第一个 unit 的终点）
   - 进行中：价格继续运行，MACD柱状图继续波动
   - 终点：**DEA 再次穿过零轴**（线段结束）

3. **关键识别要素**：
   - Unit 1 → Unit 2 的分界点：**价格接近 EMA52**（不是基于histogram峰值数量）
   - 整个线段通常包含 1-2 个 unit
   - Unit 编号从 1 开始，不是基于柱状图峰值计数



#### 周期编号规则

> 如何判断当前处于第几个周期？

**正确识别方法**：
```
从穿零轴开始是第一个单位调整周期，然后当价格触及到EMA52附近的时候第二个单位调整周期开始，直到慢线DEA再次穿过零轴。

具体判断步骤：
1. 找到DEA穿零轴的时间点 → Unit 1 开始
2. 观察价格是否触及EMA52附近：
   - 如果未触及EMA52 → 仍在 Unit 1
   - 如果已触及EMA52 → 进入 Unit 2
3. 观察DEA是否再次穿零轴：
   - 如果DEA未穿零轴 → 仍在当前线段
   - 如果DEA穿零轴 → 线段结束

第 1 个周期的特征：
- DEA刚穿零轴，动能建立初期
- 价格尚未触及EMA52
- 通常柱状图会有较强的扩张

第 2 个周期的特征（如果出现）：
- 价格已触及EMA52附近
- DEA尚未穿零轴，线段延续
- 可能出现动能背离（第二个unit的黄白线高度小于第一个unit）

注意：不是所有线段都有第二个unit，大部分线段在Unit 1完成后DEA就穿零轴结束了
```


###  2. 分立跳空

#### 定义

> 分立调控是指 MACD 柱状图在调整过程中，出现与线段反向的量能柱之后,再次产生与线段相同方向的量能柱

典型特征：
1. Histogram 呈现"同向量能柱收缩-放出反向量能柱-再次出现同向量能柱"的锯齿状
2. [你补充的其他特征]

与"连续跳空"的区别：
- 连续跳空：没有反向的量能柱
- 分立跳空：中间夹杂反向量能柱

市场含义：
分立跳空 + 量能堆与对比不背离 通常表示 [DEA 在unit调整周期内获得了新的动能支持，可能延续当前线段趋势]
分立跳空 + 量能堆与对比背离 + 位于第一个unit 通常表示 [动能衰竭，具有归零轴的需求]
分立跳空 + 量能堆与对比背离 + 位于第二个unit 通常表示 [动能极度衰竭，极有可能穿零轴变盘]


### 3. 连续跳空

#### 定义

> 连续跳空是指 MACD 柱状图在连续的 K 线上出现显著的数值跳跃（gap），且跳空方向一致。

跳空的判断标准：
1. |Histogram[i] - Histogram[i-1]| > 0
2. 方向一致性：Histogram[i] 和 Histogram[i-1] 同号（都为正或都为负）
3. 连续性：至少连续 [1] 根 K 线满足上述条件

跳空的方向：
- 正向跳空：出现在上涨线段中,Histogram 连续向正方向跳跃（动能加速上涨）
- 负向跳空：出现在下跌线段中,Histogram 连续向负方向跳跃（动能加速下跌）

市场含义：
连续跳空表示 [当DEA穿过零轴的时候 如果产生连续跳空, 则定义为有效的时间级别, 出现连续跳空的时候定位为第一个参考点, 通过多个参考点之间的比较定义背离关系]

### 4. 隐形信号

#### 定义

> 隐形信号是指在上线线段中k线价格上涨 但是没有放出上涨线段中的正向量能柱, 产生上涨动能不足的信号, 反之在下跌线段中k线价格下跌 但是没有放出下跌线段中的负向量能柱, 产生下跌动能不足的信号

隐形的种类：
1. unit中的DEA在高位隐形: [DEA在高位且无对应方向向量能柱支撑, 在缩量的过程中产生隐形, 则会归零轴]
2. unit中的零轴附近(DEA的数值很低),[DEA在零轴附近且无对应方向能柱支撑, 在缩量的过程中产生隐形, 则会穿零轴变盘]


识别条件：
- [条件 1: 次时间级别(当前时间级别的一半) 击破跳空,则认为隐形成立]

### 5.击破跳空

#### 定义
>  击破跳空为在一个unit调整周期内, k线的价格击破最后一个连续跳空(第一根增量量能柱所对应k线的开盘价格) 或 分立跳空(第一根增量量能柱所对应k线的开盘价格)的位置, 则认为该时间级别的动能被击破, 会形成长级别的隐形 甚至是该时间级别穿过零轴(k线价格穿过EMA52)


### 6.归零轴

#### 定义
> 归零轴是指 MACD 的 DEA（白线）回归到 0 轴附近的状态，单位调整周期结束的时候, 归零轴后可能产生反弹 or 穿零轴变盘

#### 识别条件
- DEA 数值接近 0 轴（例如 |DEA| < X，X 根据时间级别调整, 比如1小时就在100附近,时间级别越大X越大）
- k线价格接近 EMA52, （例如 |价格 - EMA52| < Y，Y 是允许击破EMA52价格数量）

### 高位空
#### 定义
> 高位空是指在一个时间级别的unit调整周期内, 出现DEA在高位且无对应方向向量能柱支撑,则认为是高位空
高位空有很大的回归零轴的需求, 价格回到EMA52附近

---

## 背离分析

### 1. 连续跳空背离

#### 定义

> 连续跳空背离
```
连续跳空背离是指价格与 MACD 柱状图同时满足以下条件：

1. 价格创新高（或新低）
2. MACD Histogram 未创新高（或新低）
3. 同时检测到"连续跳空"（见上文定义）

类型：
- 顶背离：价格新高 + Histogram 未新高 + 出现正向连续跳空
- 底背离：价格新低 + Histogram 未新低 + 出现反向连续跳空

市场含义：
连续跳空背离是 [代表这个线段的dea有回归零轴的需求, 价格回到EMA52附近]
```

### 2. 分立跳空背离

#### 定义

> 与连续跳空背离的区别是什么？

**示例填写**：
```
分立跳空背离是指在一个unit中, 出现反向的量能柱之后又正向量能柱而出现跳空，且与价格形成背离。

市场含义：
分立跳空背离[代表这个线段的dea有回归零轴的需求, 价格回到EMA52附近]
```

### 3. 黄白线背离

#### 定义

> 黄白线背离发生在两个单位调整周期之间, 比较两个单位调整周期黄线的最大值. 如果当前第二个unit DIF 小于 第一个unit DIF, 则认为产生背离


市场含义：
!黄白线背离通常表示 [当前时间级别发生u1,u2 之间的黄白线背离,则代表当前时间级别已经走完, 如果此时长级别有高位空(如上定义)有很大的可能穿过零轴变盘.]
特殊例子:[当发生黄白线的背离的时候, 如果长级别同样处归零轴的附近, 那么当前时间级别和长级别会形成合力, 造成时间级别的升级]



---

## 买卖点规则

> **核心章节**：请在此定义你的买卖点触发条件

### 买点规则

#### 买点类型 1：[unit 极限买点]

**触发条件**：

必要条件（全部满足）：
1. [条件 1，当前的时间级别在下跌线段中, DEA在历史DEA 的最高值附近]
2. [条件 2，产生第一个阳k]
3. [条件 3,对应的MACD 缩量]

必要条件
（满足其一）：
1. [条件 A, 1h, 2h 4h 都出现极限数值]
2. [条件 B， 出现底分型]



**入场参数**：
```
入场价位：[确认缩量k之后下一根k开盘价]
仓位大小：[账户的 10%]
```

**止损设置**：
```
止损位：[k线的开盘价- 2*ATR]
止损逻辑：[例如：收盘价跌破止损位]
```

**止盈设置**：
```
止盈位 1：[对应级别的EMA52]
止盈位 2：[穿过零轴之后的前高]
分批止盈：[例如：止盈位 1 平 50%，止盈位 2 平剩余]
```


#### 买点类型 2：[高位空 隐形买点]

**触发条件**：
```
[当前时间级别出现高位空(见上定义), 并且次时间级别击破跳空]
[出现隐形,见上定义]
```

#### 买点类型 3：[走底部买点]

**触发条件**：
```
[出现黄白线单位周期之间的背离 如上定义]
```

#### 买点类型 4：[归零轴缩量]

**触发条件**：
```
[在上涨线段中, 该时间级别出现归零轴过程中出现阳k 且MACD 缩量 如上定义]
[且该时间级别为u1 即传零轴后第一次有效的时间级别]

止损位：[击破调控止损]

```

### 卖点规则

#### 卖点类型 1：[极限卖点]

**触发条件**：
```
[在上涨线段中处于极限DEA]
```

#### 卖点类型 2：[高位空隐形卖点]

**触发条件**：
```
[该时间级别出现的上涨线段中出现高位空 + 隐形]
```

#### 卖点类型 3：[黄白线背离]

**触发条件**：
```
[产生单位调整周期之间的背离是卖点]
```

#### 卖点类型 4：[归零轴缩量卖点]

**触发条件**：
```
[在下跌线段中, 该时间级别出现归零轴过程中出现阴k 且MACD 缩量 如上定义]
[且该时间级别为u1 即传零轴后第一次有效的时间级别]
```Í


---

## 时间级别联动

> **核心章节**：请定义多时间级别如何相互影响

### 层级关系

**时间级别优先级**（从高到低）：
```
1. 2日线（最高级别）
2. 1日线
3. 12小时
4. 6小时
5. 4小时
6. 2小时
7. 1小时
8. 30分钟（最低级别）
```

**上级对下级的影响**：
```
规则 1：[如果2日线处于下跌线段，如果这个时候到次次次级别6h 走底部,则是超跌反弹到2日线零轴ema52]
规则 2：[]
规则 3：[...]
```

**下级对上级的反馈**：
```
规则 1：[例如：如果 1h 出现连续跳空背离，需警惕 4h 线段即将转换]
规则 2：[...]
```

### 共振条件

**多周期共振买点**：
```
触发条件：
1. [主要时间级别，例如：1h] 出现买点信号
2. [确认时间级别 1，例如：4h] 满足 [条件]
3. [确认时间级别 2，例如：1d] 满足 [条件]

共振级别：
- 3 个时间级别共振：[强度，例如：高]
- 2 个时间级别共振：[强度，例如：中]
- 仅单一时间级别：[强度，例如：低]

置信度加成：
共振时间级别越多，买点置信度越高。
```

**多周期矛盾处理**：
```
情况 1：大周期上涨，小周期下跌
处理方式：[例如：等待小周期企稳后顺大周期做多]

情况 2：大周期下跌，小周期上涨
处理方式：[例如：小周期反弹视为大周期的回调，可短线做空]

情况 3：[其他矛盾情况]
处理方式：[...]
```

### 嵌套分析流程

**分析顺序**：
```
1. 从大到小依次分析各时间级别
2. 识别每个级别的线段状态和单位周期
3. 检测各级别的背离信号
4. 汇总联动关系，给出综合判断
```

**联动判断矩阵示例**：
```
| 2日线 | 1日线 | 12h   | 6h    | 4h    | 2h    | 1h    | 30m   | 综合判断           |
|-------|-------|-------|-------|-------|-------|-------|-------|--------------------|
| 上涨  | 上涨  | 上涨  | 上涨  | 上涨  | 上涨  | 上涨  | 上涨  | 强势多头（做多）   |
| 上涨  | 上涨  | 上涨  | 调整  | 调整  | 下跌  | 下跌  | 下跌  | 大周期多头，小周期回调（等待买点） |
| 下跌  | 下跌  | 下跌  | 下跌  | 上涨  | 上涨  | 上涨  | 上涨  | 小周期反弹（短线做空或观望） |

[你可以补充更多场景]
```

---

## 参数配置

> 所有可调整的参数集中在此配置

### EMA 参数

```yaml
ema_short: 26   # 短期均线
ema_long: 52    # 中期均线
```

### MACD 参数

```yaml
macd_fast: 12    # 快线周期
macd_slow: 26    # 慢线周期
macd_signal: 9   # 信号线周期
```

### 线段确认参数

```yaml
# 上涨线段确认
uptrend_min_bars: [你填写，例如：2]   # 最少确认 K 线数

# 下跌线段确认
downtrend_delay_bars: [你填写，例如：25]   # DEA 下穿 0 轴后延迟确认 K 线数

# 零轴突破
below_zero_threshold: [你填写，例如：-60]   # DEA 阈值
below_zero_timeout: [你填写，例如：8]       # 突破超时 K 线数
```

### 跳空检测参数

```yaml
gap_threshold: [你填写，例如：5]        # Histogram 变化幅度阈值
consecutive_gap_min: [你填写，例如：2]  # 最少连续跳空 K 线数
```

### 背离检测参数

```yaml
divergence_lookback: [你填写，例如：50]     # 背离检测回溯 K 线数
divergence_min_distance: [你填写，例如：10] # 两次高点/低点最小间隔
```

### 止损止盈参数

```yaml
# 多单
long_stop_loss_offset: [你填写，例如：300]  # EMA52 - offset
long_take_profit_1: [你填写，例如："前高"]
long_take_profit_2: [你填写，例如："EMA26 破位"]

# 空单
short_stop_loss_offset: [你填写，例如：0]   # EMA52 + offset
short_take_profit_1: [你填写]
short_take_profit_2: [你填写]
```

### 时间级别权重

> 用于多时间级别综合评分

```yaml
timeframe_weights:
  2d: [你填写，例如：1.0]   # 最高权重
  1d: [你填写，例如：0.8]
  12h: [你填写，例如：0.6]
  6h: [你填写，例如：0.5]
  4h: [你填写，例如：0.4]
  2h: [你填写，例如：0.3]
  1h: [你填写，例如：0.2]
  30m: [你填写，例如：0.1]  # 最低权重
```
---

## 版本历史

| 日期       | 版本  | 修改内容                     | 修改人 |
|------------|-------|------------------------------|--------|
| 2025-12-10 | 1.0.0 | 初始框架创建                 | Claude |
| [日期]     | [版本]| [你的修改内容]               | [你]   |

---

**注意**：本文件是 BTC 动能分析 Skill 的核心配置文件，所有分析脚本都会读取此文件。请确保定义完整且逻辑自洽。
