---
name: docs-summarize
description: "[Docs] ⚡ Analyze the codebase and update documentation"
argument-hint: [focused-topics] [should-scan-codebase]
infer: true
---

Use `docs-manager` agent to analyze the codebase based on `docs/codebase-summary.md` and respond with a summary report.

## Arguments:
$1: Focused topics (default: all)
$2: Should scan codebase (`Boolean`, default: `false`)

## Focused Topics:
<focused_topics>$1</focused_topics>

## Should Scan Codebase:
<should_scan_codebase>$2</should_scan_codebase>

## [CRITICAL] Code Evidence Requirements

All documentation summaries MUST follow evidence rules from `.claude/skills/feature-docs/SKILL.md` → `[CRITICAL] MANDATORY CODE EVIDENCE RULE`

### Quick Reference
- **Format**: `**Evidence**: {FilePath}:{LineNumber}`
- **Status**: ✅ Verified / ⚠️ Stale / ❌ Missing
- **Requirement**: Maintain evidence links when summarizing

## Important:
- Use `docs/` directory as the source of truth for documentation.
- Do not scan the entire codebase unless the user explicitly requests it.

**IMPORTANT**: **Do not** start implementing.

## IMPORTANT Task Planning Notes

- Always plan and break many small todo tasks
- Always add a final review todo task to review the works done at the end to find any fix or enhancement needed
