---
name: kanban
description: "[Tooling & Meta] Plans dashboard server with progress tracking and timeline visualization. Use when viewing plan directories with progress tracking, Gantt charts, and phase status."
infer: true
---

# kanban

Plans dashboard server with progress tracking and timeline visualization.

## Summary

**Goal:** Serve a visual plans dashboard with progress tracking, timeline/Gantt visualization, and phase status indicators.

| Step | Action | Key Notes |
|------|--------|-----------|
| 1 | Install dependencies | `cd .claude/skills/kanban && npm install` (requires `gray-matter`) |
| 2 | Start server | `node .claude/skills/kanban/scripts/server.cjs --dir ./plans --open` |
| 3 | View dashboard | Progress per plan, Gantt timeline, activity heatmap |
| 4 | Stop server | `node .claude/skills/kanban/scripts/server.cjs --stop` |

**Key Principles:**
- Requires npm install before use — without it you get Error 500
- Reads plan markdown files with frontmatter for phase/status metadata
- Supports background mode and remote access (--host 0.0.0.0)

## ⚠️ Installation Required

**This skill requires npm dependencies.** Run one of the following:

```bash
# Option 1: Install via ClaudeKit CLI (recommended)
ck init  # Runs install.sh which handles all skills

# Option 2: Manual installation
cd .claude/skills/kanban
npm install
```

**Dependencies:** `gray-matter`

Without installation, you'll get **Error 500** when viewing plan details.

## Purpose

Visual dashboard for viewing plan directories with:

- Progress tracking per plan
- Timeline/Gantt visualization
- Phase status indicators
- Activity heatmap

## Quick Start

```bash
# View plans dashboard
node .claude/skills/kanban/scripts/server.cjs \
  --dir ./plans \
  --open

# Remote access (all interfaces)
node .claude/skills/kanban/scripts/server.cjs \
  --dir ./plans \
  --host 0.0.0.0 \
  --open

# Background mode
node .claude/skills/kanban/scripts/server.cjs \
  --dir ./plans \
  --background

# Stop all running servers
node .claude/skills/kanban/scripts/server.cjs --stop
```

## Slash Command

Use `/kanban` for quick access:

```bash
/kanban plans/           # View plans dashboard
/kanban --stop           # Stop kanban server
```

## Features

### Dashboard View

- Plan cards with progress bars
- Phase status breakdown (completed, in-progress, pending)
- Last modified timestamps
- Issue and branch links
- Priority indicators

### Timeline Visualization

- Gantt-style timeline of plans
- Duration tracking
- Activity heatmap

### Design

- Glassmorphism UI with dark mode
- Responsive grid layout
- Warm accent colors

## CLI Options

| Option            | Description                         | Default   |
| ----------------- | ----------------------------------- | --------- |
| `--dir <path>`    | Plans directory                     | -         |
| `--port <number>` | Server port                         | 3500      |
| `--host <addr>`   | Host to bind (`0.0.0.0` for remote) | localhost |
| `--open`          | Auto-open browser                   | false     |
| `--background`    | Run in background                   | false     |
| `--stop`          | Stop all servers                    | -         |

## Architecture

```
scripts/
├── server.cjs               # Main entry point
└── lib/
    ├── port-finder.cjs      # Port allocation (3500-3550)
    ├── process-mgr.cjs      # PID management
    ├── http-server.cjs      # HTTP routing
    ├── plan-parser.cjs      # Plan.md parsing
    ├── plan-scanner.cjs     # Directory scanning
    ├── plan-metadata-extractor.cjs  # Rich metadata
    └── dashboard-renderer.cjs       # HTML generation

assets/
├── dashboard-template.html  # Dashboard HTML template
├── dashboard.css           # Styles
└── dashboard.js            # Client interactivity
```

## HTTP Routes

| Route                   | Description                      |
| ----------------------- | -------------------------------- |
| `/` or `/kanban`        | Dashboard view                   |
| `/kanban?dir=<path>`    | Dashboard for specific directory |
| `/api/plans`            | JSON API for plans data          |
| `/api/plans?dir=<path>` | JSON API for specific directory  |
| `/assets/*`             | Static assets                    |
| `/file/*`               | Local file serving               |

## Remote Access

When using `--host 0.0.0.0`, the server auto-detects your local network IP:

```json
{
  "success": true,
  "url": "http://localhost:3500/kanban?dir=...",
  "networkUrl": "http://192.168.2.75:3500/kanban?dir=...",
  "port": 3500
}
```

Use `networkUrl` to access from other devices on the same network.

## Plan Structure

The dashboard scans for directories containing `plan.md` files:

```
plans/
├── 251215-feature-a/
│   ├── plan.md              # Required - parsed for phases
│   ├── phase-01-setup.md
│   └── phase-02-impl.md
├── 251214-feature-b/
│   └── plan.md
└── templates/               # Excluded by default
```

## Execution Details

**IMPORTANT:** Run server as Claude Code background task using `run_in_background: true` with the Bash tool. This makes the server visible in `/tasks` and manageable via `KillShell`.

Check if this script is located in the current workspace or in `$HOME/.claude/skills/kanban` directory:

- If in current workspace: `$SKILL_DIR_PATH` = `./.claude/skills/kanban/`
- If in home directory: `$SKILL_DIR_PATH` = `$HOME/.claude/skills/kanban/`

### Stop Server

If `--stop` flag is provided:

```bash
node $SKILL_DIR_PATH/scripts/server.cjs --stop
```

### Start Server

Run the kanban server as CC background task with `--foreground` flag (keeps process alive for CC task management):

```bash
INPUT_DIR="{{dir}}"
PLANS_DIR="${INPUT_DIR:-./plans}"

node $SKILL_DIR_PATH/scripts/server.cjs \
  --dir "$PLANS_DIR" \
  --host 0.0.0.0 \
  --open \
  --foreground
```

**Critical:** When calling the Bash tool:

- Set `run_in_background: true` to run as CC background task
- Set `timeout: 300000` (5 minutes) to prevent premature termination
- Parse JSON output and report URL to user

Example Bash tool call:

```json
{
  "command": "node .claude/skills/kanban/scripts/server.cjs --dir \"./plans\" --host 0.0.0.0 --open --foreground",
  "run_in_background": true,
  "timeout": 300000,
  "description": "Start kanban server in background"
}
```

After starting, parse the JSON output (e.g., `{"success":true,"url":"http://localhost:3500/kanban?dir=...","networkUrl":"http://192.168.1.x:3500/kanban?dir=..."}`) and report:

- Local URL for browser access
- Network URL for remote device access (if available)
- Inform user that server is now running as CC background task (visible in `/tasks`)

**CRITICAL:** MUST display the FULL URL including path and query string. NEVER truncate to just `host:port`. The full URL is required for direct access.

## Future Roadmap

### Phase 2 (Worktree Integration)

- Create tasks -> spawn git worktrees
- Assign agents to tasks
- Track agent progress per worktree

### Phase 3 (Full Orchestration)

- Parallel agent execution monitoring
- Code diff/review interface
- PR creation workflow
- Agent output streaming
- Conflict detection

Track progress: <https://github.com/claudekit/claudekit-engineer/issues/189>

## Troubleshooting

**Port in use**: Server auto-increments from 3500-3550

**No plans found**: Ensure directories contain `plan.md` files

**Remote access denied**: Use `--host 0.0.0.0` to bind all interfaces

**PID files**: Located at `/tmp/kanban-*.pid`

## IMPORTANT Task Planning Notes

- Always plan and break many small todo tasks
- Always add a final review todo task to review the works done at the end to find any fix or enhancement needed
