---
name: use-mcp
description: "[Tooling & Meta] Utilize tools of Model Context Protocol (MCP) servers"
argument-hint: [task]
infer: true
---

Execute MCP operations via **Gemini CLI** to preserve context budget.

## Execution Steps

1. **Execute task via Gemini CLI** (using stdin pipe for MCP support):

   ```bash
   # IMPORTANT: Use stdin piping, NOT -p flag (deprecated, skips MCP init)
   echo "$ARGUMENTS. Return JSON only per GEMINI.md instructions." | gemini -y -m gemini-2.5-flash
   ```

2. **Fallback to mcp-manager subagent** (if Gemini CLI unavailable):
   - Use `mcp-manager` subagent to discover and execute tools
   - If the subagent got issues with the scripts of `mcp-management` skill, use `mcp-builder` skill to fix them
   - **DO NOT** create ANY new scripts
   - The subagent can only use MCP tools if any to achieve this task
   - If the subagent can't find any suitable tools, just report it back to the main agent to move on to the next step

## IMPORTANT Task Planning Notes

- Always plan and break many small todo tasks
- Always add a final review todo task to review the works done at the end to find any fix or enhancement needed

## Anti-Pattern (DO NOT USE)

```bash
# BROKEN - deprecated -p flag skips MCP server connections!
gemini -y -m gemini-2.5-flash -p "..."
```

## Important Notes

- **MUST use stdin piping** - the deprecated `-p` flag skips MCP initialization
- Use `-y` flag to auto-approve tool execution
- **GEMINI.md auto-loaded**: Gemini CLI automatically loads `GEMINI.md` from project root, enforcing JSON-only response format
- **Parseable output**: Responses are structured JSON: `{"server":"name","tool":"name","success":true,"result":<data>,"error":null}`
