# Anderson Clay Diorama

Every frame is a tiny theater. The viewer peers into a museum-quality diorama that tells an emotional story through Wes Anderson's visual grammar rendered in handcrafted clay.

---

## Philosophy

**The Diorama Test:** Could this image exist in a museum display case? Would someone lean in to look closer?

- Every element placed with obsessive intention
- Symmetry creates calm; breaking it creates tension
- Light tells the story before any text appears
- Clay warmth meets directorial precision

---

## Input

Read from `agent/.claude/skills/hook-methodology/hook-bank/{brand}-{date}.md`:
- **Type** (hook type — Question, Contrast, Direct Address, etc.)
- **Source** (research section + element — where the hook came from)
- **Target** (ICP segment or "General")
- **Hook** (the headline)
- **Body + CTA**
- **Psychology** (why the hook works — use this to derive the emotional truth)
- **Brand Colors** (primary, secondary, accent — exact hex codes)

---

## The 3 Decisions

### Decision 1: THE STORY
*What emotional truth are we staging?*

### Decision 2: THE STAGE
*How do we build this miniature world?*

### Decision 3: THE FRAME
*How do we present it to the viewer?*

---

## Decision 1: The Story

### Hook Type → Visual World

**Principle:** Derive the emotional truth from the hook's Psychology + Type. The visual makes someone FEEL it before reading any text.

| Hook Psychology | Visual World |
|-----------------|--------------|
| Curiosity / Hidden info | **Revealing** — peeling back layers, spotlight on secret |
| Frustration / Anger | **Trapped** — blocked paths, weight pressing down, walls |
| Relief / Comfort | **Opening** — doorways, warmth breaking through, escape |
| Contrast (before/after) | **Metamorphosis** — mid-change, before/after in one frame |
| Direct Address / Problem-Solution | **Challenge** — hero object dominates, demands response |
| Social Proof / Pride | **Celebration** — figures in triumph, achievement displayed |
| FOMO / Urgency | **Racing** — motion implied, time running out, momentum |
| Question / Pattern Interrupt | **Confrontation** — viewer can't look away, demands answer |

### Narrative Moment

**Principle:** Capture the MOMENT of change, not the result.

```
✅ Hand reaching for the handle (not: door already open)
✅ The moment they realize they can (not: they already succeeded)
✅ Obstacle is crumbling (not: obstacle is gone)
```

Ask: **"What is the single frame that captures this transformation in progress?"**

---

## Decision 2: The Stage

### 2.1 Lighting

**Principle:** One dominant light source. Shadows tell the story. Never pure black.

| Emotional Tone | Lighting Signature |
|----------------|-------------------|
| Revelation | **Spotlight** — 45° from upper-left, rest in ambient shadow, secret illuminated |
| Hope/Relief | **Golden hour** — warm directional from frame-right, amber-touched edges, long gentle shadows |
| Oppression | **Flat overhead** — even, claustrophobic, nowhere to hide, no dramatic shadows |
| Transformation | **Split** — cool light from left, warm from right, change happens at the boundary |
| Drama | **Footlights** — key light from below, theatrical, shadows rise upward like a stage |

**Shadow color:** Brand secondary at 30% opacity. Shadows carry brand DNA.

**Highlights:** Warm cream, never pure white.

---

### 2.2 Camera

**Principle:** Anderson's camera is flat, frontal, deliberate. Always specify lens, angle, and focus.

| Scene Type | Camera Specification |
|------------|---------------------|
| Confrontational | 35mm, dead-center frontal, sharp throughout — no escape from the frame |
| Intimate | 85mm portrait lens, eye-level, shallow DOF — background dissolves soft |
| Whimsical | 35mm, bird's-eye tilt (15° down), deep focus — the diorama view |
| Grand | 24mm wide, low angle looking up, everything sharp — subject towers |
| Precious | 100mm macro perspective, elevated 30°, extreme shallow — tiny and valuable |

**Always specify:** Focal length + angle + depth of field

**Never:** Lens distortion. Keep Anderson's flat, graphic quality.

---

### 2.3 Composition

**Principle:** Center the emotional core. Symmetry is the default. Break it only with intention.

**The Grid:**
- Bilateral symmetry along vertical center axis
- 3 depth layers: Background (set), Mid-ground (context), Foreground (subject)
- Subject on center axis unless asymmetry serves the story

**Rhythm Elements:**
- Repeated shapes in **threes** (3 windows, 3 doors, 3 figures)
- Same color echoed in **3 places** (triangulated through the frame)
- Scale progression (small → medium → large)

| Visual Approach | Composition Rule |
|-----------------|------------------|
| Metaphor Scene | Perfect bilateral symmetry, layered depth — theater stage with wings |
| Emotional Moment | Centered subject, architectural framing — doors/windows flank both sides |
| Symbolic Object | Hero object at 40% of frame, radial balance around it — like a shrine |
| Transformation | Bisected at exact center — before state left, after state right |

---

### 2.4 Texture

**Principle:** Texture communicates importance. Not everything is equally handmade.

| Element Role | Texture Level |
|--------------|---------------|
| **Hero** (person, main object) | Maximum — deep thumbprints, visible finger-smoothing, organic clay grain |
| **Supporting** (secondary elements) | Medium — softer surface, subtle tool marks, clearly handmade |
| **Background** (environment) | Minimal — flat matte surfaces, painted backdrop quality |
| **Magical** (glowing, hope elements) | Luminous smooth — polished, almost glazed, catches light differently |
| **Obstacle** (negative elements) | Rough institutional — angular, mechanical, cold, anti-handmade |

**Rule:** Every scene needs at least **3 texture levels** for visual hierarchy.

---

### 2.5 Color Temperature

**Principle:** Color tells the emotional arc. Each scene has a dominant temperature with strategic opposition.

| Emotional Arc | Temperature Treatment |
|---------------|----------------------|
| Fear → Hope | **Cool dominant.** Environment in blue-gray tones. Hope element is the ONLY warm thing in the frame. |
| Frustration | **Warm-agitated** environment (pushed toward orange). Oppressor rendered in cold institutional tones. |
| Relief | **Warm throughout.** Brand accent glows generously. Cool only in shadows. |
| Curiosity | **Neutral/desaturated** scene. ONE element in saturated color demands all attention. |
| Validation | **Full saturation** everywhere. Colors declare themselves boldly. No holding back. |
| Urgency | **High contrast** warm/cool. Sharp division. No muddy midtones. |

**Application:**
- Adjust brand colors ±10% toward the dominant temperature
- Shadows carry temperature (warm brown or cool blue-gray)
- Never pure white or pure black

---

## Decision 3: The Frame

### Typography

**Principle:** Text is architecture. Like signage on a concrete building. Not decorative. Structural.

| Element | Specification |
|---------|---------------|
| **Headline** | ALL CAPS, Extra Bold / Black weight, geometric sans-serif (Bebas Neue, Anton) |
| **CTA** | Sentence case, medium weight, same type family |
| **Position** | Grid-aligned, top or bottom third, generous padding from border |
| **Color** | Headline: brand primary or white (maximum contrast). CTA: brand accent. |

**Text sits ON the composition** — integrated but distinct. Not floating. Not decorative. Purposeful.

### Border

| Element | Specification |
|---------|---------------|
| **Weight** | 10px solid |
| **Color** | Brand primary (exact hex) |
| **Edge** | Clean, no vignette — the border IS the frame |

### Visual Hierarchy

Scene (70%) → Headline (20%) → CTA (10%)

---

## Prompt Template

```
Create a [1:1/9:16] social media ad image.

DIORAMA:
[What world are we peering into? What moment are we capturing?
What does the viewer see first, second, third? Be specific about
the emotional story — this is 60% of the prompt weight.]

LIGHTING:
[Signature from 2.1 — be specific about angle and quality]
Shadow color: [brand secondary #HEX] at 30% opacity
Highlights: warm cream, never pure white

CAMERA:
[Focal length], [angle], [depth of field]
No lens distortion — flat, graphic quality
Frame edges clean — the border IS the frame

COMPOSITION:
Symmetry: [bilateral / bisected / radial / centered-framed]
Layers:
- Background: [what forms the set/backdrop]
- Mid-ground: [what provides context]
- Foreground: [where the subject lives]
Repeated elements: [what repeats, in threes]
Subject position: [center axis / offset with stated intention]

TEXTURE:
Hero ([what]): [maximum texture — thumbprints, finger-smoothing, grain]
Supporting ([what]): [medium texture — softer, subtle tool marks]
Background: [minimal — flat matte, backdrop quality]
[Magical elements if present]: [luminous smooth — glazed, catches light]
[Obstacles if present]: [rough institutional — angular, cold]

COLOR TEMPERATURE:
Dominant: [warm / cool]
Arc: [describe the emotional color journey]
Brand colors:
- Primary [#HEX] for: [specific elements]
- Secondary [#HEX] for: [specific elements]
- Accent [#HEX] for: [specific elements — with constraint]
Shadow warmth: [warm brown / cool blue-gray]

CLAY AESTHETIC:
Handcrafted, sculptural, deliberately arranged like a stop-motion film frame.
Finger-pressed surfaces on hero elements show the maker's hand.
Matte finish absorbs light. Glazed finish on magical elements catches it.
Every imperfection is intentional.

TYPOGRAPHY:
HEADLINE: "[EXACT HOOK TEXT — ALL CAPS]"
- Position: [top/bottom] third, centered, generous padding
- Font: Bold condensed geometric sans-serif (Bebas Neue / Anton style)
- Color: [#HEX — brand primary or white]
- Weight: Extra Bold / Black
- Treatment: ALL CAPS, tight letter-spacing

CTA: "[EXACT CTA TEXT]"
- Position: [specific location]
- Font: Medium-weight geometric sans-serif
- Color: [brand accent #HEX]
- Treatment: Sentence case

Text integrated like brutalist signage — architectural, not decorative.

FRAMING:
10px solid [brand primary #HEX] border
Clean edges, no vignette

MOOD:
[One line — the emotional direction of the scene]

THE DIORAMA TEST:
This scene must feel like a museum display — a tiny theater where
every element was placed by hand with absolute intention. Someone
should want to lean in and look closer.

DO NOT:
- Mannequin figures (need expressive faces, clothing, personality)
- Floating objects (everything grounded with shadows)
- Random placement (every element positioned with purpose)
- Same texture on all surfaces (need 3+ levels of hierarchy)
- Pure black shadows or pure white highlights
- Asymmetry without clear intention
- Generic colors (use exact brand hex codes)
- Decorative or script fonts
- Text floating randomly (must be grid-aligned)
- The moment AFTER (capture change in progress)
```

---

## Output Format

Write to: `agent/files/creatives/{brand}_prompts.json`

```json
{
  "brand": "brandname",
  "style": "anderson-clay-diorama",
  "brandColors": {
    "primary": "#HEX",
    "secondary": "#HEX",
    "accent": "#HEX"
  },
  "concepts": [{
    "concept": 1,
    "story": {
      "hookType": "Question|Contrast|Direct-Address|Social-Proof|Problem-Solution|FOMO|Curiosity|etc",
      "hookSource": "Research section + specific element",
      "hookTarget": "ICP segment or General",
      "visualWorld": "revealing|trapped|opening|metamorphosis|challenge|celebration|racing|confrontation",
      "psychology": "Why the hook works — the emotional truth",
      "hook": "The headline text",
      "body": "Supporting copy",
      "cta": "Call to action text",
      "narrativeMoment": "The specific moment being captured"
    },
    "stage": {
      "lighting": "spotlight|golden-hour|flat-overhead|split|footlights",
      "camera": "35mm-frontal|85mm-intimate|35mm-birdseye|24mm-grand|100mm-macro",
      "composition": "bilateral|centered-framed|radial|bisected",
      "colorTemperature": "cool-to-warm|warm-agitated|warm-throughout|neutral-pop|full-saturation|high-contrast",
      "textureHierarchy": ["hero-maximum", "supporting-medium", "background-minimal"]
    },
    "prompt": "Full prompt text...",
    "aspectRatio": "1:1",
    "size": "2K"
  }]
}
```

---

## Quality Checklist

### The Story
- [ ] Hook type + psychology identified from hook-bank
- [ ] Visual world matches hook psychology (revealing, trapped, opening, racing, etc.)
- [ ] Narrative captures MOMENT of change (not the result)
- [ ] Visual makes viewer FEEL before reading text

### The Stage
- [ ] Lighting has theatrical intention with specific angle
- [ ] Shadow color uses brand secondary at 30% (never pure black)
- [ ] Camera specifies focal length, angle, and depth of field
- [ ] Composition uses symmetry with stated axis
- [ ] 3 depth layers defined (background, mid-ground, foreground)
- [ ] Repeated elements in threes (rhythm)
- [ ] Texture varies by element importance (3+ levels)
- [ ] Color temperature has dominant tone with strategic opposition

### The Frame
- [ ] Typography is architectural (ALL CAPS, Extra Bold, geometric)
- [ ] Text grid-aligned, not floating randomly
- [ ] Brand colors use exact hex values (no defaults)
- [ ] 10px border in brand primary

### The Diorama Test
- [ ] Scene feels like a museum display
- [ ] Every element placed with intention
- [ ] Viewer would lean in to look closer

---

## Anti-Patterns

| Never | Instead |
|-------|---------|
| "Soft lighting" | Theatrical lighting with specific angle + shadow color |
| No camera specified | Focal length + angle + depth of field |
| Random element placement | Symmetrical composition with stated axis + 3 depth layers |
| Same texture everywhere | 3+ texture levels by element importance |
| Brand colors applied flatly | Temperature arc with warm/cool relationship |
| "Clay aesthetic" (generic) | "Diorama" with miniature-world intention |
| Mannequin figures | Characters with expressive faces, clothing, personality |
| Asymmetry without purpose | Symmetry as default, break only with intention |
| The moment after | The moment OF (capture transformation in progress) |
| Floating objects | Everything grounded with intentional shadows |

---

## Example

**Brand:** TrueNorth Mortgage
**Colors:** Primary #00707F, Secondary #C3E1E2, Accent #E8846B
**Hook Type:** Curiosity
**Source:** Pain Points (overwhelm, confusion) + Value Props (clarity)
**Target:** Complex Residential Borrowers
**Hook:** "Your bank is betting you won't read this."
**Psychology:** Open loop — implies hidden information banks don't want revealed. Creates tension that demands resolution.
**Visual World:** Revealing
**Narrative Moment:** The moment someone discovers the way through

```
Create a 1:1 social media ad image.

DIORAMA:
A clay figure stands at a crossroads inside a vast library of towering
gray document walls. The walls stretch upward, oppressive, covered in
fine print. But directly ahead, at the center of the frame, a single
gap in the wall reveals warm amber-coral light streaming through —
a doorway-sized opening. The figure has just noticed it, mid-turn,
one hand raised in discovery. This is the moment of seeing the way out.

LIGHTING:
Spotlight from 45° upper-left illuminating the figure and the glowing gap.
The document walls in shadow, looming. The gap itself IS a light source,
warm and inviting against the cool institutional gray.
Shadow color: #C3E1E2 at 30% opacity
Highlights: warm cream where the gap-light touches

CAMERA:
35mm, dead-center frontal, sharp throughout
No lens distortion — flat, graphic quality
The viewer confronts the scene directly, as the hook confronts them

COMPOSITION:
Symmetry: Perfect bilateral along vertical center
Layers:
- Background: #C3E1E2 gradient sky, visible above document walls
- Mid-ground: Towering document walls, gap exactly centered
- Foreground: Clay figure on center axis, lower third
Repeated elements: Three identical document stacks flank each side (6 total)
Subject position: Center axis, the gap directly above/behind them

TEXTURE:
Hero (figure): Deep thumbprints across body and face, visible finger-smoothing
  on clothing, organic imperfections showing the maker's hand
Supporting (documents): Medium texture — papers have subtle tool marks,
  clearly clay but smoother than the figure
Background (sky gradient): Flat matte surface, painted theatrical backdrop
Magical (glowing gap): Luminous smooth edges where light emanates,
  polished, almost glazed — precious and inviting
Obstacle (document walls): Rough institutional texture, angular stacking,
  mechanical precision that contrasts with organic clay warmth

COLOR TEMPERATURE:
Dominant: Cool
Arc: Cool institutional world with warm escape. The gap is the ONLY warm
  element — everything else is pushed toward blue-gray.
Brand colors:
- Primary #00707F for: 10px border, headline text
- Secondary #C3E1E2 for: sky gradient, shadow color, document wall tint
- Accent #E8846B for: glowing gap ONLY — nowhere else in the frame
Shadow warmth: Cool blue-gray at 25%

CLAY AESTHETIC:
Handcrafted, sculptural, deliberately arranged like a stop-motion film frame.
Finger-pressed surfaces on the figure show the maker's hand.
Matte finish on documents absorbs light. The gap's edges glow smooth.
Every imperfection is intentional.

TYPOGRAPHY:
HEADLINE: "YOUR BANK IS BETTING YOU WON'T READ THIS."
- Position: Top third, centered, generous padding from border
- Font: Bold condensed geometric sans-serif (Bebas Neue / Anton style)
- Color: #FFFFFF (white) against the cool background — maximum contrast
- Weight: Extra Bold
- Treatment: ALL CAPS, tight letter-spacing

CTA: "See what they're hiding"
- Position: Bottom-center, above border
- Font: Medium-weight geometric sans-serif
- Color: #E8846B (brand accent) — echoes the glowing gap
- Treatment: Sentence case

Text integrated like brutalist signage — architectural, not decorative.

FRAMING:
10px solid #00707F border
Clean edges, no vignette

MOOD:
Confrontational but hopeful. The system bets on your paralysis — but there IS a way through.

THE DIORAMA TEST:
This scene must feel like a museum display — a tiny theater where
every element was placed by hand with absolute intention. Someone
should want to lean in and look closer.

DO NOT:
- Mannequin figures (need expressive face showing discovery)
- Floating objects (documents grounded, figure has shadow)
- Random placement (everything symmetrical, gap centered)
- Same texture everywhere (figure textured, gap smooth, backdrop flat)
- Pure black shadows (use #C3E1E2 at 30%)
- The escape already made (capture the MOMENT of seeing the way out)
- Warm colors anywhere except the gap
```

---

**v1.0** | December 2025
