---
name: hook-methodology
description: Generates conversion-focused ad copy through research-first extraction. Creates unique hook concepts by mining EVERY section of the research document. Use when creating Meta ads, conversion campaigns, or scroll-stopping copy.
---

# Research-First Hook Methodology

Every hook must be traceable to a specific research element. No invention—only discovery.

## Core Philosophy

```
Research first. Every hook has a SOURCE.

The best hooks aren't constructed from templates.
They're extracted from what the brand has already proven, said, or delivered.

If you can't point to where it came from in the research,
it's invention. Invention is weak. Discovery is strong.
```

---

## The 10 Hook Types

Before extracting, know what you're looking for:

### Attention Hooks (Stop the Scroll)

| Type | Purpose | Example Pattern |
|------|---------|-----------------|
| **Question** | Challenge assumption | "What's the biggest mistake you're making?" |
| **Surprising Stat** | Unexpected number | "90% of banks reject self-employed applicants" |
| **Pattern Interrupt** | Break expectations | Unexpected statement that contradicts normal |
| **Controversial** | Challenge belief | Question something everyone accepts |
| **Direct Address** | Call out situation | "Self-employed? Bank said no?" |

### Desire Hooks (Drive Clicks)

| Type | Purpose | Example Pattern |
|------|---------|-----------------|
| **Social Proof** | Credibility through numbers | "16,000+ Canadians switched and saved" |
| **Problem-Solution** | Name pain, offer relief | Pain statement → Solution hint |
| **Contrast** | Show gap | "[Bad thing] vs. [Better thing]" |
| **FOMO/Urgency** | Scarcity, pressure | Limited time, competitive pressure |
| **Curiosity** | Tease hidden info | "What your bank isn't telling you" |

---

## Step 1: EXTRACT (Read EVERY Section)

Read `agent/files/research/{brand}_research.md`

**You MUST extract from EVERY section. No exceptions.**

---

### FROM: The Offer
Extract:
- Core promise (what they sell)
- Key numbers (rates, coverage, speed, capacity)

```
Example:
"AI-powered mortgage brokerage, 350+ lenders, rates from 4.19%, 24-48 hour approvals"
```

---

### FROM: Key Value Props
Extract:
- Each differentiator as a potential hook angle
- What makes them different from competitors

```
Example:
- AI-Powered Intelligence
- Rapid Approval (24-48 hours)
- 350+ institutional + 150+ private lenders
- 24+ specialized loan products
```

---

### FROM: Proof Points
Extract:
- Specific stats (ratings, reviews, credentials)
- Real deal examples with numbers
- Certifications, licenses, awards

```
Example:
- 4.8/5 rating, 856 reviews
- FSRA Licensed #M20003023
- $547.5K purchase closed in 24 hours (Oshawa)
- $2M construction deal (Vaughan)
```

---

### FROM: Products/Services ← CRITICAL

**Every product is a potential hook for a specific audience.**

Extract:
- Every product category
- Unique or surprising offerings
- Niche products that solve specific problems

```
Example:
RESIDENTIAL:
- Bank Decline Financing → hook for rejected borrowers
- 120% LTV Owner-Occupied → surprising high leverage
- Non-Resident Mortgages → new Canadians hook
- Rush Closing 24-48 hours → urgency hook

SPECIALIZED:
- BRRR Strategy Loans (72-hour funding) → investor hook
- Fix & Flip Financing → investor hook
- Power-of-Sale Financing → rescue/urgent hook
- Bridge Loans → timing gap hook

COMMERCIAL:
- No Personal Guarantee (up to $1M) → risk-reduction hook
- CMHC Multi-Family (95% LTV) → leverage hook
```

---

### FROM: Pain Points Addressed
Extract:
- Each pain point + the brand's solution
- Verbatim language when available

```
Example:
- "Slow bank approvals" → 24-48 hour turnaround
- "Bank rejection" → Bank-decline rescue financing
- "Self-employed income" → No-income verification options
```

---

### FROM: Testimonials
Extract:
- Exact customer quotes (social proof)
- Specific results mentioned
- Emotional language used

```
Example:
- "Got approved in just 2 days with a great rate" — Sarah M.
- "AI search helped me understand all my options" — John D.
```

---

### FROM: Brand Voice
Extract:
- Tone to match in hook writing
- Words/phrases to use or avoid

```
Example:
"Confident yet accessible, professional but approachable, results-oriented"
```

---

### FROM: Their Messaging
Extract:
- Headlines, taglines they already use (starting points)
- CTAs they use
- Key phrases they repeat

```
Example:
- Headline: "Canada's First Lending Hub"
- Tagline: "Not Just Rates. Real Loans for Every Property Type."
- CTAs: "Apply Now", "Start My Deal", "Get started →"
```

---

### FROM: ICP Segments (EACH segment separately)

For EACH segment extract:
- WHO they are
- PAIN POINTS (verbatim language)
- MOTIVATIONS (immediate + deeper)
- LANGUAGE they use

```
Example - Segment 1 (Complex Residential Borrowers):
WHO: Self-employed, business owners, rejected by banks
PAIN: "bank doesn't understand my income", "rejected multiple times"
MOTIVATION: Feel validated, access same opportunities as W-2 employees
LANGUAGE: "self-employed", "bank said no", "complicated income"

Example - Segment 2 (Real Estate Investors):
WHO: BRRR, fix-and-flip, portfolio builders
PAIN: Banks too slow, need creative financing
MOTIVATION: Build wealth, financial freedom
LANGUAGE: "BRRR", "fix and flip", "bridge loan", "LTV"

Example - Segment 3 (Underserved Homebuyers):
WHO: New Canadians, first-time buyers, urgent situations
PAIN: Don't qualify, feeling excluded
MOTIVATION: Canadian dream, stability, prove they belong
LANGUAGE: "new to Canada", "first home", "credit issues"
```

---

## Extraction Checklist

**STOP. Before writing ANY hooks, verify you have extracted from:**

- [ ] **The Offer** — Core promise, key numbers
- [ ] **Key Value Props** — ALL differentiators listed
- [ ] **Proof Points** — ALL stats, ratings, real deals
- [ ] **Products/Services** — EVERY product category, unique offerings noted
- [ ] **Pain Points Addressed** — ALL pain + solution pairs
- [ ] **Testimonials** — ALL customer quotes
- [ ] **Brand Voice** — Tone noted for calibration
- [ ] **Their Messaging** — Headlines, taglines, CTAs captured
- [ ] **ICP Segment 1** — WHO, PAIN, MOTIVATION, LANGUAGE
- [ ] **ICP Segment 2** — WHO, PAIN, MOTIVATION, LANGUAGE (if exists)
- [ ] **ICP Segment 3** — WHO, PAIN, MOTIVATION, LANGUAGE (if exists)

**If any checkbox is unchecked, go back and extract from that section.**

---

## Step 2: MATCH (Research Element → Hook Type)

For each extracted element, identify which hook type it best serves:

| Research Element | Best Hook Type | Why |
|------------------|----------------|-----|
| "4.8/5, 856 reviews" | Social Proof | Credibility through numbers |
| "24-48 hours vs. 3-6 weeks" | Contrast | Clear before/after |
| "bank said no" | Direct Address | Customer's exact words |
| "$547.5K closed in 24 hours" | Surprising Stat | Specific, unexpected |
| "350+ lenders" | FOMO/Access | More options than competitors |
| "AI-powered" | Curiosity | Technology intrigue |
| "Self-employed rejection" | Problem-Solution | Pain + relief |
| "Bank Decline Financing" product | Direct Address | Names the situation |
| "BRRR Strategy Loans" product | Direct Address | Investor terminology |

**Match at least 3-5 research elements to hook types before constructing.**

---

## Step 3: CONSTRUCT (Build Hooks)

For each hook, use this structure:

```
HOOK TYPE: [Which type from the 10]
SOURCE: [Which research section + specific element]
TARGET: [Which ICP segment, or "General"]
HOOK: [The actual headline — under 10 words ideal]
WHY IT WORKS: [Psychology — pattern interrupt? self-reference? open loop?]
```

### Construction Principles

**Benefits over features:**
- "Get approved in 48 hours" not "Fast processing"

**Direct address ("You"):**
- Make it personal, use identity markers

**Specificity:**
- "350+ lenders" not "many options"
- Exact numbers from Proof Points

**Empathy first:**
- Acknowledge struggle before offering solution

**Their language:**
- Use verbatim phrases from ICP sections

**Example Construction:**
```
HOOK TYPE: Contrast
SOURCE: Value Props ("24-48 hour approval") + Pain Points ("banks take 3-6 weeks")
TARGET: Complex Residential Borrowers
HOOK: "Banks take weeks. We close in 48 hours."
WHY IT WORKS: Pattern interrupt (unexpected speed) + Tension (bad vs. good)
```

---

## Step 4: BODY + CTA

### Body Formula

1. Expand the hook's promise (don't repeat it)
2. Add ONE proof element not in the hook
3. Bridge to CTA

**Keep to 1-2 sentences.**

### CTA Formula

**Action Verb + Implied Outcome**

| Weak CTA | Strong CTA |
|----------|------------|
| "Learn more" | "See your options" |
| "Apply now" | "Get your answer" |
| "Contact us" | "Talk to someone who gets it" |
| "Get started" | "Find your lender" |

The CTA should feel like the natural next step, not a demand.

---

## Step 5: VARIETY CHECK

Before finalizing, verify diversity:

### Hook Types Used
- [ ] At least 3 different hook types represented
- [ ] Not all questions, not all stats

### Research Sections Used
- [ ] Not all hooks from Pain Points
- [ ] Proof Points used in at least 1 hook
- [ ] Products/Services referenced in at least 1 hook
- [ ] Value Props featured in at least 1 hook

### ICP Segments Covered
- [ ] If multiple segments exist, hooks address different ones
- [ ] Not all hooks targeting same persona

### Emotions Triggered
Cover at least 3 of these territories:
- [ ] Fear / Protection (what they might lose)
- [ ] Hope / Aspiration (what becomes possible)
- [ ] Frustration / Anger (what's unfair)
- [ ] Relief / Comfort (burden lifted)
- [ ] Pride / Identity (being seen)
- [ ] Curiosity / Intrigue (hidden information)

**If variety is lacking, return to Step 2 and find different research elements to match.**

---

## Output Format

Write to: `agent/.claude/skills/hook-methodology/hook-bank/{brand}-{YYYY-MM-DD}.md`

```markdown
# [Brand Name] - Hook Bank
**Date:** YYYY-MM-DD
**Hooks Generated:** [number]

## Brand Colors
- Primary: #hex
- Secondary: #hex
- Accent: #hex

## Research Elements Used
[List which sections were mined for each hook]

---

## Hook 1
**Type:** [Hook type from the 10]
**Source:** [Research section + specific element]
**Target:** [ICP segment or "General"]
**Hook:** "[The headline]"
**Body:** [1-2 sentences]
**CTA:** [Action + outcome]
**Psychology:** [Why it stops scroll + drives click]

## Hook 2
[Same structure]

## Hook 3
[Same structure]

[Continue for each hook — default 3, or as specified by user]

---

## Variety Verification
- Hook Types Used: [list]
- Research Sections Used: [list]
- ICP Segments Covered: [list]
- Emotions Triggered: [list]
```

---

## Hook Volume

- **Default:** Generate 3 hooks
- **User-specified:** Generate the number requested

Quality over quantity. Each hook must pass all validation checks.

---

## Validation Checklist (Final Pass)

Before each hook is complete, verify:

1. **Is it TRACEABLE?** — Can you point to the exact research element?
2. **Is it OWNED?** — Could a competitor use this by changing the logo?
3. **Is it FELT?** — Does it name an emotion, not just a fact?
4. **Is it CLEAR?** — 3 seconds or less to understand?
5. **Is it THEIRS?** — Uses their words, their world?

If any answer is no, revise or replace the hook.

---

## Common Failure Modes

### The Skip Trap
Skipping Products/Services or Proof Points because they seem "obvious." Every section has hook potential.

### The Generic Trap
Writing hooks that could work for any competitor. Use specific proof points to make it OWNED.

### The Template Trap
Starting with a formula and filling in blanks. Start with research elements, then match to types.

### The Pain-Only Trap
Only using Pain Points section. Testimonials, Products, and Value Props often contain stronger hooks.

### The Invention Trap
Creating claims that aren't in the research. If you can't cite the source, don't use it.

---

## Remember

```
Mine the research. Every hook must be traceable.

The goal is not to be clever.
The goal is to find what the brand has already proven
and frame it in a way that stops the scroll.

If you can't point to where it came from, start over.
```
