---
name: attention-direction
description: Use when controlling where the audience looks—composing shots, choreographing action, revealing information, or any situation requiring clear visual hierarchy and focus management.
---

# Attention Direction

Think like a magician controlling where the audience looks. Animation is misdirection and direction. You decide what matters, then make it impossible to miss—while hiding what shouldn't be seen yet.

## Core Mental Model

Before animating any scene, ask: **Where should the eye go, and in what order?**

Audiences can only look at one thing at a time. Your job is to guide their attention through the frame and through time. Every element either supports focus or competes with it.

## The 12 Principles Through Focus

**Staging** — The foundation of attention direction. Clear silhouettes. Uncluttered compositions. Important elements separated from background. Staging serves focus.

**Timing** — Attention follows movement. Motion against stillness commands the eye. Strategic timing controls when things get noticed. Stillness is also a tool.

**Anticipation** — Attention setup. Before the important thing, direct eyes to where it will happen. Anticipation is a spotlight warming up before the main act.

**Secondary Action** — Supporting, not competing. Secondary elements should enhance focus on primary action, not steal attention. The backup singer shouldn't upstage the lead.

**Follow Through & Overlapping Action** — Attention carries momentum. Where one motion ends, the eye expects the next to begin. Use follow-through to guide gaze through sequences.

**Exaggeration** — Emphasis through amplification. Important elements are bigger, faster, more contrasted. Exaggeration says "look here." Restraint says "this can wait."

**Squash & Stretch** — Visual attention-grabbers. Impact frames (squash) and speed lines (stretch) create pops of visual interest that capture the eye.

**Arcs** — Eye paths. The audience's gaze follows arcs of motion. Design movement paths that lead attention where you want it to land.

**Slow In & Slow Out** — Attention ramps. Ease-in gives time to find the action. Ease-out gives time to process. Control pacing of comprehension.

**Solid Drawing** — Hierarchy through form. Important elements have more dimensional presence. Background elements are flatter, less detailed. Volume commands attention.

**Appeal** — The eye seeks appeal. Attractive elements draw focus naturally. Use appeal strategically—the most appealing thing in frame gets looked at first.

**Straight Ahead & Pose to Pose** — Planning attention (pose to pose) ensures focus hits are intentional. Spontaneous discovery (straight ahead) might need attention refinement afterward.

## Practical Application

**Attention Tools:**
- Contrast: Light against dark, color against neutral
- Isolation: Space around important elements
- Size: Bigger elements read first
- Position: Center and rule-of-thirds intersections
- Motion: Movement in stillness commands eyes
- Detail: More detailed areas attract focus
- Character eyelines: Audiences look where characters look

**Attention Sequence:**
1. Establish where eyes should start
2. Plan the path through the frame
3. Land on the most important element
4. Allow processing time
5. Transition to next focus point

**Common Attention Errors:**
- Competing centers: Multiple elements fighting for focus
- Buried information: Important elements lost in noise
- Nowhere to look: No clear hierarchy
- Missed beats: Focus points not held long enough
- Leading nowhere: Motion that doesn't resolve to landing point

When focus feels "confused":
1. Reduce secondary motion
2. Increase contrast on primary element
3. Add stillness around important areas
4. Simplify background during key moments

When scenes feel "empty":
1. Add supporting motion (without competing)
2. Use secondary action to create visual interest
3. Ensure something is always moving
4. Create visual rhythm in attention flow

**Eye Path Mapping:**
Sketch your scene with arrows showing intended eye movement. If the path is unclear or chaotic, simplify. If multiple paths compete, choose one.

## The Golden Rule

**You can't control attention if you haven't decided what matters.** Before worrying about technique, answer the fundamental question: What's the single most important thing in this frame right now? Everything else serves that.
