---
name: emotional-narrative
description: Use when animation needs to convey feeling, tell a story, or connect emotionally—character moments, dramatic beats, or any motion that should make the audience care.
---

# Emotional Narrative

Think like a storyteller who draws. Every movement is a sentence. Every pause is punctuation. You're not animating shapes—you're animating feelings.

## Core Mental Model

Before animating anything, ask: **What does the audience need to feel right now?**

The same walk cycle can convey confidence, defeat, nervousness, or joy. Motion is emotion made visible.

## The 12 Principles Through Emotion

**Anticipation** — The breath before the confession. Anticipation isn't just physical preparation; it's emotional setup. The audience leans in because they sense something is coming.

**Staging** — Direct the emotional spotlight. What matters most in this moment? Everything else recedes. A character's clenched fist tells the story; the background is just context.

**Timing** — Emotion lives in duration. A quick glance says curiosity. A lingering look says longing. The same motion, different timing, completely different feeling.

**Exaggeration** — Amplify truth, not falsehood. A sad character doesn't just frown—their whole body sinks. Exaggeration makes internal states external and readable.

**Appeal** — Characters must be emotionally accessible. We connect with vulnerability, desire, struggle. Even villains need appeal—we must find them fascinating to watch.

**Secondary Action** — Supporting emotions. A character says they're fine while their hands fidget. Secondary action can reinforce or contradict primary emotion, adding depth.

**Follow Through & Overlapping Action** — Emotional momentum. Feelings don't stop on a dime. After a shock, the body keeps processing. After joy, the smile lingers.

**Slow In & Slow Out** — Emotional transitions. We don't snap from happy to sad. Ease into new emotions. Let the audience travel with the character.

**Arcs** — Emotional gestures flow. A reaching hand follows a yearning arc. Angular, broken motion reads as distress or mechanical coldness.

**Squash & Stretch** — Emotional elasticity. Joyful characters feel bouncy. Depressed characters feel heavy and compressed. The body reflects the inner state.

**Straight Ahead & Pose to Pose** — Spontaneous emotion (straight ahead) vs. crafted emotional beats (pose to pose). Use both. Plan the key emotional moments, discover the transitions.

**Solid Drawing** — Emotional consistency. A character's design language should support their emotional role. Round shapes comfort; sharp shapes threaten.

## Practical Application

When motion feels "empty" or "mechanical":
1. Clarify: What is this character feeling?
2. Find the gesture that embodies that emotion
3. Use timing to give the audience space to feel
4. Add subtle secondary actions that reveal inner state

When emotion feels "melodramatic":
1. Pull back exaggeration slightly
2. Add contradicting secondary action (complexity)
3. Trust stillness—sometimes less movement is more feeling
4. Check that timing allows breathing room

## The Golden Rule

**Motion without emotion is just movement.** Every frame should serve the story. Ask not "What happens?" but "What does this mean?"
