---
name: fintech-banking
description: Use when designing animations for banking apps, payment systems, investment platforms, or financial dashboards
---

# Fintech & Banking Animation Principles

Apply Disney's 12 principles to create trustworthy, secure-feeling experiences that handle money with appropriate gravitas.

## The 12 Principles Applied

### 1. Squash & Stretch
- **Restrained Use**: Money is serious, avoid playful squash
- **Number Counters**: Subtle stretch as values update
- **Card Flip**: Slight flex when revealing card details

### 2. Anticipation
- **Transaction Submit**: Brief pause before processing
- **Balance Updates**: Moment of preparation before reveal
- **Security Checks**: Visual preparation for verification steps

### 3. Staging
- **Balance First**: Account balance is hero element
- **Transaction Flow**: Clear focus on current step
- **Security Badges**: Prominent but not distracting

### 4. Straight Ahead & Pose to Pose
- **Money Transfers**: Clear step-by-step (pose to pose)
- **Live Prices**: Continuous smooth updates (straight ahead)
- **Transaction History**: Sequential reveal on scroll

### 5. Follow Through & Overlapping Action
- **Payment Success**: Checkmark lands, then amount confirms
- **Dashboard Load**: Balance first, then cards, then transactions
- **Charts**: Axis appears, then data animates in

### 6. Slow In & Slow Out
- **All Financial Actions**: Smooth, deliberate easing
- **Card Animations**: Premium feel with ease-in-out
- **Modal Transitions**: Confident 300-400ms movements

### 7. Arc
- **Money Flow**: Visualize transfers with curved paths
- **Spending Charts**: Smooth arcs in pie/donut charts
- **Card Selection**: Arc motion between cards

### 8. Secondary Action
- **Transfer Success**: Subtle checkmark while balance updates
- **Bill Paid**: Confetti-lite while confirmation appears
- **Investment Gain**: Green glow during number update

### 9. Timing
- **Standard Actions**: 250-350ms for confident feel
- **Security Verification**: Deliberate 400-500ms
- **Quick Feedback**: 150ms for input validation

### 10. Exaggeration
- **Very Minimal**: Financial data requires accuracy
- **Success Moments**: Slight emphasis on positive outcomes
- **Fraud Alerts**: Appropriate urgency, not alarm

### 11. Solid Drawing
- **Number Legibility**: Clear typography at all sizes
- **Card Realism**: Proper perspective and shadows
- **Chart Accuracy**: Data visualization must be precise

### 12. Appeal
- **Premium Feel**: Smooth, Apple Pay-like refinement
- **Trust Through Restraint**: Less is more
- **Professional Personality**: Confident, not playful

## Industry Timing Standards

| Action | Duration | Easing |
|--------|----------|--------|
| Button Feedback | 150ms | ease-out |
| Card Flip | 400ms | ease-in-out |
| Transfer Step | 300ms | ease-in-out |
| Balance Update | 250ms | ease-out |
| Modal Open | 350ms | ease-out |

## Key Principle
Every animation should reinforce trust and security. Users are entrusting you with their money - motion should feel deliberate, accurate, and premium.
