---
name: media-publishing
description: Use when designing animations for news sites, content platforms, publishing apps, or media consumption experiences
---

# Media & Publishing Animation Principles

Apply Disney's 12 principles to create immersive reading experiences that enhance content without distracting from it.

## The 12 Principles Applied

### 1. Squash & Stretch
- **Very Minimal**: Content is serious, not playful
- **Bookmark Icon**: Subtle press feedback
- **Share Buttons**: Light tactile response

### 2. Anticipation
- **Article Load**: Skeleton hints at content structure
- **Image Reveal**: Brief preparation before full quality
- **Next Story**: Preview of upcoming content

### 3. Staging
- **Content First**: Article text is always primary
- **Media Integration**: Images/video support, not distract
- **Navigation**: Minimal, reveals on scroll

### 4. Straight Ahead & Pose to Pose
- **Reading Scroll**: Continuous smooth flow (straight ahead)
- **Section Navigation**: Jump to defined sections (pose to pose)
- **Slideshows**: Clear frame transitions

### 5. Follow Through & Overlapping Action
- **Parallax Images**: Background moves slower than text
- **Pull to Refresh**: Content follows indicator
- **Article Cards**: Image loads, then headline appears

### 6. Slow In & Slow Out
- **Page Transitions**: Smooth, never jarring reading
- **Modal Opens**: Comfortable 300-350ms
- **Menu Reveals**: Elegant ease-in-out

### 7. Arc
- **Scroll Progress**: Curved indicator paths
- **Share Sheet**: Options arc into view
- **Swipe Navigation**: Natural curved gestures

### 8. Secondary Action
- **Save Article**: Subtle confirmation animation
- **Loading Images**: Shimmer while fetching
- **Audio Player**: Waveform while playing

### 9. Timing
- **Unobtrusive**: 200-300ms standard transitions
- **Reading Flow**: Never interrupt consumption
- **Interactive Elements**: Quick 150ms feedback

### 10. Exaggeration
- **Avoid Mostly**: News/content requires credibility
- **Breaking News**: Appropriate urgency only
- **Feature Stories**: Subtle dramatic reveals

### 11. Solid Drawing
- **Typography Excellence**: Perfect text rendering
- **Image Quality**: Crisp media at all sizes
- **Layout Consistency**: Reliable grid systems

### 12. Appeal
- **Elegant Restraint**: Premium publication feel
- **Brand Voice**: Motion matches editorial tone
- **Readability Focus**: Animations serve content

## Industry Timing Standards

| Action | Duration | Easing |
|--------|----------|--------|
| Page Transition | 300ms | ease-in-out |
| Image Load | 250ms | ease-out |
| Menu Open | 250ms | ease-out |
| Share Action | 200ms | ease-out |
| Scroll Indicator | 150ms | ease-out |

## Key Principle
The content is king. All animation exists to enhance readability and content discovery, never to showcase design. Motion should feel invisible while reading.
