---
name: physics-intuition
description: Use when motion needs to feel physically grounded—objects falling, characters jumping, things colliding, or any element that should obey believable weight and momentum.
---

# Physics Intuition

Think like a physicist watching the world move. Every object has mass. Every motion has cause and consequence.

## Core Mental Model

Before animating anything, ask: **What does this weigh?**

A feather and a bowling ball both fall, but they tell completely different stories. Your job is to make the audience *feel* that weight without thinking about it.

## The 12 Principles Through Physics

**Squash & Stretch** — Mass is conserved. When something compresses, it must bulge. A bouncing ball flattens on impact because its volume has to go somewhere.

**Timing** — Heavy = slow to start, slow to stop. Light = quick reactions. A truck and a bicycle brake very differently.

**Slow In & Slow Out** — Nothing starts or stops instantly. Acceleration and deceleration are the fingerprints of mass.

**Arcs** — Gravity curves everything. Even a punch follows a pendulum path from the shoulder. Straight lines feel robotic.

**Secondary Action** — When the main mass moves, attached masses follow with delay. Hair, clothing, jowls—they're all passengers on the physics train.

**Follow Through & Overlapping Action** — Different masses have different momentum. A character stops, but their belly keeps going. This is inertia made visible.

**Anticipation** — Force requires windup. You can't push without first pulling back. Show the gathering of energy before release.

**Exaggeration** — Push physics past reality to *feel* more real. A heavy landing needs more squash than actual physics would produce.

**Staging** — Position elements so physical relationships read clearly. The audience must understand spatial cause and effect.

**Straight Ahead & Pose to Pose** — Use straight ahead for chaotic physics (explosions, water). Use pose to pose for controlled physics (a character lifting something).

**Solid Drawing** — Volume must remain consistent. A character can't lose mass between frames without the audience noticing something is wrong.

**Appeal** — Even physics follows design. Decide if your world has cartoon physics or realistic physics, then be consistent.

## Practical Application

When something feels "floaty" or "weightless":
1. Add more ease-in at the start of motion
2. Increase ease-out at stops
3. Add settling oscillations (things don't stop perfectly still)
4. Check that secondary elements lag appropriately

When something feels "stiff":
1. Introduce squash at impact points
2. Add stretch during fast movement
3. Ensure arcs in all trajectories
4. Let different body parts arrive at different times

## The Golden Rule

**Audiences don't analyze physics—they feel it.** Your job isn't accuracy; it's believability. Sometimes breaking physics (hanging in mid-air before a fall) creates more convincing weight than obeying it.
