---
name: rhythm-pacing
description: Use when animation needs musical flow—dance sequences, action choreography, comedic timing, scene pacing, or any motion that should feel rhythmic and well-composed over time.
---

# Rhythm & Pacing

Think like a composer scoring with motion. Animation is visual music. Beats, measures, crescendos, rests—all translate to movement and stillness across time.

## Core Mental Model

Before animating any sequence, ask: **What's the tempo, and where are the beats?**

Every good scene has rhythm. Fast-fast-slow. Action-rest-action. The pattern creates expectation; breaking the pattern creates surprise. Master the beat.

## The 12 Principles Through Music

**Timing** — Tempo control. Frames per action define speed. Consistent timing creates rhythm. Varied timing creates interest. Know when to be metronome-steady and when to rubato.

**Slow In & Slow Out** — The space between notes. Easing is like vibrato—it shapes the attack and release of each movement-note. Hard stops are staccato. Soft settles are legato.

**Anticipation** — The upbeat before the downbeat. Music notation shows anticipation as the breath mark. The pause that creates emphasis on what follows.

**Follow Through & Overlapping Action** — Counterpoint. Multiple elements moving at different rhythms create harmonic complexity. The main action is melody; follow-through is accompaniment.

**Secondary Action** — Rhythm section. While the lead melody (primary action) plays, secondary elements keep the underlying beat. They support without overpowering.

**Staging** — Composition includes visual rhythm. Pattern and variation in how shots are framed. Long shot, medium shot, close-up—like verses and choruses.

**Exaggeration** — Accents and dynamics. Fortissimo movements demand attention. Pianissimo subtlety creates contrast. Without dynamic range, rhythm becomes monotonous.

**Squash & Stretch** — Visual percussion. Impact frames are drum hits. Stretch is the sustain. Squash-stretch patterns create rhythmic texture in motion.

**Arcs** — Melodic lines. Smooth arcs are flowing melodies. Sharp direction changes are rhythmic accents. The shape of motion in time is the shape of music in space.

**Appeal** — Rhythmic motion is inherently appealing. Humans are pattern-recognizing creatures. We find pleasure in rhythm and satisfaction when patterns resolve.

**Solid Drawing** — Consistent structure allows rhythm to read. If forms are muddy, beats get lost. Clarity of drawing supports clarity of timing.

**Straight Ahead & Pose to Pose** — Pose to pose is like writing sheet music—define the beats first. Straight ahead is like jazz improv—find rhythm in the performance.

## Practical Application

**Rhythmic Structures:**
- Action-pause-action: Classic three-beat phrase
- Building: Accelerating tempo toward climax
- Breathing: Alternating active and rest sections
- Syncopation: Off-beat emphasis for surprise
- Polyrhythm: Multiple timing patterns overlapping

**Scene Pacing:**
- Opening: Establish tempo
- Development: Vary within established tempo
- Climax: Fastest or most intense section
- Resolution: Return to calm, or new tempo

**Beat Mapping:**
1. Identify key story moments
2. Place them as "downbeats" in your timeline
3. Determine measures between beats
4. Fill measures with appropriate action density
5. Add rests (held poses) for breathing room

When pacing feels "rushed":
1. Insert more rest moments
2. Extend holds on key poses
3. Reduce density of action per measure
4. Add breathing poses between phrases

When pacing feels "draggy":
1. Cut frames from transitions
2. Increase action density
3. Add rhythmic secondary motion
4. Sharpen contrasts between sections

**Musical Terms for Animators:**
- Accelerando: Speeding up
- Ritardando: Slowing down
- Fermata: Held pose longer than expected
- Crescendo: Building intensity
- Staccato: Quick, punchy actions
- Legato: Smooth, connected movements

## The Golden Rule

**Rhythm is expectation plus surprise.** Establish a pattern so the audience feels the beat. Then break it at the perfect moment. The art is knowing when to be predictable and when to syncopate.
