---
name: saas-productivity
description: Use when designing animations for business tools, project management, collaboration software, or productivity apps
---

# SaaS & Productivity Animation Principles

Apply Disney's 12 principles to create efficient, professional experiences that enhance focus and reduce friction.

## The 12 Principles Applied

### 1. Squash & Stretch
- **Minimal Use**: Professional context requires restraint
- **Checkboxes**: Subtle squash on task completion
- **Buttons**: Slight compression for tactile feedback

### 2. Anticipation
- **Save Actions**: Brief preparation before confirmation
- **Form Submit**: Button state hints at processing
- **Drag Initiation**: Element lifts before moving

### 3. Staging
- **Active Task**: Current work item takes focus
- **Sidebar Navigation**: Secondary to main content
- **Notifications**: Non-intrusive placement

### 4. Straight Ahead & Pose to Pose
- **Workflows**: Clear step-by-step processes (pose to pose)
- **Real-time Collaboration**: Smooth cursor movements (straight ahead)
- **Dashboard Updates**: Sequential data loading

### 5. Follow Through & Overlapping Action
- **Card Movements**: Shadow follows card with delay
- **List Reordering**: Items settle naturally
- **Panel Resizing**: Content adjusts after panel stops

### 6. Slow In & Slow Out
- **Professional Easing**: Smooth, never bouncy
- **Modal Transitions**: Confident 250-350ms
- **State Changes**: Deliberate, not snappy

### 7. Arc
- **Drag and Drop**: Natural curved paths
- **Kanban Cards**: Arc between columns
- **Notification Dismiss**: Swipe follows curve

### 8. Secondary Action
- **Auto-save Indicator**: Subtle pulse while saving
- **Sync Status**: Background indicator during updates
- **Loading Skeleton**: Shimmer while data fetches

### 9. Timing
- **Efficient**: 150-300ms for most interactions
- **Never Slow**: Users are here to work
- **Instant Feedback**: 100ms for input validation

### 10. Exaggeration
- **Almost Never**: Productivity demands efficiency
- **Milestones Only**: Project completion, goals met
- **Onboarding**: Slightly more playful to engage

### 11. Solid Drawing
- **Data Visualization**: Clear, accurate charts
- **Icon Consistency**: Uniform across all features
- **Typography**: Readable at all sizes

### 12. Appeal
- **Professional Polish**: Refined, not flashy
- **Invisible Design**: Animations serve, not distract
- **Trust & Reliability**: Consistent, predictable motion

## Industry Timing Standards

| Action | Duration | Easing |
|--------|----------|--------|
| Button Feedback | 100ms | ease-out |
| Modal Open | 250ms | ease-out |
| Dropdown Menu | 200ms | ease-in-out |
| Page Transition | 300ms | ease-in-out |
| Toast Notification | 200ms | ease-out |

## Key Principle
Animations should be invisible to users focused on work. Motion exists to provide feedback and maintain spatial awareness, never to entertain or delay.
