---
name: social-media
description: Use when designing animations for social platforms, messaging apps, content sharing, or community features
---

# Social Media Animation Principles

Apply Disney's 12 principles to create engaging, expressive experiences that encourage interaction and emotional connection.

## The 12 Principles Applied

### 1. Squash & Stretch
- **Like Buttons**: Heart squishes on tap, then bounces back
- **Reaction Emojis**: Playful stretch during selection
- **Send Button**: Compress before message flies away

### 2. Anticipation
- **Post Button**: Brief wind-up before publishing
- **Stories**: Tap-and-hold with radial progress
- **Swipe Actions**: Preview hints at what's coming

### 3. Staging
- **Content First**: User content is always the star
- **Reactions Bar**: Clear but not overshadowing
- **Notifications**: Prominent but dismissible

### 4. Straight Ahead & Pose to Pose
- **Feed Scroll**: Endless smooth flow (straight ahead)
- **Posting Flow**: Step-by-step creation (pose to pose)
- **Story Sequences**: Frame-by-frame progression

### 5. Follow Through & Overlapping Action
- **Like Animation**: Icon bounces, count updates after
- **Comment Thread**: Avatar appears, then text
- **Share Menu**: Options cascade in sequence

### 6. Slow In & Slow Out
- **Pull to Refresh**: Smooth deceleration
- **Card Transitions**: Ease-in-out for polished feel
- **Modal Sheets**: Comfortable 300ms timing

### 7. Arc
- **Reactions Float**: Emojis arc upward from button
- **Story Gestures**: Swipe follows natural curve
- **Content Sharing**: Posts arc to share destination

### 8. Secondary Action
- **Double-Tap Like**: Heart bursts while fading
- **Typing Indicator**: Dots bounce while thinking
- **Upload Progress**: Shimmer while processing

### 9. Timing
- **Interactions**: Snappy 100-200ms for engagement
- **Transitions**: Swift 250-300ms to maintain flow
- **Celebrations**: 500-800ms for emotional moments

### 10. Exaggeration
- **Reactions**: Amplify emotional expression
- **Milestones**: Celebrate follower counts, likes
- **Live Features**: Dynamic, attention-grabbing

### 11. Solid Drawing
- **Avatar Consistency**: Uniform sizing and styling
- **Icon Language**: Cohesive visual vocabulary
- **Grid Layouts**: Proper alignment and spacing

### 12. Appeal
- **Personality Forward**: Platform character shines through
- **Dopamine Design**: Rewarding micro-interactions
- **Shareability**: Animations worth recording

## Industry Timing Standards

| Action | Duration | Easing |
|--------|----------|--------|
| Like/React | 200ms | spring |
| Pull to Refresh | 300ms | ease-out |
| Story Transition | 250ms | ease-in-out |
| Modal Open | 300ms | ease-out |
| Send Message | 150ms | ease-out |

## Key Principle
Social media thrives on emotional expression. Animations should amplify connection, make interactions feel rewarding, and encourage continued engagement without feeling manipulative.
