---
name: universal-fallback
description: Use when the animation domain is unclear or spans multiple contexts—provides general-purpose Disney animation principle guidance.
---

# Universal Animation Principles

Disney's 12 animation principles applied generically across any medium or context.

## Quick Reference

| Principle | Universal Application |
|-----------|----------------------|
| Squash & Stretch | Show impact and flexibility |
| Anticipation | Prepare before action |
| Staging | Direct attention clearly |
| Straight Ahead / Pose to Pose | Continuous vs keyframe approach |
| Follow Through / Overlapping | Elements complete at different rates |
| Slow In / Slow Out | Ease acceleration/deceleration |
| Arc | Natural curved motion paths |
| Secondary Action | Supporting elements reinforce primary |
| Timing | Duration affects perceived weight |
| Exaggeration | Push for clarity and impact |
| Solid Drawing | Maintain form and structure |
| Appeal | Design for engagement and delight |

## The 12 Principles Explained

### 1. Squash & Stretch
Objects deform during action to show impact, weight, and flexibility. Volume remains constant—compression in one axis means expansion in another. The most important principle for showing life and physics.

**Application**: Anything with mass reacts to force. Soft objects deform more. Rigid objects show less but still respond. Use to show weight, speed, and material properties.

### 2. Anticipation
Preparation before the main action. Wind-up before pitch. Crouch before jump. Pullback before push. Prepares the audience for what's coming and makes action more readable.

**Application**: Major actions need setup. The bigger the action, the bigger the anticipation. Can be physical, visual, or timing-based. Skipping anticipation makes motion feel robotic.

### 3. Staging
Directing attention to what matters. Composition, contrast, motion, and timing work together to make intent clear. One clear idea per moment.

**Application**: Audiences can only focus on one thing at a time. Use all available tools (position, lighting, motion, timing) to make the important element unmistakable.

### 4. Straight Ahead & Pose to Pose
Two animation approaches. Straight ahead: draw frame-by-frame for fluid, spontaneous motion. Pose to pose: define key poses, then fill between for control and clarity. Most work combines both.

**Application**: Use straight ahead for dynamic, unpredictable motion. Use pose to pose for planned, precise sequences. Procedural/physics = straight ahead. Scripted = pose to pose.

### 5. Follow Through & Overlapping Action
Different parts of an object/character move at different rates and stop at different times. Nothing stops all at once. Overlapping creates natural, organic motion.

**Application**: Lead with the root/core, secondary elements follow. Heavier elements lag more. Lighter elements react faster. Creates complexity and believability.

### 6. Slow In & Slow Out
Objects accelerate and decelerate—they don't move at constant speed. More frames at start and end of motion, fewer in the middle. Creates natural, physics-based movement.

**Application**: Linear motion looks mechanical. Ease-in for exits, ease-out for entrances. Ease-in-out for contained motion. The curve defines the character of movement.

### 7. Arc
Natural motion follows curved paths, not straight lines. Joints rotate, creating inherent arcs. Thrown objects follow parabolas. Straight line motion is rare in nature.

**Application**: When something moves from A to B, the path between matters. Check motion paths—mechanical if straight, natural if curved. Exceptions: robots, specific mechanical effects.

### 8. Secondary Action
Supporting actions that reinforce the primary action without distracting from it. Facial expression supporting body language. Environmental response to character action.

**Application**: Primary action tells the story. Secondary actions enrich it. Secondary should never dominate. Remove secondary if it distracts from primary.

### 9. Timing
The number of frames/duration determines the feel of motion. Fewer frames = faster = lighter/snappier. More frames = slower = heavier/more deliberate. Timing is the foundation of personality.

**Application**: Experiment with timing to find the right feel. Context matters—same duration can feel fast or slow depending on expectations. Timing conveys weight, emotion, and energy.

### 10. Exaggeration
Push beyond reality for clarity and impact. Doesn't mean "unrealistic"—means amplifying the essence. More extreme poses, more dramatic timing, clearer staging.

**Application**: Reality can be subtle, unclear, boring. Animation clarifies reality by pushing what matters. Find the truth and amplify it. Different contexts allow different levels.

### 11. Solid Drawing
Understanding of form, weight, volume, and three-dimensional space. Objects maintain their structure during motion. Drawings have weight, balance, and depth.

**Application**: Things have mass and occupy space. Maintain consistency during animation. Understand the structure of what you're animating. Avoid unintentional distortion.

### 12. Appeal
The quality that makes audiences want to watch. Not just "cute"—can be appealing through design, personality, or movement. Characters and motion should be engaging.

**Application**: Design and animate for your audience. Create emotional connection. Motion should feel intentional and satisfying. Every choice should serve engagement.

## Applying Principles

1. **Start with purpose**: What must the audience understand/feel?
2. **Stage clearly**: Direct attention to what matters
3. **Time appropriately**: Duration affects everything
4. **Ease naturally**: No linear motion in nature
5. **Anticipate actions**: Prepare for major moments
6. **Follow through**: Let motion complete naturally
7. **Add depth**: Secondary action enriches primary
8. **Exaggerate clarity**: Push to communicate
9. **Maintain structure**: Respect form and physics
10. **Design appeal**: Make it worth watching

These principles transcend medium. Master them, adapt them, apply them thoughtfully.
