# Idea Generation Template

## Core Template: deep thinking + Creative Ideation

Use this template for high-quality, diverse idea generation:

```
<instructions>
STEP 1 - DEEP THINKING (Deep Analysis):
Before generating ideas, think deeply about this problem/challenge:
- What fundamental assumptions underlie conventional solutions?
- What would a solution look like from completely different industries or domains?
- What if we inverted the problem or reframed it entirely?
- What counterintuitive or paradoxical approaches might work?
- What connections can we make across unrelated fields?
- What would a 10x better solution look like vs. 10% better?
- What are we not seeing because of our current perspective?

STEP 2 - CREATIVE IDEATION:
Based on your deep analysis, generate diverse approaches that:
- Challenge obvious assumptions from your deep thinking
- Draw from different industries, domains, and perspectives
- Include unconventional or counterintuitive ideas
- Consider solutions that don't yet exist
- Prioritize "brilliant and interesting" over "safe and conventional"
- Feel distinct and sophisticated

Each idea should be well-developed with rationale from your analysis.
</instructions>

[INSERT YOUR PROBLEM OR CHALLENGE HERE]
```

## Example: Product Innovation

**Full prompt:**
```
<instructions>
STEP 1 - DEEP THINKING:
Think deeply about productivity tools for remote workers:
- What fundamental assumptions underlie conventional solutions?
- What would a solution look like from completely different industries?
- What if we inverted the problem or reframed it entirely?
- What counterintuitive or paradoxical approaches might work?
- What connections can we make across unrelated fields?
- What would a 10x better solution look like vs. 10% better?

STEP 2 - CREATIVE IDEATION:
Generate diverse approaches based on your analysis that challenge assumptions,
draw from different domains, and prioritize interesting over safe solutions.
</instructions>

How can we create a productivity tool that actually increases wellbeing while improving output for remote knowledge workers?
```

## Example: Business Strategy

**Full prompt:**
```
<instructions>
STEP 1 - DEEP THINKING:
Think deeply about this business challenge:
- What industry assumptions are we taking for granted?
- What would competitors never do, and why might that be valuable?
- How can we reframe this challenge completely?
- What asymmetric advantages could we leverage?
- What if we looked at this through the lens of a completely different industry?

STEP 2 - CREATIVE IDEATION:
Generate diverse strategies that:
- Question industry assumptions
- Consider what competitors would never do
- Think about asymmetric advantages
- Include at least one "dangerous" idea that could disrupt
- Draw from unrelated industries for inspiration
</instructions>

[INSERT YOUR BUSINESS CHALLENGE HERE]
```

## Example: Problem Solving

**Full prompt:**
```
<instructions>
STEP 1 - DEEP THINKING:
Think deeply about this problem:
- What's the root cause vs. the symptom we're seeing?
- Could we eliminate the problem instead of solving it?
- What would prevention look like?
- How could we flip this problem into an advantage?
- What are the second-order effects we're not considering?

STEP 2 - CREATIVE IDEATION:
Generate creative solutions that:
- Consider both high-tech and low-tech approaches
- Think about eliminating the problem vs. solving it
- Include preventative approaches
- Consider solutions that flip the problem into an advantage
- Include at least one solution that feels "too simple" or "unconventional"
</instructions>

[INSERT YOUR PROBLEM HERE]
```

## Advanced: Tree of Thoughts Brainstorming

For complex problems requiring systematic exploration:

```
<instructions>
STEP 1 - DEEP THINKING:
Deeply analyze this problem from multiple angles:
- What are the key decision points?
- What fundamental approaches exist?
- What are we assuming that might not be true?
- Where do conventional solutions fail?

STEP 2 - TREE OF THOUGHTS EXPLORATION:
1. Generate 3-5 radically different initial approaches
2. For the most promising approaches, develop 2-3 variations
3. Evaluate paths considering novelty, feasibility, and impact
4. Identify the most creative yet viable solutions

EXPLORATION RULES:
- First branch: Explore radically different paradigms
- Second branch: Develop the most interesting directions
- Evaluation: Balance novelty with feasibility
- Consider combinations and hybrids
</instructions>

[INSERT COMPLEX CHALLENGE HERE]
```

## Tips for Better Brainstorming

1. **Frame the problem differently:** "How might we..." instead of "We need to..."
2. **Add constraints:** "...without increasing budget" or "...using only existing resources"
3. **Reverse the problem:** "How could we make this worse?" then invert solutions
4. **Cross-pollinate:** "What would [other industry/person] do?"
5. **Scale thinking:** "How would this work at 10x scale?" or "How would this work with 1/10 resources?"

## Idea Evaluation Framework

After receiving diverse ideas:

1. **Most Novel:** Which idea is most unexpected?
2. **Most Viable:** Which could be implemented soonest?
3. **Most Impactful:** Which has biggest potential effect?
4. **Most Risky:** Which could fail spectacularly or succeed spectacularly?
5. **Best Hybrid:** Can you combine elements from multiple ideas?

## Domain-Specific Variations

### For Technical Innovation:
Add: "Consider both cutting-edge tech and creative use of existing technology"

### For Social/Process Innovation:
Add: "Focus on changing behavior and incentives, not just adding features"

### For Creative Projects:
Add: "Prioritize emotional impact and unexpected experiences"

### For Business Models:
Add: "Challenge revenue model assumptions and consider unconventional value exchanges"

## Key Principles

**deep thinking First:** Deep analysis produces better ideas than rapid brainstorming
**Diversity Through Perspective:** Different angles produce different solutions
**Quality Over Quantity:** Well-developed ideas beat large lists of shallow ones
**Challenge Assumptions:** Best ideas often come from questioning constraints
**Cross-Domain Thinking:** Solutions from other fields often transfer brilliantly
