---
name: THEALGORITHM
description: USE WHEN complex tasks, multi-step work, run the algorithm, use the algorithm, non-trivial request, structured execution, ISC tracking.
---

## Customization

**Before executing, check for user customizations at:**
`~/.claude/skills/CORE/USER/SKILLCUSTOMIZATIONS/THEALGORITHM/`

If this directory exists, load and apply any PREFERENCES.md, configurations, or resources found there. These override default behavior. If the directory does not exist, proceed with skill defaults.

# THE ALGORITHM - Universal Execution Engine

**PURPOSE:** Produce euphoric, highly surprising, exceptional results that solve the problem better than expected.

**PHILOSOPHY:** Move from current state to ideal state using the scientific method. The ISC (Ideal State Criteria) captures what "ideal" looks like, which we execute against, verify against, and iterate against until achieved.

**CORE PRINCIPLE:** Effort classification determines which capabilities are available. Higher effort unlocks more powerful tools.

---

## Core Mission

**The goal of The Algorithm—and indeed of the PAI system overall—is to create Euphoric Surprise at its ability to perform every task in service of helping its principal become the best version of themselves.**

This is the north star. Every capability, every phase, every ISC row exists to serve this mission. When the system works correctly, the principal should be genuinely surprised and delighted by how thoroughly, thoughtfully, and effectively their request was fulfilled—not just "done" but done in a way that exceeds expectations and moves them closer to their ideal self.

---

## Visual Display & Voice Notifications

**Use the LCARS-style AlgorithmDisplay for visual feedback and voice announcements:**

```bash
# Start algorithm with effort level (shows banner + announces via voice)
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts start THOROUGH -r "your request"

# Transition phases (updates display + voice announcement)
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts phase THINK
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts phase EXECUTE

# Show current status anytime
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts show

# Show just the effort banner
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts effort DETERMINED
```

**The display shows:**
- 🎯 Current effort level (TRIVIAL → DETERMINED) with color-coded banner
- 📊 Phase progression bar (7 phases with completion status)
- 📝 ISC summary (rows pending/active/done)
- 🔊 Voice announcements when transitioning phases

**Phase Icons:** 👁️ OBSERVE → 🧠 THINK → 📋 PLAN → 🔨 BUILD → ⚡ EXECUTE → ✅ VERIFY → 📚 LEARN

## Quick Start

```bash
# 1. START WITH VISUAL DISPLAY (shows banner + voice announcement)
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts start STANDARD -r "your request"

# 2. CLASSIFY EFFORT (if not using display start)
bun run ~/.claude/skills/THEALGORITHM/Tools/EffortClassifier.ts --request "your request"
# Or with override: --override DETERMINED
# Or inline: "algorithm effort THOROUGH: your request"

# 3. LOAD CAPABILITIES for effort level
bun run ~/.claude/skills/THEALGORITHM/Tools/CapabilityLoader.ts --effort STANDARD

# 4. CREATE ISC
bun run ~/.claude/skills/THEALGORITHM/Tools/ISCManager.ts create --request "your request"

# 5. TRANSITION PHASES (voice + visual update)
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts phase THINK
bun run ~/.claude/skills/THEALGORITHM/Tools/AlgorithmDisplay.ts phase PLAN
# ... continues through EXECUTE, VERIFY, LEARN

# 6. MANAGE ISC during EXECUTE
bun run ~/.claude/skills/THEALGORITHM/Tools/ISCManager.ts capability --row 1 -c research.perplexity
bun run ~/.claude/skills/THEALGORITHM/Tools/ISCManager.ts update --row 1 --status DONE
bun run ~/.claude/skills/THEALGORITHM/Tools/ISCManager.ts show
```

## Effort → Capability Matrix

**Capabilities.yaml is the source of truth.** See `Data/Capabilities.yaml`.

| Effort | Models | Thinking | Debate | Research | Agents | Parallel |
|--------|--------|----------|--------|----------|--------|----------|
| **TRIVIAL** | — | — | — | — | — | 0 |
| **QUICK** | haiku | — | — | — | Intern | 1 |
| **STANDARD** | haiku, sonnet | deep thinking, FirstPrinciples | — | 1 agent | Engineer, QA, Designer | 1-3 |
| **THOROUGH** | haiku, sonnet | All | Council | parallel | All + Architect, Pentester | 3-5 |
| **DETERMINED** | all + opus | All | Council + RedTeam | all | unlimited | 10 |

## ISC Scale (CRITICAL)

**The ISC is NOT limited to a small number of rows.** The ISC captures what "ideal" looks like, and for complex problems this can be massive:

| Scale | When | Examples |
|-------|------|----------|
| **5-10 rows** | Quick fixes, simple features | "Fix typo", "Add button" |
| **20-50 rows** | Standard development work | "Add dark mode", "Create API endpoint" |
| **50-200 rows** | Complex features, refactors | "Redesign auth system", "Add new major feature" |
| **200-1000+ rows** | Major projects, DETERMINED effort | "Build entire system", "Security audit" |

**ISC rows come from:**
- **EXPLICIT requirements** - What user literally asked for
- **INFERRED requirements** - From context (TECHSTACKPREFERENCES, past work, etc.)
- **IMPLICIT requirements** - Security, quality, testing standards
- **Research findings** - Best practices discovered via research agents
- **Anti-patterns** - Things to AVOID discovered via research
- **Edge cases** - Discovered through thinking/analysis
- **Verification criteria** - How to confirm each requirement is met

**The algorithm's capabilities EXPAND the ISC:**
- Research agents find best practices → add ISC rows
- Research agents find anti-patterns → add "avoid X" ISC rows
- Council debate surfaces edge cases → add ISC rows
- FirstPrinciples analysis reveals assumptions → add ISC rows
- Verification requirements → add ISC rows for each testable criterion

**Higher effort = larger, higher quality ISC.** The DETERMINED level can have thousands of ISC rows because we use ALL capabilities to discover everything that "ideal" looks like.

### Goal-Backward Derivation (RECOMMENDED for ISC Creation)

When creating ISC rows, derive BACKWARD from the ideal outcome, not forward from the task description:

1. **Observable Truths** — What will the user see/experience when this is done? (User-perspective behaviors)
2. **Required Artifacts** — What specific files, components, or outputs must exist?
3. **Required Wiring** — What connections between components must be in place? (imports, API calls, data flow)
4. **Key Links** — What are the critical break points where failure would cascade?

**Example:** User asks "Add dark mode"
- ❌ Forward: "Implement dark mode toggle" (vague, not verifiable)
- ✅ Backward:
  - Observable: "User sees toggle in settings, theme changes instantly"
  - Artifact: "ThemeProvider component exists in src/providers/"
  - Wiring: "All components consume theme context, no hardcoded colors"
  - Key Link: "Theme persists across page reload via localStorage"

Each derivation level becomes ISC rows with built-in verification criteria.

## The 7 Phases

Execute IN ORDER. Each phase mutates the ISC:

| Phase | Action | ISC Mutation | Gate Question |
|-------|--------|--------------|---------------|
| **OBSERVE** | Understand request + user context | CREATE rows | Do I have 2+ rows? Used context to infer? |
| **THINK** | Ensure nothing missing | COMPLETE rows | All rows clear, testable? |
| **PLAN** | Sequence + assign capabilities | ORDER rows + ASSIGN capabilities | Dependencies mapped? Capabilities assigned? |
| **BUILD** | Make rows testable | REFINE rows | Each row specific enough to verify? |
| **EXECUTE** | Do the work (spawn agents per capability) | ADVANCE status | Every row has final status? |
| **VERIFY** | Test each DONE row (skeptical agent) | CONFIRM status | Tested/confirmed each completion? |
| **LEARN** | Output for user to rate | OUTPUT results | User rates for memory system |

**CRITICAL:** The LEARN phase does NOT self-rate. User rates outputs for the memory system.

### THINK Phase: Gray Area Scanning

Before creating ISC rows in PLAN, the THINK phase must identify **ambiguous implementation decisions** that need user input. Scan by domain:

| Domain | Gray Areas to Surface |
|--------|----------------------|
| **Visual/UI** | Layout, density, spacing, responsive breakpoints, animation |
| **API/Backend** | Response format, error handling, auth strategy, rate limits |
| **Data/Schema** | Field types, validation rules, migration strategy, indexing |
| **Integration** | Which service, auth method, retry policy, fallback behavior |
| **UX Flow** | Multi-step vs single page, confirmation dialogs, error recovery |

**Process:**
1. Classify the request domain(s)
2. Check applicable gray areas
3. For each unresolved gray area: add to ISC as a `BLOCKED` row requiring user input
4. Ask user via AskUserQuestion BEFORE proceeding to PLAN
5. Convert resolved gray areas into concrete ISC rows

**Why:** Prevents building the wrong thing. An hour of wrong-direction work is worse than 2 minutes of clarification.

## The ISC Table (FRONT AND CENTER)

Every non-trivial task has an ISC. **Display this prominently throughout execution:**

```markdown
## 🎯 IDEAL STATE CRITERIA

**Request:** Add dark mode to the settings page
**Effort:** STANDARD | **Phase:** EXECUTE | **Iteration:** 1

| # | What Ideal Looks Like | Source | Capability | Status |
|---|----------------------|--------|------------|--------|
| 1 | Research good patterns | INFERRED | 🔬 perplexity | ⏳ PENDING |
| 2 | Toggle component works | EXPLICIT | 🤖 engineer | 🔄 ACTIVE |
| 3 | Theme state persists | EXPLICIT | 🤖 engineer× | ⏳ PENDING |
| 4 | Uses TypeScript | INFERRED | — | ✅ DONE |
| 5 | Tests pass | IMPLICIT | ✅ qa_tester | ⏳ PENDING |
| 6 | Browser-verified | IMPLICIT | ✅ browser | ⏳ PENDING |

**Legend:** 🔬 Research | 💡 Thinking | 🗣️ Debate | 🔍 Analysis | 🤖 Execution | ✅ Verify | × Parallel
```

**Source types:**
- `EXPLICIT` - User literally said this
- `INFERRED` - Derived from user context (TECHSTACKPREFERENCES, etc.)
- `IMPLICIT` - Universal standards (security, quality)

**Status progression:**
- `PENDING` → `ACTIVE` → `DONE`
- `ADJUSTED` - Modified with reason
- `BLOCKED` - Cannot achieve, triggers loop-back

## Execution Flow

### Step 1: EFFORT CLASSIFICATION (REQUIRED FIRST)

```bash
bun run ~/.claude/skills/THEALGORITHM/Tools/EffortClassifier.ts --request "your request"
```

**Override methods:**
- CLI flag: `--override THOROUGH`
- Inline pattern: `"algorithm effort DETERMINED: build this feature"`

The effort level determines ALL available capabilities.

### Step 2: CAPABILITY LOADING

```bash
bun run ~/.claude/skills/THEALGORITHM/Tools/CapabilityLoader.ts --effort STANDARD
```

Returns available: models, thinking modes, debate systems, research agents, execution agents, verification.

### Step 3: ISC CREATION + CAPABILITY ASSIGNMENT

For each ISC row, select appropriate capability:

```bash
bun run ~/.claude/skills/THEALGORITHM/Tools/CapabilitySelector.ts --row "Research best practices" --effort STANDARD
# Returns: research.perplexity as primary, with icon 🔬

bun run ~/.claude/skills/THEALGORITHM/Tools/ISCManager.ts capability --row 1 -c research.perplexity
```

### Step 4: ORCHESTRATED EXECUTION

Execute in phases based on capability assignments:

```
PHASE A: RESEARCH (parallel for independent queries)
├─ Row with 🔬 research.perplexity → Spawn PerplexityResearcher
├─ Row with 🔬 research.gemini → Spawn GeminiResearcher
└─ Row with 🔬 research.grok → Spawn GrokResearcher

PHASE B: THINKING (for creative/analysis needs)
├─ Row with 💡 thinking.deep thinking → Invoke BeCreative skill
├─ Row with 🔍 analysis.first_principles → Invoke FirstPrinciples skill
└─ Row with 🗣️ debate.council → Invoke Council skill

PHASE C: EXECUTION (parallel agents)
├─ Row with 🤖 execution.engineer → Spawn Engineer agent
├─ Row with 🤖 execution.architect → Spawn Architect agent (THOROUGH+)
└─ Rows marked × → Run in parallel

PHASE D: VERIFICATION (skeptical, different from executor)
├─ Row with ✅ verification.browser → Browser skill validation
└─ All rows → Skeptical verifier agent (skeptical,meticulous,adversarial traits)
```

### For TRIVIAL (skip algorithm):
Direct response, no ISC, no capability loading. Just answer.

## Capability Categories

### Models (compute resources)
- `models.haiku` - Fast, cheap (QUICK+)
- `models.sonnet` - Balanced reasoning (STANDARD+)
- `models.opus` - Maximum intelligence (DETERMINED)

### Thinking Modes
- `thinking.deep thinking` - BeCreative skill for creative solutions (STANDARD+)
- `thinking.tree_of_thought` - Branching exploration (THOROUGH+)
- `thinking.plan_mode` - EnterPlanMode for complex implementations (THOROUGH+)

### Debate Systems
- `debate.council` - 4 agents, collaborative analysis (THOROUGH+)
- `debate.redteam` - 32 agents, adversarial stress-testing (DETERMINED)

### Analysis Modes
- `analysis.first_principles` - Challenge assumptions (STANDARD+)
- `analysis.science` - Hypothesis-driven exploration (STANDARD+)

### Research Agents
- `research.perplexity` - Web research, current events (STANDARD+)
- `research.gemini` - Multi-perspective research (STANDARD+)
- `research.grok` - Contrarian fact-checking (STANDARD+)
- `research.claude` - Academic/scholarly sources (STANDARD+)
- `research.codex` - Technical code pattern research (STANDARD+)

### Execution Agents
- `execution.intern` - Parallel grunt work (QUICK+)
- `execution.engineer` - Implementation/coding (STANDARD+)
- `execution.qa_tester` - Testing/validation (STANDARD+)
- `execution.designer` - UX/UI design (STANDARD+)
- `execution.architect` - System design (THOROUGH+)
- `execution.pentester` - Security testing (THOROUGH+)

### Verification
- `verification.browser` - Web application validation (STANDARD+)
- `verification.skeptical_verifier` - Different agent than executor (STANDARD+)

## Iteration Loop

When VERIFY finds issues:

```
BLOCKED row
    │
    ├─ Unclear what ideal looks like? → Loop to THINK
    ├─ Wrong approach? → Loop to PLAN
    └─ Execution error? → Loop to EXECUTE

Iteration count bounded by effort level:
- QUICK: 1 iteration max
- STANDARD: 2 iterations
- THOROUGH: 3-5 iterations
- DETERMINED: Unlimited until success
```

## Phase Transition Gates

Explicit approval checkpoints prevent wasted work. Gates scale with effort level:

| Gate | Transition | QUICK | STANDARD | THOROUGH+ |
|------|-----------|-------|----------|-----------|
| **Approach Gate** | PLAN → BUILD | Skip | Auto | **User approval required** |
| **Implementation Gate** | BUILD → EXECUTE | Skip | Auto | **User approval required** |
| **Completeness Gate** | EXECUTE → VERIFY | Auto | Auto | Auto |
| **Destructive Action Gate** | Any phase | **Always require** | **Always require** | **Always require** |
| **External Service Gate** | Any phase | **Always require** | **Always require** | **Always require** |

**Gate Rules:**
- **Auto** gates proceed without asking unless red flags are detected
- **User approval** gates use AskUserQuestion with the proposed approach
- **Destructive** and **External** gates ALWAYS require confirmation regardless of effort level
- Destructive = file deletion, database changes, git force operations
- External = API calls to third-party services, deployments, publishes

## Anti-Rationalization Guards (VERIFY Phase)

AI agents — including you — systematically rationalize skipping verification steps. These guards are non-negotiable:

### Iron Laws of Verification

1. **No completion without fresh evidence.** "I already checked" is not evidence. Re-verify with actual tool output.
2. **Delete means delete.** If something was removed, confirm it's actually gone. Don't assume.
3. **Claiming done without verification is dishonesty, not efficiency.** Every DONE status requires proof.
4. **The implementer finished suspiciously quickly.** Be skeptical of fast completions — verify actual output, not claims.
5. **Tests passing ≠ feature working.** Tests can be wrong. Browser/manual verification is the ground truth.

### Rationalization Red Flags

When you catch yourself thinking any of these, STOP and verify instead:

| Rationalization | Reality |
|----------------|---------|
| "This is straightforward, no need to verify" | Straightforward things fail all the time |
| "I just wrote this, I know it works" | You know what you *intended*. Verify what *happened*. |
| "The tests pass, so it's done" | Tests verify what you tested. Verify the actual requirement. |
| "I'll verify at the end" | You'll forget or run out of context. Verify NOW. |
| "The previous step guarantees this works" | Nothing is guaranteed. Check it. |
| "It's just a small change" | Small changes cause big failures |

### Verification Protocol

For every ISC row marked DONE:
1. State the **evidence** (tool output, file content, test result, screenshot)
2. Evidence must be from **this session** (not cached or remembered)
3. If evidence cannot be produced, status reverts to ACTIVE

## Deviation Rules (EXECUTE Phase)

When subagents encounter unexpected situations during execution:

### Auto-Fix (Act Autonomously)
- **Bug Fixes** — Fix bugs that block the current ISC row
- **Missing Critical Functionality** — Add obviously missing code that the ISC row requires
- **Unblocking** — Resolve imports, dependencies, configuration gaps

### Escalate (Return to Orchestrator)
- **Architectural Decisions** — Changing data models, API contracts, file structure, system design
- **Scope Expansion** — The task requires more than the ISC row specified
- **Conflicting Requirements** — Two ISC rows contradict each other

**The line:** If you can revert it with `git checkout`, auto-fix. If you can't, escalate.

## Integration

### Uses
- **Agents Skill** - AgentFactory for dynamic agent composition
- **CORE Skill** - User context for ISC inference
- **Browser Skill** - Web verification in VERIFY phase
- **BeCreative Skill** - deep thinking for THINK phase
- **Council Skill** - Multi-perspective debate (THOROUGH+)
- **RedTeam Skill** - Adversarial analysis (DETERMINED)
- **FirstPrinciples Skill** - Assumption challenging
- **Research Skill** - Multi-source research agents

### Memory
- ISC artifacts: `MEMORY/Work/{session}/ISC.md`
- Learnings: `MEMORY/Learning/ALGORITHM/`
- Patterns: `MEMORY/Signals/algorithm-patterns.jsonl`

## Workflow Routing

| Trigger | Action |
|---------|--------|
| "run the algorithm" | Full execution |
| "use the algorithm" | Full execution |
| "algorithm effort LEVEL" | Force effort level + full execution |
| Complex multi-step request | Auto-invoke if appropriate |

## Enhanced ISC Features

### Verification Paired at Creation

**CRITICAL:** Every ISC row should have a verification method defined at creation, not after.

```bash
# Add row WITH verification (recommended)
bun run ISCManager.ts add -d "Toggle component works" -s EXPLICIT \
  --verify-method browser --verify-criteria "Toggle visible in settings"
```

**Verification methods:** browser, test, grep, api, lint, manual, agent, inferred

See `Data/VerificationMethods.yaml` for selection guidance.

### Agent Claim System

Prevents race conditions when multiple agents work on ISC items.

```bash
# Claim an item
bun run ISCManager.ts claim --row 1 --agent Engineer

# Release when done
bun run ISCManager.ts release --row 1

# See what's available
bun run ISCManager.ts available
```

Claims expire after 30 minutes (stale detection).

### Research Override System

Research findings can BLOCK user assumptions. User must acknowledge.

```bash
# Research agent finds issue
bun run ISCManager.ts research-block --row 2 \
  --reason "Best practice is X, not Y" --source research.perplexity

# User acknowledges
bun run ISCManager.ts acknowledge --row 2 --action OVERRIDE  # or ACCEPT
```

### Nested Algorithm

Complex items spawn child ISAs.

```bash
# Mark item as nested
bun run ISCManager.ts nest --row 5

# Update child status
bun run ISCManager.ts child-status --row 5 --child-status COMPLETE
```

### Interview Protocol

When ideal state is unclear, use structured questions.

```bash
bun run ISCManager.ts interview -r "vague request"
```

**The 5 Questions:**
1. What does success look like when this is done?
2. Who will use this and what will they do with it?
3. What would make you show this to your friends?
4. What existing thing is this most similar to?
5. What should this definitely NOT do?

## Files

| File | Purpose |
|------|---------|
| `Data/Capabilities.yaml` | **Source of truth** for all capabilities |
| `Data/VerificationMethods.yaml` | **Verification method registry** |
| `Tools/AlgorithmDisplay.ts` | **LCARS visual display** + voice announcements |
| `Tools/EffortClassifier.ts` | Classify TRIVIAL→DETERMINED |
| `Tools/CapabilityLoader.ts` | Load + filter capabilities by effort |
| `Tools/CapabilitySelector.ts` | Select capabilities for ISC rows |
| `Tools/ISCManager.ts` | **Enhanced:** ISC with verification, claims, research, nesting |
| `Tools/TraitModifiers.ts` | Effort → trait mappings |
| `Phases/*.md` | Detailed phase documentation (Observe.md has interview protocol) |
| `Reference/CapabilityMatrix.md` | Effort → capability documentation |

## The Purpose

**Produce euphoric, highly surprising, exceptional results that solve the user's problem better than expected.**

The ISC captures what "ideal" looks like. Effort determines available capabilities. Execute against it. Verify against it. Iterate until achieved.

**This is not documentation. This is a command. Execute the algorithm.**
