# MASTER WEB APPLICATION SECURITY TESTING METHODOLOGY

**Compiled from:**
- Jason Haddix's Bug Hunter's Methodology (TBHM v4)
- The Web Application Hacker's Handbook (2nd Edition)
- Daniel Miessler's Adaptive Testing Methodology

**Philosophy:** Breadth-first reconnaissance combined with depth-focused vulnerability analysis, mechanized through modular automation where possible, with human intelligence applied to strategic decisions.

---

## PHASE 0: SCOPING & PREPARATION

### 0.1 Define Engagement Parameters
- **Scope Definition**
  - In-scope domains, IP ranges, applications
  - Out-of-scope assets (production vs staging)
  - Allowed testing methods and times
  - Credential provision for authenticated testing

- **Goal Setting**
  - Vulnerability assessment (breadth)
  - Penetration test (depth + exploitation)
  - Red team engagement (objective-based)
  - Bug bounty (continuous discovery)

- **Tool Environment Setup**
  - Verify tool installations and versions
  - Configure API keys (Shodan, Censys, etc.)
  - Set up testing infrastructure
  - Prepare wordlists (SecLists, all.txt)

### 0.2 Legal & Authorization
- Signed authorization documents
- Emergency contact information
- Rules of engagement agreement
- Data handling and confidentiality

---

## PHASE 1: RECONNAISSANCE & ASSET DISCOVERY

**Goal:** Discover ALL assets associated with target before testing begins
**Philosophy:** Breadth-first - find everything, then prioritize
**Approach:** Passive first, then active validation

### 1.1 Subdomain Enumeration

#### Passive Subdomain Discovery
**Data Sources:**
- Certificate Transparency logs (crt.sh, cert.sh, Censys, CertSpotter)
- DNS aggregators (DNSDB, Robtex, VirusTotal)
- Search engines (Google, Bing, Yahoo, Baidu dorking)
- Threat intelligence (ThreatMiner, ThreatCrowd, PassiveTotal)
- Archive data (Wayback Machine, Ptrarchive)
- Code repositories (GitHub, GitLab reconnaissance)

**Tools:**
- Amass (passive mode) - ~30 sources
- Subfinder - Fast passive discovery
- Assetfinder - Additional passive sources
- crt.sh API - Certificate transparency
- Sublist3r - Multi-source aggregation

**Technique:**
- Run multiple tools in parallel
- Combine and deduplicate results
- Extract subdomains from all sources

#### Active Subdomain Brute-Forcing
**Wordlists:**
- Jason Haddix's all.txt (comprehensive merged list)
- SecLists DNS discovery lists
- CommonSpeak subdomain wordlists
- Custom wordlists based on target naming

**Tools:**
- Amass (active mode with brute-forcing)
- MassDNS - Ultra-fast DNS resolution
- Gobuster (DNS mode)
- Puredns - DNS brute-forcing

**Technique:**
```bash
# Brute-force with MassDNS for speed
subbrute.py + all.txt → pipe to → massdns
# Can process 1M+ entries in ~1.5 minutes
```

#### Permutation & Alteration Scanning
**Tools:**
- Altdns - Permutation-based discovery
- Amass (built-in permutation mode)

**Technique:**
- Input: Previously discovered subdomains + common words
- Generate permutations (dev-one → dev-two, dev-three, etc.)
- Discover systematic naming patterns
- Find WAF bypasses and CDN origins

**Common Permutation Words:**
test, dev, staging, prod, production, api, admin, portal, vpn, mail, etc.

#### Recursive Discovery
**Technique:**
- Find 4th, 5th, 6th level domains
- Recursively enumerate discovered subdomains
- Example: api.dev.sub1.example.com

**Tools:**
- Altdns (recursive mode)
- Custom scripting for multi-level discovery

### 1.2 Infrastructure Mapping

#### Port Scanning
**Approach:** Masscan for speed, Nmap for accuracy

**Masscan:**
- Scan all 65,535 ports across all discovered hosts
- Internet-scale scanner (6 minutes for entire Internet)
- 10M packets/second capability
- Output in Nmap format for re-scanning

**Nmap:**
- Service detection on discovered ports
- Version fingerprinting
- OS detection
- Script scanning for additional info

**Command Flow:**
```bash
# Masscan for initial discovery
masscan -p1-65535 <targets> --rate=10000 -oG masscan_output.txt

# Nmap for detailed analysis
nmap -sV -sC -p<discovered_ports> <targets>
```

#### Service Fingerprinting
- Banner grabbing on open ports
- Technology stack detection
- Version identification for vulnerability matching

**Tools:**
- Wappalyzer - Web technology detection
- BuiltWith - Technology profiler
- WhatWeb - Command-line fingerprinting
- Nmap service detection

#### Cloud Asset Discovery
**AWS/GCP/Azure Recon:**
- S3 bucket enumeration
- Cloud storage discovery
- Subdomain takeover identification
- Cloud service mapping

**Tools:**
- Cloud_enum - Multi-cloud enumeration
- S3Scanner - AWS S3 bucket discovery
- Bucket finder scripts

### 1.3 Content & Endpoint Discovery

#### Directory & File Brute-Forcing
**Tools:**
- ffuf - Fast web fuzzer (high performance)
- Gobuster - Go-based directory brute-forcing
- Dirsearch - Python-based discovery
- Feroxbuster - Recursive content discovery

**Wordlists:**
- SecLists (curated by Daniel Miessler, Jason Haddix, g0tm1lk)
- Jason Haddix's all.txt
- Technology-specific wordlists
- Custom lists based on target

**Technique:**
- Directory enumeration
- File extension fuzzing
- Backup file discovery (.bak, .old, ~, .swp)
- Source code disclosure attempts

#### Virtual Host Discovery
**Tools:**
- Gobuster (vhost mode)
- ffuf (VHOST fuzzing)
- Custom vhost scripts

**Technique:**
- Fuzz Host header to discover virtual hosts
- Multiple sites/apps may share same IP
- Discover hidden applications

#### JavaScript Analysis & Endpoint Extraction
**Purpose:** Discover hidden API endpoints and functionality not visible in HTML

**Tools:**
- LinkFinder - Python script for endpoint discovery in JS
- JSParser - Burp Suite extension
- GAP (Burp) - Parses inline and external JS
- JS Miner (Burp) - Finds API endpoints
- JSpider - Browser-based JS crawling
- getallurls (gau) - URL extraction

**Technique:**
- Extract all <script> tags and external .js files
- Parse for API endpoints using regex patterns
- Identify hidden parameters
- Discover internal API structure
- Manual analysis for complex JS applications

**Endpoint Regex Pattern:**
```regex
"(?<=(\"|'|`))/[a-zA-Z0-9_?&=/\-#.]*(?=(\"|'|`))"
```

**JS File Detection:**
```regex
(?<=(\"|'|`))(\/|https?:\/\/)[a-zA-Z0-9_?&=/\-#.]+\.js(?:\?[^"'%60]*)?(?=(\"|'|`))
```

#### API Reconnaissance

**GraphQL Discovery:**
- Common GraphQL paths: /graphql, /api/graphql, /graphql/api, /v1/graphql, /graphql/console
- Introspection queries (__schema field)
- Introspection bypass techniques (special characters after __schema)
- Schema discovery with Clairvoyance

**REST API Enumeration:**
- Swagger/OpenAPI documentation discovery
  - /swagger.json, /api/swagger.json, /v1/swagger.json
  - /swagger-ui.html, /api-docs, /openapi.json
- Kiterunner - Contextual API scanning with Swagger specs
- APISpider & Postman for endpoint discovery
- Burp Suite site map analysis

**Mobile API Discovery:**
- APK decompilation (APKLeaks)
- iOS binary analysis
- Mobile APIs often share domain with web (in scope!)
- Hardcoded API keys and endpoints

### 1.4 Data Source Reconnaissance

#### Search Engine Intelligence
**Google Dorking:**
- `site:*.target.com api`
- `site:*.target.com inurl:api`
- `site:*.target.com v1 OR v2 OR graphql`
- `site:target.com ext:php OR ext:asp OR ext:jsp`
- Exposed files, directories, credentials

**Other Search Engines:**
- Bing, DuckDuckGo, Baidu
- Different indexing patterns

#### GitHub & Code Repository Recon
**Jason Haddix's GitHub Dorking Techniques:**

**Credentials & Secrets:**
- `password`, `npmrc _auth`, `dockercfg`, `git-credentials`
- `pem private`, `id_rsa`, `aws_access_key_id`, `s3cfg`
- `api_key`, `SECRET_KEY`, `client_secret`, `github_token`
- `xoxp`, `xoxb`, `xoxa` (Slack tokens)

**Config Files:**
- `.env`, `composer.json`, `.bash_history`, `passwd`
- `deploy.rake`, `.npmrc`, `.dockercfg`

**Tools:**
- GitHub search with dorks
- GitRob - GitHub reconnaissance
- TruffleHog - Secret discovery
- Automated dorking scripts

#### Internet-Wide Scanning Databases
**Shodan:**
- Banner collection from internet-connected devices
- Favicon hashing to find technologies/brands
- Exposed services and ports
- Misconfigured devices

**Censys:**
- Weekly scans of IPv4 for many protocols
- Daily scans of popular websites
- SSL certificate storage (domains & emails)
- More structured certificate data than Shodan

**ZoomEye:**
- Similar to Shodan/Censys
- Additional coverage

#### Historical & Archive Data
**Wayback Machine (Archive.org):**
- Old/abandoned JavaScript files with exposed endpoints
- Legacy API endpoints still accessible
- Abandoned CDN endpoints
- Dev/staging endpoints in source comments
- Historical infrastructure changes

**Technique:**
- Search target in Wayback archives
- Analyze old source code
- Extract URLs, endpoints, comments
- Track infrastructure evolution

### 1.5 Live Host Validation & Screenshot

**Tools:**
- httpx - Fast HTTP probing
  - HTTP status codes
  - Page titles
  - Technology detection
  - TLS/SSL information
- Aquatone - Visual reconnaissance with screenshots
- EyeWitness - Website screenshot utility
- Gowitness - Go-based screenshot tool

**Workflow:**
```bash
# Validate which subdomains are live
cat all_subdomains.txt | httpx -title -tech-detect -status-code -o live_hosts.txt

# Screenshot for visual analysis
cat live_hosts.txt | aquatone
```

### 1.6 Reconnaissance Output & Organization

**Deliverables:**
- Complete subdomain list (all levels)
- Live host inventory with technologies
- Open port matrix
- Discovered endpoints and APIs
- Identified technologies and versions
- Screenshots of all web applications
- Infrastructure map

**Organization:**
- Structured directories by phase
- Database or CSV for large asset lists
- Automated updates for continuous monitoring

---

## PHASE 2: APPLICATION MAPPING & ANALYSIS

**Goal:** Understand application architecture, functionality, and attack surface
**Source:** WAHH Phase 1-2, Haddix Application Analysis

### 2.1 Map Application Content

#### Spider & Crawl
**Tools:**
- Burp Suite Spider
- ZAP Spider
- GoSpider - Fast Go-based crawler
- Hakrawler - Web crawler for recon
- Katana - Next-gen crawling framework

**Technique:**
- Authenticated crawling (with test credentials)
- Multi-user role crawling (different privilege levels)
- Analyze sitemap.xml and robots.txt
- Capture all requests in proxy

#### Manual Exploration
- Browse entire application as normal user
- Click every link, fill every form
- Test all input fields
- Note interesting parameters and functionality
- Identify user roles and privilege levels

#### Technology Stack Analysis
**Identify:**
- Web server (Apache, Nginx, IIS)
- Application framework (Rails, Django, .NET, Node.js)
- Frontend frameworks (React, Angular, Vue)
- Programming language
- Database technology (inferred from errors, behavior)
- WAF/Security controls
- CDN and caching layers
- Third-party integrations

### 2.2 Analyze Application Architecture

#### Entry Points Identification
- All URL parameters
- POST body parameters
- Cookies
- HTTP headers (custom headers, User-Agent, Referer, etc.)
- File uploads
- JSON/XML in request bodies
- GraphQL queries

#### Data Flow Analysis
- Map user input → processing → output
- Identify data validation points
- Trace sensitive data handling
- Understand business logic flow

#### Authentication Mechanisms
- Login process analysis
- Password reset functionality
- Multi-factor authentication
- SSO/OAuth implementations
- API authentication (tokens, API keys, OAuth)

#### Session Management
- Cookie attributes (HttpOnly, Secure, SameSite)
- Token generation patterns
- Session timeout behavior
- Concurrent session handling

---

## PHASE 3: VULNERABILITY DISCOVERY & EXPLOITATION

**Goal:** Systematically test for all vulnerability classes
**Source:** WAHH Phases 3-12, OWASP ASVS, Haddix Testing Approach

### 3.1 Test Client-Side Controls

#### JavaScript Validation Bypass
- Disable JavaScript
- Modify JavaScript in browser
- Intercept and modify requests (bypass client-side validation)

#### HTML5 Security
- postMessage vulnerabilities
- Web Storage security
- CORS misconfigurations

#### Browser Vulnerabilities
- Clickjacking potential
- UI redressing attacks

### 3.2 Test Authentication Mechanism

#### Authentication Vulnerabilities
- **Username Enumeration**
  - Different responses for valid vs invalid usernames
  - Timing attacks
  - Account harvesting

- **Weak Credentials**
  - Default credentials
  - Common passwords
  - Credential stuffing potential

- **Brute Force Protection**
  - Rate limiting effectiveness
  - Account lockout mechanisms
  - CAPTCHA bypass

- **Password Reset Flaws**
  - Predictable reset tokens
  - Token not expiring
  - Account takeover via reset
  - User enumeration

- **Multi-Factor Bypasses**
  - MFA implementation flaws
  - Backup code weaknesses
  - SMS interception vectors

#### SQL Injection in Authentication
- Login form injection
- `' OR '1'='1` and variants
- Time-based blind SQLi
- Boolean-based blind SQLi

### 3.3 Test Session Management

#### Session Token Analysis
- Randomness testing
- Predictability analysis
- Token strength assessment

#### Session Fixation
- Can attacker set session ID?
- Session adoption after login?

#### Session Hijacking Vectors
- XSS to steal cookies
- Network sniffing (non-HTTPS)
- Session prediction

#### Cookie Security
- Missing HttpOnly flag
- Missing Secure flag
- Improper SameSite attribute
- Cookies with sensitive data

### 3.4 Test Access Controls

#### Vertical Privilege Escalation
- Access admin functions as normal user
- Parameter manipulation (user_id, role, etc.)
- Direct URL access to privileged functions

#### Horizontal Privilege Escalation
- Access other users' data
- IDOR (Insecure Direct Object References)
- Manipulate user identifiers in requests

#### Missing Function-Level Access Control
- Administrative endpoints accessible
- API endpoints without authorization
- Hidden functionality exposed

### 3.5 Test for Input-Based Vulnerabilities

#### SQL Injection
**Testing Locations:**
- URL parameters
- POST data
- Headers (User-Agent, Referer, X-Forwarded-For)
- Cookies

**Types:**
- Error-based SQLi
- Union-based SQLi
- Boolean-based blind SQLi
- Time-based blind SQLi
- Second-order SQLi

**Tools:**
- SQLMap - Automated SQL injection
- Manual testing with payloads

#### Cross-Site Scripting (XSS)
**Types:**
- Reflected XSS
- Stored XSS
- DOM-based XSS
- Mutation XSS (mXSS)

**Testing Payloads:**
- Basic: `<script>alert(1)</script>`
- Event handlers: `<img src=x onerror=alert(1)>`
- SVG: `<svg onload=alert(1)>`
- Polyglots for WAF bypass

**Tools:**
- XSStrike - Advanced XSS detection
- Dalfox - Parameter analysis and XSS
- Manual payload crafting

#### Cross-Site Request Forgery (CSRF)
- Missing CSRF tokens
- Weak token implementation
- Token not validated
- Token reuse

#### Command Injection (OS/System)
**Payloads:**
- `; ls`, `| whoami`, `&& cat /etc/passwd`
- Blind command injection with time delays
- Out-of-band data exfiltration

#### XML External Entity (XXE)
- XML parsing vulnerabilities
- External entity injection
- File disclosure via XXE
- SSRF via XXE

#### Server-Side Template Injection (SSTI)
- Template engine detection
- Payload injection based on engine
- RCE potential

#### Server-Side Request Forgery (SSRF)
**Testing:**
- Internal IP access (192.168.x.x, 10.x.x.x, 127.0.0.1)
- Cloud metadata endpoints (169.254.169.254)
- Port scanning via SSRF
- Protocol smuggling

#### Local/Remote File Inclusion
- Path traversal (../../../etc/passwd)
- Filter bypass techniques
- Null byte injection (%00)
- Remote code inclusion

#### Insecure Deserialization
- Java deserialization (ysoserial)
- PHP object injection
- Python pickle vulnerabilities
- .NET deserialization

### 3.6 Test Function-Specific Vulnerabilities

#### File Upload Vulnerabilities
- Unrestricted file upload
- Extension filter bypass (.php.jpg, .phtml)
- MIME type spoofing
- Path traversal in filename
- XXE in uploaded XML/SVG
- Archive extraction vulnerabilities (Zip Slip)

#### Payment Processing
- Price manipulation
- Quantity tampering
- Currency conversion exploits
- Race conditions

#### Email/Notification Functionality
- Email header injection
- SMTP injection
- HTML injection in emails

### 3.7 Test for Logic Flaws

#### Business Logic Vulnerabilities
- Workflow bypass
- State machine manipulation
- Race conditions
- Time-of-check to time-of-use (TOCTOU)
- Insufficient process validation

**Examples:**
- Negative quantities in shopping cart
- Skipping payment steps
- Replaying/reordering steps
- Parallel requests for race conditions

#### Application Logic Testing
- Identify intended workflow
- Map all possible states
- Attempt out-of-order operations
- Test with unexpected values (negative, zero, huge numbers)

### 3.8 Test Application Hosting & Infrastructure

#### Shared Hosting Issues
- Virtual host confusion
- Cross-application attacks
- Resource exhaustion affecting neighbors

#### Application Server Vulnerabilities
- Server misconfiguration
- Default credentials
- Unnecessary HTTP methods (PUT, DELETE, TRACE)
- Directory listing enabled
- Verbose error messages

#### Web Server Testing
- HTTP method tampering
- Request smuggling
- Host header attacks
- HTTP desync attacks

### 3.9 Miscellaneous Security Checks

#### Information Disclosure
- Verbose error messages
- Stack traces
- Debug information
- Comments in source code
- Metadata in files
- API responses with sensitive data

#### Security Headers
- Missing Content-Security-Policy
- Missing X-Frame-Options (clickjacking)
- Missing X-Content-Type-Options
- Missing Strict-Transport-Security
- Permissive CORS headers

#### Cryptographic Issues
- Weak SSL/TLS configuration
- Insecure algorithms (MD5, SHA1 for passwords)
- Predictable random values
- Hardcoded encryption keys

#### Denial of Service
- Resource exhaustion
- Regular expression DoS (ReDoS)
- XML bomb (billion laughs attack)
- Application-level DoS

---

## PHASE 4: ADVANCED TESTING & EXPLOITATION

### 4.1 API Security Testing

#### API-Specific Vulnerabilities
- Mass assignment
- Excessive data exposure
- Lack of rate limiting
- BOLA (Broken Object Level Authorization)
- BFLA (Broken Function Level Authorization)

#### GraphQL-Specific
- Query depth attacks
- Batching attacks
- Circular query attacks
- Field duplication DoS

#### REST API Testing
- HTTP verb tampering
- Parameter pollution
- Content-Type bypass

### 4.2 Modern Application Testing

#### Single Page Applications (SPA)
- Client-side routing bypass
- State manipulation
- Local storage security

#### Progressive Web Apps (PWA)
- Service worker security
- Cache poisoning

#### WebSocket Testing
- Connection hijacking
- Message tampering
- CSWSH (Cross-Site WebSocket Hijacking)

#### Cloud-Native Applications
- Kubernetes API exposure
- Container escape
- Secrets in environment variables
- Misconfigured cloud services

---

## PHASE 5: AUTOMATION & CONTINUOUS MONITORING

**Goal:** Mechanize repetitive tasks, enable continuous discovery
**Source:** Daniel Miessler's "Mechanizing the Methodology," Haddix Automation

### 5.1 Automation Philosophy

#### Principles
- **Granular Questions:** Break testing into small, answerable questions
- **Modular Design:** Discrete scripts with single responsibility
- **Pipeline Architecture:** Chain outputs as inputs for next process
- **Human + Machine:** Automate recon, apply human intelligence to analysis

#### Automation Tiers
- **C-Level:** Basic bash scripts, single-threaded
- **B-Level:** Modular automation, point-in-time scans, flat file output
- **A-Level:** Continuous monitoring, GUI, database integration, real-time alerts
- **S-Level:** Enterprise scale, distributed processing, AI/ML integration

### 5.2 Continuous Reconnaissance

#### Scheduled Discovery
**Cron Jobs:**
```bash
# Daily scope fetching (bug bounty)
0 17 * * * /path/to/fetch_bounty_scopes.sh

# Weekly subdomain enumeration
0 2 * * 0 /path/to/subdomain_discovery.sh

# Hourly new host validation
0 * * * * /path/to/validate_new_hosts.sh
```

#### Change Detection
- Monitor for new subdomains
- Detect new open ports
- Track application changes
- Alert on new technologies deployed

#### Integration & Notifications
- Slack/Discord webhooks
- Email alerts
- Dashboard visualization
- Database storage for trending

### 5.3 Tool Orchestration

#### Reconnaissance Pipeline Example
```bash
# 1. Subdomain enumeration
amass enum -d target.com -o amass.txt &
subfinder -d target.com -o subfinder.txt &
wait

# 2. Combine and deduplicate
cat amass.txt subfinder.txt | sort -u > all_subdomains.txt

# 3. Live host validation
cat all_subdomains.txt | httpx -o live_hosts.txt

# 4. Vulnerability scanning
cat live_hosts.txt | nuclei -t ~/nuclei-templates/

# 5. Notify results
./send_to_slack.sh "Discovery complete: $(wc -l live_hosts.txt) live hosts"
```

#### Modular Script Design
- Each script does ONE thing well
- Accepts stdin/file input
- Outputs to stdout/file
- Exit codes for success/failure
- Logging for debugging

---

## PHASE 6: REPORTING & REMEDIATION TRACKING

### 6.1 Vulnerability Documentation

#### Required Information
- Vulnerability title and type
- Severity rating (CVSS score)
- Affected components/URLs
- Step-by-step reproduction
- Proof-of-concept code/screenshots
- Business impact analysis
- Remediation recommendations
- References (OWASP, CWE, CVE)

### 6.2 Evidence Collection
- Screenshots/screen recordings
- HTTP request/response pairs
- Exploitation proof
- Payload examples
- Before/after comparisons

### 6.3 Prioritization
- Critical: RCE, Authentication bypass, SQL injection with data access
- High: XSS (stored), IDOR with sensitive data, authorization flaws
- Medium: CSRF, some information disclosure, security misconfigurations
- Low: Minor information leakage, missing best practices
- Informational: Observations without direct security impact

---

## METHODOLOGY ADAPTATION GUIDES

### For Bug Bounty Hunting
- **Emphasis:** Phase 1 (Reconnaissance) - breadth-first
- **Continuous monitoring:** Automated daily/weekly scans
- **Quick wins:** Focus on high-impact, easy-to-find vulnerabilities
- **Scaling:** Process multiple targets simultaneously

### For Penetration Testing
- **Emphasis:** Phases 3-4 (Vulnerability Discovery & Exploitation)
- **Time-boxed:** Prioritize based on engagement duration
- **Depth:** Thorough testing of identified issues
- **Goal-oriented:** Achieve specific objectives (domain admin, data exfiltration)

### For Red Team Engagements
- **Emphasis:** Stealth and objective completion
- **Minimal noise:** Avoid broad scanning
- **Creative exploitation:** Chain vulnerabilities
- **Social engineering:** Combine technical and human attacks

### For Vulnerability Assessments
- **Emphasis:** Comprehensive coverage
- **Automated + Manual:** Balance for efficiency
- **Breadth over depth:** Identify all issues, don't fully exploit
- **Remediation focus:** Prioritized findings for fixes

---

## TOOL REFERENCE MATRIX

### Reconnaissance
- **Subdomain Enum:** Amass, Subfinder, Assetfinder, crt.sh, MassDNS
- **Content Discovery:** ffuf, Gobuster, Feroxbuster, Dirsearch
- **Port Scanning:** Masscan, Nmap
- **Screenshots:** Aquatone, EyeWitness, Gowitness
- **JS Analysis:** LinkFinder, JSParser, GAP, JS Miner

### Vulnerability Scanning
- **Web Scanners:** Burp Suite, ZAP, Nuclei, Nikto
- **SQLi:** SQLMap
- **XSS:** XSStrike, Dalfox
- **API Testing:** Postman, Kiterunner, Swagger tools

### Infrastructure
- **Cloud:** cloud_enum, S3Scanner
- **Services:** Shodan, Censys, ZoomEye
- **Git Recon:** GitRob, TruffleHog, GitHub dorking scripts

### Automation
- **Frameworks:** Recon-ng, SpiderFoot, reconftw
- **Custom:** Bash/Python scripts, cron jobs

### Wordlists
- **SecLists** (Daniel Miessler, Jason Haddix, g0tm1lk)
- **Jason Haddix's all.txt**
- **CommonSpeak**

---

## CONTINUOUS IMPROVEMENT

### Stay Updated
- Follow security researchers (Jason Haddix, PortSwigger, etc.)
- Monitor CVEs and security advisories
- Attend conferences (DEF CON, Black Hat, BSides)
- Participate in bug bounty programs
- Contribute to open source security tools

### Methodology Evolution
- Adapt to new technologies (containers, serverless, cloud-native)
- Incorporate new tools and techniques
- Learn from past engagements
- Document lessons learned
- Share knowledge with community

---

**Last Updated:** 2025-10-20
**Version:** 1.0 - Master Methodology Compilation
**Sources:** TBHM v4, WAHH 2nd Ed, Daniel Miessler ATM/Blog Posts
