# Puffery and Exaggeration

## "Stands as" / "serves as"

|  | Words to watch: ***stands/serves as / is a testament/reminder*, *plays a vital/significant/crucial role*, *underscores/highlights its importance/significance*, *reflects broader*, *symbolizing its ongoing*, *enduring/lasting impact*, *key turning point*, *indelible mark*, *deeply rooted*, *profound heritage*, *steadfast dedication*...** |
| --- | --- |

LLM writing often puffs up the importance of the subject matter by adding statements about how arbitrary aspects of the topic represent or contribute to a broader topic.[^8] There is a distinct and easily identifiable repertoire of ways that it writes these statements.[^9] LLMs may include these for even the most mundane of things, sometimes with hedging comments like "While \[minor/not well known/etc\], it \[symbolizes/stands as/contributes\]..."

When talking about biology (e.g. when asked to discuss a given animal or plant species), LLMs tend to put too much emphasis on the species' conservation status and the efforts to protect it, even if the status is unknown and no serious efforts exist, and may strain to derive symbolism from things like taxonomy.

**Examples**

> Douera enjoys close proximity to the capital city, Algiers, further ==enhancing its significance== as a dynamic hub of activity and culture. With its coastal charm and convenient location, Douera ==captivates both residents and visitors alike== \[...\]

— From [this revision](https://en.wikipedia.org/w/index.php?title=&diff=1161677884&oldid=) to [Douéra](https://en.wikipedia.org/wiki/Dou%C3%A9ra "Douéra")

> Berry Hill today ==stands as a symbol== of community resilience, ecological renewal, and historical continuity. Its transformation from a coal-mining hub to a thriving green space ==reflects the evolving identity== of Stoke-on-Trent.

— From [Draft:Berry Hill, Stoke-on-Trent](https://en.wikipedia.org/wiki/Draft:Berry_Hill,_Stoke-on-Trent "Draft:Berry Hill, Stoke-on-Trent")

> By preying on these pests, Zagloba species ==play a significant role== in natural pest control, ==contributing to ecological balance== and agricultural health.

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1267500649 "Special:Diff/1267500649") to [Zagloba (beetle)](https://en.wikipedia.org/wiki/Zagloba_\(beetle\) "Zagloba (beetle)")

> These citations, spanning more than six decades and appearing in recognized academic publications, ==illustrate Blois' lasting influence in computational linguistics, grammar, and neology.==

— From [this revision](https://en.wikipedia.org/wiki/Special:PermanentLink/1308008350 "Special:PermanentLink/1308008350") to [Draft:Jacques Blois (linguist)](https://en.wikipedia.org/wiki/Draft:Jacques_Blois_\(linguist\) "Draft:Jacques Blois (linguist)")

## Superficial analyses

|  | Words to watch: ***ensuring...*, *highlighting...*, *emphasizing...*, *reflecting...*, *underscoring...*, *showcasing...*, *aligns with...*, *contributing to...*** |
| --- | --- |

AI chatbots tend to insert superficial analysis of information, often in relation to its significance, recognition, or impact. This is often done by attaching a [present participle](https://en.wikipedia.org/wiki/Participle#Forms "Participle") ("-ing") phrase at the end of sentences, sometimes with vague attributions to third parties (see below).[^8]

While many of these words are strong AI tells on their own,[^9] an even stronger tell is when the subjects of these verbs are facts, events, or other abstract concepts. A person, for example, can highlight or emphasize something, but a fact or event cannot. The "highlighting" or "underscoring" is not something that is actually happening; it is a claim by a disembodied narrator about what something means.[^8]

Such comments are usually [synthesis](https://en.wikipedia.org/wiki/Wikipedia:SYNTH "Wikipedia:SYNTH") and/or unattributed opinions in wikivoice. Newer chatbots with [retrieval-augmented generation](https://en.wikipedia.org/wiki/Retrieval-augmented_generation "Retrieval-augmented generation") may instead attach this language to attributed statements, e.g., "Critic Roger Ebert praised the film, underscoring the story's impact...", but since it is still AI-generated text it may be an inaccurate or [subjective representation](https://en.wikipedia.org/wiki/Wikipedia:OR "Wikipedia:OR") of what the source actually said.

**Examples**

> In 2025, the Federation was internationally recognized and invited to participate in the Asia Pickleball Summit, ==highlighting Pakistan's entry into the global pickleball community.==

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1299294247 "Special:Diff/1299294247") to [Draft:Pakistan Pickleball Federation](https://en.wikipedia.org/wiki/Draft:Pakistan_Pickleball_Federation "Draft:Pakistan Pickleball Federation")

> The [civil rights movement](https://en.wikipedia.org/wiki/Civil_rights_movement "Civil rights movement") emerged as a powerful continuation of this struggle, ==emphasizing the importance of solidarity and collective action in the fight for justice==.

— From [this revision](https://en.wikipedia.org/wiki/Special:PermanentLink/1299132059 "Special:PermanentLink/1299132059") to [African-American culture](https://en.wikipedia.org/wiki/African-American_culture "African-American culture")

> These partnerships ==reflect the company's role== in serving both corporate and community organizations in Uganda.

— From [Draft:GEOWISE MEDIA](https://en.wikipedia.org/wiki/Draft:GEOWISE_MEDIA "Draft:GEOWISE MEDIA")

[^8]: ["10 Ways AI Is Ruining Your Students' Writing"](https://www.chronicle.com/article/10-ways-ai-is-ruining-your-students-writing). *Chronicle of Higher Education*. September 16, 2025.

[^9]: Juzek, Tom S.; Ward, Zina B. (2025). [*Why Does ChatGPT "Delve" So Much? Exploring the Sources of Lexical Overrepresentation in Large Language Models*](https://aclanthology.org/2025.coling-main.426.pdf) (PDF). Findings of the Association for Computational Linguistics: ACL 2025. [Association for Computational Linguistics](https://en.wikipedia.org/wiki/Association_for_Computational_Linguistics "Association for Computational Linguistics"). [arXiv](https://en.wikipedia.org/wiki/ArXiv_\(identifier\) "ArXiv (identifier)"):[2412.11385](https://arxiv.org/abs/2412.11385). Retrieved October 13, 2025 – via [ACL Anthology](https://en.wikipedia.org/wiki/ACL_Anthology "ACL Anthology").
