# Communication Patterns

## Subject lines

User messages and [unblock requests](https://en.wikipedia.org/wiki/Wikipedia:Identifying_LLM_unblock_requests "Wikipedia:Identifying LLM unblock requests") generated by AI chatbots sometimes begin with text that is intended to be pasted into the *Subject* field on an email form.

**Examples**

> Subject: Request for Permission to Edit Wikipedia Article - "Dog"

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1210351576 "Special:Diff/1210351576") to [Talk:Dog](https://en.wikipedia.org/wiki/Talk:Dog "Talk:Dog")

> Subject: Request for Review and Clarification Regarding Draft Article

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1256545561 "Special:Diff/1256545561") to [Wikipedia:WikiProject Articles for creation/Help desk](https://en.wikipedia.org/wiki/Wikipedia:WikiProject_Articles_for_creation/Help_desk "Wikipedia:WikiProject Articles for creation/Help desk")

## Collaborative communication

|  | Words to watch: ***I hope this helps*, *Of course!*, *Certainly!*, *You're absolutely right!*, *Would you like...*, *is there anything else*, *let me know*, *more detailed breakdown*, *here is a*...** |
| --- | --- |

In some cases, editors will paste text from an AI chatbot that was meant as correspondence, prewriting or advice by the chatbot, rather than article content. AI chatbots may also explicitly indicate that the text is for a Wikipedia article if prompted to produce one, and may mention various [policies and guidelines](https://en.wikipedia.org/wiki/Wikipedia:PG "Wikipedia:PG") in their outputs—often explicitly specifying that they're *Wikipedia* 's conventions.

**Examples**

> This fictional article combines the tone of a Wikipedia article and the creative elements you requested, including the announcement date, release date, new cast, and crew for the sequel. Let me know if you'd like it expanded or tailored further!

— From [Draft:A Knight's Tale: The Legend Continues](https://en.wikipedia.org/wiki/Draft:A_Knight%27s_Tale:_The_Legend_Continues "Draft:A Knight's Tale: The Legend Continues")

> Certainly. Here's a draft Wikipedia-style article for Mark Biram, written in a neutral, encyclopedic tone and formatted according to Wikipedia conventions. This assumes notability is supported by independent sources (which would need to be cited for a real Wikipedia page):

— From [this revision](https://en.wikipedia.org/wiki/Special:PermanentLink/1299612408 "Special:PermanentLink/1299612408") to [Draft:Mark Biram](https://en.wikipedia.org/wiki/Draft:Mark_Biram "Draft:Mark Biram")

> Final important tip: The ~~~~ at the very end is Wikipedia markup that automatically

— Adapted from [this revision](https://en.wikipedia.org/w/index.php?title=&diff=1297191187&oldid=) to [Talk:Test automation management tools](https://en.wikipedia.org/wiki/Talk:Test_automation_management_tools "Talk:Test automation management tools"); the message also [ends unexpectedly](https://en.wikipedia.org/wiki/#Abrupt_cut_offs)

> In this section, we will discuss the background information related to the topic of the report. This will include a discussion of relevant literature, previous research, and any theoretical frameworks or concepts that underpin the study. The purpose is to provide a comprehensive understanding of the subject matter and to inform the reader about the existing knowledge and gaps in the field.

— From [this revision](https://en.wikipedia.org/w/index.php?title=&diff=1172646802&oldid=) to [Metaphysics](https://en.wikipedia.org/wiki/Metaphysics "Metaphysics")

> Including photos of the forge (as above) and its tools would enrich the article's section on culture or economy, giving readers a visual sense of Ronco's industrial heritage. Visual resources can also highlight Ronco Canavese's landscape and landmarks. For instance, a map of the Soana Valley or Ronco's location in Piedmont could be added to orient readers geographically. The village's scenery \[...\] could be illustrated with an image. Several such photographs are available (e.g., on Wikimedia Commons) that show Ronco's panoramic view, \[...\] Historical images, if any exist (such as early 20th-century photos of villagers in traditional dress or of old alpine trades), would also add depth to the article. Additionally, the town's notable buildings and sites can be visually presented: \[...\] Including an image of the Santuario di San Besso \[...\] could further engage readers. By leveraging these visual aids – maps, photographs of natural and cultural sites – the expanded article can provide a richer, more immersive picture of Ronco Canavese.

## Knowledge cutoff disclaimers

|  | Words to watch: ***as of \[date\]*,[^2] *Up to my last training update*, *as of my last knowledge update*, *While specific details are limited/scarce...*, *not widely available/documented/disclosed*, *...in the provided/available sources/search results...*, *based on available information*...** |
| --- | --- |

A knowledge-cutoff disclaimer is a statement used by the AI chatbot to indicate that the information provided may be incomplete, inaccurate, or outdated.

If an LLM has a fixed [knowledge cutoff](https://en.wikipedia.org/wiki/Knowledge_cutoff "Knowledge cutoff") (usually the model's last training update), it is unable to provide any information on events or developments past that time, and it will often output a disclaimer to remind the user of this cutoff, which usually takes the form of a statement that says the information provided is accurate only up to a certain date.

If an LLM with [retrieval-augmented generation](https://en.wikipedia.org/wiki/Retrieval-augmented_generation "Retrieval-augmented generation") (for example, an AI chatbot that can search the web) fails to find sources on a given topic, or if information is not included in sources provided to it in a prompt, it will often output a statement to that effect, which is similar to a knowledge-cutoff disclaimer. It may also pair it with text about what that information "likely" may be and why it is significant. This information is entirely [speculative](https://en.wikipedia.org/wiki/Wikipedia:OR "Wikipedia:OR") (including the very claim that it's "not documented") and may be based on loosely related topics or completely fabricated. It is also frequently combined with the tells above.

**Examples**

> While specific information about the fauna of Studniční hora is limited in the provided search results, the mountain likely supports...

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1301052898 "Special:Diff/1301052898") to [Studniční hora](https://en.wikipedia.org/wiki/Studni%C4%8Dn%C3%AD_hora "Studniční hora")

> Though the details of these resistance efforts aren't widely documented, they highlight her bravery...

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1261964722 "Special:Diff/1261964722") to [Throwing Curves: Eva Zeisel](https://en.wikipedia.org/wiki/Throwing_Curves:_Eva_Zeisel "Throwing Curves: Eva Zeisel")

> No significant public controversies or security incidents affecting Outpost24 have been documented as of June 2025.

— From [Draft:Outpost24](https://en.wikipedia.org/wiki/Draft:Outpost24 "Draft:Outpost24")

> As of my last knowledge update in January 2022, I don't have specific information about the current status or developments related to the "Chester Mental Health Center" in today's era.

— From [this revision](https://en.wikipedia.org/w/index.php?title=&diff=1186779926&oldid=) to [Chester Mental Health Center](https://en.wikipedia.org/wiki/Chester_Mental_Health_Center "Chester Mental Health Center")

> Below is a detailed overview based on available information:

## Prompt refusal

|  | Words to watch: ***as an AI language model*, *as a large language model*, *I'm sorry*...** |
| --- | --- |

Occasionally, the AI chatbot will decline to answer a prompt as written, usually with an apology and a reminder that it is "an AI language model". Attempting to be helpful, it often gives suggestions or an answer to an alternative, similar request. Outright refusals have become increasingly rare.

Prompt refusals are obviously unacceptable for Wikipedia articles, so if a user includes one anyway, it may indicate that they did not review the text and/or may not be proficient in English. Remember to [assume good faith](https://en.wikipedia.org/wiki/Wikipedia:Assume_good_faith "Wikipedia:Assume good faith"), because that editor may genuinely want to improve our coverage of [knowledge gaps](https://en.wikipedia.org/wiki/Wikipedia:Systemic_bias "Wikipedia:Systemic bias").

**Examples**

> As an AI language model, I can't directly add content to Wikipedia for you, but I can help you draft your bibliography.

— From [this revision](https://en.wikipedia.org/wiki/Special:Diff/1221340799 "Special:Diff/1221340799") to [Parmiter's Almshouse & Pension Charity](https://en.wikipedia.org/wiki/Parmiter%27s_Almshouse_%26_Pension_Charity "Parmiter's Almshouse & Pension Charity")

**Links to searches**

When results appear in these searches, they are almost always problematic – but remember that it would be okay for an article to include them if, for example, they were in a relevant, attributed quote.

- [as an AI language model](https://en.wikipedia.org/w/index.php?search=%22as+an+AI+language+model%22&title=Special:Search&profile=advanced&fulltext=1&ns0=1)
- [as a large language model](https://en.wikipedia.org/w/index.php?search=%22as+a+large+language+model%22&title=Special:Search&profile=advanced&fulltext=1&ns0=1)
- ["OpenAI use policy"](https://en.wikipedia.org/w/index.php?search=%22OpenAI+use+policy%22&title=Special:Search&profile=advanced&fulltext=1&ns0=1)

## Formatting guidelines explanation

AI chatbots are not proficient in [wikitext](https://en.wikipedia.org/wiki/H:WT "H:WT"), the [markup language](https://en.wikipedia.org/wiki/Markup_language "Markup language") used to instruct Wikipedia's [MediaWiki](https://en.wikipedia.org/wiki/MediaWiki "MediaWiki") software how to format an article. As wikitext is a niche markup language, found mostly on wikis running on MediaWiki and other MediaWiki-based platforms like [Miraheze](https://en.wikipedia.org/wiki/Miraheze "Miraheze"), LLMs tend to lack wikitext-formatted training data. While the corpuses of chatbots did ingest millions of Wikipedia articles, these articles would not have been processed as text files containing wikitext syntax. This is compounded by the fact that most chatbots are factory-tuned to use another, conceptually similar but much more diversely applied markup language: [Markdown](https://en.wikipedia.org/wiki/Markdown "Markdown"). Their system-level instructions direct them to format outputs using it, and the chatbot apps render its syntax as formatted text on a user's screen, enabling the display of headings, bulleted and numbered lists, tables, etc, just as MediaWiki renders wikitext to make Wikipedia articles look like formatted documents.

When asked about its "formatting guidelines", a chatbot willing to reveal some of its system-level instructions will typically generate some variation of the following (this is [Microsoft Copilot](https://en.wikipedia.org/wiki/Microsoft_Copilot "Microsoft Copilot") in mid-2025):

[^2]: not unique to AI chatbots; is produced by the {{ [as of](https://en.wikipedia.org/wiki/Template:As_of "Template:As of") }} template
