# Citation Problems

## Non-existent categories

LLMs sometimes hallucinate non-existent categories (which appear as red links) because their training set includes obsolete and renamed categories that they reproduce in new content. They may also treat ordinary references to topics as categories, thus generating non-existent categories. Note that this is also a common error made by new or returning editors.

**Examples**

> ```
> [[Category:American hip hop musicians]]
> ```

— From [this revision](https://en.wikipedia.org/wiki/Special:PermanentLink/1304282215 "Special:PermanentLink/1304282215") to [Draft:Paytra](https://en.wikipedia.org/wiki/Draft:Paytra "Draft:Paytra")

rather than

> ```
> [[Category:American hip-hop musicians]]
> ```

## Dead links and hallucinated references

If a new article or draft has multiple citations with external links, and most of them are broken (error 404 pages), this is a strong sign of an AI-generated page, particularly if the dead links are not found in website archiving sites like [Internet Archive](https://en.wikipedia.org/wiki/Internet_Archive "Internet Archive") or [Archive Today](https://en.wikipedia.org/wiki/Archive_Today "Archive Today"). Most links become broken (see [link rot](https://en.wikipedia.org/wiki/Link_rot "Link rot")) over time, but those factors make it unlikely that the link was ever valid.

A [checksum](https://en.wikipedia.org/wiki/Checksum "Checksum") can be used to verify [ISBNs](https://en.wikipedia.org/wiki/ISBN "ISBN"). An invalid checksum is a very likely sign that an ISBN is incorrect, and citation templates will display [a warning](https://en.wikipedia.org/wiki/Help:CS1_errors#bad_isbn "Help:CS1 errors") if so. Similarly, [DOIs](https://en.wikipedia.org/wiki/Digital_object_identifier "Digital object identifier") are more resistant to link rot than regular hyperlinks. Unresolvable DOIs and invalid ISBNs can be indicators of [hallucinated](https://en.wikipedia.org/wiki/Hallucination_\(AI\) "Hallucination (AI)") references.

Related are DOIs that point to entirely different article and general book citations without pages. This passage, for example, was generated by ChatGPT.

> Ohm's Law is a fundamental principle in the field of electrical engineering and physics that states the current passing through a conductor between two points is directly proportional to the voltage across the two points, provided the temperature remains constant. Mathematically, it is expressed as V=IR, where V is the voltage, I is the current, and R is the resistance. The law was formulated by German physicist Georg Simon Ohm in 1827, and it serves as a cornerstone in the analysis and design of electrical circuits \[1\]. Ohm's Law applies to many materials and components that are "ohmic," meaning their resistance remains constant regardless of the applied voltage or current. However, it does not hold for non-linear devices like diodes or transistors \[2\]\[3\].
>
> References:
>
> 1\. Dorf, R. C., & Svoboda, J. A. (2010). Introduction to Electric Circuits (8th ed.). Hoboken, NJ: John Wiley & Sons. [ISBN](https://en.wikipedia.org/wiki/ISBN_\(identifier\) "ISBN (identifier)") [9780470521571](https://en.wikipedia.org/wiki/Special:BookSources/9780470521571 "Special:BookSources/9780470521571").
>
> 2\. M. E. Van Valkenburg, "The validity and limitations of Ohm's law in non-linear circuits," Proceedings of the IEEE, vol. 62, no. 6, pp. 769–770, Jun. 1974. [doi](https://en.wikipedia.org/wiki/Doi_\(identifier\) "Doi (identifier)"):[10.1109/PROC.1974.9547](https://doi.org/10.1109%2FPROC.1974.9547)
>
> 3\. C. L. Fortescue, "Ohm's Law in alternating current circuits," Proceedings of the IEEE, vol. 55, no. 11, pp. 1934–1936, Nov. 1967. [doi](https://en.wikipedia.org/wiki/Doi_\(identifier\) "Doi (identifier)"):[10.1109/PROC.1967.6033](https://doi.org/10.1109%2FPROC.1967.6033)

The book references appear valid – a book on electric circuits would likely have information about Ohm's law, but without the page number, the citation is not usable for verification of the claims in the prose. Worse, both *Proceedings of the IEEE* citations are completely made up. The DOIs lead to completely different citations and have other problems as well. For instance, [C. L. Fortescue](https://en.wikipedia.org/wiki/Charles_LeGeyt_Fortescue "Charles LeGeyt Fortescue") was dead for 30+ years at the purported time of writing, and [Vol 55, Issue 11](https://ieeexplore.ieee.org/xpl/tocresult.jsp?isnumber=31102&punumber=5) does not list any articles that match anything remotely close to the information given in reference 3. Note also the use of [curly quotation marks and apostrophes](https://en.wikipedia.org/wiki/#Curly_quotation_marks_and_apostrophes) in some, but not all, of the above text, another indicator that text may be LLM-generated.

## Incorrect reference syntax

AI tools may have been prompted to include references, and make an attempt to do so as Wikipedia expects, but fail with some key implementation details or stand out when compared with conventions.

In the below example, note the incorrect attempt at re-using references. The tool used here was not capable of searching for non-confabulated sources (as it was done the day before Bing Deep Search launched) but nonetheless found one real reference. The syntax for re-using the references was incorrect.

In this case, the *Smith, R. J.* source – being the "third source" the tool presumably generated the link ' [https://pubmed.ncbi.nlm.nih.gov/3'](https://pubmed.ncbi.nlm.nih.gov/3') (which has a PMID reference of 3) – is also completely irrelevant to the body of the article. The user did not check the reference before they converted it to a {{ [cite journal](https://en.wikipedia.org/wiki/Template:Cite_journal "Template:Cite journal") }} reference, even though the links resolve.

The LLM in this case has diligently included the incorrect re-use syntax after every single full stop.

> ```
> For over thirty years, computers have been utilized in the rehabilitation of individuals with brain injuries. Initially, researchers delved into the potential of developing a "prosthetic memory."<ref>Fowler R, Hart J, Sheehan M. A prosthetic memory: an application of the prosthetic environment concept. ''Rehabil Counseling Bull''. 1972;15:80–85.</ref> However, by the early 1980s, the focus shifted towards addressing brain dysfunction through repetitive practice.<ref>{{Cite journal |last=Smith |first=R. J. |last2=Bryant |first2=R. G. |date=1975-10-27 |title=Metal substitutions incarbonic anhydrase: a halide ion probe study |url=https://pubmed.ncbi.nlm.nih.gov/3 |journal=Biochemical and Biophysical Research Communications |volume=66 |issue=4 |pages=1281–1286 |doi=10.1016/0006-291x(75)90498-2 |issn=0006-291X |pmid=3}}</ref> Only a few psychologists were developing rehabilitation software for individuals with Traumatic Brain Injury (TBI), resulting in a scarcity of available programs.<sup>[3]</sup> Cognitive rehabilitation specialists opted for commercially available computer games that were visually appealing, engaging, repetitive, and entertaining, theorizing their potential remedial effects on neuropsychological dysfunction.<sup>[3]</sup>
> ```

— From [this revision](https://en.wikipedia.org/wiki/Special:PermanentLink/1188218670 "Special:PermanentLink/1188218670") to [Cognitive orthotics](https://en.wikipedia.org/wiki/Cognitive_orthotics "Cognitive orthotics")

## Footnote formatting with ↩

Some LLMs or chatbot interfaces use their own method of providing footnotes, typically using the character ↩:

> References
>
> Would you like help formatting and submitting this to Wikipedia, or do you plan to post it yourself? I can guide you step-by-step through that too.
>
> **Footnotes**
>
> 1. KLAS Research. (2024). *Top Performing RCM Vendors 2024*. https://klasresearch.com ↩ ↩ <sup>2</sup>
> 2. PR Newswire. (2025, February 18). *CureMD AI Scribe Launch Announcement*. https://www.prnewswire.com/news-releases/curemd-ai-scribe ↩

— From [this revision](https://en.wikipedia.org/wiki/Special:PermanentLink/1304723248 "Special:PermanentLink/1304723248") of [Draft:CureMD](https://en.wikipedia.org/wiki/Draft:CureMD "Draft:CureMD")

## utm\_source=

ChatGPT may add the [UTM parameter](https://en.wikipedia.org/wiki/UTM_parameter "UTM parameter") `utm_source=openai` or, in edits prior to August 2025, `utm_source=chatgpt.com` to URLs that it is using as sources. This behavior is much less common with other LLMs such as Gemini or Claude.[^11]

**Examples**

> Following their marriage, Burgess and Graham settled in Cheshire, England, where Burgess serves as the head coach for the Warrington Wolves rugby league team. \[https://www.theguardian.com/sport/2025/feb/11/sam-burgess-interview-warrington-rugby-league-luke-littler?utm\_source=chatgpt.com\]

— From [this revision](https://en.wikipedia.org/w/index.php?title=&diff=1277944793&oldid=) to [Sam Burgess](https://en.wikipedia.org/wiki/Sam_Burgess "Sam Burgess")

> Vertex AI documentation and blog posts describe watermarking, verification workflow, and configurable safety filters (for example, person‑generation controls and safety thresholds). (\[cloud.google.com\](https://cloud.google.com/vertex-ai/generative-ai/docs/image/generate-images?utm\_source=openai))

— From [this revision](https://en.wikipedia.org/w/index.php?title=&diff=1308699845&oldid=) to [Draft:Nano Banana (Chatbot)](https://en.wikipedia.org/wiki/Draft:Nano_Banana_\(Chatbot\) "Draft:Nano Banana (Chatbot)")

- [utm\_source=chatgpt.com](https://en.wikipedia.org/w/index.php?search=%utm_source=chatgpt.com%22&title=Special:Search&profile=advanced&fulltext=1&ns0=1)
- [insource:"utm\_source=chatgpt.com"](https://en.wikipedia.org/w/index.php?search=insource%3A%22utm_source%3Dchatgpt.com%22&title=Special%3ASearch&profile=advanced&fulltext=1&ns0=1)
- [insource:"utm\_source=openai"](https://en.wikipedia.org/w/index.php?search=insource%3A%22utm_source%3Dopenai%22&title=Special%3ASearch&profile=advanced&fulltext=1&ns0=1)

[^11]: See [T387903](https://phabricator.wikimedia.org/T387903 "phabricator:T387903").
