# Meta Indicators

## Abrupt cut offs

AI tools may abruptly stop generating content, for example if they predict the end of text sequence (appearing as <|endoftext|>) next. Also, the number of tokens that a single response has is usually limited, and further responses will require the user to select "continue generating".

This method is not foolproof, as a malformed copy/paste from one's local computer can also cause this. It may also indicate a [copyright violation](https://en.wikipedia.org/wiki/Wikipedia:Copyvio "Wikipedia:Copyvio") rather than the use of an LLM.

## Discrepancies in writing style and variety of English

A sudden shift in an editor's writing style, such as unexpectedly flawless grammar compared to their other communication, may indicate the use of AI tools.

Another discrepancy is a mismatch of user location, national ties of the topic to a variety of English, and the variety of English used. A human writer from India writing about an Indian university would probably not use American English; however, LLM outputs use American English by default, unless prompted otherwise.[^10] Note that non-native English speakers tend to mix up English varieties, and such signs should only raise suspicion if there is a sudden and complete shift in an editor's English variety use.

## Temporal considerations

ChatGPT was launched to the public on November 30, 2022. Although OpenAI had similarly powerful LLMs before then, they were paid services and not particularly accessible or known to lay people. ChatGPT experienced extreme growth immediately on launch.

It is very unlikely that any particular text added to Wikipedia **prior to November 30, 2022** was generated by an LLM. If an edit to a page was made before this date, AI use can be safely ruled out for that revision. While some text added long ago (such as in 2006) may appear to match some of the AI signs given in this list, and even convincingly appear to have been AI generated, the vastness of Wikipedia allows for these rare coincidences.

## Edit summaries

AI-generated [edit summaries](https://en.wikipedia.org/wiki/Help:Edit_summary "Help:Edit summary") are often unusually long, written as formal, first-person paragraphs without [abbreviations](https://en.wikipedia.org/wiki/Wikipedia:Edit_summary_legend "Wikipedia:Edit summary legend"), and/or conspicuously itemize Wikipedia's conventions.

Most editors using AI do not ask for summaries to be generated.

> Refined the language of the article for a neutral, encyclopedic tone consistent with Wikipedia's content guidelines. Removed promotional wording, ensured factual accuracy, and maintained a clear, well-structured presentation. Updated sections on history, coverage, challenges, and recognition for clarity and relevance. Added proper formatting and categorized the entry accordingly

— Edit summary from [this revision](https://en.wikipedia.org/wiki/Special:Diff/1263518156 "Special:Diff/1263518156") to [Khaama Press](https://en.wikipedia.org/wiki/Khaama_Press "Khaama Press")

> I formalized the tone, clarified technical content, ensured neutrality, and indicated citation needs. Historical narratives were streamlined, allocation details specified with regulatory references, propagation explanations made reader-friendly, and equipment discussions focused on availability and regulatory compliance, all while adhering to encyclopedic standards.

— Edit summary from [this revision](https://en.wikipedia.org/wiki/Special:Diff/1184567431 "Special:Diff/1184567431") to [4-metre band](https://en.wikipedia.org/wiki/4-metre_band "4-metre band")

> \*\*Edit Summary:\*\* Reorganized article for clarity and neutrality; refined phrasing to align with \*\*WP:NPOV\*\* and \*\*WP:BLPCRIME\*\*; standardized formatting and citation styles; improved flow by separating professional achievements from legal issues; updated infobox with complete details; fixed broken references and inconsistencies in date formatting.

— Edit summary from [this revision](https://en.wikipedia.org/wiki/Special:Diff/1279941059 "Special:Diff/1279941059") to [David Bitel](https://en.wikipedia.org/wiki/David_Bitel "David Bitel")

## False indicators

False accusations of AI use can [drive away new editors](https://en.wikipedia.org/wiki/Wikipedia:BITE "Wikipedia:BITE") and foster an atmosphere of suspicion. Before claiming AI was used, consider if [Dunning–Kruger effect](https://en.wikipedia.org/wiki/Dunning%E2%80%93Kruger_effect "Dunning–Kruger effect") and [confirmation bias](https://en.wikipedia.org/wiki/Confirmation_bias "Confirmation bias") is clouding your judgement. In particular, there are several somewhat commonly used indicators which are ineffective (and may even indicate the opposite) in LLM detection.

- **Perfect grammar**: While modern LLMs are known for their high grammatical proficiency, many editors are also skilled writers or come from professional writing backgrounds. (See also [§ Discrepancies in writing style and variety of English](https://en.wikipedia.org/wiki/#Discrepancies_in_writing_style_and_variety_of_English).)
- **"Bland" or "robotic" prose**: By default, modern LLMs tend toward effusive and verbose prose, as detailed above; while this tendency is formulaic, it may not scan as "robotic" to those unfamiliar with AI writing.[^12]
- **"Fancy," "academic," or unusual words**: While LLMs disproportionately favor certain words and phrases, many of which are long and have difficult [readability](https://en.wikipedia.org/wiki/Readability "Readability") scores, the correlation does not extend to *all* "fancy," academic, or "advanced"-sounding prose.[^6] "AI vocabulary" and academic vocabulary are not the same thing; indeed, the specific words overused by AI appeared far less frequently in research abstracts prior to 2023.[^9] Low-frequency and "unusual" words are also less likely to show up in AI-generated writing as they are statistically less common, unless they are proper nouns directly related to the topic.
- **Letter-like writing (in isolation)**: Although many talk page messages written with [salutations](https://en.wikipedia.org/wiki/Salutation "Salutation"), [valedictions](https://en.wikipedia.org/wiki/Valediction "Valediction") and other formalities after 2023 tend to appear AI-generated, that is not guaranteed to be the case for all such messages. Letters and emails have conventionally been written in similar ways *long* before modern LLMs existed. An AI-generated message may start with a [subject line](https://en.wikipedia.org/wiki/Wikipedia:SUBJECTLINE "Wikipedia:SUBJECTLINE"), include a [vertical list](https://en.wikipedia.org/wiki/#Inline-header_vertical_lists) [^5] or one or more [placeholders](https://en.wikipedia.org/wiki/#Phrasal_templates_and_placeholder_text), or [end abruptly](https://en.wikipedia.org/wiki/#Abrupt_cut_offs). In addition, some human editors may mistakenly post emails, letters, petitions, or messages intended for the article's subject, frequently formatted as letters. While such edits are generally off-topic and may be removed per the guidelines at [WP:NOTFORUM](https://en.wikipedia.org/wiki/Wikipedia:NOTFORUM "Wikipedia:NOTFORUM") —particularly if they contain personal information—they are not necessarily LLM-generated.
- **Conjunctions (in isolation)**: While LLMs tend to overuse [connecting words](https://en.wikipedia.org/wiki/Transition_\(linguistics\) "Transition (linguistics)") and phrases in a stilted, formulaic way that implies inappropriate [synthesis](https://en.wikipedia.org/wiki/Wikipedia:SYNTH "Wikipedia:SYNTH") of facts, such uses are typical of essay-like writing by humans and are not strong indicators by themselves.
- **Bizarre [wikitext](https://en.wikipedia.org/wiki/Help:Wikitext "Help:Wikitext")**: While LLMs may hallucinate templates or generate wikitext code with invalid syntax for reasons explained in [§ Use of Markdown](https://en.wikipedia.org/wiki/#Use_of_Markdown), they are not likely to generate content with certain random-seeming, "inexplicable" errors and artifacts (excluding the ones listed on this page in [§ Markup](https://en.wikipedia.org/wiki/#Markup)). Bizarrely placed [HTML tags](https://en.wikipedia.org/wiki/HTML_tags "HTML tags") like <span> are more indicative of poorly programmed browser extensions or a known bug with Wikipedia's content translation tool ([T113137](https://phabricator.wikimedia.org/T113137 "phabricator:T113137")). Misplaced syntax like `''Catch-22 i''s a satirical novel.` (rendered as " *Catch-22 i* s a satirical novel.") are more indicative of mistakes in [VisualEditor](https://en.wikipedia.org/wiki/Wikipedia:VisualEditor "Wikipedia:VisualEditor"), where such errors are harder to notice than in [source editing](https://en.wikipedia.org/wiki/Wikipedia:Source_editing "Wikipedia:Source editing").

## See also

- [Wikipedia:Artificial intelligence](https://en.wikipedia.org/wiki/Wikipedia:Artificial_intelligence "Wikipedia:Artificial intelligence")

## References

[^5]: [Example](https://en.wikipedia.org/wiki/Wikipedia:Articles_for_deletion/Sarwan_Kumar_Bheel "Wikipedia:Articles for deletion/Sarwan Kumar Bheel") of a vertical list in a deletion discussion

[^6]: Russell, Jenna; Karpinska, Marzena; Iyyer, Mohit (2025). [*People who frequently use ChatGPT for writing tasks are accurate and robust detectors of AI-generated text*](https://aclanthology.org/2025.acl-long.267/). Proceedings of the 63rd Annual Meeting of the Association for Computational Linguistics (Volume 1: Long Papers). Vienna, Austria: Association for Computational Linguistics. pp. 5342– 5373. [arXiv](https://en.wikipedia.org/wiki/ArXiv_\(identifier\) "ArXiv (identifier)"):[2501.15654](https://arxiv.org/abs/2501.15654). [doi](https://en.wikipedia.org/wiki/Doi_\(identifier\) "Doi (identifier)"):[10.18653/v1/2025.acl-long.267](https://doi.org/10.18653%2Fv1%2F2025.acl-long.267). Retrieved 2025-09-05 – via [ACL Anthology](https://en.wikipedia.org/wiki/ACL_Anthology "ACL Anthology").

[^9]: Juzek, Tom S.; Ward, Zina B. (2025). [*Why Does ChatGPT "Delve" So Much? Exploring the Sources of Lexical Overrepresentation in Large Language Models*](https://aclanthology.org/2025.coling-main.426.pdf) (PDF). Findings of the Association for Computational Linguistics: ACL 2025. [Association for Computational Linguistics](https://en.wikipedia.org/wiki/Association_for_Computational_Linguistics "Association for Computational Linguistics"). [arXiv](https://en.wikipedia.org/wiki/ArXiv_\(identifier\) "ArXiv (identifier)"):[2412.11385](https://arxiv.org/abs/2412.11385). Retrieved October 13, 2025 – via [ACL Anthology](https://en.wikipedia.org/wiki/ACL_Anthology "ACL Anthology").

[^10]: Ju, Da; Blix, Hagen; Williams, Adina (2025). [*Domain Regeneration: How well do LLMs match syntactic properties of text domains?*](https://aclanthology.org/2025.findings-acl.120). Findings of the Association for Computational Linguistics: ACL 2025. Vienna, Austria: [Association for Computational Linguistics](https://en.wikipedia.org/wiki/Association_for_Computational_Linguistics "Association for Computational Linguistics"). pp. 2367– 2388. [arXiv](https://en.wikipedia.org/wiki/ArXiv_\(identifier\) "ArXiv (identifier)"):[2505.07784](https://arxiv.org/abs/2505.07784). [doi](https://en.wikipedia.org/wiki/Doi_\(identifier\) "Doi (identifier)"):[10.18653/v1/2025.findings-acl.120](https://doi.org/10.18653%2Fv1%2F2025.findings-acl.120). Retrieved October 4, 2025 – via [ACL Anthology](https://en.wikipedia.org/wiki/ACL_Anthology "ACL Anthology").

[^12]: This can be directly observed by examining images generated by [text-to-image models](https://en.wikipedia.org/wiki/Text-to-image_model "Text-to-image model"); they look acceptable at first glance, but specific details tend to be blurry and malformed. This is especially true for background objects and text.
