"""Minimal marimo notebook structure demonstrating core patterns."""

import marimo

app = marimo.App()


@app.cell
def _():
    """Import cell - returns all imports for use in other cells."""
    import marimo as mo
    import polars as pl

    return mo, pl


@app.cell
def _(mo):
    """Display cell - uses mo.md for formatted output."""
    mo.md(
        """
        # Basic Marimo Notebook

        This notebook demonstrates the core marimo patterns:
        - Import cells that return modules
        - Data cells that return DataFrames
        - Display cells for visualization
        """
    )


@app.cell
def _(pl):
    """Data cell - creates and returns a DataFrame."""
    df = pl.DataFrame(
        {
            "name": ["Alice", "Bob", "Charlie"],
            "age": [25, 30, 35],
            "city": ["NYC", "LA", "Chicago"],
        }
    )
    return (df,)  # Trailing comma for single return


@app.cell
def _(df, pl):
    """Transform cell - filters data and returns result."""
    adults = df.filter(pl.col("age") >= 30)
    return (adults,)


@app.cell
def _(adults, mo):
    """Output cell - displays the result."""
    mo.md(f"## Filtered Results\n\nFound {len(adults)} adults (age >= 30)")
    adults  # Last expression is displayed


if __name__ == "__main__":
    app.run()
