# Volokh's Academic Legal Writing - Extended Reference

Comprehensive guidance for law review articles distilled from Eugene Volokh's *Academic Legal Writing*.

## Logical Problems

### Categorical Assertions

Avoid "never" and "always." "This law would be completely unenforceable" or "could never be enforced" invites the devastating response: "Really? Not even once?"

Modest claims are more likely to be right and harder to attack.

### Insistence on Perfection

"The law would not adequately protect against all possible harms" is a weak criticism. No law prevents all instances of harm. The questions are whether the law does more good than harm and whether alternatives do better.

Be careful of false dichotomies: perfect laws vs. pointless laws ignores laws that do something but not everything.

### False Alternatives

"Is pornography free speech or hate speech?" The answer may be "both." Asking "X or Y?" suggests mutual exclusivity that may not exist.

If you think X and Y are mutually exclusive, demonstrate this rather than assuming it.

### Missing Pieces in Arguments

Legal arguments must connect logically:

```
1. Classifications based on sex get strict scrutiny
2. Separate schools involve sex classifications
3. Therefore, separate schools are unconstitutional [WRONG]
```

Steps 1 and 2 prove only that separate schools are *subject to* strict scrutiny, not that they fail it. Fill the gap by showing the classification fails the scrutiny.

**Test:** Before and after writing the proof section, summarize each significant assertion in one sentence. Do they fit together?

### Criticisms That Apply to Everything

"Chilling effect," "slippery slope," "imposes majority's morality," "intrudes on privacy"—most laws that constrain conduct do one or more of these. Sometimes that's acceptable.

Explain specifically:
- Why *this* chilling effect is worse than tolerable ones
- Why *this* slope is more slippery than others
- Why *this* intrusion is unjustified when others are permissible

Ask: Does this criticism equally apply to laws I endorse?

### Metaphors Require Unpacking

Legal metaphors are literally false. "Slippery slope" is shorthand for "this decision may cause more troublesome future decisions"—but why? What's the mechanism?

| Metaphor | Literal Meaning | Requires |
|----------|-----------------|----------|
| Slippery slope | Future decisions follow | Explain *why* they would follow |
| Chilling effect | Speech beyond the law's scope is deterred | Explain *what* speech and *how* |
| Balancing | Weighing competing interests | Explain *what weights* and *who decides* |

Physical slippery slopes are self-explanatory (gravity + friction). Legal ones are not.

### Undefined Terms

Circle every abstraction: "paternalism," "privacy," "democratic legitimacy," "fundamental fairness," "evolving standards of decency," "narrow tailoring," "good faith."

For each, ask:
- What constitutes this?
- Does the reader understand what I mean?
- Do *I* understand what I mean?
- Am I using it consistently?

If a term is too vague to define, ask whether it helps the argument.

### "Arguably" and "Raises Concerns"

"Arguably X" acknowledges controversy but doesn't explain why readers should accept your side. If something is arguably true, give the argument and explain why it beats the counterargument.

"Raises constitutional concerns" or "is troubling" is not an argument. If the proposal is unconstitutional or unsound, explain why.

## Paragraph-Level Problems

### One Theme Per Paragraph

Each paragraph should be about one main thought. The first sentence (topic sentence) expresses that thought. Other sentences support it.

### Paragraph Length

Aim for 2-4 sentences (Volokh) or 5-6 (others). Once past 6 medium sentences or 4 long ones, readers' attention wanes.

One-sentence paragraphs are usually too choppy, though sometimes good for introducing several longer paragraphs.

### Connections Between Paragraphs

Each paragraph should be logically linked to the one before. The reader starting a new paragraph should understand its relationship to the previous one.

This doesn't require explicit transitions ("Moreover," "On the other hand"). Repetition of a word or concept from the previous paragraph's last sentence works.

## Sentence and Clause Problems

### Redundancy

When two sentences express similar thoughts, eliminate one or part of one. "In other words" signals the first words weren't good enough.

Avoid legal doublets: "any and all," "null and void," "cease and desist." Unless the phrase has legal significance ("cease-and-desist letter"), use one word.

### Unnecessary Introductory Clauses

Delete throat-clearing:
- "It should be mentioned that..."
- "In having researched the implications..."
- "It is important to note that..."

### Unnecessary Phrases

Each clause should make a specific point useful to the argument.

**Bad:** "The state legislature should reject this proposal because it is the wrong solution."
What extra information does "because it is the wrong solution" convey?

**Bad:** "Given the large number of accidental firearms injuries among young people, everyone would agree that firearms safety is a matter of great public concern."
On that level of generality, everyone does agree—to the point that the sentence adds nothing.

Either delete such sentences or make them concrete with specific numbers or facts.

### Needless Tangential Detail

Organize narration around the needs of the argument, not the internal structure of facts learned during research.

Don't describe each Supreme Court case you read. Don't explain the chemistry of pepper spray. Focus on what readers need to know.

## Word and Phrase Problems

### Legalese and Bureaucratese

Write like normal people speak.

| Legalese | Plain English |
|----------|---------------|
| Opposition to the bill is needed on the grounds that... | We should oppose the bill because... |
| Guns have a far greater utilitarian value | Guns are far more useful |
| Could negatively affect the accessibility | Could make... less accessible |

### Nominalization

Turning verbs and adjectives into nouns makes prose abstract and complex.

| Nominalized | Direct |
|-------------|--------|
| Opposition to the bill is needed | We should oppose the bill |
| Have a far greater utilitarian value | Are far more useful |
| Affect the accessibility of | Make... less accessible |

If you see an abstract noun, ask whether you can replace it with the concrete verb, adjective, or adverb it embodies.

### Long Synonyms for Short Phrases

| Long | Short |
|------|-------|
| A large number of | Many |
| In close proximity to | Near |
| The legislative branch of government | The legislature |
| At this point in time | Now |
| Prior to | Before |
| In order to | To |

### Unnecessary Abstractions

Make arguments using words that concretely describe real problems people face.

| Abstract | Concrete |
|----------|----------|
| When law enforcement is unavailable | When the police can't come in time |
| Violence connected with guns | People killed, injured, or threatened with guns |
| Will have a positive effect | Will prevent many murders and suicides |

"The police" is what people want; "law enforcement" is the abstraction.

### Passive Voice

Active voice is usually better, but passive is appropriate when the discussion focuses on the object rather than the actor.

**Appropriate passive:** "The Act was adopted shortly after September 11" (focus is on the Act, not Congress).

### Word Choice Mistakes

Poor word choice undermines credibility. Reread each sentence and ask: Is this exactly what I want to say?

Common problems:
- "Alternate" vs. "alternative"
- Unidiomatic phrases ("crimes done" should be "crimes committed")
- Inattentiveness to literal meaning ("Firearms are one of the most lethal forms of suicide"—no, they're a *means* of suicide)

### Figurative Phrases

Figurative language is often misused:
- Mixed metaphors ("the political equation was saturated with kerosene")
- Literal meaning highlighted by context ("The felony murder rule has been done to death")
- Misuse ("back to ground zero" instead of "back to square one")
- "Begs the question" traditionally means assuming what you're trying to prove, not "raises the question"

Never use "literally" when you mean "figuratively."

### Abbreviations

Don't create your own abbreviations. Even preexisting ones (RFRA, GFSZA) can make work less accessible.

Use "the Act" or "such arguments" instead of abbreviations when meaning is clear from context.

## Rhetorical Problems

### Unduly Harsh Criticism

Use "mistaken," "unsound," or "erroneous," not "fraudulent," "nonsense," "ridiculous," or "idiotic."

Reasons:
1. Overstating raises your burden of proof
2. No one likes a bully
3. Invective suggests lack of substance
4. Readers tolerate less harshness from juniors
5. No need to make unnecessary enemies
6. Easier to backpedal if proven wrong

### Personalized Criticism

Attack arguments, not people. "This argument is wrong because..." not "Volokh is wrong because..."

Label arguments by content ("the cost-lowering slippery slope argument") rather than by author. Attribute in footnotes.

### Caricatured Criticism

Avoid drive-by characterizations of schools of thought ("retributivists believe X"). Name names and cite specific works.

Quote adherents of a position, not its critics, when explaining the position. Critics are less invested in describing the position accurately.

**Test:** Could the objects of criticism agree the characterization is fair?

## Evidence Handling

### Read Original Sources

Never rely on intermediate sources—cases, articles, treatises—for what another case or statute says. Check the original.

**Even Supreme Court opinions err.** *Reno v. ACLU* incorrectly stated that *Ginsberg* and *Pacifica* were limited to commercial speech. They weren't.

### Historical, Economic, and Scientific Evidence

Law review authors are usually not experts in history, economics, or science. Some have learned just enough to be dangerous.

If possible, go to the ultimate source (historical document, scientific study). Law school librarians can help obtain materials.

If you must rely on secondary sources, at least don't rely on law review articles citing history books—there, the risk of error is too high.

### Newspapers

Newspapers often omit critical details or err in what they include. Reporters are generalists writing under tight deadlines. They rarely check original sources or verify quotes with sources.

Rules:
1. Never rely on newspaper accounts of published cases or statutes
2. Get underlying documents or studies, not newspaper descriptions of them
3. Search other papers to identify original sources
4. Contact quoted speakers to verify quotes
5. Acknowledge reliability problems ("press accounts report that...")
6. Note the article's nature (opinion piece?), source's biases, and reasons for possible inaccuracy

### Transcripts

Transcribers make mistakes. One transcript rendered "whether a state even may exclude religion" as "whether a state even makes good religion."

Even accurate transcripts may not reflect considered judgment—speakers misspeak and can't proofread.

### Wikipedia

Wikipedia entries tend to be relatively accurate, but:
1. Find the original sources and cite them, not Wikipedia
2. Many readers and law review editors will assume Wikipedia is unreliable

### Check Studies You Cite

Read studies with a skeptical eye. Pretend you disagree with the political view the study supports. Search for criticisms of the study.

If you find flaws, acknowledge them and explain why the study is still valuable despite them.

## Survey Evidence

### What Surveys Measure

Surveys measure only what (1) survey-takers recorded (2) these particular respondents (3) were willing to say (4) in response to particular questions asked.

Surveys of small groups can reveal likely answers of a larger group *only if* respondents are a large enough randomly selected sample.

### Bad Samples

**Biased samples:** The 1936 *Literary Digest* poll predicted Landon would beat Roosevelt 55-41%. Roosevelt won 61-37%. The poll used telephone books and automobile registrations, disproportionately reaching richer people.

**Convenience samples:** Psychology students, pedestrians on a corner—wildly unrepresentative of the population.

**Self-selected samples:** Internet polls and reader surveys are meaningless. Only those who feel most strongly respond. Activist groups swamp results.

**Mail-in and Internet samples:** Most involve self-selection. Only 25% of *Literary Digest* surveys were returned.

### Valid Surveys

Requirements:
1. Random sample of a broader group
2. High response rate (70%+) to avoid self-selection bias
3. Large enough sample (1000 respondents for ±3% margin)

### Question Wording

Surveys asking different questions can't measure the same thing.

**Example:** "The First Amendment goes too far in the rights it guarantees" was reported as showing 49% think "the First Amendment goes too far in guaranteeing free speech." But the question asked about *all* First Amendment rights, including religion. A later question found only 10% thought Americans have "too much freedom to speak freely."

Ambiguous questions measure nothing in particular. "The right to privacy" means different things to different people (abortion? searches? something else?).

Get the text of the questionnaire. If a survey organization refuses to release questions, be skeptical.

### Consider All Information

If a survey asks many questions, consider all the information, not just parts supporting your case.

### Incorrect Answers

Respondents may:
- Not remember past events accurately
- Conceal illegal or embarrassing behavior
- Conceal unpopular views
- Misunderstand questions
- Give answers to avoid looking ignorant

## Assumptions and Inferences

### Correlation vs. Causation

"More guns in the U.S. than England; more murder in the U.S. Therefore, guns cause murder."

"More guns in rural areas than urban areas; less murder in rural areas. Therefore, guns decrease murder."

Both premises are true. Both conclusions can't be.

Ice cream production and rape are highly correlated (0.84 in 2000). Both increase in summer. Ice cream doesn't cause rape.

Make clear when you're inferring causation from correlation, and explain why the inference is valid.

### Extrapolation Across Places

Data from one city may not generalize to the country. Data from the country may not generalize to one city.

A study of San Francisco homosexual men in 1970 may not represent all American homosexual men in 1990.

### Extrapolation Across Time

Behavior patterns change. Data from one decade may not apply to another.

### Extrapolation Across Populations

Data from STD patients does not generalize to the general population—they're in hospitals *because* they had many partners.

One book reported that homosexual men had a median of 1,160 lifetime partners—but the source said "homosexual men *with AIDS*" had that median. The ellipses hid the critical qualifier.

### Extrapolation Across Variables

Arrest rates ≠ crime rates. Ice cream production ≈ ice cream consumption. Reported burglaries ≠ actual burglaries.

Make clear what variable the data measures and why inferring to another variable is legitimate.

### Summary

When citing a study showing a state law was followed by falling arrest rates:

1. **Generalizability over time/space:** Results from Ohio in 1991 may not generalize to other states today.
2. **Causation vs. correlation:** Arrests may have fallen for other reasons (crime generally falling, other measures implemented).
3. **Measured vs. important variable:** Falling arrests don't necessarily mean falling crime.

## False Synonyms and Qualifiers

### False Synonyms

| Term Used | Actual Meaning | Problem |
|-----------|----------------|---------|
| Foreign-born | Noncitizen | Twice as many foreign-born as noncitizens |
| Murder | Homicide | Homicide includes manslaughter, justifiable killing |
| Children | People age 0-24 | "Children" connotes much younger |
| Right of publicity | Narrow right re: performance rebroadcasting | *Zacchini* upheld only the narrow version |

### Necessary Qualifiers

Holmes: "The most stringent protection of free speech would not protect a man in *falsely* shouting fire in a theatre and causing a panic."

The "falsely" is usually dropped. False statements are often unprotected; true ones generally are.

If you want to argue even accurate fire-shouting is dangerous, make that argument explicitly.

## Editing Principles

### Go Through Many Drafts

Nothing is ever written; it is rewritten. Aim for 10 complete edits before submission. Judge Kozinski's chambers did 30-40 drafts of opinions.

### Questions for Each Sentence

1. What information does this communicate that readers don't already know?
2. Has this information already been communicated?
3. Is this sentence so related to the previous one that part is repeated?
4. Can I eliminate this without changing the meaning?
5. Is this how normal people talk?
6. Does each word communicate exactly what I want?
7. Should this noun be a verb, adjective, or adverb instead?

### If You See No Red Marks, Edit Again

At least in early drafts, every paragraph needs correction. If you're not finding flaws, you're not looking hard enough.

### If You Reread to Understand, Rewrite

If your writing confuses even you, it will confuse readers more. Complex material can still be explained clearly.

### Ask "Why?" and "Why Not?"

For every sentence in the argument, ask "why?" The sentence or its neighbors must answer, unless the answer is obvious.

Then ask "why not?"—what would a reasonable person think on the other side?

### Use Your Imaginary Adversary

Imagine someone you respect who takes the opposite view. Read as that person. What counterarguments would they raise? Would they see flaws in the logic?

### No Lazy Readers, Only Busy Readers

Smart, industrious readers are busy *because* they are industrious and smart. They can parse complex prose, but it takes work. Why should they wade through your morass when they could work on something else?

Make things as easy for readers as possible.
