---
name: octave-mastery
description: Advanced semantic vocabulary and architectural patterns for the OCTAVE format. REQUIRES octave-literacy to be loaded first
allowed-tools: ["Read", "Write", "Edit"]
triggers: ["octave architecture", "agent design", "semantic pantheon", "advanced octave", "OCTAVE mastery", "holographic patterns", "archetypes", "high-density specifications", "system architecture", "OCTAVE patterns"]
version: "2.3.0"
---

===OCTAVE_MASTERY===
META:
  TYPE::SKILL
  VERSION::"2.3.0"
  STATUS::ACTIVE
  PURPOSE::"Expert-level OCTAVE application: Archetypes, Advanced Syntax, Strategy"
  REQUIRES::octave-literacy
  TIER::LOSSLESS
  SPEC_REFERENCE::octave-core-spec.oct.md
  V6_FEATURES::"Holographic contracts, JIT grammar compilation, constraint validation"

§1::SEMANTIC_PANTHEON
  // Core vocabulary for semantic compression — extensible, not closed
  // See octave-mythology §10::EXTENSION_POINTS for expansion guidance
  DOMAINS:
    ZEUS::"Executive function, authority, strategic direction, final arbitration"
    ATHENA::"Strategic wisdom, planning, elegant solutions, deliberate action"
    APOLLO::"Analytics, data, insight, clarity, prediction, revealing truth"
    HERMES::"Communication, translation, APIs, networking, messaging, speed"
    HEPHAESTUS::"Infrastructure, tooling, engineering, automation, system architecture"
    ARES::"Security, defense, stress testing, conflict simulation, adversarial analysis"
    ARTEMIS::"Monitoring, observation, logging, alerting, precision targeting of issues"
    POSEIDON::"Data lakes, storage, databases, unstructured data pools"
    DEMETER::"Resource allocation, budgeting, system growth, scaling"
    DIONYSUS::"User experience, engagement, creativity, chaotic innovation"

§2::NARRATIVE_DYNAMICS
  PATTERNS:
    ODYSSEAN::"Long, transformative journey with a clear goal"
    SISYPHEAN::"Repetitive, endless maintenance (e.g., tech debt)"
    PROMETHEAN::"Breakthrough innovation challenging the status quo"
    ICARIAN::"Overreach due to early success leading to failure"
    PANDORAN::"Action unleashing complex, unforeseen problems"
    TROJAN::"Hidden payload changing system from within"
    GORDIAN::"Unconventional solution to impossible problem"
    ACHILLEAN::"Single critical point of failure"
    PHOENICIAN::"Necessary destruction and rebirth (refactoring)"

§3::SYSTEM_FORCES
  DYNAMICS:
    HUBRIS::"Dangerous overconfidence"
    NEMESIS::"Inevitable corrective consequence"
    KAIROS::"Critical, fleeting window of opportunity"
    CHRONOS::"Constant linear time pressure"
    CHAOS::"Entropy and disorder"
    COSMOS::"Emergence of order"

§4::ADVANCED_SYNTAX
  // Extends octave-literacy with holographic and type patterns
  HOLOGRAPHIC::KEY::["value"∧CONSTRAINT→§TARGET]
  INLINE_MAP::[key::value, key2::value2][values_must_be_atoms,no_nesting]
  TYPE_DISAMBIGUATION::[
    STRING::"42",
    NUMBER::42,
    BOOL::true
  ]

  §4b::V6_HOLOGRAPHIC_CONTRACTS
    // v6 innovation: Documents carry their own validation law
    CONTRACT::HOLOGRAPHIC[
      PRINCIPLE::"Validation rules embedded in document META block",
      MECHANISM::JIT_GRAMMAR_COMPILATION[META→GBNF],
      ANCHORING::HERMETIC[frozen@sha256|latest@local],
      BENEFIT::"Self-validating documents, no external schema needed"
    ]
    GRAMMAR::[
      GENERATOR::OCTAVE_GBNF_COMPILER[planned],
      INTEGRATION::[llama.cpp,Outlines,vLLM],
      OUTPUT::"Constrained generation - impossible to produce invalid syntax"
    ]
    EXAMPLE_META::[
      CONTRACT::TYPE_CONSTRAINTS[field1::STRING,field2::NUMBER],
      GRAMMAR::GBNF[rules_for_structured_output]
    ]

§4c::CONSTRAINTS
  // Available constraint types for holographic patterns
  CORE::[REQ,OPT,CONST,ENUM,TYPE,REGEX,DIR,APPEND_ONLY]
  EXTENDED::[RANGE,MAX_LENGTH,MIN_LENGTH,DATE,ISO8601]
  EXAMPLES::[
    "REQ"[required_field],
    "ENUM[A,B,C]"[enumerated_values],
    "RANGE[1,10]"[numeric_bounds],
    "MAX_LENGTH[50]"[string_or_list_max],
    "DATE"[strict_YYYY_MM_DD],
    "ISO8601"[full_datetime]
  ]
  V6_USAGE::constraints_in_CONTRACT_block[self_contained_validation]

§5::ANTI_PATTERNS
  SMELLS::[
    "Isolated Lists (no relationships)",
    "Flat Hierarchies (lack of grouping)",
    "Buried Networks (relationships hidden in prose)",
    "Operator Soup (A+B->C~D all in one line)"
  ]

===END===
