---
name: pda-reframing
description: Rephrase tasks and requests by avoiding Demand Avoidance triggers for someone with PDA autism spectrum disorder. It transforms demands into exploration and autonomous actions.
---
# PDA Task Reframing Skill

## Overview

This skill helps reframe tasks and requests in ways that reduce demand avoidance triggers for people with PDA (Pathological Demand Avoidance) autism. It transforms direct demands into collaborative explorations, genuine choices, and curiosity-driven opportunities.

## When to Use This Skill

- User explicitly requests PDA-friendly reframing
- User mentions demand avoidance, PDA, or executive function struggles with traditional task language
- User asks for help making a task feel less overwhelming or anxiety-inducing

## Core Principles

### Understanding PDA

PDA is an autism profile characterized by:

- Intense anxiety around perceived demands and loss of autonomy
- Strong need for control and equality in interactions
- Extreme stress responses to direct instructions, even for preferred activities
- Better response to indirect, collaborative, or curiosity-based approaches

### What Doesn’t Work (Avoid These)

- Direct commands: “You need to do X”
- Time pressure: “Do this now” or “You should have done this already”
- Obligation language: “You must,” “You have to,” “You should”
- Conditional threats: “If you don’t do X, then Y will happen”
- Patronizing tone: Treating the person as incapable
- Rigid schedules: “At 3pm you will…”

### What Works Better

- Collaborative framing: “I wonder if we could explore…”
- Genuine choice: “Would X or Y work better for you?”
- Curiosity-driven: “What would happen if…?”
- Problem-solving partnership: “This is tricky - what do you think?”
- Indirect approaches: Making the task available without demanding uptake
- Humor and playfulness: When appropriate to the person’s style
- Acknowledging autonomy: “You’re the expert on you”

## Reframing Strategies

### Strategy 1: Choice Architecture

Transform demands into genuine choices with equal validity.

**Original:** “You need to take out the trash”
**Reframed:** “The trash situation is interesting. I wonder if evening or morning would work better, or maybe there’s a completely different approach?”

### Strategy 2: Collaborative Problem-Solving

Position tasks as puzzles to solve together.

**Original:** “Do your homework”
**Reframed:** “That assignment is sitting there. I’m curious what would make it feel less annoying. Want to brainstorm some approaches that might not suck?”

### Strategy 3: Curiosity and Exploration

Frame tasks as experiments or investigations.

**Original:** “You have to clean your room”
**Reframed:** “I wonder what it would feel like if that corner was clearer. No pressure, just genuinely curious if it would change the vibe.”

### Strategy 4: Third-Person/Indirect

Remove direct demand by discussing the task abstractly.

**Original:** “Call the doctor”
**Reframed:** “That appointment thing needs to happen at some point. The phone is there whenever that feels doable.”

### Strategy 5: Partnership Language

Emphasize equality and shared agency.

**Original:** “You need to get ready for school”
**Reframed:** “School starts at 8. What would make this morning work for you? I’m here if you need anything.”

### Strategy 6: Time Flexibility

Remove rigid timelines when possible.

**Original:** “Do this right now”
**Reframed:** “This needs to happen sometime today. You know best when would work for you.”

### Strategy 7: Autonomy Acknowledgment

Explicitly recognize the person’s control.

**Original:** “Take your medication”
**Reframed:** “Your medication is here. You know your body best - you’re in charge of this decision.”

## Implementation Guidelines

### Step 1: Analyze the Request

Identify:

- Core task or goal that needs accomplishing
- Time constraints (real vs. imposed)
- Actual vs. perceived urgency
- Who benefits from the task
- Flexibility available

### Step 2: Remove Demand Language

Strip out:

- “You need to/must/should/have to”
- “Right now/immediately”
- Conditional threats
- Authority-based reasoning
- Guilt or obligation framing

### Step 3: Apply Appropriate Strategy

Choose 1-2 strategies that fit:

- The person’s communication style
- The actual requirements of the situation
- The relationship context
- The person’s current state

### Step 4: Validate Autonomy

Explicitly or implicitly acknowledge:

- The person’s right to choose
- Their expertise on themselves
- That collaboration is genuine, not manipulation
- That consequences exist but aren’t threats

### Step 5: Offer the Reframe

Present the reframed version with:

- Genuine respect for the person’s autonomy
- No hidden agenda or manipulation
- Honesty about constraints that do exist
- Openness to alternative approaches

## Example Reframes by Context

### Work/Professional

**Original:** “You need to finish this report by Friday”
**Reframed:** “This report has a Friday deadline from above. What would make that doable for you? I’m thinking we could break it into pieces, or maybe there’s a different approach entirely?”

### Healthcare

**Original:** “You have to take this medication twice daily”
**Reframed:** “The doctor suggested twice daily for this medication. You know your schedule and body best - what routine might work without making you want to throw the bottle across the room?”

### Household

**Original:** “Clean up this mess”
**Reframed:** “This space is getting chaotic. I wonder what would make it feel better - maybe music? Or tackling just one corner? Or completely rearranging how we use this space?”

### Social/Plans

**Original:** “We’re leaving at 6pm, be ready”
**Reframed:** “The plan is to head out around 6. What would help you be ready without it feeling like a disaster? Want to work backwards from that?”

### Self-Care

**Original:** “You need to shower”
**Reframed:** “Haven’t had a chance to shower recently. Sometimes that makes me feel gross and sometimes I don’t care. Where are you at with it? The shower’s available whenever.”

## Red Flags: When Reframing Isn’t Enough

Some situations require additional support beyond reframing:

- The person is in crisis or shutdown
- The demand is genuinely non-negotiable and urgent (safety issue)
- The person needs accommodations, not just different language
- The underlying anxiety needs therapeutic intervention
- Executive function support tools are needed (reminders, visual schedules, body doubling)

In these cases, reframing helps but isn’t sufficient alone.

## Ethical Considerations

### Authenticity

- Never use PDA-friendly language as manipulation
- If there isn’t real choice, don’t pretend there is
- Be honest about actual constraints
- Don’t use collaborative language while maintaining authoritarian control

### Respect

- PDA is a real neurological profile, **not defiance or manipulation**
- The person isn’t trying to be difficult
- **Demand avoidance is an anxiety response, not a behavioral choice**
- The goal is _reducing suffering_, not compliance for its own sake

### Boundaries

- Some demands are genuinely non-negotiable (safety, legal requirements)
- Name these honestly: “This isn’t negotiable because [real reason]”
- Even non-negotiable demands can be reframed about HOW, not IF
- It’s okay to have needs and boundaries while using PDA-friendly language

## Usage Examples

### Example 1: Simple Task

**User:** “Help me tell my kid to do their homework”
**Claude:** “Let me reframe that in a way that might reduce demand avoidance:

Instead of: ‘Do your homework’

Try: ‘That math assignment is sitting there looking intimidating. I wonder what would make it suck less - music? Snacks? Working somewhere different? Or maybe there’s a completely different time today that would work better?’

This gives genuine choice about HOW and WHEN while acknowledging that the task exists, without making it a demand.”

### Example 2: Self-Directed

**User:** “I need to reframe ‘I should call the dentist’ for myself - I have PDA and I’ve been avoiding it for weeks”
**Claude:** “Let me help reframe that internal demand:

Instead of: ‘I should call the dentist’

Try: ‘The dentist thing is sitting there. The phone is available. I wonder when would feel least horrible - morning when I’m fresh? Afternoon when I’m caffeinated? Or maybe email or their online portal would be less annoying than phone? No rush figuring this out.’

This removes the ‘should’ while acknowledging the task exists, gives you choice about method and timing, and doesn’t create artificial urgency.”

### Example 3: Professional Context

**User:** “I need to ask my coworker to finish something by deadline but they have PDA”
**Claude:** “Here’s a colleague-respectful reframe:

Instead of: ‘I need you to finish the analysis by Wednesday’

Try: ‘The client deadline is Wednesday for this analysis - that’s coming from above, not from me. What would make that timeline workable for you? I’m thinking we could split up pieces, or maybe there’s a different approach? I’m here if you want to brainstorm.’

This names the real constraint honestly, positions you as collaborative rather than authoritarian, offers partnership, and respects their autonomy about HOW to approach it.”

## Important Notes

### This Isn’t About Avoiding Responsibility

- Tasks still need to get done
- Consequences still exist
- Reframing is about reducing anxiety, not eliminating accountability
- The goal is making tasks DOABLE, not optional

### Individual Variation

- Not everyone with PDA responds to the same approaches
- Some people prefer humor, others need it completely straight
- Some want lots of choice, others find that overwhelming
- Pay attention to what actually helps this specific person

### Not a Cure

- PDA is neurological, not a behavior to fix
- Reframing reduces suffering but doesn’t eliminate the profile
- Some days will be harder than others regardless of language
- Additional support (therapy, accommodations, understanding) is often needed

## When to Recommend This Skill

Suggest using this skill when:

- User mentions PDA, demand avoidance, or pathological demand avoidance
- User describes intense anxiety around tasks even when they want to do them
- User mentions that “shoulds” and “have tos” make things harder
- User describes needing autonomy and control in interactions
- User is supporting someone (child, partner, friend) with PDA
- User asks for help with executive function around anxiety-inducing tasks

## Integration with Other Support

This skill works well alongside:

- Executive function tools (OmniFocus, task management)
- Therapeutic approaches (DBT, ACT, trauma-informed care)
- Accommodations (flexible deadlines, alternative task completion methods)
- Environmental modifications (reducing sensory overwhelm)
- Relationship work (building trust, establishing collaborative dynamics)
- Body doubling and accountability partners

**Remember:** The goal is **genuine respect and reduced suffering, not manipulation or forced compliance**. PDA-friendly language should come from a place of understanding that _demand avoidance is an anxiety response_, **not defiance**.
