# Academic Research Writer Skill

A comprehensive skill for creating high-quality academic research documents with proper scholarly standards, verified peer-reviewed sources, and IEEE-format citations.

## Purpose

This skill enables Claude to write academic research documents following rigorous academic guidelines, including:
- Proper academic writing conventions
- Source verification from peer-reviewed databases
- IEEE standard reference formatting
- Research integrity and quality assurance

## Skill Contents

### SKILL.md
Main instruction file containing:
- Core workflow for academic writing
- Source discovery and verification protocols
- IEEE reference formatting rules
- Document structure guidelines
- Quality assurance checklists

### References (references/)
Detailed guides loaded as needed:
- **ACADEMIC-WRITING.md**: Comprehensive academic writing conventions, tone, structure, and discipline-specific guidelines
- **IEEE-CITATION-GUIDE.md**: Complete IEEE citation format with examples for all source types
- **SOURCE-VERIFICATION.md**: Guide to identifying peer-reviewed sources, evaluating quality, and avoiding predatory publishers

### Scripts (scripts/)
- **ieee_formatter.py**: Python utility for formatting IEEE references programmatically

### Assets (assets/)
- **research_paper_template.md**: Template for standard academic research papers with section guidelines

## Usage

The skill automatically triggers when users request:
- Research papers
- Literature reviews
- Technical reports
- Academic proposals
- Thesis/dissertation chapters
- Conference papers

## Key Features

1. **Source Verification**: Ensures all sources are peer-reviewed from reputable databases
2. **IEEE Citations**: Generates accurate IEEE-format references
3. **Academic Standards**: Maintains scholarly writing quality
4. **Multiple Formats**: Creates documents as DOCX, PDF, or Markdown
5. **Quality Assurance**: Built-in verification checklists

## Supported Databases

- Google Scholar
- IEEE Xplore
- PubMed
- ACM Digital Library
- arXiv (with preprint notation)
- ScienceDirect
- JSTOR
- And other discipline-specific databases

## Document Types Supported

- Research papers
- Literature reviews
- Technical reports
- Conference papers
- Theses and dissertations
- Academic proposals
- Review articles

## Installation

Upload the skill zip file to Claude via the Skills interface.

## Version

1.0 - Initial release
