# Academic Research Writer Skill - User Guide

## Overview

The Academic Research Writer skill transforms Claude into a specialized academic writing assistant that follows rigorous scholarly standards, verifies peer-reviewed sources, and generates IEEE-formatted citations.

## What This Skill Does

✅ **Writes research documents** following academic guidelines  
✅ **Finds and verifies** peer-reviewed sources from scholarly databases  
✅ **Generates IEEE citations** in proper format  
✅ **Maintains academic rigor** throughout the writing process  
✅ **Creates multiple formats** (DOCX, PDF, Markdown)  
✅ **Quality checks** all sources and references  

## Installation

1. Download the `academic-research-writer.zip` file
2. Go to Claude's interface
3. Click on "Skills" in the menu
4. Click "Upload Skill"
5. Select the downloaded zip file
6. The skill is now available for use

## How to Use

### Basic Usage

Simply ask Claude to write an academic document. The skill automatically triggers for:

**Example prompts:**
- "Write a research paper on machine learning in healthcare"
- "Create a literature review on blockchain security"
- "Help me write the methodology section for my thesis"
- "Write a conference paper on quantum computing applications"

### Specifying Requirements

Provide more details for better results:

```
Write a 10-page research paper on:
- Topic: Deep learning for medical diagnosis
- Focus: Recent advances (last 5 years)
- Required sections: Abstract, Introduction, Literature Review, Methodology, 
  Results, Discussion, Conclusion
- Target: IEEE journal submission
- Format: DOCX with IEEE references
```

### Step-by-Step Process

When you make a request, the skill will:

1. **Clarify requirements** - Confirm document type, length, focus areas
2. **Research planning** - Identify key topics and search strategies
3. **Source discovery** - Search academic databases for peer-reviewed sources
4. **Source verification** - Verify credibility and peer-review status
5. **Content writing** - Draft sections with proper academic tone
6. **Citation integration** - Add IEEE-formatted citations throughout
7. **Reference generation** - Create complete IEEE reference list
8. **Quality assurance** - Verify all requirements met
9. **Document creation** - Produce final document in requested format

## Examples of Documents You Can Create

### Research Paper
```
Create a research paper on "Artificial Intelligence in Drug Discovery":
- 8000 words
- Include: Abstract, Introduction, Literature Review, Methodology, 
  Results, Discussion, Conclusion
- 20+ peer-reviewed references
- IEEE format
- DOCX output
```

### Literature Review
```
Write a comprehensive literature review on:
Topic: Renewable energy storage technologies
Time frame: 2018-2024
Focus: Battery technologies, grid integration, economic analysis
Length: 6000 words
Format: PDF with IEEE citations
```

### Thesis Chapter
```
Help me write Chapter 2 (Literature Review) for my thesis on:
- Computer vision in autonomous vehicles
- 15-20 pages
- Cover: traditional approaches, deep learning methods, current challenges
- 30+ academic sources
- University thesis format with IEEE references
```

### Conference Paper
```
Create a 6-page conference paper for IEEE conference on:
Topic: Edge computing for IoT
Include: Abstract (150 words), Introduction, Related Work, 
Proposed Method, Evaluation, Conclusion
Minimum 15 references
Two-column IEEE conference format
```

## Features in Detail

### 1. Source Verification

The skill searches and verifies sources from:

**Primary Databases:**
- Google Scholar - Broad academic search
- IEEE Xplore - Engineering and computer science
- PubMed - Medical and life sciences
- ACM Digital Library - Computer science
- arXiv - Preprints (physics, CS, math)

**Verification Process:**
- ✓ Confirms peer-review status
- ✓ Checks journal reputation
- ✓ Verifies author credentials
- ✓ Assesses citation impact
- ✓ Identifies predatory publishers

### 2. IEEE Citation Format

Automatically generates proper IEEE citations for:
- Journal articles
- Conference papers
- Books and chapters
- Websites
- Technical reports
- Theses/dissertations
- Patents
- Standards

**Example Output:**
```
[1] J. Smith, R. Johnson, and M. Williams, "Deep learning approaches 
for medical image analysis," IEEE Trans. Med. Imaging, vol. 42, no. 3, 
pp. 234-245, Mar. 2023.

[2] P. Kumar and S. Patel, "Machine learning for network optimization," 
in Proc. IEEE Int. Conf. Commun. (ICC), Rome, Italy, 2023, pp. 456-461.
```

### 3. Academic Writing Standards

Maintains proper:
- **Tone**: Formal, objective, scholarly
- **Structure**: Clear organization with logical flow
- **Citations**: Every claim properly cited
- **Language**: Precise technical terminology
- **Arguments**: Evidence-based and logical

### 4. Quality Assurance

Built-in checks for:
- Source credibility (peer-reviewed only)
- Citation accuracy (all sources verified)
- Reference formatting (IEEE compliance)
- Content quality (methodology, logic, clarity)
- Completeness (all required sections)

## Advanced Features

### Custom Guidelines

Specify institutional or journal requirements:
```
Write a research paper following:
- University of XYZ thesis guidelines
- Maximum 12,000 words
- Harvard referencing (instead of IEEE)
- Specific ethical approval statement
- Required appendices
```

### Multiple Iterations

Request revisions and improvements:
```
Improve the literature review section:
- Add more recent sources (2023-2024)
- Expand discussion of deep learning methods
- Include more quantitative comparisons
- Add a comparison table
```

### Specific Sections

Work on individual sections:
```
Write just the Methodology section for my paper on:
- Experimental design
- Data collection procedures (survey of 500 participants)
- Statistical analysis methods (regression analysis)
- Validation approach
```

## Tips for Best Results

### 1. Be Specific About Requirements
❌ "Write a paper on AI"  
✅ "Write a 10-page research paper on AI applications in healthcare, focusing on diagnostic imaging, with 20+ peer-reviewed sources from 2020-2024"

### 2. Specify Target Audience
- Academic journal (which journal?)
- Conference (which conference?)
- Thesis/dissertation (which university?)
- General academic audience

### 3. Indicate Preferred Structure
Specify if you need:
- Standard structure (Intro, Lit Review, Methods, Results, Discussion, Conclusion)
- Journal-specific format
- Short communication format
- Extended abstract format

### 4. Mention Constraints
- Word/page limits
- Number of references required
- Specific topics to cover/exclude
- Methodological requirements

### 5. Request Specific Focus
- Theoretical vs. applied
- Broad overview vs. deep dive
- Comparative analysis
- Critical review

## Common Use Cases

### For Students
- Thesis and dissertation chapters
- Course research papers
- Literature reviews
- Research proposals
- Seminar papers

### For Researchers
- Journal article drafts
- Conference paper submissions
- Grant proposals
- Technical reports
- Review articles

### For Academics
- Book chapters
- Research summaries
- State-of-the-art reviews
- Position papers
- White papers

## Output Formats

### DOCX (Microsoft Word)
- Fully editable
- Formatted for submissions
- Track changes compatible
- Best for: Journals, theses

### PDF
- Print-ready
- Professional appearance
- Best for: Final submissions, archiving

### Markdown
- Plain text with formatting
- Version control friendly
- Easy to convert
- Best for: Drafts, collaboration, online publication

## Troubleshooting

### "Not enough recent sources found"
**Solution**: Adjust time frame or broaden search terms

### "Can't verify source credibility"
**Solution**: Skill will search for alternative verified sources

### "References not in proper format"
**Solution**: Skill automatically reformats to IEEE standards

### "Document too technical/too simple"
**Solution**: Specify desired complexity level in request

## Limitations

**What the skill does NOT do:**
- ❌ Fabricate data or sources
- ❌ Use non-peer-reviewed sources (unless explicitly requested for preprints)
- ❌ Plagiarize content
- ❌ Make unsupported claims
- ❌ Access paywalled articles (searches abstracts and metadata)
- ❌ Guarantee publication acceptance

**Ethical Guidelines:**
- All sources properly cited
- No plagiarism
- Transparent about limitations
- Acknowledges data availability constraints

## Best Practices

1. **Start with clear objectives** - Know what you want to achieve
2. **Review and refine** - Treat output as a strong draft, not final
3. **Verify critical claims** - Check key citations yourself
4. **Customize to requirements** - Adapt to specific guidelines
5. **Iterate as needed** - Request improvements and additions
6. **Maintain research integrity** - Use ethically and honestly

## Support and Feedback

For skill improvements or issues:
- Note specific problems encountered
- Provide example prompts that didn't work well
- Suggest additional features needed
- Share successful use cases

## Version Information

**Current Version:** 1.0  
**Last Updated:** October 2025

## Additional Resources

The skill includes comprehensive reference guides on:
- Academic writing conventions (discipline-specific)
- Complete IEEE citation examples
- Source verification procedures
- Predatory publisher identification
- Research quality assessment

These are automatically consulted as needed during the writing process.

---

## Quick Start Examples

### Beginner Example
```
Write a 5-page research paper on solar energy technologies for beginners 
in the field. Include 10-15 references and make it accessible.
```

### Intermediate Example
```
Create a literature review on machine learning in climate modeling:
- 8000 words
- Cover 2018-2024 publications
- Focus on: neural networks, data assimilation, uncertainty quantification
- 25+ peer-reviewed sources
- IEEE format
```

### Advanced Example
```
Write a comprehensive research article for submission to Nature Machine 
Intelligence on:
- Novel deep learning architecture for protein folding prediction
- Include: Abstract (150 words), Introduction, Related Work, Methods 
  (detailed algorithm description), Results (with statistical analysis), 
  Discussion, Conclusion
- 40+ high-impact references (Nature, Science, Cell, PNAS, etc.)
- 12,000 words
- Include comparison table with existing methods
- Follow Nature journal formatting
```

---

**Ready to start?** Just ask Claude to write your academic document, and the skill will guide you through the process!
