# Academic Writing Conventions

## Table of Contents
1. Academic Tone and Voice
2. Sentence and Paragraph Construction
3. Argumentation and Logic
4. Common Errors to Avoid
5. Discipline-Specific Conventions

## 1. Academic Tone and Voice

### Formality Levels

**High Formality (STEM, Law, Medicine):**
- Avoid contractions (use "cannot" not "can't")
- Minimize personal pronouns
- Use passive voice strategically
- Employ technical terminology precisely

**Moderate Formality (Social Sciences, Humanities):**
- Personal pronouns acceptable in methodology
- Active voice preferred for clarity
- Balance between accessibility and precision

### Objectivity

**Maintain neutrality:**
- Present multiple perspectives
- Acknowledge counterarguments
- Use hedging language: "suggests," "appears," "may indicate"
- Avoid absolute statements: "proves," "always," "never"

**Hedge appropriately:**
- Strong evidence: "demonstrates," "shows," "indicates"
- Moderate evidence: "suggests," "implies," "may reflect"
- Weak evidence: "might," "could," "appears to"

### Precision

**Be specific:**
- ❌ "Many studies show..."
- ✅ "A meta-analysis of 47 studies [1] demonstrates..."

**Use technical terms correctly:**
- Define specialized terms on first use
- Maintain consistency in terminology
- Use standard abbreviations

## 2. Sentence and Paragraph Construction

### Sentence Structure

**Clarity principles:**
- One main idea per sentence
- Subject-verb proximity
- Active voice for clarity (when appropriate)
- Vary sentence length for readability

**Examples:**

❌ Weak: "It was found by the researchers that the algorithm performed better."
✅ Strong: "The algorithm demonstrated superior performance [1]."

❌ Weak: "There are many factors that contribute to climate change."
✅ Strong: "Multiple factors contribute to climate change, including greenhouse gas emissions, deforestation, and industrial activity [2]."

### Paragraph Structure

**Standard academic paragraph:**

1. **Topic sentence**: Introduces main idea
2. **Evidence**: Supporting data, citations, examples
3. **Analysis**: Interpretation and explanation
4. **Link**: Connection to thesis or transition to next point

**Example:**

"Machine learning algorithms have transformed medical diagnostics [Topic]. Recent studies demonstrate that deep learning models achieve diagnostic accuracy comparable to expert physicians in radiology [1], dermatology [2], and pathology [3] [Evidence]. This performance stems from the algorithms' ability to recognize complex patterns in large datasets that may elude human observation [Analysis]. These advances suggest a paradigm shift in clinical decision-making processes [Link]."

### Transitions

**Between paragraphs:**
- However, Moreover, Furthermore
- In contrast, Similarly, Conversely
- Consequently, Therefore, Thus
- First, Second, Finally

**Within paragraphs:**
- Additionally, Also, Furthermore
- For example, For instance, Specifically
- In other words, That is to say
- Nevertheless, Nonetheless, Still

## 3. Argumentation and Logic

### Thesis Development

**Strong thesis characteristics:**
- Specific and focused
- Arguable (not self-evident)
- Supported by evidence
- Addresses "so what?" question

**Examples:**

❌ Weak: "Social media affects society."
✅ Strong: "Social media platforms' algorithmic curation of content contributes to political polarization by creating echo chambers that reinforce existing beliefs and limit exposure to diverse viewpoints."

### Evidence Integration

**Citation placement:**

**Author-prominent:**
"Smith et al. [1] argue that quantum computing will revolutionize cryptography."

**Information-prominent:**
"Quantum computing threatens current cryptographic methods [1], [2]."

**Synthesis of multiple sources:**
"While some researchers emphasize the benefits of AI in education [1], [3], others highlight potential risks [2], [4]."

### Logical Fallacies to Avoid

1. **Hasty generalization**: Drawing broad conclusions from limited evidence
2. **False causation**: Assuming correlation implies causation
3. **Appeal to authority**: Relying solely on credentials without evidence
4. **Straw man**: Misrepresenting opposing arguments
5. **Cherry picking**: Selecting only supporting evidence

## 4. Common Errors to Avoid

### Wordiness

❌ "Due to the fact that"
✅ "Because"

❌ "In order to"
✅ "To"

❌ "It is important to note that"
✅ Delete (unnecessary)

### Redundancy

❌ "Past history," "future plans," "advance warning"
✅ "History," "plans," "warning"

### Vague Language

❌ "Things," "stuff," "a lot," "very"
✅ Specific nouns and precise quantifiers

### Inappropriate Register

❌ "The data is super interesting and shows..."
✅ "The data reveals significant patterns..."

### Anthropomorphism

❌ "The study wants to prove..."
✅ "This study aims to demonstrate..."

❌ "The paper believes that..."
✅ "This paper argues that..."

## 5. Discipline-Specific Conventions

### STEM Fields

**Characteristics:**
- Emphasis on methodology and reproducibility
- Extensive use of figures, tables, equations
- Passive voice acceptable in methods sections
- Present tense for established facts, past tense for specific studies

**Example:**
"Samples were collected from five sites (Methods). Figure 1 shows the temperature distribution (Results). These findings indicate that thermal gradients affect reaction rates (Discussion)."

### Social Sciences

**Characteristics:**
- Theoretical frameworks prominently discussed
- Qualitative and quantitative methods
- First-person acceptable in reflective methodology
- Past tense for research conducted, present for ongoing debate

**Example:**
"Previous research suggests that socioeconomic factors influence educational outcomes [1]. We conducted semi-structured interviews with 30 participants to explore this relationship."

### Humanities

**Characteristics:**
- Emphasis on interpretation and analysis
- Extensive engagement with primary texts
- Present tense for discussing texts/artworks
- More flexible citation practices (footnotes common)

**Example:**
"In Pride and Prejudice, Austen critiques the marriage market of Regency England. Elizabeth Bennet's refusal of Mr. Collins represents a radical assertion of female autonomy."

### Engineering

**Characteristics:**
- Focus on problem-solving and implementation
- Detailed technical specifications
- Extensive use of diagrams and schematics
- Clear delineation of requirements and results

**Example:**
"The proposed architecture achieves 95% accuracy with 40% lower computational complexity than existing methods [1]. Figure 2 illustrates the system design."

## Best Practices Summary

1. **Clarity over complexity**: Simple, direct language conveys ideas more effectively
2. **Evidence-based claims**: Support all assertions with citations
3. **Logical structure**: Organize ideas hierarchically and sequentially
4. **Consistent terminology**: Use terms uniformly throughout
5. **Appropriate tone**: Match formality to discipline and audience
6. **Active engagement**: Show critical thinking, not just summary
7. **Revision**: Multiple drafts improve quality significantly

## Self-Review Checklist

- [ ] Each paragraph has clear topic sentence
- [ ] Claims supported by evidence
- [ ] Transitions between ideas smooth
- [ ] Tone formal and objective
- [ ] Technical terms defined
- [ ] No logical fallacies
- [ ] Sentence variety maintained
- [ ] Citations integrated smoothly
- [ ] Discipline conventions followed
- [ ] "So what?" question answered
