# IEEE Citation Guide

## Table of Contents
1. General IEEE Rules
2. Detailed Format Examples
3. Special Cases
4. In-Text Citation Patterns
5. Common Mistakes
6. Quick Reference Table

## 1. General IEEE Rules

### Basic Principles

**Numbering:**
- Number references consecutively in order of first appearance in text
- Use square brackets [1], [2], [3]
- References cited multiple times keep original number

**Author Names:**
- Format: First Initial(s). Last Name
- List all authors if six or fewer
- Use "et al." after first author if more than six
- Separate authors with commas, "and" before last author

**Punctuation:**
- Use commas between reference elements
- End with period
- Italicize journal/book titles
- Use quotation marks for article/chapter titles

### Abbreviations

**Months:**
Jan., Feb., Mar., Apr., May, Jun., Jul., Aug., Sep., Oct., Nov., Dec.

**Common Terms:**
- vol. (volume)
- no. (number)
- pp. (pages)
- ed. (edition or editor)
- Proc. (Proceedings)
- Conf. (Conference)
- Int. (International)
- Dept. (Department)
- Univ. (University)
- Rep. (Report)

## 2. Detailed Format Examples

### Journal Articles

**Standard format:**
```
[1] A. Author, B. Author, and C. Author, "Title of article," Journal Name, vol. X, no. Y, pp. ZZ-ZZ, Month Year.
```

**With DOI:**
```
[2] A. Author, B. Author, and C. Author, "Title of article," Journal Name, vol. X, no. Y, pp. ZZ-ZZ, Month Year, doi: 10.1234/example.
```

**Online/Open Access:**
```
[3] A. Author, "Title of article," Journal Name, vol. X, no. Y, pp. ZZ-ZZ, Month Year. [Online]. Available: https://doi.org/10.1234/example
```

**Accepted for publication:**
```
[4] A. Author, "Title," Journal Name, to be published.
```

**In press:**
```
[5] A. Author, "Title," Journal Name, in press.
```

**Examples:**

```
[1] J. Smith, R. Johnson, and M. Williams, "Deep learning approaches for medical image analysis," IEEE Trans. Med. Imaging, vol. 42, no. 3, pp. 234-245, Mar. 2023.

[2] L. Chen et al., "Quantum computing applications in cryptography," Nature Quantum Inf., vol. 8, no. 2, pp. 112-128, Feb. 2023, doi: 10.1038/s41534-023-00234-5.

[3] K. Anderson, "Blockchain security protocols," ACM Comput. Surv., vol. 55, no. 4, article 89, Apr. 2023. [Online]. Available: https://doi.org/10.1145/3578234
```

### Conference Papers

**Standard format:**
```
[1] A. Author and B. Author, "Title of paper," in Proc. Conference Name, City, State/Country, Year, pp. ZZ-ZZ.
```

**With DOI:**
```
[2] A. Author, "Title," in Proc. Conf. Name, City, Country, Year, pp. ZZ-ZZ, doi: 10.1234/example.
```

**Unpublished but presented:**
```
[3] A. Author, "Title," presented at Conf. Name, City, Country, Month Year.
```

**Examples:**

```
[1] P. Kumar and S. Patel, "Machine learning for network optimization," in Proc. IEEE Int. Conf. Commun. (ICC), Rome, Italy, 2023, pp. 456-461.

[2] M. Zhang, "Edge computing architectures," in Proc. 45th ACM Symp. Theory Comput., Boston, MA, USA, 2023, pp. 1234-1240, doi: 10.1145/3234567.3234890.

[3] R. Taylor, "Novel cryptographic methods," presented at RSA Conf., San Francisco, CA, USA, Apr. 2023.
```

### Books

**Complete book:**
```
[1] A. Author, Title of Book, Edition. City, State: Publisher, Year.
```

**With volume:**
```
[2] A. Author, Title of Book, Edition, vol. X. City, State: Publisher, Year.
```

**Chapter in edited book:**
```
[3] A. Author, "Title of chapter," in Book Title, Edition, Ed. City, State: Publisher, Year, pp. ZZ-ZZ.
```

**Examples:**

```
[1] D. Patterson and J. Hennessy, Computer Architecture: A Quantitative Approach, 6th ed. Cambridge, MA, USA: Morgan Kaufmann, 2017.

[2] I. Goodfellow, Y. Bengio, and A. Courville, Deep Learning. Cambridge, MA, USA: MIT Press, 2016.

[3] M. Nielsen, "Neural networks and deep learning," in Handbook of Artificial Intelligence, vol. 2, A. Editor, Ed. Berlin, Germany: Springer, 2020, pp. 145-178.
```

### Technical Reports

**Standard format:**
```
[1] A. Author, "Title of report," Institution, City, State, Rep. Number, Month Year.
```

**Available online:**
```
[2] A. Author, "Title," Institution, City, State, Rep. Number, Month Year. [Online]. Available: URL
```

**Examples:**

```
[1] R. Brooks, "Artificial intelligence in robotics," MIT Computer Sci. Artif. Intell. Lab., Cambridge, MA, USA, Tech. Rep. MIT-CSAIL-TR-2023-001, Jan. 2023.

[2] National Institute of Standards and Technology, "Cybersecurity framework," NIST, Gaithersburg, MD, USA, NIST SP 800-53, Feb. 2023. [Online]. Available: https://nvlpubs.nist.gov/nistpubs/
```

### Theses and Dissertations

**Standard format:**
```
[1] A. Author, "Title of thesis," M.S. thesis/Ph.D. dissertation, Dept. Abbrev., University, City, State, Year.
```

**Examples:**

```
[1] S. Thompson, "Optimization algorithms for large-scale systems," Ph.D. dissertation, Dept. Elect. Eng., Stanford Univ., Stanford, CA, USA, 2023.

[2] J. Martinez, "Novel approaches to data compression," M.S. thesis, Dept. Comput. Sci., MIT, Cambridge, MA, USA, 2022.
```

### Online Sources

**Websites:**
```
[1] A. Author. "Title of webpage." Website Name. URL (accessed Month Day, Year).
```

**Without author:**
```
[2] "Title of webpage," Website Name. URL (accessed Month Day, Year).
```

**Examples:**

```
[1] T. Brown. "Language models are few-shot learners." OpenAI Blog. https://openai.com/blog/gpt-3 (accessed Jan. 15, 2023).

[2] "Python documentation," Python Software Foundation. https://docs.python.org/3/ (accessed Mar. 10, 2023).
```

### Standards

**Format:**
```
[1] Title of Standard, Standard Number, Year.
```

**Example:**

```
[1] IEEE Standard for Floating-Point Arithmetic, IEEE Std 754-2019, Jul. 2019.
```

### Patents

**Format:**
```
[1] A. Inventor, "Title of patent," Country Patent Number, Month Day, Year.
```

**Example:**

```
[1] J. Smith, "Method for data encryption," U.S. Patent 10,234,567, Mar. 19, 2019.
```

### Preprints (arXiv)

**Format:**
```
[1] A. Author et al., "Title," arXiv preprint arXiv:XXXX.XXXXX, Month Year.
```

**Example:**

```
[1] A. Vaswani et al., "Attention is all you need," arXiv preprint arXiv:1706.03762, Jun. 2017.
```

## 3. Special Cases

### Multiple Works by Same Author(s)

Number chronologically and use original numbers:

```
[1] J. Smith, "First paper," ...2022.
[2] J. Smith, "Second paper," ...2023.
```

Text cites: [1], [2]

### Multiple Citations in One Bracket

**Separate papers:**
```
[1], [2], [3] or [1]-[3]
```

**Same author, different papers:**
```
Smith [1], [2] or Smith [1]-[3]
```

### No Author Available

Use organization or "Anonymous":

```
[1] National Research Council, Title, ...
[2] Anonymous, "Title," ...
```

### Non-English Sources

**With translation:**
```
[1] A. Author, "Titre en français (Title in French)," ...
```

**Original language kept:**
```
[1] A. Author, "原题 (Original title)," ...
```

## 4. In-Text Citation Patterns

### Single Reference

"Recent studies demonstrate improved accuracy [1]."

"Smith et al. [1] proposed a novel algorithm..."

### Multiple References

**Sequential:**
"Several studies [1]-[4] confirm..."

**Non-sequential:**
"Previous work [1], [3], [7] addresses..."

### Reference in Sentence

"As shown in [1], the method achieves..."

"The algorithm described in [5] outperforms..."

### Multiple Authors

**Parenthetical:**
"The technique improves efficiency [1]."

**Narrative:**
"Smith et al. [1] demonstrate that..."

Note: Always use "et al." in text even if all authors listed in reference

## 5. Common Mistakes

### ❌ Incorrect Formats

**Wrong:**
```
[1] Smith, J., Johnson, R. (2023). "Title of article." Journal Name, Vol. 42, No. 3, Pages 234-245.
```

**Correct:**
```
[1] J. Smith and R. Johnson, "Title of article," Journal Name, vol. 42, no. 3, pp. 234-245, Mar. 2023.
```

### ❌ Author Name Format

**Wrong:**
- Smith, John (APA style)
- John Smith
- SMITH, J.

**Correct:**
- J. Smith
- J. R. Smith

### ❌ Punctuation Errors

**Wrong:**
- [1] J. Smith; "Title;" Journal; vol. 1; 2023
- [1] J. Smith. "Title." Journal. vol. 1. 2023

**Correct:**
- [1] J. Smith, "Title," Journal, vol. 1, 2023.

### ❌ Title Capitalization

**Wrong:**
- "The Effect Of Temperature On Reaction Rates" (title case)

**Correct:**
- "The effect of temperature on reaction rates" (sentence case)

### ❌ Page Number Format

**Wrong:**
- p. 234-245
- pages 234-245

**Correct:**
- pp. 234-245

## 6. Quick Reference Table

| Type | Basic Format |
|------|--------------|
| **Journal** | Authors, "Title," Journal, vol., no., pp., Month Year. |
| **Conference** | Authors, "Title," in Proc. Conf., City, Country, Year, pp. |
| **Book** | Authors, Title, ed. City, State: Publisher, Year. |
| **Chapter** | Author, "Chapter title," in Book Title, Ed. City: Pub., Year, pp. |
| **Website** | Author. "Title." Site. URL (accessed Date). |
| **Report** | Author, "Title," Institution, City, Rep. No., Month Year. |
| **Thesis** | Author, "Title," Degree, Dept., Univ., City, Year. |
| **Patent** | Inventor, "Title," Country Patent No., Date. |
| **Standard** | Standard Title, Std. Number, Year. |
| **arXiv** | Authors, "Title," arXiv preprint arXiv:XXXX, Month Year. |

## Reference Management Tips

1. **Maintain consistency**: Follow format exactly throughout
2. **Verify all details**: Check author names, dates, page numbers
3. **Include DOI when available**: Improves discoverability
4. **Double-check URLs**: Ensure links work
5. **Sort references**: Number in order of appearance
6. **Cross-check citations**: Every [X] must have reference [X]
7. **Use tools carefully**: Reference managers may have errors

## Journal Name Abbreviations

Use IEEE standard abbreviations:

- Transactions → Trans.
- Journal → J.
- Proceedings → Proc.
- International → Int.
- Computer → Comput.
- Magazine → Mag.
- Communications → Commun.
- Technology → Technol.

Example: 
- Full: "IEEE Transactions on Pattern Analysis and Machine Intelligence"
- Abbreviated: "IEEE Trans. Pattern Anal. Mach. Intell."
