# Source Verification Guide

## Table of Contents
1. Identifying Peer-Reviewed Sources
2. Academic Database Overview
3. Source Quality Assessment
4. Predatory Publishing Warning Signs
5. Verification Checklist
6. Citation Metrics and Impact

## 1. Identifying Peer-Reviewed Sources

### What is Peer Review?

Peer review is a quality control process where experts in the field evaluate research before publication. Legitimate peer review involves:

- **Expert evaluation**: Multiple qualified reviewers assess methodology, validity, and significance
- **Blind or double-blind process**: Reviewer/author identities may be hidden to reduce bias
- **Revision requirements**: Authors typically must address reviewer concerns
- **Editorial oversight**: Editors make final publication decisions based on reviews

### Indicators of Peer Review

**Strong indicators:**
- Published in indexed journals (Web of Science, Scopus, PubMed)
- Journal describes peer review process on website
- Established publication history (>5 years)
- Affiliated with reputable academic organizations (IEEE, ACM, APA, etc.)
- Selective acceptance rates mentioned
- Detailed author guidelines for submission

**Verification steps:**
1. Check journal website for "About" or "Submission" sections
2. Look for editorial board with institutional affiliations
3. Verify journal indexing status
4. Check journal's impact factor or citation metrics
5. Search for journal in Directory of Open Access Journals (DOAJ) or Ulrichsweb

### Publication Types by Peer Review Status

**Peer-Reviewed:**
- Academic journal articles
- Conference papers from major conferences
- Book chapters in academic publishers
- Doctoral dissertations (university-reviewed)

**Not Peer-Reviewed (use cautiously):**
- Newspaper articles
- Magazine articles
- Blog posts
- White papers
- Technical documentation
- Preprints (arXiv, bioRxiv) - not yet peer-reviewed but may be acceptable in fast-moving fields
- Books (generally not peer-reviewed in same way)

**Gray area:**
- Conference abstracts (minimal review)
- Posters (limited review)
- Workshop papers (varies by venue)
- Technical reports (institutional review, not external peer review)

## 2. Academic Database Overview

### General Interdisciplinary

**Google Scholar (scholar.google.com)**
- Scope: All academic disciplines
- Coverage: Broadest, includes preprints, theses, books
- Strengths: Comprehensive, easy to use, citation tracking
- Limitations: No quality filter, includes predatory journals
- Best for: Initial broad searches, finding recent work

**Web of Science**
- Scope: Selective across all disciplines
- Coverage: High-quality journals only
- Strengths: Quality control, citation analysis, impact factors
- Limitations: Subscription required, more limited coverage
- Best for: High-impact research, citation metrics

**Scopus**
- Scope: All academic disciplines
- Coverage: Large curated database
- Strengths: Quality journals, author profiles, metrics
- Limitations: Subscription required
- Best for: Comprehensive literature review

### STEM Databases

**IEEE Xplore (ieeexplore.ieee.org)**
- Disciplines: Electrical engineering, computer science, electronics
- Coverage: IEEE publications, conferences, standards
- Strengths: High-quality technical content, standards access
- Best for: Engineering and CS research

**PubMed (pubmed.ncbi.nlm.nih.gov)**
- Disciplines: Medicine, biology, health sciences
- Coverage: MEDLINE plus additional life science journals
- Strengths: Free access, highly curated, MeSH indexing
- Best for: Biomedical research

**arXiv (arxiv.org)**
- Disciplines: Physics, mathematics, CS, statistics
- Coverage: Preprints (not peer-reviewed)
- Strengths: Latest research, free access, quick dissemination
- Limitations: Not peer-reviewed, quality varies
- Best for: Cutting-edge research in physics/math/CS

**ACM Digital Library (dl.acm.org)**
- Disciplines: Computer science, information technology
- Coverage: ACM publications and conferences
- Strengths: Computer science focus, high-quality venues
- Best for: CS and IT research

### Social Sciences & Humanities

**JSTOR**
- Disciplines: Humanities, social sciences
- Coverage: Archived scholarly journals, books
- Strengths: Historical depth, high-quality sources
- Best for: Historical research, humanities

**PsycINFO**
- Disciplines: Psychology, behavioral sciences
- Coverage: APA publications, international psychology journals
- Strengths: Comprehensive psychology coverage
- Best for: Psychology and behavioral research

**SSRN (Social Science Research Network)**
- Disciplines: Social sciences, humanities
- Coverage: Working papers, preprints
- Limitations: Not peer-reviewed
- Best for: Latest social science research

### Discipline-Specific

**ScienceDirect**: Chemistry, materials science, engineering
**ERIC**: Education research
**EconLit**: Economics
**MathSciNet**: Mathematics
**ChemSpider**: Chemistry
**GeoRef**: Earth sciences

## 3. Source Quality Assessment

### Evaluating Journal Quality

**High-quality indicators:**
- Indexed in major databases (WoS, Scopus, PubMed)
- Impact factor >1.0 (discipline-dependent)
- Published by reputable academic publishers:
  - Springer, Elsevier, Wiley, IEEE, ACM, Nature, Science, AAAS
  - University presses (Oxford, Cambridge, MIT, etc.)
- Long publication history (>10 years)
- Selective acceptance rate (<30%)
- Clear peer review process described
- Distinguished editorial board with major institutions

**Red flags:**
- Excessive promotional emails soliciting papers
- Promises of rapid publication (<1 month)
- High article processing charges (>$2000) without clear reputation
- No clear peer review process
- Generic journal name ("International Journal of Science")
- Poor website quality or multiple domains
- Editorial board with no institutional affiliations or stock photos

### Evaluating Author Credibility

**Positive indicators:**
- University or research institution affiliation
- Multiple publications in field
- H-index appropriate for career stage
- Research funded by recognized organizations (NSF, NIH, etc.)
- Collaboration with established researchers
- Institutional email address

**Verification:**
- Check author's institutional webpage
- Review publication history on Google Scholar
- Verify current affiliation
- Check for research grants and funding

### Evaluating Article Quality

**Methodology assessment:**
- Clear research questions/hypotheses
- Appropriate research design
- Sufficient sample size
- Proper statistical analysis
- Acknowledged limitations
- Reproducible methods

**Content quality:**
- Comprehensive literature review
- Logical argumentation
- Clear contribution to field
- Appropriate conclusions from data
- Proper acknowledgment of funding/conflicts
- Well-structured and clearly written

## 4. Predatory Publishing Warning Signs

### What is Predatory Publishing?

Predatory publishers exploit open-access model by charging fees without providing proper peer review or editorial services. They harm research integrity by:
- Publishing low-quality or fraudulent research
- Misleading researchers about journal quality
- Damaging researcher reputations
- Contaminating academic literature

### Warning Signs

**Journal-level red flags:**

1. **Aggressive solicitation**: Excessive spam emails inviting submissions
2. **Rapid publication promises**: Guaranteed acceptance within weeks
3. **Generic naming**: "International Journal of Advanced Research"
4. **Misleading metrics**: Fake impact factors or made-up indices
5. **Unclear peer review**: No description of review process
6. **High fees, low service**: Expensive APCs without quality services
7. **Poor website**: Grammar errors, broken links, stock photos
8. **Fake editorial boards**: Non-existent people or unauthorized use of names
9. **Lack of indexing**: Not in major databases (WoS, Scopus, DOAJ)
10. **Address inconsistencies**: Multiple addresses, PO boxes only

**Submission red flags:**
- Instant acceptance letters
- No reviewer comments
- Request for payment immediately after submission
- Editors who don't respond to queries
- No retraction policy
- Copyright assignment unclear

### Verification Resources

**Check these resources:**

1. **Think.Check.Submit** (thinkchecksubmit.org)
   - Checklist for evaluating journals
   
2. **Directory of Open Access Journals (DOAJ)** (doaj.org)
   - Whitelist of legitimate OA journals
   
3. **Cabells Predatory Reports** (subscription)
   - Blacklist of predatory journals
   
4. **Web of Science Master Journal List**
   - Indexed legitimate journals
   
5. **Scopus Source List**
   - Indexed legitimate journals
   
6. **Journal Citation Reports**
   - Impact factors for legitimate journals

**Historical note:**
- Beall's List (discontinued 2017) was a prominent predatory journal list
- Some archives exist but use with caution as they're outdated

## 5. Verification Checklist

### Quick Verification Protocol

For each source, verify:

**Level 1 - Basic Verification (Required for all sources):**
- [ ] Published in identifiable journal/venue
- [ ] Authors have institutional affiliations
- [ ] Year of publication clear
- [ ] Peer-review status determinable

**Level 2 - Quality Verification (Required for key sources):**
- [ ] Journal indexed in major database (verify on WoS/Scopus)
- [ ] Journal has impact factor or citation metrics
- [ ] Publisher is reputable
- [ ] Editorial board exists with real, affiliated researchers
- [ ] Peer review process described
- [ ] Author credentials verifiable

**Level 3 - Content Verification (Required for controversial/critical claims):**
- [ ] Methodology appropriate and clearly described
- [ ] Results support conclusions
- [ ] Limitations acknowledged
- [ ] Conflicts of interest disclosed
- [ ] Data availability stated
- [ ] Ethical approval mentioned (if human/animal research)

**Level 4 - Impact Verification (For establishing importance):**
- [ ] Citation count appropriate for publication date
- [ ] Cited by other peer-reviewed sources
- [ ] Part of ongoing research conversation
- [ ] Findings replicated or confirmed (if applicable)

### Red Flag Scoring

Assign concern levels:

**High concern (Do not use):**
- 3+ predatory indicators
- No verifiable peer review
- Anonymous or fake authors
- Retracted or disputed findings

**Moderate concern (Use with caution):**
- 1-2 predatory indicators
- Limited citation or impact
- Unclear methodology
- Preliminary findings only

**Low concern (Generally acceptable):**
- Established journal
- Clear peer review
- Verified authors
- Appropriate methodology

## 6. Citation Metrics and Impact

### Understanding Citation Metrics

**Journal Impact Factor (JIF):**
- Average citations per article in previous 2 years
- Discipline-dependent (compare within field)
- Physics/Medicine: 3-5 = good, >10 = excellent
- Social Sciences: 1-2 = good, >5 = excellent
- Limitations: Can be manipulated, favors review articles

**H-Index (Author metric):**
- H papers with at least H citations each
- Career-stage dependent
- New researcher: 5-10
- Mid-career: 15-30
- Senior researcher: 30+
- Limitations: Favors older researchers, quantity over quality

**CiteScore:**
- Citations in year X to papers published in years X-3
- Alternative to Impact Factor
- Generally higher numbers than JIF

**SJR (SCImago Journal Rank):**
- Weighted citation metric (prestigious journals count more)
- Alternative quality indicator

### Using Metrics Appropriately

**Do:**
- Compare within same discipline
- Consider multiple metrics
- Account for article age (older = more time for citations)
- Use as one quality indicator among many

**Don't:**
- Rely solely on metrics
- Compare across disciplines
- Assume high citations = truth
- Ignore recent, potentially important work

### Alternative Impact Indicators

**Article-level metrics:**
- Download counts
- Altmetrics (social media mentions, news coverage)
- Post-publication peer review

**Journal-level alternatives:**
- Acceptance rates
- Time to publication
- Editorial board quality
- Publisher reputation

## Best Practices Summary

### Before Using a Source:

1. **Verify venue**: Check if journal/conference is indexed
2. **Check authors**: Confirm institutional affiliations
3. **Assess peer review**: Ensure proper review process
4. **Evaluate content**: Review methodology and conclusions
5. **Cross-reference**: Find corroborating sources
6. **Check citations**: See if others cite this work positively

### When in Doubt:

- Search for journal in DOAJ or WoS
- Check if other researchers cite this work
- Look for author's other publications
- Ask librarian or subject expert
- Use higher-standard source instead

### Document Your Process:

- Keep notes on verification steps
- Record database searches conducted
- Note why sources included/excluded
- Maintain audit trail for thesis/dissertation

## Common Questions

**Q: Can I use preprints (arXiv, bioRxiv)?**
A: In fast-moving fields (CS, physics), preprints acceptable but note "preprint" status. Prefer published versions when available.

**Q: How recent should sources be?**
A: Generally last 5-7 years, but depends on field. Foundational older work appropriate. Rapidly evolving fields need more recent sources.

**Q: What if I can't verify a source?**
A: Don't use it. Find alternative verified sources instead.

**Q: Are all Google Scholar results acceptable?**
A: No. Google Scholar includes predatory journals, theses, and non-peer-reviewed work. Always verify independently.

**Q: Can I cite Wikipedia?**
A: No for academic papers. Use Wikipedia to find original sources, then cite those directly.

**Q: What about conference papers vs. journals?**
A: Top-tier conferences (especially in CS) equivalent to journals. Lower-tier conferences less rigorous. Check conference ranking.
