# D2 Validated Icons List

This reference contains verified icon URLs from the Terrastruct icon library. These icons are hosted and maintained for use in D2 diagrams.

**Important**: Only use icons from this list or other verified sources. Icons must be accessible via HTTP/HTTPS.

## Usage

```d2
element: {
  icon: https://icons.terrastruct.com/[path-from-below]
  shape: image  # Optional: removes border around icon
}
```

## AWS Services

### Compute
- **EC2**: `aws/Compute/Amazon-EC2.svg`
- **Lambda**: `aws/Compute/AWS-Lambda.svg`
- **ECS**: `aws/Compute/Amazon-Elastic-Container-Service.svg`
- **EKS**: `aws/Compute/Amazon-Elastic-Kubernetes-Service.svg`
- **Fargate**: `aws/Compute/AWS-Fargate.svg`
- **Auto Scaling**: `aws/Compute/Amazon-EC2-Auto-Scaling.svg`

### Storage
- **S3**: `aws/Storage/Amazon-Simple-Storage-Service-S3.svg`
- **EBS**: `aws/Storage/Amazon-Elastic-Block-Store-EBS.svg`
- **EFS**: `aws/Storage/Amazon-Elastic-File-System-EFS.svg`
- **Glacier**: `aws/Storage/Amazon-S3-Glacier.svg`

### Database
- **RDS**: `aws/Database/Amazon-RDS.svg`
- **DynamoDB**: `aws/Database/Amazon-DynamoDB.svg`
- **Aurora**: `aws/Database/Amazon-Aurora.svg`
- **ElastiCache**: `aws/Database/Amazon-ElastiCache.svg`
- **Neptune**: `aws/Database/Amazon-Neptune.svg`
- **DocumentDB**: `aws/Database/Amazon-DocumentDB-with-MongoDB-compatibility.svg`

### Networking
- **VPC**: `aws/Networking%20&%20Content%20Delivery/Amazon-VPC.svg`
- **CloudFront**: `aws/Networking%20&%20Content%20Delivery/Amazon-CloudFront.svg`
- **Route 53**: `aws/Networking%20&%20Content%20Delivery/Amazon-Route-53.svg`
- **API Gateway**: `aws/Networking%20&%20Content%20Delivery/Amazon-API-Gateway.svg`
- **Load Balancer**: `aws/Networking%20&%20Content%20Delivery/Elastic-Load-Balancing.svg`
- **Direct Connect**: `aws/Networking%20&%20Content%20Delivery/AWS-Direct-Connect.svg`

### Security
- **IAM**: `aws/Security%20Identity%20&%20Compliance/AWS-Identity-and-Access-Management-IAM.svg`
- **KMS**: `aws/Security%20Identity%20&%20Compliance/AWS-Key-Management-Service.svg`
- **Secrets Manager**: `aws/Security%20Identity%20&%20Compliance/AWS-Secrets-Manager.svg`
- **Shield**: `aws/Security%20Identity%20&%20Compliance/AWS-Shield.svg`
- **WAF**: `aws/Security%20Identity%20&%20Compliance/AWS-WAF.svg`
- **GuardDuty**: `aws/Security%20Identity%20&%20Compliance/Amazon-GuardDuty.svg`

### Analytics
- **Athena**: `aws/Analytics/Amazon-Athena.svg`
- **EMR**: `aws/Analytics/Amazon-EMR.svg`
- **Kinesis**: `aws/Analytics/Amazon-Kinesis.svg`
- **Redshift**: `aws/Analytics/Amazon-Redshift.svg`
- **QuickSight**: `aws/Analytics/Amazon-Quicksight.svg`
- **Glue**: `aws/Analytics/AWS-Glue.svg`

### Machine Learning
- **SageMaker**: `aws/Machine%20Learning/Amazon-SageMaker.svg`
- **Rekognition**: `aws/Machine%20Learning/Amazon-Rekognition.svg`
- **Comprehend**: `aws/Machine%20Learning/Amazon-Comprehend.svg`
- **Lex**: `aws/Machine%20Learning/Amazon-Lex.svg`

### Developer Tools
- **CodeCommit**: `aws/Developer%20Tools/AWS-CodeCommit.svg`
- **CodeBuild**: `aws/Developer%20Tools/AWS-CodeBuild.svg`
- **CodeDeploy**: `aws/Developer%20Tools/AWS-CodeDeploy.svg`
- **CodePipeline**: `aws/Developer%20Tools/AWS-CodePipeline.svg`

### Management
- **CloudWatch**: `aws/Management%20&%20Governance/Amazon-CloudWatch.svg`
- **CloudFormation**: `aws/Management%20&%20Governance/AWS-CloudFormation.svg`
- **Systems Manager**: `aws/Management%20&%20Governance/AWS-Systems-Manager.svg`
- **Config**: `aws/Management%20&%20Governance/AWS-Config.svg`

## GCP Services

### Compute
- **Compute Engine**: `gcp/Compute/Compute-Engine.svg`
- **App Engine**: `gcp/Compute/App-Engine.svg`
- **Kubernetes Engine**: `gcp/Compute/Kubernetes-Engine.svg`
- **Cloud Functions**: `gcp/Compute/Cloud-Functions.svg`

### Storage & Database
- **Cloud Storage**: `gcp/Storage/Cloud-Storage.svg`
- **Cloud SQL**: `gcp/Database/Cloud-SQL.svg`
- **Bigtable**: `gcp/Database/Cloud-Bigtable.svg`
- **Firestore**: `gcp/Database/Cloud-Firestore.svg`

## Azure Services

### Compute
- **Virtual Machines**: `azure/Compute/Azure-Virtual-Machine.svg`
- **App Service**: `azure/Compute/Azure-App-Service.svg`
- **Container Instances**: `azure/Compute/Azure-Container-Instances.svg`
- **Kubernetes Service**: `azure/Compute/Azure-Kubernetes-Service.svg`

### Storage & Database
- **Blob Storage**: `azure/Storage/Azure-Blob-Storage.svg`
- **SQL Database**: `azure/Database/Azure-SQL-Database.svg`
- **Cosmos DB**: `azure/Database/Azure-Cosmos-DB.svg`

## Technology & Tools

### Programming Languages
- **Python**: `tech/python.svg`
- **JavaScript**: `tech/javascript.svg`
- **Java**: `tech/java.svg`
- **Go**: `tech/go.svg`
- **Ruby**: `tech/ruby.svg`
- **PHP**: `tech/php.svg`
- **C#**: `tech/csharp.svg`

### Frameworks & Libraries
- **React**: `tech/react.svg`
- **Vue**: `tech/vue.svg`
- **Angular**: `tech/angular.svg`
- **Node.js**: `tech/nodejs.svg`
- **Django**: `tech/django.svg`
- **Flask**: `tech/flask.svg`
- **Spring**: `tech/spring.svg`

### Databases
- **PostgreSQL**: `tech/postgresql.svg`
- **MySQL**: `tech/mysql.svg`
- **MongoDB**: `tech/mongodb.svg`
- **Redis**: `tech/redis.svg`
- **Cassandra**: `tech/cassandra.svg`
- **Elasticsearch**: `tech/elasticsearch.svg`

### DevOps & Tools
- **Docker**: `tech/docker.svg`
- **Kubernetes**: `tech/kubernetes.svg`
- **Jenkins**: `tech/jenkins.svg`
- **Git**: `tech/git.svg`
- **GitHub**: `tech/github.svg`
- **GitLab**: `tech/gitlab.svg`
- **Terraform**: `tech/terraform.svg`
- **Ansible**: `tech/ansible.svg`
- **Prometheus**: `tech/prometheus.svg`
- **Grafana**: `tech/grafana.svg`

### Message Queues & Streaming
- **Kafka**: `tech/kafka.svg`
- **RabbitMQ**: `tech/rabbitmq.svg`

### Monitoring & Logging
- **Datadog**: `tech/datadog.svg`
- **New Relic**: `tech/newrelic.svg`
- **Splunk**: `tech/splunk.svg`

## Infrastructure & Networking

### General Infrastructure
- **Server**: `infra/server.svg`
- **Network**: `infra/019-network.svg`
- **Database**: `infra/database.svg`
- **Router**: `infra/router.svg`
- **Firewall**: `infra/firewall.svg`
- **Load Balancer**: `infra/load-balancer.svg`

### Devices
- **Desktop**: `essentials/desktop.svg`
- **Mobile**: `essentials/mobile.svg`
- **Tablet**: `essentials/tablet.svg`
- **Laptop**: `essentials/laptop.svg`

## Essential Icons

### Users & People
- **User**: `essentials/365-user.svg`
- **Users**: `essentials/users.svg`
- **Admin**: `essentials/admin.svg`
- **Team**: `essentials/team.svg`

### Communication
- **Email**: `essentials/email.svg`
- **Message**: `essentials/message.svg`
- **Chat**: `essentials/chat.svg`
- **Phone**: `essentials/phone.svg`

### General
- **Settings**: `essentials/settings.svg`
- **Search**: `essentials/search.svg`
- **Lock**: `essentials/lock.svg`
- **Key**: `essentials/key.svg`
- **Clock**: `essentials/clock.svg`
- **Calendar**: `essentials/calendar.svg`
- **Globe/Worldwide**: `essentials/214-worldwide.svg`
- **Home**: `essentials/home.svg`
- **Dashboard**: `essentials/dashboard.svg`

### Status & Actions
- **Success/Check**: `essentials/check.svg`
- **Warning**: `essentials/warning.svg`
- **Error**: `essentials/error.svg`
- **Info**: `essentials/info.svg`

## Usage Examples

### Basic Icon Usage

```d2
user: End User {
  icon: https://icons.terrastruct.com/essentials/365-user.svg
  shape: person
}

database: PostgreSQL {
  icon: https://icons.terrastruct.com/tech/postgresql.svg
  shape: cylinder
}

server: Web Server {
  icon: https://icons.terrastruct.com/tech/nginx.svg
  shape: rectangle
}
```

### Icon Without Border

```d2
docker: {
  icon: https://icons.terrastruct.com/tech/docker.svg
  shape: image  # This removes the border
}
```

### Combining Icons with Containers

```d2
aws_infra: AWS Infrastructure {
  lambda: Lambda Functions {
    icon: https://icons.terrastruct.com/aws/Compute/AWS-Lambda.svg
  }
  
  dynamodb: DynamoDB {
    icon: https://icons.terrastruct.com/aws/Database/Amazon-DynamoDB.svg
    shape: cylinder
  }
  
  api_gateway: API Gateway {
    icon: https://icons.terrastruct.com/aws/Networking%20&%20Content%20Delivery/Amazon-API-Gateway.svg
  }
}
```

## Finding More Icons

The Terrastruct icon library is hosted at: https://icons.terrastruct.com/

Browse categories:
- `/aws/` - Amazon Web Services icons
- `/azure/` - Microsoft Azure icons
- `/gcp/` - Google Cloud Platform icons
- `/tech/` - Technology and tool icons
- `/infra/` - Infrastructure icons
- `/essentials/` - Essential UI icons

## Icon Best Practices

1. **Use consistently**: Apply similar icons to similar types of components
2. **Don't overuse**: Too many icons can clutter the diagram
3. **Match to function**: Choose icons that clearly represent the element's purpose
4. **Test visibility**: Ensure icons are clear at the diagram's typical viewing size
5. **Fallback to shapes**: If no suitable icon exists, use an appropriate shape instead
6. **Verify URLs**: Always test icon URLs work before including in production diagrams
7. **Consider alternatives**: If an icon isn't in this list, use a standard shape with clear labeling

## Custom Icons

If you need icons not in the Terrastruct library:
- Ensure the icon is accessible via a public HTTPS URL
- SVG format is preferred for clarity at any size
- PNG is acceptable but may not scale as well
- Test the URL in a browser before using in D2
