# Clean Slate Implementation Timeline

Tracking automatic expungement laws by state with implementation dates.

## Active Clean Slate Laws (as of 2026)

### 2018
**Pennsylvania** - First in the nation
- Signed: June 28, 2018
- Effective: June 28, 2019
- Coverage:
  - Non-conviction records (arrests)
  - Summary offenses after 10 years arrest-free
  - Misdemeanor convictions (2nd, 3rd degree) after 10 years
- Exclusions: Felonies, violent crimes, sex offenses
- Source: 18 Pa.C.S. § 9122.2

### 2019
**Utah**
- Signed: March 29, 2019
- Effective: May 1, 2020
- Coverage:
  - Acquittals and dismissals (automatic)
  - Arrests without charges
- Note: Does NOT cover convictions automatically (petition required)
- Source: Utah Code 77-40a

**New Jersey**
- Signed: December 18, 2019
- Effective: June 15, 2020
- Coverage:
  - Most criminal convictions after 10 years
  - Disorderly persons offenses
  - Municipal ordinance violations
- Exclusions: Murder, sex crimes, robbery, other violent offenses
- Source: N.J.S.A. 2C:52-5.1 ("Clean Slate Law")

### 2020
**Michigan**
- Signed: October 12, 2020
- Effective: April 11, 2021
- Coverage:
  - Arrests after 7 years
  - Misdemeanor convictions after 7 years
  - Up to 2 felony convictions after 10 years
- Exclusions: Assaultive crimes, crimes > 10 years max, traffic offenses
- Source: MCL 780.621g

**California**
- Signed: October 8, 2020 (AB 1076)
- Effective: January 1, 2021
- Coverage:
  - Arrests not leading to conviction (after 3 years)
  - Completion of sentence/probation (automatic relief)
- Exclusions: Registration offenses, cases with victims opposed
- Source: PC 1203.425

### 2021
**Connecticut**
- Signed: June 22, 2021 (PA 21-32)
- Effective: January 1, 2023
- Coverage:
  - Most misdemeanors after 7 years
  - Class D and E felonies after 10 years
- Exclusions: Class A-C felonies, sex offenses, family violence
- Note: One of the most comprehensive laws
- Source: Conn. Gen. Stat. § 54-142e

**Delaware**
- Signed: July 29, 2021
- Effective: July 29, 2021
- Coverage:
  - Misdemeanor convictions after 7 years
  - Some felonies after 10 years
- Exclusions: Violent felonies, sex offenses
- Source: 11 Del. C. § 4373

**Virginia**
- Signed: March 31, 2021 (SB 5034)
- Effective: July 1, 2021
- Coverage:
  - Limited automatic sealing
  - Certain misdemeanors after waiting period
- Exclusions: DUI, domestic violence, many felonies
- Note: Implementation phased, ongoing
- Source: Va. Code 19.2-392.12

### 2022
**Oklahoma**
- Signed: May 25, 2022
- Effective: November 1, 2022
- Coverage:
  - Nonviolent misdemeanors after 5 years
  - Nonviolent felonies after 5-15 years (depending on level)
- Exclusions: Violent crimes, sex offenses
- Source: 22 O.S. § 19c

**Colorado**
- Signed: May 31, 2022
- Effective: January 1, 2024
- Coverage:
  - Certain misdemeanors automatic sealing
  - Drug offenses expanded eligibility
- Exclusions: Violent crimes, sex offenses
- Source: CRS 24-72-710.5

### 2023
**New York**
- Signed: November 16, 2023
- Effective dates:
  - Misdemeanors: November 16, 2024
  - Felonies (Class D/E): November 16, 2027
- Coverage:
  - Most misdemeanors after 3 years
  - Class D and E felonies after 8 years
- Exclusions: Sex offenses, Class A-C felonies, violent felonies
- Note: Largest impact due to population
- Source: CPL 160.57

**Minnesota**
- Signed: May 19, 2023
- Effective: January 1, 2025
- Coverage:
  - Petty misdemeanors, misdemeanors after 2 years
  - Gross misdemeanors after 4 years
  - Some felonies after 5-7 years
- Exclusions: Murder, criminal sexual conduct, DUI
- Source: Minn. Stat. 609A.015

### 2024
**Maryland**
- Signed: May 16, 2024
- Effective: October 1, 2024
- Coverage:
  - Expanded automatic sealing
  - Certain misdemeanors and felonies
- Details: Implementation regulations pending
- Source: Md. Code, Crim. Proc. § 10-301

**Illinois**
- Signed: August 9, 2024
- Effective: January 1, 2025
- Coverage:
  - Extensive automatic sealing
  - Most misdemeanors
  - Many Class 3 and 4 felonies
- Exclusions: Sex offenses, violent crimes, DUI
- Source: 20 ILCS 2630/5.2

### 2025
**Oregon**
- Signed: July 1, 2025
- Effective: January 1, 2026
- Coverage:
  - Arrests and dismissals (automatic after 3 years)
  - Many misdemeanors (automatic after 3 years)
  - Some felonies (automatic after 7-10 years)
- Exclusions: Person felonies, Class A felonies, sex offenses
- Source: ORS 137.225(12)

---

## Pending/Proposed Clean Slate Legislation

### Under Consideration (2026)
- **Massachusetts**: Multiple bills introduced
- **Washington**: SB 5180 (2023) discussion ongoing
- **Nevada**: AB 192 (2023) partial implementation
- **Texas**: Limited bills (nondisclosure expansion)
- **Florida**: Advocacy campaigns active

### Failed/Stalled
- **Ohio**: Multiple bills failed to advance
- **Arizona**: SB 1294 (2020) did not pass
- **Wisconsin**: No automatic mechanism possible under current law

---

## Implementation Patterns

### What "Automatic" Actually Means

**Truly Automatic**:
- State agency reviews records systematically
- No petition or action required from individual
- Records updated on set schedule
- Examples: PA, NJ, CT, MI

**Semi-Automatic**:
- Triggered by completion of sentence/probation
- May require verification by probation officer
- Individual may need to confirm eligibility
- Examples: CA, OK

**Automatic Notification**:
- Individual notified of eligibility
- Still must petition or confirm
- Simplified petition process
- Examples: Some VA provisions

### Timeline from Law to Implementation

Typical pattern:
1. **Law signed** (Day 0)
2. **Regulations drafted** (3-6 months)
3. **IT systems built** (6-18 months)
4. **Testing period** (3-6 months)
5. **Gradual rollout** (6-12 months)
6. **Full implementation** (18-36 months total)

**Fastest**: Utah (12 months from signing)
**Slowest**: Virginia (36+ months, ongoing)

### Common Exclusions Across States

Nearly universal exclusions:
- Sex offenses requiring registration
- Murder/manslaughter
- Domestic violence (varies)
- Offenses against children

Common exclusions:
- DUI (some states)
- Violent felonies generally
- Crimes with mandatory minimums
- Offenses with sentences > 10 years

Less common exclusions:
- Drug trafficking (many states include)
- Property crimes (usually included)
- First-degree felonies only (some states)

---

## Verification URLs

For researching current law status:

| State | Primary Source |
|-------|---------------|
| PA | https://www.legis.state.pa.us/cfdocs/legis/LI/consCheck.cfm?txtType=HTM&ttl=18&div=0&chpt=91 |
| NJ | https://www.njleg.state.nj.us/ |
| MI | http://www.legislature.mi.gov/ |
| CA | https://leginfo.legislature.ca.gov/ |
| CT | https://www.cga.ct.gov/ |
| DE | https://delcode.delaware.gov/ |
| VA | https://law.lis.virginia.gov/ |
| OK | https://www.oscn.net/ |
| CO | https://leg.colorado.gov/ |
| NY | https://www.nysenate.gov/legislation |
| MN | https://www.revisor.mn.gov/ |
| MD | https://mgaleg.maryland.gov/ |
| IL | https://www.ilga.gov/ |
| OR | https://www.oregonlegislature.gov/ |
| UT | https://le.utah.gov/ |

---

## Research Notes

### Key Advocacy Organizations
- **Clean Slate Initiative**: https://www.cleanslateinitiative.org/
- **Collateral Consequences Resource Center**: https://ccresourcecenter.org/
- **ACLU Criminal Law Reform**: state-specific pages
- **Legal Aid organizations**: state-by-state

### Academic Sources
- Brennan Center for Justice (wage penalty studies)
- Vera Institute of Justice (racial disparity data)
- RAND Corporation (recidivism studies)

### Media Coverage for Law Changes
- Search "[State] Clean Slate" + year for implementation updates
- State bar association news for attorney guidance
- Court administrative orders for implementation rules
