# URL Patterns by State

Quick reference for authoritative legal sources by state.

## Pattern Legend

- **Legislature**: Official statute text
- **Court Admin**: Court system self-help and forms
- **Public.law**: Third-party but authoritative statute hosting
- **Forms**: Direct links to expungement forms

---

## Pacific States

### Oregon (OR)
```
Legislature: https://oregon.public.law/statutes/ors_137.225
Court Admin: https://www.courts.oregon.gov/programs/exp/Pages/default.aspx
Forms: https://www.courts.oregon.gov/forms/Pages/default.aspx
Key statute: ORS 137.225 (Set aside)
```

### California (CA)
```
Legislature: https://california.public.law/codes/ca_penal_code_section_1203.4
Court Admin: https://www.courts.ca.gov/selfhelp-expungement.htm
Forms: https://www.courts.ca.gov/forms.htm
Key statutes: PC 1203.4 (Dismissal), PC 1203.4a (Arrests)
```

### Washington (WA)
```
Legislature: https://apps.leg.wa.gov/RCW/default.aspx?cite=9.96.060
Court Admin: https://www.courts.wa.gov/forms/
Forms: https://www.courts.wa.gov/forms/?fa=forms.contribute&formID=101
Key statute: RCW 9.96.060 (Vacating convictions)
```

### Alaska (AK)
```
Legislature: http://www.legis.state.ak.us/basis/statutes.asp#12.62.180
Court Admin: https://courts.alaska.gov/shc/records/
Key statute: AS 12.62.180
```

### Hawaii (HI)
```
Legislature: https://www.capitol.hawaii.gov/hrscurrent/Vol14_Ch0701-0853/HRS0831/
Court Admin: https://www.courts.state.hi.us/self-help
Key statute: HRS 831-3.2
```

---

## Mountain States

### Colorado (CO)
```
Legislature: https://leg.colorado.gov/sites/default/files/2023a_1167_signed.pdf
Court Admin: https://www.courts.state.co.us/Forms/Index.cfm
Key statute: CRS 24-72-702 (Sealing)
```

### Nevada (NV)
```
Legislature: https://www.leg.state.nv.us/NRS/NRS-179.html
Court Admin: https://nvcourts.gov/self-help
Key statute: NRS 179.245-179.301
```

### Utah (UT)
```
Legislature: https://le.utah.gov/xcode/Title77/Chapter40/77-40.html
Court Admin: https://www.utcourts.gov/howto/expunge/
Key statute: Utah Code 77-40-102
Clean Slate: Utah Code 77-40a (automatic)
```

### Arizona (AZ)
```
Legislature: https://www.azleg.gov/ars/13/00905.htm
Court Admin: https://www.azcourts.gov/selfservicecenter/
Key statute: ARS 13-905 (Set aside)
Note: Voter rights restoration: ARS 13-908
```

### New Mexico (NM)
```
Legislature: https://nmonesource.com/nmos/nmsa/en/item/4371/index.do
Court Admin: https://www.nmcourts.gov/self-help/
Key statute: NMSA 1978 § 29-3A
```

### Idaho (ID)
```
Legislature: https://legislature.idaho.gov/statutesrules/idstat/Title67/T67CH30/
Court Admin: https://isc.idaho.gov/forms
Key statute: Idaho Code 67-3004 (expungement), IC 19-2604 (withheld judgment)
```

### Montana (MT)
```
Legislature: https://leg.mt.gov/bills/mca/title_0460/chapter_0180/part_0020/sections_index.html
Court Admin: https://courts.mt.gov/forms
Key statute: MCA 46-18-1101 (Deferred sentences)
```

### Wyoming (WY)
```
Legislature: https://wyoleg.gov/statutes/compress/title07.pdf
Court Admin: https://www.courts.state.wy.us/
Key statute: Wyo. Stat. Ann. § 7-13-1501
Note: Limited expungement - primarily DNA records
```

---

## Southwest States

### Texas (TX)
```
Legislature: https://texas.public.law/statutes/tex._code_of_crim._proc._art._55.01
Court Admin: https://www.txcourts.gov/rules-forms/
Key statutes:
  - Art. 55.01 (Expunction) - arrests/dismissals only
  - Gov't Code 411.081 (Nondisclosure) - some convictions
```

### Oklahoma (OK)
```
Legislature: https://www.oscn.net/applications/oscn/DeliverDocument.asp?CiteID=69619
Court Admin: https://www.oscn.net/
Key statute: 22 O.S. § 18 (Expungement)
Clean Slate: 22 O.S. § 19c (automatic)
```

---

## Midwest States

### Illinois (IL)
```
Legislature: https://www.ilga.gov/legislation/ilcs/ilcs3.asp?ActID=1876
Court Admin: https://www.illinoiscourts.gov/forms/expungement-forms
Key statutes:
  - 20 ILCS 2630/5.2 (Expungement)
  - 730 ILCS 5/5-5-5 (Sealing)
Clean Slate: SB 2122 (2024)
```

### Michigan (MI)
```
Legislature: http://www.legislature.mi.gov/documents/mcl/pdf/mcl-780-621.pdf
Court Admin: https://www.courts.michigan.gov/administration/admin-services/forms/set-aside/
Key statute: MCL 780.621
Clean Slate: MCL 780.621g (automatic)
```

### Ohio (OH)
```
Legislature: https://codes.ohio.gov/ohio-revised-code/section-2953.32
Court Admin: https://www.supremecourt.ohio.gov/
Key statute: ORC 2953.32
```

### Indiana (IN)
```
Legislature: https://iga.in.gov/legislative/laws/2021/ic/titles/035#35-38-9
Court Admin: https://www.in.gov/courts/forms/
Key statute: IC 35-38-9
```

### Minnesota (MN)
```
Legislature: https://www.revisor.mn.gov/statutes/cite/609A
Court Admin: https://www.mncourts.gov/Help-Topics/Expungement.aspx
Key statute: Minn. Stat. Ch. 609A
Clean Slate: Minn. Stat. 609A.015 (2023)
```

### Wisconsin (WI)
```
Legislature: https://docs.legis.wisconsin.gov/statutes/statutes/973/015
Court Admin: https://www.wicourts.gov/services/public/selfhelp/expungement.htm
Key statute: Wis. Stat. 973.015
Note: Limited - only granted at sentencing
```

### Iowa (IA)
```
Legislature: https://www.legis.iowa.gov/docs/code/901C.pdf
Court Admin: https://www.iowacourts.gov/for-the-public/representing-yourself/
Key statute: Iowa Code 901C
```

### Missouri (MO)
```
Legislature: https://revisor.mo.gov/main/OneSection.aspx?section=610.140
Court Admin: https://www.courts.mo.gov/page.jsp?id=35299
Key statute: RSMo 610.140
```

### Kansas (KS)
```
Legislature: http://www.kslegislature.org/li/b2021_22/statute/021_000_0000_chapter/021_061_0000_article/
Court Admin: https://www.kscourts.org/KSCourts/media/KsCourts/court%20forms/General/298.pdf
Key statute: K.S.A. 21-6614
```

### Nebraska (NE)
```
Legislature: https://nebraskalegislature.gov/laws/statutes.php?statute=29-3523
Court Admin: https://supremecourt.nebraska.gov/self-help
Key statute: Neb. Rev. Stat. 29-3523
```

### North Dakota (ND)
```
Legislature: https://www.legis.nd.gov/cencode/t12-1c10.pdf
Court Admin: https://www.ndcourts.gov/
Key statute: N.D.C.C. 12-60.1-01
```

### South Dakota (SD)
```
Legislature: https://sdlegislature.gov/Statutes/Codified_Laws/2068901
Court Admin: https://ujs.sd.gov/
Key statute: SDCL 23A-3
```

---

## Southeast States

### Florida (FL)
```
Legislature: http://www.leg.state.fl.us/statutes/index.cfm?App_mode=Display_Statute&URL=0900-0999/0943/0943.html
Court Admin: https://www.flcourts.gov/Resources-Services/Court-Improvement/Family-Courts/Expungement
Key statute: F.S. 943.0585 (Expungement), F.S. 943.059 (Sealing)
```

### Georgia (GA)
```
Legislature: https://law.justia.com/codes/georgia/2020/title-35/chapter-3/article-7/
Court Admin: https://www.georgiacourts.gov/
Key statute: O.C.G.A. 35-3-37 (Restriction)
```

### North Carolina (NC)
```
Legislature: https://www.ncleg.gov/EnactedLegislation/Statutes/PDF/BySection/Chapter_15A/GS_15A-145.5.pdf
Court Admin: https://www.nccourts.gov/help-topics/criminal-record-expungement
Key statute: N.C.G.S. 15A-145.5
```

### Tennessee (TN)
```
Legislature: https://www.tn.gov/tbi/divisions/cjis-division/tennessee-expungement-information.html
Court Admin: https://www.tncourts.gov/
Key statute: T.C.A. 40-32-101
Note: No true expungement - diversion only
```

### Virginia (VA)
```
Legislature: https://law.lis.virginia.gov/vacode/title19.2/chapter9.1/
Court Admin: https://www.vacourts.gov/
Key statute: Va. Code 19.2-392.2
Clean Slate: SB 5034 (2021)
```

### Kentucky (KY)
```
Legislature: https://apps.legislature.ky.gov/law/statutes/chapter.aspx?id=37305
Court Admin: https://courts.ky.gov/courts/circuit/Pages/expungement.aspx
Key statute: KRS 431.073
```

### Alabama (AL)
```
Legislature: https://codes.findlaw.com/al/title-15-criminal-procedure/al-code-sect-15-27-1.html
Court Admin: https://judicial.alabama.gov/
Key statute: Ala. Code § 15-27-1
Note: Very limited eligibility
```

### Mississippi (MS)
```
Legislature: https://law.justia.com/codes/mississippi/2020/title-99/chapter-19/
Court Admin: https://courts.ms.gov/
Key statute: Miss. Code Ann. § 99-19-71
```

### Louisiana (LA)
```
Legislature: https://www.legis.la.gov/Legis/Law.aspx?d=78537
Court Admin: https://www.lasc.org/
Key statute: La. C.Cr.P. art. 971-995
```

### Arkansas (AR)
```
Legislature: https://codes.findlaw.com/ar/title-16-practice-procedure-and-courts/ar-code-sect-16-90-1401.html
Court Admin: https://www.arcourts.gov/
Key statute: Ark. Code Ann. § 16-90-1401
```

### South Carolina (SC)
```
Legislature: https://www.scstatehouse.gov/code/t17c022.php
Court Admin: https://www.sccourts.org/selfHelp/
Key statute: S.C. Code Ann. § 17-22-910
Note: Very limited - first offense only
```

### West Virginia (WV)
```
Legislature: http://www.wvlegislature.gov/wvcode/ChapterEntire.cfm?chap=61&art=11
Court Admin: https://www.courtswv.gov/
Key statute: W. Va. Code § 61-11-25
```

---

## Northeast States

### New York (NY)
```
Legislature: https://www.nysenate.gov/legislation/laws/CPL/160.50
Court Admin: https://www.nycourts.gov/courthelp/Criminal/sealingConvictions.shtml
Key statutes:
  - CPL 160.50 (Sealing after dismissal)
  - CPL 160.59 (Sealing after conviction)
Clean Slate: CPL 160.57 (2023)
```

### Pennsylvania (PA)
```
Legislature: https://www.legis.state.pa.us/cfdocs/legis/LI/consCheck.cfm?txtType=HTM&ttl=18&div=0&chpt=91
Court Admin: https://www.pacourts.us/learn/expungement
Key statute: 18 Pa.C.S. § 9122
Clean Slate: 18 Pa.C.S. § 9122.2
```

### New Jersey (NJ)
```
Legislature: https://lis.njleg.state.nj.us/nxt/gateway.dll?f=templates&fn=default.htm&vid=Publish:10.1048/Enu
Court Admin: https://www.njcourts.gov/selfhelp/expungement.html
Key statute: N.J.S.A. 2C:52-1
Clean Slate: N.J.S.A. 2C:52-5.1
```

### Massachusetts (MA)
```
Legislature: https://malegislature.gov/Laws/GeneralLaws/PartIV/TitleII/Chapter276/Section100A
Court Admin: https://www.mass.gov/sealing-criminal-records
Key statute: M.G.L. c. 276, § 100A
```

### Connecticut (CT)
```
Legislature: https://www.cga.ct.gov/current/pub/chap_961.htm#sec_54-142a
Court Admin: https://jud.ct.gov/crimrecords/
Key statute: Conn. Gen. Stat. § 54-142a
Clean Slate: PA 21-32
```

### Maryland (MD)
```
Legislature: https://mgaleg.maryland.gov/mgawebsite/Laws/StatuteText?article=gcp&section=10-105
Court Admin: https://mdcourts.gov/legalhelp/expungement
Key statute: Md. Code, Crim. Proc. § 10-105
```

### Delaware (DE)
```
Legislature: https://delcode.delaware.gov/title11/c004/sc07/index.html
Court Admin: https://courts.delaware.gov/help/expungement.aspx
Key statute: 11 Del. C. § 4372
Clean Slate: 11 Del. C. § 4373
```

### Rhode Island (RI)
```
Legislature: http://webserver.rilin.state.ri.us/Statutes/TITLE12/12-1.3/INDEX.HTM
Court Admin: https://www.courts.ri.gov/Courts/districtcourt/PDF/Expungement_Instructions.pdf
Key statute: R.I. Gen. Laws § 12-1.3-1
```

### Vermont (VT)
```
Legislature: https://legislature.vermont.gov/statutes/section/13/230/07601
Court Admin: https://www.vermontjudiciary.org/
Key statute: 13 V.S.A. § 7601
```

### New Hampshire (NH)
```
Legislature: http://www.gencourt.state.nh.us/rsa/html/LIX/651/651-5.htm
Court Admin: https://www.courts.nh.gov/
Key statute: RSA 651:5
```

### Maine (ME)
```
Legislature: https://legislature.maine.gov/statutes/15/title15sec2003.html
Court Admin: https://www.courts.maine.gov/fees-forms/forms/
Key statute: 15 M.R.S. § 2003
```

---

## District of Columbia

### DC
```
Legislature: https://code.dccouncil.gov/us/dc/council/code/titles/16/chapters/8/
Court Admin: https://www.dccourts.gov/services/criminal-matters/motion-to-seal
Key statute: D.C. Code § 16-803
```

---

## Cross-Reference Resources

### National Compilations
```
CCRC Restoration Project: https://ccresourcecenter.org/state-restoration-profiles/
NACDL Second Chance: https://www.nacdl.org/Landing/SecondChances
Collateral Consequences Resource Center: https://ccresourcecenter.org/
Legal Services Corporation: https://www.lsc.gov/what-legal-aid/find-legal-aid
```

### State-Specific Legal Aid
```
LawHelp.org: https://www.lawhelp.org/find-help/
Legal Aid Finder: https://www.lsc.gov/what-legal-aid/find-legal-aid
```
