---
name: adhd-daily-planner
description: Time-blind friendly planning, executive function support, and daily structure for ADHD brains. Specializes in realistic time estimation, dopamine-aware task design, and building systems that actually work for neurodivergent minds.
allowed-tools: Read, Edit, Write, Bash, Glob, Grep, WebFetch, WebSearch, Task
category: Lifestyle & Personal
tags:
  - adhd
  - productivity
  - planning
  - neurodivergent
  - executive-function
pairs-with:
  - skill: project-management-guru-adhd
    reason: Long-term project planning with ADHD context
  - skill: wisdom-accountability-coach
    reason: Accountability and habit tracking
---

# ADHD Daily Planner

A planning system designed BY and FOR ADHD brains. This skill understands that traditional productivity advice fails for neurodivergent minds and provides strategies that work WITH your brain, not against it.

## Core Philosophy

ADHD is not a character flaw or lack of willpower. It's a difference in how the brain handles dopamine, time perception, and attention regulation. This skill:
- Never uses shame or "just try harder" rhetoric
- Builds systems around ADHD realities, not neurotypical ideals
- Acknowledges that what works today might not work tomorrow
- Celebrates done > perfect
- Treats executive function as a battery that depletes

## The ADHD Planning Paradox

```
Traditional Planning:
1. Make detailed plan
2. Follow plan
3. Achieve goal

ADHD Reality:
1. Make detailed plan (hyperfocus, feels great)
2. Plan feels constraining by day 2
3. Rebel against own plan
4. Feel guilty about abandoned plan
5. Avoid thinking about goal entirely
```

This skill breaks the paradox by creating FLEXIBLE structures with BUILT-IN pivots.

## Decision Tree

```
What time horizon are we planning?
├── RIGHT NOW (next 2 hours) → Emergency brain dump + single next action
├── TODAY → Time-blocked structure with transition buffers
├── THIS WEEK → Theme days + priority winnowing
├── THIS MONTH → Goal setting with anti-overwhelm safeguards
└── LONGER → Break into month-sized chunks, don't over-plan

Is the person in crisis mode?
├── YES → Skip planning, identify ONE smallest possible action
└── NO → Proceed with appropriate planning level

Is the person hyperfocusing on planning itself?
├── YES → Interrupt! Planning ≠ doing. Set timer, start ONE task.
└── NO → Continue planning support
```

## Time Blindness Strategies

### The ADHD Time Estimation Formula

```
Take your first estimate. Now:

"5 minutes" → Actually 15-20 minutes
"30 minutes" → Actually 1-1.5 hours
"A couple hours" → Actually half a day
"This weekend" → Actually won't happen without body doubling
```

**The 3x Rule**: Whatever you think it will take, multiply by 3. You're not bad at estimating—your brain processes time differently.

### Making Time Visible

- **Analog clocks** in every room (digital jumps; analog shows time PASSING)
- **Time Timer** or similar visual countdown timers
- **Calendar blocking** - if it's not on the calendar with a time, it doesn't exist
- **"When, then" statements** - "When I finish my coffee, then I start the report"

### Transition Time

ADHD brains struggle with task transitions. BUILD IN BUFFERS:

```
Neurotypical Schedule:
9:00 - Meeting
10:00 - Deep work
12:00 - Lunch

ADHD-Friendly Schedule:
9:00 - Meeting
10:00 - [Transition buffer: bathroom, water, stare at wall]
10:15 - Deep work
11:45 - [Transition buffer: save work, prepare for context switch]
12:00 - Lunch
```

## Daily Planning Template

### Morning Brain Dump (5 min max - set timer!)

```
EVERYTHING IN MY HEAD RIGHT NOW:
_________________________________
_________________________________
_________________________________
_________________________________

NOW CIRCLE ONLY 1-3 THINGS THAT ACTUALLY MATTER TODAY.
```

### The "3 Things" System

Your daily plan is exactly 3 things:
1. **THE Thing** - If you do nothing else, do this
2. **Would Be Nice** - Important but not critical today
3. **If I'm On Fire** - Only if crushing it

That's it. Not 10 things. Not 5 things. THREE.

### Time Blocking for ADHD

```
┌─────────────────────────────────────────────────────────────┐
│ MORNING (Peak brain time for many - protect it!)           │
├─────────────────────────────────────────────────────────────┤
│ 9:00  - THE Thing (hardest/most important)                 │
│         [Use body doubling, website blockers, timer]       │
│ 10:30 - TRANSITION BUFFER (10-15 min)                      │
│ 10:45 - Would Be Nice OR meetings                          │
├─────────────────────────────────────────────────────────────┤
│ MIDDAY (Energy dip - don't fight it)                       │
├─────────────────────────────────────────────────────────────┤
│ 12:00 - Lunch (actual break, not working lunch)            │
│ 12:45 - Low-effort tasks: email, admin, organizing         │
├─────────────────────────────────────────────────────────────┤
│ AFTERNOON (Second wind for some)                           │
├─────────────────────────────────────────────────────────────┤
│ 2:00  - Collaborative work, meetings, variety tasks        │
│ 4:00  - Wrap up, tomorrow prep (5 min), shutdown ritual    │
└─────────────────────────────────────────────────────────────┘
```

## Executive Function Support

### Task Initiation (The Hardest Part)

**The 2-Minute Start**: Don't commit to finishing. Commit to 2 minutes.
- "I'll just open the document"
- "I'll just write the first sentence"
- "I'll just look at the thing"

**Body Doubling**: Work alongside someone (physically or virtually). The Focusmate app, Discord study groups, or just a friend on video call.

**Temptation Bundling**: Pair unpleasant tasks with pleasant ones.
- Boring data entry + favorite podcast
- Exercise + audiobook
- Cleaning + dance music

### Working Memory Support

ADHD working memory is limited. EXTERNALIZE EVERYTHING:

- **Capture tools everywhere** - Notes app, physical notepad, voice memos
- **Written instructions** even for simple things
- **Checklists** for repeated tasks (even ones you've done 100 times)
- **Visual reminders** in the physical space where you'll need them

### Decision Fatigue

ADHD brains make thousands of micro-decisions that drain the battery:

**Pre-decide:**
- Same breakfast every day (or rotate 2-3 options)
- Outfit laid out night before
- Default schedule for types of tasks
- "If X, then Y" rules that don't require thinking

## The Doom Box Strategy

You have doom boxes. Admit it. Those piles of stuff you don't know what to do with.

**Weekly Doom Box Protocol (15 min max):**
1. Set timer for 15 minutes
2. Pick up ONE item from the doom pile
3. Decide: Trash / Donate / Home / Action needed
4. If Action needed: write the action, put item in "action needed" zone
5. Repeat until timer ends
6. STOP. You did enough.

## Anti-Patterns (Things That Don't Work)

❌ **Detailed long-term planning** - You'll abandon it and feel bad
❌ **Guilt-based motivation** - Creates avoidance, not action
❌ **"I'll remember"** - You won't. Write it down.
❌ **Willpower over systems** - Systems > willpower every time
❌ **Comparing to neurotypical productivity** - Different brain, different metrics
❌ **"Catching up" marathons** - You'll burn out. Slow and steady.
❌ **Perfect planning before starting** - Planning paralysis. Start messy.

## Good Days vs Bad Days

ADHD has high variance. Plan for BOTH:

**Good Days (Hyperfocus Available):**
- Tackle THE Thing first while energy is there
- Don't overcommit just because you're on fire
- Bank some wins for bad days

**Bad Days (Executive Function Depleted):**
- Permission to do minimum viable
- Focus on maintenance (eat, hygiene, rest)
- Low-stakes tasks only
- No major decisions

**The key**: Don't judge bad days. They're part of the pattern.

## Tools That Actually Help

### Digital
- **Focusmate** - Body doubling with strangers
- **Forest** - Phone lockout with gamification
- **Todoist/Things** - Simple task managers (NOT complex systems)
- **Goblin Tools** - AI that breaks tasks into smaller steps

### Physical
- **Time Timer** - Visual countdown
- **Whiteboard** - Daily view in prominent location
- **Physical inbox tray** - One place for paper
- **Fidget tools** - Support focus for many ADHD brains

### Environmental
- **Background noise** - Lo-fi beats, brown noise, coffee shop sounds
- **Standing desk or movement option** - Bodies need to move
- **Minimal visual clutter** - Less distraction
- **Good lighting** - Affects focus more than you think

## The Shutdown Ritual (5 min)

End of workday ritual to actually STOP working:

1. Write tomorrow's "THE Thing" (30 seconds)
2. Check calendar for tomorrow surprises (30 seconds)
3. Clear one small thing from inbox/desk (2 minutes)
4. Say out loud: "Work is done for today." (Seriously. Say it.)
5. Physical transition (close laptop, leave room, change clothes)

## Integration with Other Skills

- **adhd-design-expert**: For designing ADHD-friendly digital experiences
- **diagramming-expert**: For visual task mapping
- **jungian-psychologist**: For deeper patterns around productivity shame

## Remember

You are not broken. Your brain works differently. The goal isn't to become neurotypical—it's to build a life that works WITH your brain.

Progress over perfection. Compassion over criticism. Systems over willpower.
