# Post Templates for Claude Ecosystem Promotion

Copy-paste templates for all major platforms. Customize the bracketed sections.

---

## Reddit Templates

### r/ClaudeAI Showcase Post

```markdown
# [Showcase] [Tool Name] - [One-line value prop]

Hey r/ClaudeAI!

I just released **[Tool Name]**, an MCP server that [brief description of what it does].

## The Problem

[2-3 sentences about the pain point this solves. Be specific.]

## What It Does

[Bullet points of key features]:
- Feature 1: [description]
- Feature 2: [description]
- Feature 3: [description]

## Quick Demo

[Embed GIF or link to video]

## Installation

```bash
[one-liner installation command]
```

Then add to your Claude config:

```json
{
  "mcpServers": {
    "[server-name]": {
      "command": "[command]",
      "args": ["[args]"]
    }
  }
}
```

## Links

- **GitHub**: [link]
- **Documentation**: [link]
- **Demo Video**: [link]

## What's Next

I'm planning to add:
- [ ] [Feature 1]
- [ ] [Feature 2]

Would love your feedback! What features would be most useful for your workflow?

---

*Built with [framework/language]. MIT licensed.*
```

### r/mcp Technical Showcase

```markdown
# [Tool Name]: [Technical description]

Just shipped a new MCP server for [use case].

## Architecture

[Brief technical overview - what makes this interesting technically]

## Key Features

1. **[Feature]**: [Technical detail]
2. **[Feature]**: [Technical detail]
3. **[Feature]**: [Technical detail]

## Example Usage

```
User: [example prompt]
Claude: [example response showing tool in action]
```

## Performance

- [Metric]: [Value]
- [Metric]: [Value]

## Installation

```bash
[installation command]
```

## Source

GitHub: [link]
Registry: [link to MCP registry entry]

Feedback welcome - especially on [specific aspect you want feedback on].
```

---

## X/Twitter Templates

### Launch Thread

```
1/🚀 Just launched [Tool Name] - [one-liner description]

It lets Claude [key capability].

Here's what it does and why you might want it 🧵

2/The problem:

[Pain point in ~200 characters]

Before: [old way]
After: [new way with your tool]

3/How it works:

[Simple explanation, possibly with diagram/GIF]

4/Key features:

✅ [Feature 1]
✅ [Feature 2]
✅ [Feature 3]
✅ [Feature 4]

5/Quick demo:

[GIF or video link]

Watch Claude [do the thing] in real-time.

6/Get started in 30 seconds:

```
[one-liner install]
```

Add to Claude config and you're ready.

7/What's coming next:

📍 [Roadmap item 1]
📍 [Roadmap item 2]
📍 [Roadmap item 3]

8/Links:

🔗 GitHub: [link]
📚 Docs: [link]
🎥 Full demo: [link]

9/Built this because [personal story/motivation].

If you're dealing with [problem], give it a try!

Feedback & feature requests welcome. What would make this more useful for you?
```

### Single Tweet Announcement

```
🚀 Just shipped [Tool Name] - [one-liner]

[Key feature 1]
[Key feature 2]
[Key feature 3]

Install: [one-liner command]
GitHub: [link]

RT appreciated! 🙏
```

### Quote Tweet for Retweets

```
[Original content creator] inspired me to build this.

[Tool Name] takes it further by [your addition/improvement].

Try it: [link]
```

---

## dev.to / Medium Templates

### Launch Post

```markdown
---
title: I Built [Tool Name] to Solve [Problem] - Here's What I Learned
published: true
tags: claude, mcp, ai, [relevant-tag]
cover_image: [URL to cover image - 1000x420px]
---

## TL;DR

[2-3 sentence summary. What is it, what does it do, link to repo.]

---

## The Problem

[Tell the story of the pain point. Make it relatable.]

I was trying to [task] when I realized [frustration]. The existing solutions either [limitation 1] or [limitation 2].

What I really needed was [your solution description].

## Existing Solutions

Before building, I evaluated:

### [Solution 1]
- ✅ [Pro]
- ❌ [Con that matters]

### [Solution 2]
- ✅ [Pro]
- ❌ [Con that matters]

None of them quite fit because [gap your tool fills].

## My Approach

[Technical overview without getting too deep]

### Architecture

[Diagram or description]

### Key Design Decisions

1. **[Decision 1]**: I chose [X] over [Y] because [reason].
2. **[Decision 2]**: [Explanation]
3. **[Decision 3]**: [Explanation]

## Demo

![Demo GIF](url-to-gif)

Here's what it looks like in action:

```
User: [example prompt]
Claude: [response]
```

## Getting Started

### Installation

```bash
[installation commands]
```

### Configuration

```json
{
  "mcpServers": {
    "[name]": {
      // config
    }
  }
}
```

### Your First [Action]

[Quick tutorial to get value in 2 minutes]

## What I Learned

Building this taught me:

1. **[Lesson 1]**: [Explanation]
2. **[Lesson 2]**: [Explanation]
3. **[Lesson 3]**: [Explanation]

## What's Next

I'm planning to add:

- [ ] [Feature 1] - [why it matters]
- [ ] [Feature 2] - [why it matters]
- [ ] [Feature 3] - [why it matters]

## Get Involved

- ⭐ Star on GitHub: [link]
- 🐛 Report issues: [link]
- 💡 Request features: [link]
- 🤝 Contribute: [link to contributing guide]

---

*[Tool Name] is MIT licensed and open source. Built with [tech stack].*

What features would you find useful? Let me know in the comments!
```

---

## LinkedIn Templates

### Professional Announcement

```
🚀 Excited to share my latest project: [Tool Name]

As AI assistants become more capable, they need better tools. I built [Tool Name] to help Claude [capability].

The problem: [1-2 sentences on pain point]

The solution: [Brief description]

Key features:
• [Feature 1]
• [Feature 2]
• [Feature 3]

This is part of the Model Context Protocol (MCP) ecosystem - an open standard for connecting AI assistants to external tools and data.

Try it: [GitHub link]
Learn more: [docs/blog link]

What tools would make your AI workflow better? I'd love to hear your ideas.

#AI #MCP #Claude #DeveloperTools #OpenSource
```

---

## Discord Templates

### Server Announcement (Claude/MCP Discords)

```
🎉 **New MCP Server: [Tool Name]**

Hey everyone! Just released an MCP server for [use case].

**What it does:**
→ [Feature 1]
→ [Feature 2]
→ [Feature 3]

**Quick start:**
```
[one-liner install]
```

**Links:**
• GitHub: [URL]
• Demo: [URL]

Would love feedback! Especially interested in [specific feedback area].
```

---

## YouTube Video Script Outline

### Demo Video (2-5 minutes)

```
[0:00-0:15] Hook
"If you use Claude and you've ever wanted to [capability], this is for you."

[0:15-0:45] Problem Statement
"Here's the problem: [pain point]. You have to [manual process]. It's tedious and error-prone."

[0:45-1:30] Solution Introduction
"I built [Tool Name] to fix this. It's an MCP server that lets Claude [capability]."

[1:30-3:30] Live Demo
[Screen recording showing actual usage]
- Show installation
- Show configuration
- Show 2-3 example prompts
- Show results

[3:30-4:00] Key Features Recap
"So to recap:
- [Feature 1]
- [Feature 2]
- [Feature 3]"

[4:00-4:30] Call to Action
"Link to GitHub is in the description. Star it if you find it useful.

Let me know in the comments what features you'd like to see.

If you're building with MCP, subscribe - I'll be sharing more tools like this."

[4:30-5:00] Outro
"Thanks for watching. See you in the next one."
```

---

## GitHub README Header Template

```markdown
# [Tool Name]

[![npm version](https://badge.fury.io/js/%40org%2Fpackage.svg)](...)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](...)
[![MCP](https://img.shields.io/badge/MCP-compatible-blue.svg)](...)

> [One-line description - what it does and for whom]

[Screenshot or GIF showing the tool in action]

## Why [Tool Name]?

- ✅ **[Benefit 1]**: [Brief explanation]
- ✅ **[Benefit 2]**: [Brief explanation]
- ✅ **[Benefit 3]**: [Brief explanation]

## Quick Start

```bash
[Single installation command]
```

[Minimal config example]

## Demo

[GIF or link to video]

---

[Rest of README...]
```

---

## Hashtags Reference

### Twitter/X
```
#Claude #MCP #ModelContextProtocol #AI #AITools #DevTools #OpenSource #Anthropic #ClaudeAI #LLM #AIAgents
```

### LinkedIn
```
#AI #ArtificialIntelligence #MCP #Claude #DeveloperTools #OpenSource #TechInnovation #AIAssistants #Productivity
```

### dev.to Tags
```
claude, mcp, ai, productivity, opensource, tutorial, showdev
```
