# Optimal Timing Calendar for Promotion

Strategic timing can significantly impact the reach and engagement of your launch.

---

## Best Days & Times by Platform

### Reddit

| Day | Quality | Best Times (UTC) | Notes |
|-----|---------|------------------|-------|
| Monday | Good | 14:00-17:00 | Catches weekly planning |
| Tuesday | **Best** | 13:00-17:00 | Peak engagement |
| Wednesday | **Best** | 13:00-17:00 | Mid-week attention |
| Thursday | Good | 14:00-17:00 | Pre-weekend browsing |
| Friday | Avoid | - | Weekend dropoff starts |
| Saturday | Avoid | - | Low developer traffic |
| Sunday | OK | 18:00-22:00 | Sunday prep browsing |

**US-Centric Timing**: Most Reddit traffic is US-based
- 9am-12pm ET (14:00-17:00 UTC) = peak
- Avoid US holidays

### X/Twitter

| Day | Quality | Best Times (UTC) |
|-----|---------|------------------|
| Monday | Good | 14:00-18:00 |
| Tuesday | **Best** | 14:00-18:00 |
| Wednesday | **Best** | 14:00-18:00 |
| Thursday | Good | 14:00-18:00 |
| Friday | OK | 12:00-15:00 |
| Weekend | Low | Avoid for launches |

**Thread Strategy**:
- Post first tweet at optimal time
- Space follow-up tweets 5-10 min apart
- Engagement tweet 2-4 hours later

### LinkedIn

| Day | Quality | Best Times (UTC) |
|-----|---------|------------------|
| Tuesday | **Best** | 09:00-12:00 |
| Wednesday | **Best** | 09:00-12:00 |
| Thursday | Good | 09:00-12:00 |
| Monday | OK | 10:00-12:00 |
| Friday | Avoid | - |
| Weekend | Avoid | - |

**B2B Note**: LinkedIn is business hours only

### dev.to

| Day | Quality | Best Times (UTC) |
|-----|---------|------------------|
| Monday | **Best** | 13:00-16:00 |
| Tuesday | **Best** | 13:00-16:00 |
| Wednesday | Good | 13:00-16:00 |
| Thursday | Good | 14:00-17:00 |
| Friday | Avoid | - |
| Weekend | Low | - |

### Hacker News (Show HN)

| Day | Quality | Best Times (UTC) |
|-----|---------|------------------|
| Tuesday | **Best** | 14:00-16:00 |
| Wednesday | **Best** | 14:00-16:00 |
| Thursday | Good | 14:00-16:00 |
| Monday | OK | 15:00-17:00 |
| Weekend | Risky | Can work, less competition |

**HN Tips**:
- Front page = exponential reach
- Timing is crucial
- Title matters enormously
- Be ready to answer comments immediately

### Product Hunt

| Day | Quality | Notes |
|-----|---------|-------|
| Tuesday | **Best** | Highest engagement |
| Wednesday | Good | Good visibility |
| Thursday | Good | - |
| Monday | OK | Post-weekend traffic |
| Friday | Avoid | Pre-weekend dropoff |
| Weekend | Avoid | Low traffic |

**PH Timing**:
- Launches go live at 12:01 AM PT
- Be online and responsive immediately
- First hours are crucial

---

## 30-Day Launch Calendar

### Week -1: Preparation

| Day | Activity |
|-----|----------|
| Day -7 | Finalize README, create demo video |
| Day -6 | Prepare social media graphics (1200x630, 1080x1080) |
| Day -5 | Draft all posts (Reddit, Twitter, dev.to) |
| Day -4 | Set up tracking (GitHub insights, social analytics) |
| Day -3 | Schedule tweets, prepare responses |
| Day -2 | Final testing, bug fixes |
| Day -1 | Rest, final review, set alarms |

### Week 1: Launch

| Day | Platform | Activity |
|-----|----------|----------|
| **Day 0** (Tue/Wed) | MCP Registry | Submit PR |
| **Day 0** | Reddit r/ClaudeAI | Post with [Showcase] |
| **Day 0** | Reddit r/mcp | Post |
| **Day 0** | Twitter/X | Launch thread |
| **Day 0** | Discord | Share in #showcase |
| Day 1 | dev.to | Publish launch post |
| Day 1 | YouTube | Upload demo video |
| Day 1 | Smithery | Submit listing |
| Day 1 | Glama | Submit listing |
| Day 2 | LinkedIn | Professional announcement |
| Day 3 | PulseMCP | Submit + Discord |
| Day 3 | Awesome lists | Submit PRs |

### Week 2: Amplification

| Day | Activity |
|-----|----------|
| Day 7 | Follow up on awesome list PRs |
| Day 8 | Share user testimonials/feedback |
| Day 9 | Post "Week 1 learnings" thread |
| Day 10 | Engage with any podcast/newsletter opportunities |
| Day 11 | Cross-post to secondary subreddits if relevant |

### Week 3-4: Sustainability

| Day | Activity |
|-----|----------|
| Day 14 | "Two weeks in" update post |
| Day 17 | Feature update announcement |
| Day 21 | Community showcase (share how users are using it) |
| Day 28 | Month 1 retrospective |

---

## Launch Day Hour-by-Hour (UTC)

### Target: Tuesday Launch

```
05:00 UTC - Wake up, coffee, final checks
06:00 UTC - Submit MCP Registry PR
07:00 UTC - Smithery + Glama submissions
08:00 UTC - LinkedIn post
09:00 UTC - Discord announcements

13:00 UTC - Reddit r/ClaudeAI post (US waking up)
13:30 UTC - Reddit r/mcp post
14:00 UTC - Twitter launch thread
14:30 UTC - Engage with early comments

15:00-18:00 UTC - Active engagement period
- Respond to all comments
- Answer questions
- Thank supporters
- Share additional context

19:00 UTC - dev.to post goes live
20:00 UTC - YouTube video published

21:00-23:00 UTC - Evening engagement
- Respond to later comments
- Track metrics
- Note feedback for improvements
```

---

## Seasonal Considerations

### Best Months

| Month | Quality | Notes |
|-------|---------|-------|
| January | Good | New year motivation |
| February | **Best** | Post-holiday, focused |
| March | **Best** | Q1 energy |
| April | Good | Spring productivity |
| September | **Best** | Post-summer, back to work |
| October | Good | Q4 planning |
| November | OK | Before holiday slowdown |

### Avoid

| Period | Reason |
|--------|--------|
| Late December | Holiday absence |
| Late June/July | Summer vacations |
| Major holidays | Low engagement |
| Big tech announcements | Overshadowed |

### Ride the Wave

Launch near (but not during) major AI events:
- Anthropic announcements → Launch compatible tools
- MCP updates → Launch servers using new features
- Claude updates → Launch relevant skills

---

## Time Zone Strategy

### Primary Audiences

| Audience | Peak Hours (Local) |
|----------|-------------------|
| US West Coast | 9am-12pm PT |
| US East Coast | 9am-12pm ET |
| Europe | 10am-1pm CET |
| Asia-Pacific | Consider separate push |

### Global Launch Strategy

For maximum reach, stagger announcements:
1. **Primary**: 14:00 UTC (US morning)
2. **European follow-up**: 08:00 UTC (Europe morning)
3. **APAC follow-up**: 00:00 UTC (Asia morning)

---

## Response Time Targets

| Platform | Target Response Time |
|----------|---------------------|
| Reddit comments | &lt; 30 minutes (first 4 hours) |
| Twitter replies | &lt; 15 minutes (launch day) |
| GitHub issues | &lt; 4 hours |
| Discord questions | &lt; 1 hour |
| Email inquiries | &lt; 24 hours |

**Critical**: First 4 hours after posting determine success. Be fully available.

---

## Metrics Checkpoints

### Hour 1
- Reddit: 5+ upvotes
- Twitter: 10+ likes
- Goal: Establish momentum

### Hour 4
- Reddit: 20+ upvotes
- Twitter: 50+ likes
- GitHub: 5+ stars

### Day 1
- Reddit: 50+ upvotes
- Twitter: 100+ likes
- GitHub: 20+ stars

### Week 1
- Reddit: Total 100+ upvotes
- GitHub: 50+ stars
- npm/downloads: 100+
- Listed on 3+ registries

If behind targets, consider:
- Boosting with personal network
- Engaging more in comments
- Cross-posting to relevant communities
- Adjusting messaging based on feedback

---

## Quick Reference Card

```
╔═══════════════════════════════════════════════╗
║           OPTIMAL LAUNCH TIMING               ║
╠═══════════════════════════════════════════════╣
║  Best Day:     Tuesday or Wednesday           ║
║  Best Time:    14:00 UTC (9am ET, 6am PT)     ║
║  Best Month:   Feb, Mar, Sep, Oct             ║
╠═══════════════════════════════════════════════╣
║  Platform Priority:                           ║
║  1. MCP Registry (foundation)                 ║
║  2. Reddit r/ClaudeAI (volume)                ║
║  3. Twitter thread (reach)                    ║
║  4. dev.to post (SEO)                         ║
║  5. YouTube demo (persistence)                ║
╠═══════════════════════════════════════════════╣
║  Response Targets:                            ║
║  • Reddit: < 30 min                           ║
║  • Twitter: < 15 min                          ║
║  • GitHub: < 4 hours                          ║
╚═══════════════════════════════════════════════╝
```
