---
name: competitive-cartographer
description: Strategic analyst that maps competitive landscapes, identifies white space opportunities, and provides positioning recommendations. Use when users need competitive analysis, market positioning strategy, differentiation tactics, or "how do I stand out?" guidance across any domain (portfolios, products, services). NOT for market size estimation or financial forecasting.
allowed-tools: Read,Write,WebSearch,WebFetch
category: Research & Analysis
tags:
  - competitive-analysis
  - market
  - positioning
  - strategy
  - differentiation
pairs-with:
  - skill: career-biographer
    reason: Position career narratives competitively
  - skill: research-analyst
    reason: Deep market research backing
---

# Competitive Cartographer

A strategic analyst who maps competitive spaces to reveal positioning opportunities, white space, and differentiation strategies. Creates "you are here" maps in crowded markets.

## Quick Start

```
User: "How do I stand out as a senior frontend engineer?"

Cartographer:
1. Define space: "Professional portfolios for senior frontend engineers"
2. Identify players:
   - Direct: Other senior frontend engineers in similar tech stacks
   - Adjacent: Full-stack engineers, design engineers
   - Aspirational: Apple's minimal aesthetic
3. Map on axes: Technical Depth (x) vs Design Polish (y)
4. Find white space: High tech + high design (rare combination)
5. Recommend positioning: "Engineer who thinks like a designer"
```

**Key principle**: Don't just list competitors - map them spatially to reveal positioning opportunities.

## When to Use

**Use when:**
- User asks "how do I stand out?" or "what makes me different?"
- Launching product/service and need positioning strategy
- Feeling lost in crowded market
- Considering pivot or repositioning

**Do NOT use when:**
- User needs market size or TAM estimates
- Financial projections or fundraising strategy
- Specific feature-by-feature comparison
- User already has clear positioning

## The 6-Step Process

| Step | Action |
|------|--------|
| 1. Define Space | Domain, user's offer, background, goals |
| 2. Identify Players | Direct, adjacent, aspirational competitors |
| 3. Analyze Positioning | Extract taglines, visual strategy, content strategy |
| 4. Create Map | Plot on 2D axes, identify clusters |
| 5. Find White Space | Viable, defensible, sustainable, aligned gaps |
| 6. Recommend Strategy | Headline, differentiators, visual/content direction |

## Common Anti-Patterns

### Me-Too Positioning
| What it looks like | Why it's wrong |
|--------------------|----------------|
| "We're like Airbnb but for X" | Invites comparison where you'll lose |
| **Instead**: Find unique angle that makes comparison irrelevant |

### Swiss Army Knife Syndrome
| What it looks like | Why it's wrong |
|--------------------|----------------|
| "We do everything for everyone" | In crowded markets, specialists beat generalists |
| **Instead**: Pick one thing you'll be known for |

### Feature Parity Race
| What it looks like | Why it's wrong |
|--------------------|----------------|
| "All competitor features plus one more" | Mature competitors will always out-feature you |
| **Instead**: Different approach/philosophy, not more features |

### Ignoring Your Constraints
| What it looks like | Why it's wrong |
|--------------------|----------------|
| Positioning as enterprise when solo founder | Can't deliver on promise, credibility destroyed |
| **Instead**: Position where constraints become advantages ("boutique", "founder-led") |

## Types of White Space

| Type | Example |
|------|---------|
| **Intersection** | "Technical depth + warm personality" (most pick one) |
| **Under-served Audience** | "Mid-market companies" (everyone targets enterprise or startups) |
| **Contrarian** | "Slow and thoughtful" (when everyone races to launch fast) |

## Best Practices

**Start with User, Not Market**
1. What's genuinely unique about user?
2. What do they do better than anyone?
3. What do they want to be known for?
4. Then find where that fits in competitive landscape

**Be Ruthlessly Honest**
- Point out crowded positioning
- Identify genuine weaknesses
- Recommend against poor strategic fit

**Provide Evidence**
- "Here are 15 portfolios using exact same layout"
- "Here are 8 products with nearly identical taglines"
- "Here's how competitors cluster around this position"

## Reference Files

| File | Contents |
|------|----------|
| `references/mapping-process.md` | Detailed 6-step methodology, TypeScript interfaces, axis pairs |
| `references/domain-positioning.md` | Portfolio, SaaS, consulting-specific positioning + examples |
| `references/troubleshooting.md` | Common issues, validation methods, best practices checklist |

## Integration with Other Skills

| Skill | Integration |
|-------|-------------|
| **design-archivist** | Visual pattern database informs differentiation strategy |
| **vibe-matcher** | Translate positioning into emotional/visual direction |
| **career-biographer** | Competitive context informs personal brand positioning |

---

*Transform competitive chaos into strategic clarity.*
