# Troubleshooting Guide

Common issues when doing competitive mapping and positioning.

## Issue: Can't Find Any White Space

**Cause**: Market is genuinely saturated OR looking at wrong dimensions

**Fixes**:
1. Zoom out to adjacent categories
2. Zoom in to micro-niches
3. Try different axis pairs for mapping
4. Consider positioning on intangibles (values, personality, process)

---

## Issue: User Resists Differentiation

**Example**: "But I can do everything they do!"

**Fix**: Explain positioning vs capability.

> You can DO many things, but you're KNOWN for one thing. Choose what you want to be known for.

The goal isn't to limit what you offer - it's to create a memorable first impression that gets you in the door.

---

## Issue: White Space Has No Audience

**Example**: Found gap but no one wants that position

**Fix**: Validate before committing.

White space can be empty because:
- It's genuinely overlooked (opportunity!)
- It's bad space no one wants (trap!)

**Validation methods**:
- Search for content/discussions in that space
- Look for failed attempts to occupy that space
- Ask potential audience if they'd value that positioning

---

## Issue: Recommended Positioning Feels Inauthentic

**Example**: Strategy is sound but doesn't match user's personality

**Fix**: Positioning must be authentic.

Don't force a positioning that doesn't fit who you actually are. Instead:
1. Start with user's genuine strengths and values
2. Find white space that aligns with those
3. If no alignment exists, look at different competitive dimensions

---

## Issue: Too Many Competitors to Map

**Example**: 50+ players in the space

**Fix**: Tier and filter.

1. **Primary** (5-8): Direct competitors user most often loses to
2. **Secondary** (10-15): Adjacent players worth watching
3. **Aspirational** (3-5): Reference points for positioning

Map primary tier in detail; note secondary and aspirational for context.

---

## Issue: Competitors Keep Shifting Position

**Example**: Market moving too fast to map

**Fix**: Map trends, not just current state.

- Where are competitors moving TO?
- What positions are being abandoned?
- What new entrants are claiming?

The valuable white space is often where the market is heading, not where it currently is.

---

## Issue: User's Positioning Gets Copied

**Example**: Differentiation works but competitors follow

**Fix**: Build defensible positioning.

Defensibility sources:
- **Expertise**: Deep specialization that takes years to build
- **Community**: Network effects around your position
- **Track record**: Portfolio of proof that compounds
- **Personality**: Your unique voice can't be copied

If positioning is purely visual or message-based, it will be copied. Build substance behind it.

---

## Best Practices Checklist

### Start with User, Not Market
1. What's genuinely unique about user?
2. What do they do better than anyone?
3. What do they want to be known for?
4. Then find where that fits in competitive landscape

### Be Ruthlessly Honest
- Point out when user's desired positioning is crowded
- Identify genuine weaknesses vs competitors
- Recommend against poor strategic fit
- Better to surface hard truths early

### Provide Evidence
Don't just say "this space is crowded" - show specific examples:
- "Here are 15 portfolios using exact same layout"
- "Here are 8 products with nearly identical taglines"
- "Here's how competitors cluster around this position"

### Think Long-Term
- Will this positioning still work in 2-3 years?
- Is it defensible or easily copied?
- Does it allow room to grow/evolve?
