# Jungian Psychology Diagram Patterns

Specialized visual patterns for depth psychology work.

## THE PSYCHE: LAYERED MODELS

### Complete Psyche Map

```
┌─────────────────────────────────────────────────────────────────────────┐
│                        COLLECTIVE UNCONSCIOUS                           │
│                                                                         │
│    Universal patterns shared by all humanity across time and culture    │
│                                                                         │
│    ┌─────────────────────────────────────────────────────────────────┐  │
│    │                       ARCHETYPES                                │  │
│    │                                                                 │  │
│    │    ┌──────┐  ┌──────┐  ┌──────┐  ┌──────┐  ┌──────┐             │  │
│    │    │ Self │  │Shadow│  │Anima/│  │ Hero │  │ Wise │             │  │
│    │    │      │  │      │  │Animus│  │      │  │ Old  │             │  │
│    │    └──────┘  └──────┘  └──────┘  └──────┘  └──────┘             │  │
│    │                                                                 │  │
│    │    ┌──────┐  ┌──────┐  ┌──────┐  ┌──────┐  ┌──────┐             │  │
│    │    │Great │  │Divine│  │Trick-│  │ Puer/│  │Mother│             │  │
│    │    │Father│  │Child │  │ ster │  │Senex │  │      │             │  │
│    │    └──────┘  └──────┘  └──────┘  └──────┘  └──────┘             │  │
│    │                                                                 │  │
│    └─────────────────────────────────────────────────────────────────┘  │
│                                                                         │
├─────────────────────────────────────────────────────────────────────────┤
│                        PERSONAL UNCONSCIOUS                             │
│                                                                         │
│    Individual experiences, memories, and repressed material             │
│                                                                         │
│    ┌─────────────────────────────────────────────────────────────────┐  │
│    │                        COMPLEXES                                │  │
│    │                                                                 │  │
│    │   ┌───────────────┐  ┌───────────────┐  ┌───────────────┐       │  │
│    │   │    Mother     │  │    Father     │  │  Inferiority  │       │  │
│    │   │   Complex     │  │   Complex     │  │   Complex     │       │  │
│    │   │               │  │               │  │               │       │  │
│    │   │ archetypal    │  │ archetypal    │  │ archetypal    │       │  │
│    │   │ core + your   │  │ core + your   │  │ core + your   │       │  │
│    │   │ experience    │  │ experience    │  │ experience    │       │  │
│    │   └───────────────┘  └───────────────┘  └───────────────┘       │  │
│    │                                                                 │  │
│    └─────────────────────────────────────────────────────────────────┘  │
│                                                                         │
├─────────────────────────────────────────────────────────────────────────┤
│                              EGO                                        │
│                                                                         │
│    Center of consciousness. "I" — but NOT the whole Self.               │
│    Mediates between inner and outer worlds.                             │
│                                                                         │
├─────────────────────────────────────────────────────────────────────────┤
│                            PERSONA                                      │
│                                                                         │
│    The mask worn for social adaptation.                                 │
│    From Latin: theatrical mask.                                         │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
                                    │
                                    │
                            OUTER WORLD
                    (Society, Relationships, Environment)
```

### Simplified Psyche Diagram

```
                    ┌────────────────────────┐
                    │    OUTER WORLD         │
                    └───────────┬────────────┘
                                │
              ╔═════════════════╧═════════════════╗
              ║            PERSONA                ║
              ║       (social mask)               ║
              ╠═══════════════════════════════════╣
              ║              EGO                  ║
              ║    (conscious "I")                ║
              ╠═══════════════════════════════════╣
              ║                                   ║
              ║     PERSONAL UNCONSCIOUS          ║
              ║  ┌─────────┐  ┌─────────┐         ║
              ║  │Complex A│  │Complex B│         ║
              ║  └─────────┘  └─────────┘         ║
              ║                                   ║
              ╠═══════════════════════════════════╣
              ║                                   ║
              ║    COLLECTIVE UNCONSCIOUS         ║
              ║                                   ║
              ║   Shadow ─ Anima/Animus ─ Self    ║
              ║                                   ║
              ╚═══════════════════════════════════╝
```

---

## THE SHADOW

### Shadow Content Map

```
┌────────────────────────────────────────────────────────────────────────┐
│                           THE SHADOW                                   │
│                                                                        │
│   "Where there is light, there is shadow" — Jung                       │
│                                                                        │
├───────────────────────────────────┬────────────────────────────────────┤
│                                   │                                    │
│    DARK SHADOW                    │    GOLDEN SHADOW                   │
│    (Rejected Negative)            │    (Rejected Positive)             │
│                                   │                                    │
│    ┌─────────────────────┐        │    ┌─────────────────────┐         │
│    │ • Rage              │        │    │ • Creativity        │         │
│    │ • Greed             │        │    │ • Power             │         │
│    │ • Selfishness       │        │    │ • Beauty            │         │
│    │ • Weakness          │        │    │ • Intelligence      │         │
│    │ • Sexual impulses   │        │    │ • Leadership        │         │
│    │ • Aggression        │        │    │ • Authenticity      │         │
│    │ • Fear              │        │    │ • Spontaneity       │         │
│    └─────────────────────┘        │    └─────────────────────┘         │
│                                   │                                    │
│    "I am NOT that kind            │    "Who am I to be                 │
│     of person"                    │    brilliant/talented?"            │
│                                   │                                    │
├───────────────────────────────────┼────────────────────────────────────┤
│                                   │                                    │
│    UNLIVED LIFE                   │    COLLECTIVE SHADOW               │
│                                   │                                    │
│    ┌─────────────────────┐        │    ┌─────────────────────┐         │
│    │ • Roads not taken   │        │    │ • Cultural denied   │         │
│    │ • Dreams abandoned  │        │    │ • Historical trauma │         │
│    │ • Potential denied  │        │    │ • Systemic injustice│         │
│    │ • "What if I had..."│        │    │ • Group projection  │         │
│    └─────────────────────┘        │    └─────────────────────┘         │
│                                   │                                    │
│    Accumulates as                 │    "Nice" cultures have            │
│    resentment & regret            │    the most brutal shadows         │
│                                   │                                    │
└───────────────────────────────────┴────────────────────────────────────┘
```

### Shadow Recognition Pattern

```
SHADOW RECOGNITION MARKERS
═══════════════════════════════════════════════════════════════════════════

┌─────────────────────────────────────────────────────────────────────────┐
│                        INTENSE REACTION                                 │
│                                                                         │
│   Something in the other person triggers you disproportionately         │
│                                                                         │
│         ATTRACTION                          REPULSION                   │
│             │                                  │                        │
│             │    ┌───────────────────────┐     │                        │
│             └───►│  PROJECTION ACTIVE    │◄────┘                        │
│                  │                       │                              │
│                  │  "I can't stand       │                              │
│                  │   people who..."      │                              │
│                  │                       │                              │
│                  │  "I'm so drawn to     │                              │
│                  │   people who..."      │                              │
│                  └───────────┬───────────┘                              │
│                              │                                          │
│                              ▼                                          │
│                  ┌───────────────────────┐                              │
│                  │    SHADOW CONTENT     │                              │
│                  │                       │                              │
│                  │  "Where does this     │                              │
│                  │   quality live in     │                              │
│                  │   ME?"                │                              │
│                  └───────────────────────┘                              │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘

OTHER MARKERS:
├── Slips of the tongue ("Freudian slips")
├── "Accidental" behaviors
├── What you're most defensive about when accused
├── Same-sex dream figures (often dark or inferior)
└── Strong opinions about what's "wrong" with others
```

---

## THE ANIMA/ANIMUS

### Classical Model

```
ANIMA DEVELOPMENT STAGES (in male psyche)
════════════════════════════════════════════════════════════════════════
      EVE              HELEN              MARY             SOPHIA
       │                 │                  │                 │
       ▼                 ▼                  ▼                 ▼
┌────────────┐     ┌────────────┐     ┌────────────┐     ┌────────────┐
│ Biological │     │  Romantic  │     │  Spiritual │     │   Wisdom   │
│   Woman    │     │   Ideal    │     │   Mother   │     │   Guide    │
│            │     │            │     │            │     │            │
│  Object    │────►│   Muse     │────►│  Mediator  │────►│ Integrated │
│    of      │     │            │     │            │     │    Soul    │
│  Desire    │     │            │     │            │     │            │
└────────────┘     └────────────┘     └────────────┘     └────────────┘

         ANIMUS DEVELOPMENT STAGES (in female psyche)
════════════════════════════════════════════════════════════════════════
   PHYSICAL          ROMANTIC            WORD            MEANING
    POWER              MAN              (Logos)          (Spirit)
       │                 │                 │                 │
       ▼                 ▼                 ▼                 ▼
┌────────────┐     ┌────────────┐     ┌────────────┐     ┌────────────┐
│  Athlete   │     │  Romantic  │     │  Teacher   │     │    Wise    │
│  Warrior   │     │    Hero    │     │  Minister  │     │   Guide    │
│            │     │            │     │            │     │            │
│ Strength   │────►│   Action   │────►│ Conviction │────►│ Integrated │
│  & Power   │     │   & Deed   │     │  & Ideas   │     │   Spirit   │
└────────────┘     └────────────┘     └────────────┘     └────────────┘
```

### Contemporary Model

```
CONTEMPORARY UNDERSTANDING OF ANIMA/ANIMUS
═══════════════════════════════════════════════════════════════════════════

┌─────────────────────────────────────────────────────────────────────────┐
│                                                                         │
│   Not bound by biological sex or gender identity                        │
│   Represents the "Other" — the complementary force in the psyche        │
│                                                                         │
│                        ┌───────────────────┐                            │
│                        │                   │                            │
│                        │   CONTRASEXUAL    │                            │
│                        │    ARCHETYPE      │                            │
│                        │                   │                            │
│                        │  • Soul-bridge    │                            │
│                        │  • Creative muse  │                            │
│                        │  • Inner guide    │                            │
│                        │  • Gateway to     │                            │
│                        │    unconscious    │                            │
│                        │                   │                            │
│                        └─────────┬─────────┘                            │
│                                  │                                      │
│            ┌─────────────────────┼─────────────────────┐                │
│            │                     │                     │                │
│            ▼                     ▼                     ▼                │
│    ┌───────────────┐    ┌───────────────┐    ┌───────────────┐          │
│    │  PROJECTED    │    │  INTEGRATED   │    │   POSSESSED   │          │
│    │               │    │               │    │               │          │
│    │ Seen in       │    │ Inner         │    │ Mood swings   │          │
│    │ romantic      │    │ creativity    │    │ Irrational    │          │
│    │ partners      │    │ & depth       │    │ opinions      │          │
│    └───────────────┘    └───────────────┘    └───────────────┘          │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
```

---

## INDIVIDUATION

### The Individuation Journey

```
                    THE INDIVIDUATION PROCESS
═══════════════════════════════════════════════════════════════════════════

                            ┌─────────────────┐
                            │  SELF-REALIZED  │
                            │    (ongoing)    │
                            └────────▲────────┘
                                     │
                                     │
    ┌────────────────────────────────┴────────────────────────────────┐
    │                        STAGE 5                                  │
    │                   ONGOING INTEGRATION                           │
    │                                                                 │
    │   • Never complete in a lifetime                                │
    │   • Holding the tension of opposites                            │
    │   • Service to collective becomes possible                      │
    │   • The wound becomes the gift                                  │
    └────────────────────────────────▲────────────────────────────────┘
                                     │
    ┌────────────────────────────────┴────────────────────────────────┐
    │                        STAGE 4                                  │
    │                     SELF ENCOUNTER                              │
    │                                                                 │
    │   • Experience of organizing center                             │
    │   • Ego relativized but not destroyed                           │
    │   • Paradox: ego must be strong to surrender to Self            │
    │   • Symbols: Mandala, Divine Child, Philosopher's Stone         │
    └────────────────────────────────▲────────────────────────────────┘
                                     │
    ┌────────────────────────────────┴────────────────────────────────┐
    │                        STAGE 3                                  │
    │                 ANIMA/ANIMUS INTEGRATION                        │
    │                                                                 │
    │   • Working through projections in relationships                │
    │   • Accessing contrasexual creative energy                      │
    │   • No longer seeking wholeness through others                  │
    │   • Inner marriage preparation                                  │
    └────────────────────────────────▲────────────────────────────────┘
                                     │
    ┌────────────────────────────────┴────────────────────────────────┐
    │                        STAGE 2                                  │
    │                    SHADOW ENCOUNTER                             │
    │                                                                 │
    │   • Meeting the rejected aspects of self                        │
    │   • "Where there is light, there is shadow"                     │
    │   • Integration, not elimination, is the goal                   │
    │   • Shadow becomes ally and source of vitality                  │
    └────────────────────────────────▲────────────────────────────────┘
                                     │
    ┌────────────────────────────────┴────────────────────────────────┐
    │                        STAGE 1                                  │
    │                   PERSONA DISSOLUTION                           │
    │                                                                 │
    │   • Crisis reveals persona isn't whole self                     │
    │   • Often triggered by failure, loss, illness                   │
    │   • "Midlife crisis" is classic but can happen anytime          │
    │   • "I am not who I thought I was"                              │
    └────────────────────────────────▲────────────────────────────────┘
                                     │
                            ┌────────┴────────┐
                            │     START       │
                            │ (Identification │
                            │  with persona)  │
                            └─────────────────┘

NOTE: This is a spiral, not linear.
      Each stage revisited at deeper levels.
      Progress is not smooth — expect regression.
```

### Ego-Self Axis

```
EGO-SELF AXIS: THE STABILIZING CONNECTION
═══════════════════════════════════════════════════════════════════════════

   HEALTHY CONNECTION              FRAGILE CONNECTION
   ─────────────────               ───────────────────

        ┌──────┐                        ┌──────┐
        │ SELF │                        │ SELF │
        │      │                        │      │
        └──┬───┘                        └──┬───┘
           │                               ╳
           │ ← Strong, stable              ╳ ← Broken, unstable
           │   axis allows:                ╳   leads to:
           │                               ╳
           │   • Ego receives              ╳   • Ego inflated OR
           │     guidance from             ╳     deflated
           │     deeper center             ╳   • Seeking substitutes
           │                               ╳     for Self-connection
           │   • Meaning flows             ╳   • Grandiosity or
           │     into conscious            ╳     emptiness
           │     life                      ╳
           │                               ╳
           │   • Grounded yet              ╳   • Ungrounded,
           │     connected to              ╳     chaotic
           │     transcendent              ╳
        ┌──┴───┐                        ┌──┴───┐
        │ EGO  │                        │ EGO  │
        │      │                        │      │
        └──────┘                        └──────┘
```

---

## COMPLEX ANATOMY

### Structure of a Complex

```
                    ANATOMY OF A COMPLEX
═══════════════════════════════════════════════════════════════════════════

┌─────────────────────────────────────────────────────────────────────────┐
│                                                                         │
│                         ┌─────────────────────┐                         │
│                         │                     │                         │
│                         │   ARCHETYPAL CORE   │  ◄── Universal,         │
│                         │                     │      numinous energy    │
│                         │   (e.g., "Mother"   │                         │
│                         │    archetype)       │                         │
│                         │                     │                         │
│                         └──────────┬──────────┘                         │
│                                    │                                    │
│                                    │                                    │
│                         ┌──────────▼──────────┐                         │
│                         │                     │                         │
│                         │   PERSONAL SHELL    │  ◄── Your specific      │
│                         │                     │      experiences        │
│                         │  (memories of YOUR  │                         │
│                         │   mother, events,   │                         │
│                         │   associations)     │                         │
│                         │                     │                         │
│                         └──────────┬──────────┘                         │
│                                    │                                    │
│                                    │                                    │
│                         ┌──────────▼──────────┐                         │
│                         │                     │                         │
│                         │  AFFECTIVE CHARGE   │  ◄── Emotional          │
│                         │                     │      intensity,         │
│                         │  (emotional energy, │      autonomy,          │
│                         │   power to "possess"│      can hijack ego     │
│                         │   the ego)          │                         │
│                         │                     │                         │
│                         └─────────────────────┘                         │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
```

### Complex Activation

```
WHEN A COMPLEX IS ACTIVATED
═══════════════════════════════════════════════════════════════════════════

    TRIGGER                     COMPLEX                    BEHAVIOR
   (external)                  (activated)                 (output)
       │                           │                          │
       ▼                           ▼                          ▼
┌─────────────┐            ┌─────────────────┐         ┌─────────────┐
│  Situation  │            │                 │         │ Reactions   │
│  resembling │───────────►│  ████████████   │────────►│ "not like   │
│  original   │            │  ████████████   │         │ me"         │
│  wound      │            │  ████████████   │         │             │
└─────────────┘            │                 │         │ • Strong    │
                           │  Emotional      │         │   affect    │
                           │  charge floods  │         │ • Projection│
                           │  consciousness  │         │ • Somatic   │
                           │                 │         │   symptoms  │
                           └─────────────────┘         │ • Parapraxis│
                                                       └─────────────┘

                                   │
                                   │
                                   ▼
                           ┌──────────────────┐
                           │  EGO RESPONSE    │
                           │                  │
                           │  1. Notice       │
                           │  2. Differentiate│
                           │  3. "I HAVE this │
                           │     complex"     │
                           │     (not "I AM") │
                           │  4. Explore      │
                           │  5. Integrate    │
                           └──────────────────┘
```

---

## PARTS WORK DIAGRAMS

### Basic Parts Map

```
                       PARTS WORK MAP
═══════════════════════════════════════════════════════════════════════════
                         ┌─────────────────┐
                         │                 │
                         │   WISE SELF     │
                         │  (Observer,     │
                         │   Compassion)   │
                         │                 │
                         └────────┬────────┘
                                  │
                                  │ holds space for all
                                  │
        ┌─────────────────────────┼─────────────────────────┐
        │                         │                         │
        ▼                         ▼                         ▼
┌─────────────────┐       ┌─────────────────┐       ┌─────────────────┐
│                 │       │                 │       │                 │
│   PROTECTOR     │◄─────►│    WOUNDED      │◄─────►│    MANAGER      │
│                 │ guards│     CHILD       │control│                 │
│ • Anger         │       │                 │       │ • Perfectionism │
│ • Walls         │       │ • Vulnerability │       │ • Productivity  │
│ • Deflection    │       │ • Pain          │       │ • Hypervigiltic │
│                 │       │ • Needs         │       │                 │
└─────────────────┘       └─────────────────┘       └─────────────────┘
        │                                                   │
        │                                                   │
        └───────────────────────┬───────────────────────────┘
                                │
                                ▼
                         ┌─────────────────┐
                         │                 │
                         │     CRITIC      │
                         │                 │
                         │ • Harsh voice   │
                         │ • Shame         │
                         │ • "Not enough"  │
                         │                 │
                         └─────────────────┘
```

### Addiction Parts System

```
              ADDICTION: PARTS SYSTEM VIEW
═══════════════════════════════════════════════════════════════════════════

                         ┌─────────────────┐
                         │   WISE SELF     │
                         │  (recoverable   │
                         │   with work)    │
                         └────────┬────────┘
                                  │
         ┌────────────────────────┼────────────────────────┐
         │                        │                        │
         ▼                        ▼                        ▼
┌─────────────────┐      ┌─────────────────┐      ┌─────────────────┐
│   THE ADDICT    │      │   THE WOUNDED   │      │   THE MANAGER   │
│                 │      │     CHILD       │      │                 │
│ • Seeks relief  │◄────►│                 │◄────►│ • Tries to      │
│ • Knows the way │      │ • Original pain │      │   control       │
│   to numbness   │      │ • Unmet needs   │      │ • Willpower     │
│ • Has own       │      │ • Abandonment   │      │ • "Should be    │
│   intelligence  │      │ • Shame         │      │   able to..."   │
│                 │      │                 │      │                 │
└────────┬────────┘      └────────┬────────┘      └────────┬────────┘
         │                        │                        │
         │                        │                        │
         │                        ▼                        │
         │               ┌─────────────────┐               │
         │               │   THE CRITIC    │               │
         └──────────────►│                 │◄──────────────┘
                         │ • "You're weak" │
                         │ • "You'll never │
                         │   change"       │
                         │ • Shame spiral  │
                         └────────┬────────┘
                                  │
                                  │ cycles with
                                  │
                                  ▼
                         ┌─────────────────┐
                         │   THE ADDICT    │
                         │  (activated by  │
                         │   shame)        │
                         └─────────────────┘

RECOVERY: Build relationship between WISE SELF and all parts.
          Each part has positive intention. None are enemies.
```

---

## MANDALA PATTERNS

### Basic Mandala Structure

```
                      MANDALA: SYMBOL OF WHOLENESS
═══════════════════════════════════════════════════════════════════════════
                        ┌───────────────────┐
                       ╱                     ╲
                      ╱     ┌───────────┐     ╲
                     ╱      │           │      ╲
                    │       │  CENTER   │       │
                    │       │  (Self)   │       │
                    │       │           │       │
                     ╲      └───────────┘      ╱
                      ╲                       ╱
                       ╲                     ╱
                        └───────────────────┘
    
    The mandala represents:
    • Wholeness and integration
    • The Self as organizing center
    • The goal of individuation
    • Psychic equilibrium
    
    In Jung's own practice:
    • Drew mandalas daily during his "confrontation with the unconscious"
    • Called them "cryptograms on the state of my self"
    • Used with patients experiencing psychological fragmentation
```

### Four-Fold Mandala (Quaternary)

```
                         NORTH
                    (Spirit / Air)
                           │
                           │
            ┌──────────────┼──────────────┐
            │              │              │
            │      ┌───────┴───────┐      │
            │      │               │      │
   WEST ────┼──────┤    CENTER     ├──────┼──── EAST
 (Water/    │      │    (Self)     │      │   (Fire/
  Feeling)  │      │               │      │    Intuition)
            │      └───────┬───────┘      │
            │              │              │
            └──────────────┼──────────────┘
                           │
                           │
                         SOUTH
                   (Earth / Sensation)

    Jung's psychological types mapped to quaternary:
    • Thinking (North) ↔ Feeling (South)
    • Intuition (East) ↔ Sensation (West)
```

---

## DREAM DIAGRAM TEMPLATES

### Dream Scene Map

```
                    DREAM SCENE ANALYSIS
═══════════════════════════════════════════════════════════════════════

┌─────────────────────────────────────────────────────────────────────┐
│                           SETTING                                   │
│                                                                     │
│   Location: ___________________    Time: ______________             │
│   Atmosphere: _________________    Familiar?: Y / N                 │
│                                                                     │
├─────────────────────────────────────────────────────────────────────┤
│                           CHARACTERS                                │
│                                                                     │
│   ┌─────────────┐   ┌─────────────┐   ┌─────────────┐               │
│   │   DREAMER   │   │  FIGURE 1   │   │  FIGURE 2   │               │
│   │    (Ego)    │   │             │   │             │               │
│   │             │   │ Name:       │   │ Name:       │               │
│   │             │   │ Known?: Y/N │   │ Known?: Y/N │               │
│   │             │   │ Feeling:    │   │ Feeling:    │               │
│   └──────┬──────┘   └──────┬──────┘   └──────┬──────┘               │
│          │                 │                 │                      │
│          └─────────────────┼─────────────────┘                      │
│                            │                                        │
│                     RELATIONSHIPS                                   │
│                                                                     │
├─────────────────────────────────────────────────────────────────────┤
│                         KEY SYMBOLS                                 │
│                                                                     │
│   Symbol 1: ____________    Personal association: _______________   │
│   Symbol 2: ____________    Personal association: _______________   │
│   Symbol 3: ____________    Personal association: _______________   │
│                                                                     │
├─────────────────────────────────────────────────────────────────────┤
│                       INTERPRETATION LEVELS                         │
│                                                                     │
│   OBJECTIVE:    How does this relate to outer life situations?      │
│   _______________________________________________________________   │
│                                                                     │
│   SUBJECTIVE:   What parts of ME are these figures?                 │
│   _______________________________________________________________   │
│                                                                     │
│   ARCHETYPAL:   What universal pattern is active?                   │
│   _______________________________________________________________   │
│                                                                     │
├─────────────────────────────────────────────────────────────────────┤
│                         COMPENSATION                                │
│                                                                     │
│   What is my conscious attitude?                                    │
│   _______________________________________________________________   │
│                                                                     │
│   How might this dream compensate/balance that?                     │
│   _______________________________________________________________   │
│                                                                     │
└─────────────────────────────────────────────────────────────────────┘
```

---

## ACTIVE IMAGINATION GUIDE

### Process Flow

```
                ACTIVE IMAGINATION PROCESS
═════════════════════════════════════════════════════════════════════

┌───────────────────────────────────────────────────────────────────┐
│                        1. INVOCATION                              │
│                                                                   │
│   • Begin with an image (from dream, emotion, body sensation)     │
│   • Quiet the ego but don't extinguish it                         │
│   • Hold "alert passivity"                                        │
│                                                                   │
└────────────────────────────────┬──────────────────────────────────┘
                                 │
                                 ▼
┌───────────────────────────────────────────────────────────────────┐
│                        2. ENGAGEMENT                              │
│                                                                   │
│   • Allow the image to move, speak, act                           │
│   • DO NOT direct or control                                      │
│   • Ego remains present as witness AND participant                │
│   • Ask questions, respond genuinely                              │
│                                                                   │
└────────────────────────────────┬──────────────────────────────────┘
                                 │
                                 ▼
┌───────────────────────────────────────────────────────────────────┐
│                     3. ETHICAL STANDPOINT                         │
│                                                                   │
│   • Ego MUST maintain values                                      │
│   • You can disagree with the figure                              │
│   • Don't be swallowed by the unconscious                         │
│   • "The unconscious is not God" — ego maintains responsibility   │
│                                                                   │
└────────────────────────────────┬──────────────────────────────────┘
                                 │
                                 ▼
┌───────────────────────────────────────────────────────────────────┐
│                        4. EMBODIMENT                              │
│                                                                   │
│   • Record the experience (writing, painting, movement)           │
│   • Give it form in the outer world                               │
│   • Art-making as psychological work                              │
│                                                                   │
└────────────────────────────────┬──────────────────────────────────┘
                                 │
                                 ▼
┌───────────────────────────────────────────────────────────────────┐
│                        5. INTEGRATION                             │
│                                                                   │
│   • What does this mean for my life?                              │
│   • What action does it call for?                                 │
│   • How does this change my conscious position?                   │
│                                                                   │
└───────────────────────────────────────────────────────────────────┘
```
