# Unicode Box Drawing Characters

Complete reference for text-based diagram creation.

## Box Drawing (U+2500–U+257F)

### Light Lines

```
HORIZONTAL & VERTICAL
─  U+2500  Box Drawings Light Horizontal
│  U+2502  Box Drawings Light Vertical

CORNERS
┌  U+250C  Box Drawings Light Down and Right
┐  U+2510  Box Drawings Light Down and Left
└  U+2514  Box Drawings Light Up and Right
┘  U+2518  Box Drawings Light Up and Left

T-JUNCTIONS
├  U+251C  Box Drawings Light Vertical and Right
┤  U+2524  Box Drawings Light Vertical and Left
┬  U+252C  Box Drawings Light Down and Horizontal
┴  U+2534  Box Drawings Light Up and Horizontal

CROSS
┼  U+253C  Box Drawings Light Vertical and Horizontal
```

### Heavy Lines

```
HORIZONTAL & VERTICAL
━  U+2501  Box Drawings Heavy Horizontal
┃  U+2503  Box Drawings Heavy Vertical

CORNERS
┏  U+250F  Box Drawings Heavy Down and Right
┓  U+2513  Box Drawings Heavy Down and Left
┗  U+2517  Box Drawings Heavy Up and Right
┛  U+251B  Box Drawings Heavy Up and Left

T-JUNCTIONS
┣  U+2523  Box Drawings Heavy Vertical and Right
┫  U+252B  Box Drawings Heavy Vertical and Left
┳  U+2533  Box Drawings Heavy Down and Horizontal
┻  U+253B  Box Drawings Heavy Up and Horizontal

CROSS
╋  U+254B  Box Drawings Heavy Vertical and Horizontal
```

### Double Lines

```
HORIZONTAL & VERTICAL
═  U+2550  Box Drawings Double Horizontal
║  U+2551  Box Drawings Double Vertical

CORNERS
╔  U+2554  Box Drawings Double Down and Right
╗  U+2557  Box Drawings Double Down and Left
╚  U+255A  Box Drawings Double Up and Right
╝  U+255D  Box Drawings Double Up and Left

T-JUNCTIONS
╠  U+2560  Box Drawings Double Vertical and Right
╣  U+2563  Box Drawings Double Vertical and Left
╦  U+2566  Box Drawings Double Down and Horizontal
╩  U+2569  Box Drawings Double Up and Horizontal

CROSS
╬  U+256C  Box Drawings Double Vertical and Horizontal
```

### Rounded Corners

```
╭  U+256D  Box Drawings Light Arc Down and Right
╮  U+256E  Box Drawings Light Arc Down and Left
╯  U+256F  Box Drawings Light Arc Up and Left
╰  U+2570  Box Drawings Light Arc Up and Right
```

### Dashed Lines

```
LIGHT DASHED
┄  U+2504  Box Drawings Light Triple Dash Horizontal
┆  U+2506  Box Drawings Light Triple Dash Vertical
┈  U+2508  Box Drawings Light Quadruple Dash Horizontal
┊  U+250A  Box Drawings Light Quadruple Dash Vertical

HEAVY DASHED
┅  U+2505  Box Drawings Heavy Triple Dash Horizontal
┇  U+2507  Box Drawings Heavy Triple Dash Vertical
┉  U+2509  Box Drawings Heavy Quadruple Dash Horizontal
┋  U+250B  Box Drawings Heavy Quadruple Dash Vertical
```

### Mixed Weight (Light/Heavy)

```
CORNERS
┍  U+250D  Light Down and Heavy Right
┎  U+250E  Heavy Down and Light Right
┑  U+2511  Light Down and Heavy Left
┒  U+2512  Heavy Down and Light Left
┕  U+2515  Light Up and Heavy Right
┖  U+2516  Heavy Up and Light Right
┙  U+2519  Light Up and Heavy Left
┚  U+251A  Heavy Up and Light Left
```

### Mixed (Single/Double)

```
CORNERS
╒  U+2552  Down Single and Right Double
╓  U+2553  Down Double and Right Single
╕  U+2555  Down Single and Left Double
╖  U+2556  Down Double and Left Single
╘  U+2558  Up Single and Right Double
╙  U+2559  Up Double and Right Single
╛  U+255B  Up Single and Left Double
╜  U+255C  Up Double and Left Single
```

## Arrows

### Basic Arrows

```
←  U+2190  Leftwards Arrow
↑  U+2191  Upwards Arrow
→  U+2192  Rightwards Arrow
↓  U+2193  Downwards Arrow
↔  U+2194  Left Right Arrow
↕  U+2195  Up Down Arrow
```

### Heavy Arrows

```
◄  U+25C4  Black Left-Pointing Pointer
►  U+25BA  Black Right-Pointing Pointer
▲  U+25B2  Black Up-Pointing Triangle
▼  U+25BC  Black Down-Pointing Triangle
```

### Double Arrows

```
⇐  U+21D0  Leftwards Double Arrow
⇑  U+21D1  Upwards Double Arrow
⇒  U+21D2  Rightwards Double Arrow
⇓  U+21D3  Downwards Double Arrow
⇔  U+21D4  Left Right Double Arrow
⇕  U+21D5  Up Down Double Arrow
```

### Long Arrows

```
⟵  U+27F5  Long Leftwards Arrow
⟶  U+27F6  Long Rightwards Arrow
⟷  U+27F7  Long Left Right Arrow
⟸  U+27F8  Long Leftwards Double Arrow
⟹  U+27F9  Long Rightwards Double Arrow
⟺  U+27FA  Long Left Right Double Arrow
```

### Arrow Combinations (ASCII)

```
──►   Line with arrowhead
◄──   Line with left arrowhead
──►──  Through arrow
◄──►   Bidirectional
│
▼     Vertical with arrowhead
```

## Shapes & Symbols

### Bullets & List Markers

```
•  U+2022  Bullet
◦  U+25E6  White Bullet
○  U+25CB  White Circle
●  U+25CF  Black Circle
◯  U+25EF  Large Circle
□  U+25A1  White Square
■  U+25A0  Black Square
▪  U+25AA  Black Small Square
▫  U+25AB  White Small Square
◇  U+25C7  White Diamond
◆  U+25C6  Black Diamond
```

### Check Marks & Status

```
✓  U+2713  Check Mark
✔  U+2714  Heavy Check Mark
✗  U+2717  Ballot X
✘  U+2718  Heavy Ballot X
☐  U+2610  Ballot Box
☑  U+2611  Ballot Box with Check
☒  U+2612  Ballot Box with X
```

### Mathematical

```
×  U+00D7  Multiplication Sign
÷  U+00F7  Division Sign
±  U+00B1  Plus-Minus Sign
≈  U+2248  Almost Equal To
≠  U+2260  Not Equal To
≤  U+2264  Less-Than or Equal To
≥  U+2265  Greater-Than or Equal To
∞  U+221E  Infinity
```

### Block Elements

```
█  U+2588  Full Block
▓  U+2593  Dark Shade
▒  U+2592  Medium Shade
░  U+2591  Light Shade
▀  U+2580  Upper Half Block
▄  U+2584  Lower Half Block
▌  U+258C  Left Half Block
▐  U+2590  Right Half Block
```

## Quick Copy Reference

### Complete Box Sets

```
LIGHT BOX:
┌─┬─┐
├─┼─┤
│ │ │
└─┴─┘

HEAVY BOX:
┏━┳━┓
┣━╋━┫
┃ ┃ ┃
┗━┻━┛

DOUBLE BOX:
╔═╦═╗
╠═╬═╣
║ ║ ║
╚═╩═╝

ROUNDED BOX:
╭───╮
│   │
╰───╯
```

### Tree Structures

```
STANDARD TREE:
├── Item 1
│   ├── Sub 1.1
│   └── Sub 1.2
└── Item 2
    └── Sub 2.1

HEAVY TREE:
┣━━ Item 1
┃   ┣━━ Sub 1.1
┃   ┗━━ Sub 1.2
┗━━ Item 2
    ┗━━ Sub 2.1
```

### Arrow Connectors

```
HORIZONTAL FLOW:
[A] ──► [B] ──► [C]

VERTICAL FLOW:
[A]
 │
 ▼
[B]
 │
 ▼
[C]

BRANCHING:
    [A]
     │
  ┌──┴──┐
  ▼     ▼
 [B]   [C]

MERGING:
 [A]   [B]
  │     │
  └──┬──┘
     ▼
    [C]
```

## Monospace Font Requirements

For proper rendering, use monospace fonts:
- **Recommended:** JetBrains Mono, Fira Code, SF Mono, Consolas
- **System defaults:** Monaco (macOS), Consolas (Windows), DejaVu Sans Mono (Linux)

Test alignment:
```
┌─────────────────────────────┐
│ If this box is rectangular, │
│ your font supports box      │
│ drawing characters.         │
└─────────────────────────────┘
```
