# Anatomical Diagram Conventions

This reference covers the established conventions for medical and anatomical illustration that ensure scientific accuracy while maintaining the hand-drawn aesthetic.

---

## Core Principles of Medical Illustration

### 1. Accuracy Over Artistry

**Rule:** If forced to choose between beautiful and accurate, always choose accurate.

**Why:** Recovery education has medical implications. Mislabeling brain structures or showing incorrect relationships undermines trust and can spread misinformation.

**Application:**
- Use reference anatomy (Gray's Anatomy, medical textbooks)
- Verify structure names with medical sources
- Show spatial relationships correctly (what's anterior vs posterior)
- Maintain scale relationships (relative sizes matter)

---

### 2. Clarity Through Simplification

**Rule:** Show only what's necessary for understanding the concept.

**Why:** Anatomical completeness can obscure the educational point. If teaching about the salience network, you don't need to show every brain region.

**Application:**
- Omit structures not relevant to the concept
- Simplify complex forms into recognizable shapes
- Use labels to clarify what would otherwise need detailed rendering
- "Suggest" background structures with lighter lines

**Example:**
```
Teaching salience network:
✓ Show: ACC, insula, amygdala (relevant structures)
✓ Suggest: Overall brain outline, basic sulci (context)
✗ Omit: Cerebellum detail, cranial nerves, ventricles (irrelevant)
```

---

### 3. Standard Anatomical Planes

**Definitions:**

| Plane | Description | View | Use Case |
|-------|-------------|------|----------|
| **Sagittal** | Divides left/right, side view | Profile | Brain structures, midline comparison |
| **Coronal** | Divides front/back, face-on | Front view | Comparing hemispheres, symmetry |
| **Axial/Transverse** | Divides top/bottom, horizontal | Top-down | Showing depth, cross-sections |

**Visual Reference:**
```
Sagittal (side view):
     ╭─────╮
    ╱       ╲
   │  Brain  │ ← View from left side
    ╲       ╱
     ╰─────╯

Coronal (front view):
   ╭───┬───╮
  │ L │ R │ ← Left and right hemispheres visible
   ╰───┴───╯

Axial (top-down):
      ╭───╮
     ╱     ╲
    │   ^   │ ← Anterior (front) at top
    │  nose │
     ╲     ╱
      ╰───╯
```

**Choosing a Plane:**
- **Sagittal**: Best for showing depth (front vs back brain regions), midline structures
- **Coronal**: Best for comparing left/right, showing symmetry or asymmetry
- **Axial**: Best for showing surrounding structures, relative positions

**For Recovery Education:**
- **Most common**: Sagittal (shows prefrontal cortex, limbic system relationship)
- **Occasional**: Coronal (when comparing hemispheres)
- **Rare**: Axial (unless showing specific cross-section)

---

## Brain Anatomy Essentials

### Key Structures for Recovery Education

#### Prefrontal Cortex (PFC)
**Location:** Very front of brain, behind forehead
**Function:** Executive control, decision-making, impulse inhibition
**Recovery relevance:** Suppressed during active use, recovers slowly

**Diagram conventions:**
- Label: "Prefrontal Cortex (PFC)" or "Executive Control Center"
- Position: Anterior (front), visible in sagittal view
- Simplified shape: Rounded front section of brain
- Highlight: When showing damage/suppression (coral) or recovery (gold)

**Layperson explanation in margin notes:**
```
"The brain's CEO - makes decisions, says 'no' to impulses.
First to shut down during use, slow to recover."
```

---

#### Limbic System (Emotional Brain)
**Location:** Deep central brain, includes amygdala, hippocampus, ACC
**Function:** Emotion, motivation, memory, fight-or-flight
**Recovery relevance:** Hyperactive during use, drives cravings

**Diagram conventions:**
- Label: "Limbic System" or list components (amygdala, hippocampus, etc.)
- Position: Central, beneath cerebral cortex
- Simplified shape: Cluster of small structures
- Highlight: When showing hyperactivity (coral) or emotional dysregulation

**Layperson explanation in margin notes:**
```
"The emotional brain - fear, craving, fight-or-flight.
Screams 'I NEED THIS' louder than the PFC can say 'no.'"
```

---

#### Salience Network (ACC + Insula)
**Location:** ACC (anterior cingulate cortex) = midline front; Insula = deep within lateral sulcus
**Function:** Detects important stimuli, filters threat vs safety
**Recovery relevance:** Overactive in paranoia, triggers hypervigilance

**Diagram conventions:**
- Label: "Salience Network" with sub-labels for ACC and insula
- Position: ACC visible on sagittal midline, insula suggested within fold
- Simplified shape: ACC = curved band, insula = indicated region
- Highlight: When showing overactivity (coral) or recalibration (gold)

**Layperson explanation in margin notes:**
```
"The pattern detector - decides what's important/threatening.
On meth: Everything = potential threat (paranoia)."
```

---

#### Reward Pathway (VTA → Nucleus Accumbens → PFC)
**Location:** VTA (midbrain) → Nucleus Accumbens (ventral striatum) → PFC (frontal)
**Function:** Dopamine-driven motivation, "wanting" system
**Recovery relevance:** Hijacked by drugs, drives compulsive seeking

**Diagram conventions:**
- Show: Arrow pathway from VTA → NAc → PFC
- Label: "Dopamine Reward Pathway" or "Motivation Circuit"
- Simplified: Three labeled regions connected by arrows (don't detail each structure)
- Highlight: Pathway in teal (normal) vs coral (hijacked by drugs)

**Layperson explanation in margin notes:**
```
"The 'I want this' circuit. Normally: food, sex, connection.
On drugs: ONLY the drug matters."
```

---

### Anatomical Orientation Labels

**Standard directional terms:**

| Term | Opposite | Meaning | Example |
|------|----------|---------|---------|
| Anterior | Posterior | Front | "Prefrontal cortex is anterior" |
| Dorsal | Ventral | Top | "Dorsal ACC" |
| Medial | Lateral | Toward midline | "Medial prefrontal cortex" |
| Superior | Inferior | Above | "Superior temporal gyrus" |

**For layperson diagrams:**
- **Use sparingly**: Only when necessary for precision
- **Translate**: "Anterior cingulate (front part of cingulate)"
- **Show with arrows**: Visual indicators supplement text

**Example label:**
```
Instead of: "ACC (anterior, dorsal)"
Use: "Anterior Cingulate Cortex (ACC)" with arrow pointing to front/top region
```

---

## Labeling Conventions

### Hierarchy of Labels

**Three levels:**

1. **Primary labels** (16-18px, bold or all caps)
   - Major structures: "PREFRONTAL CORTEX"
   - Key regions: "LIMBIC SYSTEM"

2. **Secondary labels** (14-16px, normal case)
   - Substructures: "Nucleus Accumbens"
   - Specific regions: "Dorsolateral PFC"

3. **Descriptive annotations** (12-14px, italic or lighter)
   - Function: "Executive control center"
   - Context: "Reward motivation pathway"

**Visual hierarchy:**
```
PREFRONTAL CORTEX ← Primary (largest, boldest)
  │
  ├─ Dorsolateral region ← Secondary (medium)
  │
  └─ Executive control ← Annotation (smallest, lighter)
```

---

### Label Line Conventions

**Connecting labels to structures:**

**Leader line styles:**
- **Straight line + elbow**: Professional, clean (use for most labels)
- **Curved line**: Organic, flows with contours (use sparingly)
- **Dotted line**: Background structure (less emphasis)

**Example:**
```
                   Anterior Cingulate Cortex (ACC)
                   ↑
            ┌──────┘  ← Straight line with elbow
         ───▓▓▓───     ← Structure highlighted
```

**Rules:**
1. **No crossing lines**: Arrange labels to avoid line intersections
2. **Point precisely**: Line touches exact structure boundary
3. **Consistent angle**: Most lines at 45° or horizontal
4. **Adequate spacing**: Labels don't overlap structures

---

### Abbreviation Standards

**When to abbreviate:**
- Structure has commonly-used abbreviation (ACC, PFC, NAc)
- Space is limited for full name
- Repeated references in same diagram

**Format:**
```
First mention: "Anterior Cingulate Cortex (ACC)"
Subsequent: "ACC"
```

**Common abbreviations:**
- ACC = Anterior Cingulate Cortex
- PFC = Prefrontal Cortex
- NAc = Nucleus Accumbens
- VTA = Ventral Tegmental Area
- dlPFC = Dorsolateral Prefrontal Cortex
- vmPFC = Ventromedial Prefrontal Cortex
- OFC = Orbitofrontal Cortex

**Avoid obscure abbreviations:**
- Don't: "sgACC" (subgenual anterior cingulate)
- Do: "Lower ACC" or spell out full name

---

## Scale and Proportion

### Relative Sizes

**Rule:** Maintain approximate relative sizes of structures (don't exaggerate small structures just to label them).

**Brain region sizes (approximate):**
- Cerebral cortex: ~80% of brain volume
- Cerebellum: ~10%
- Brainstem: ~5%
- Deep structures (thalamus, basal ganglia): ~5%

**Visual check:**
```
Correct proportions:
  ╭─────────────╮ ← Cortex (large)
 ╱               ╲
│    ●  ●  ●     │ ← Deep structures (small)
│                │
 ╲    ╭──╮      ╱
  ╰───┴──┴─────╯
      ↑ Cerebellum (medium)

Wrong (exaggerated):
  ╭─────────╮
 ╱           ╲
│  ●●● ●●●   │ ← Deep structures too big
│  ●●● ●●●   │
 ╲           ╱
  ╰──╭───╮──╯
     ↑ Cerebellum too small
```

---

### Scale Bars

**When to include:**
- Any diagram showing anatomical structures
- When size comparison is relevant
- For scientific credibility

**Format:**
```
Bottom right corner:
├─────┤ 5 cm
```

**Specifications:**
- Length: 20-30% of diagram width
- Label: Size in cm (for brain: 5 cm typical)
- Style: Simple bracket with measurement
- Color: Charcoal #1a2332, 1-2px lines

**AI Prompt:**
```
"scale bar in bottom right corner showing 5 centimeters, simple bracket style,
charcoal ink (#1a2332), hand-drawn, approximate human brain scale"
```

---

## Cross-Sections and Depth

### Showing Internal Structures

**Challenge:** How to show structures inside the brain without dissection gore?

**Solutions:**

**1. "Windowing" (Cutaway View):**
- Show external brain outline
- "Cut away" a section to reveal internal structures
- Use lighter lines for cut edges

```
    ╭─────────╮
   ╱           ╲ ← External brain
  │   ┌─────┐  │
  │   │ ACC │  │ ← Internal structure visible
  │   └─────┘  │
   ╲           ╱
    ╰─────────╯
```

**AI Prompt:**
```
"cutaway view showing external brain outline with rectangular window revealing
internal anterior cingulate cortex, lighter lines for cut edges, anatomical
illustration style"
```

---

**2. "Ghosting" (Transparency):**
- Show external structures at 30-40% opacity
- Internal structures at 100% opacity
- Label both layers

```
External (light):  ╭ ─ ─ ─ ─ ╮
                  ╱           ╲
Internal (dark):  │    ●      │ ← Visible through transparency
                   ╲           ╱
                    ╰ ─ ─ ─ ─ ╯
```

**AI Prompt:**
```
"brain cortex shown at 30% opacity (ghosted) to reveal internal limbic structures
at 100% opacity, layered transparency, anatomical illustration"
```

---

**3. "Exploded View":**
- Separate structures spatially
- Show relationships with arrows or labels
- Maintain relative positions

```
   ╭─────╮
  ╱ PFC  ╲     ← Separated but positioned correctly
 ╰───────╯

    ●  ●  ●     ← Deep structures (NAc, etc.)

   ╭─────╮
  ╱ Limb ╲     ← Limbic system
 ╰───────╯
```

---

## Color Coding for Functional States

### Standard Color Meanings (Consistent Across All Diagrams)

| State | Color | Opacity | Application |
|-------|-------|---------|-------------|
| **Normal/Baseline** | Charcoal #1a2332 | 100% | Non-highlighted structures |
| **Active/Positive** | Teal #4a9d9e | 40% fill, 100% outline | Functional activation, healthy state |
| **Hyperactive/Dysfunctional** | Coral #e63946 | 40% fill, 100% outline | Overactivity, damage, problematic |
| **Healing/Recovery** | Gold #f4a261 | 40% fill, 100% outline | Neuroplasticity, progress |

**Example application:**

**Diagram: "Salience Network in Paranoia"**
```
Brain outline: Charcoal (baseline)
ACC + Insula: Coral highlight (hyperactive, problematic)
Other regions: Charcoal (not involved)
```

**Diagram: "Prefrontal Cortex Recovery"**
```
Brain outline: Charcoal
PFC at month 0: Coral highlight (suppressed)
PFC at month 6: Gold highlight (healing)
PFC at month 12: Teal highlight (recovered)
```

---

## Common Mistakes to Avoid

### Mistake 1: Mirror Image Confusion

**Problem:** Sagittal views can be from left or right side—easy to flip.

**Convention:** Left-side view is standard (nose points right on page).

**Check:**
```
Correct (left-side view):
    ╭─────╮
   ╱       ╲  → Nose points right
  │         │
   ╲       ╱
    ╰─────╯

Wrong (right-side view):
    ╭─────╮
 ← ╱       ╲  Nose points left (unusual)
  │         │
   ╲       ╱
    ╰─────╯
```

**Fix:** Specify in AI prompt: "left-side view, nose pointing right"

---

### Mistake 2: Cartoon Brain vs Anatomical Brain

**Problem:** Simplified "blob" brain loses anatomical landmarks.

**Cartoon brain (too simple):**
```
    ●
  ╱   ╲
 ●─────●  ← No sulci, no regions, just blob
  ╲   ╱
    ●
```

**Anatomical brain (appropriate simplification):**
```
    ╭───╮
   ╱╭─╮ ╲  ← Frontal lobe indicated
  │ │  │ │
  │ ╰──╯ │  ← Central sulcus suggested
   ╲    ╱
    ╰──╯   ← Cerebellum suggested
```

**Fix:** Include basic landmarks (sulci, lobes) even if simplified.

---

### Mistake 3: Incorrect Spatial Relationships

**Problem:** Structures shown in wrong relative positions.

**Wrong:**
```
╭─────────╮
│  NAc    │ ← Nucleus accumbens in FRONT of brain? No!
│    PFC  │
╰─────────╯
```

**Correct:**
```
╭─────────╮
│  PFC    │ ← PFC is anterior (front)
│    NAc  │ ← NAc is deeper, more central
╰─────────╯
```

**Fix:** Use anatomical atlas reference (Gray's Anatomy, BrainMaps.org).

---

### Mistake 4: Over-Labeling

**Problem:** Too many labels obscure the diagram.

**Over-labeled:**
```
╭─────────╮
│ 1 2 3 4 │ ← 20+ labeled structures
│ 5 6 7 8 │
│ 9 10 11 │
╰─────────╯
```

**Appropriately labeled (3-5 key structures):**
```
╭─────────╮
│  1      │ ← PFC (key structure)
│    2    │ ← ACC (key structure)
│      3  │ ← Amygdala (key structure)
╰─────────╯
```

**Fix:** Label only structures relevant to the educational concept.

---

## Reference Resources

### Anatomical Atlases (Free/Public Domain)
- **Gray's Anatomy** (1918 edition) - Public domain, classic illustrations
- **BrainMaps.org** - High-resolution brain images, various planes
- **The Human Brain Atlas** (neuroscientist.com) - Interactive web atlas

### Medical Illustration Textbooks
- **"Medical Illustration Sourcebook"** by Peter Cull (techniques)
- **"Grant's Atlas of Anatomy"** (standard reference)
- **"Netter's Atlas of Human Anatomy"** (beautiful, accurate)

### Neuroscience References
- **"The Human Brain Book"** by Rita Carter (layperson-friendly)
- **"Neuroanatomy through Clinical Cases"** by Hal Blumenfeld (clinical)
- **"Principles of Neural Science"** by Kandel et al. (comprehensive)

### Verification Tools
- **PubMed** (pubmed.ncbi.nlm.nih.gov) - Verify structure names and functions
- **NeuroNames** (braininfo.org) - Standardized neuroanatomy nomenclature
- **Allen Brain Atlas** (brain-map.org) - Gene expression + anatomy

---

## Quality Checklist

Before finalizing any anatomical diagram:

### Scientific Accuracy
- [ ] Structure names verified against medical source
- [ ] Spatial relationships correct (anterior/posterior, etc.)
- [ ] Relative sizes approximately correct
- [ ] Functions accurately described in margin notes

### Anatomical Conventions
- [ ] Standard plane used (sagittal, coronal, or axial)
- [ ] Left-side view for sagittal (nose points right)
- [ ] Scale bar included (5 cm for brain)
- [ ] Abbreviations defined on first use

### Clarity
- [ ] Only relevant structures labeled (3-5 maximum)
- [ ] Labels don't overlap or obscure structures
- [ ] Leader lines don't cross
- [ ] Hierarchy clear (primary vs secondary labels)

### Accessibility
- [ ] Layperson explanations in margin notes
- [ ] Technical terms translated ("ACC = pattern detector")
- [ ] Color coding explained (not relied upon alone)
- [ ] Alt text includes structure names and relationships

---

**Last Updated:** 2026-01-11
**Version:** 1.0.0
**Skill:** hand-drawn-infographic-creator
