# Example: Shadow Work Session with Diagram Integration

This example demonstrates how the `jungian-psychologist` and `diagramming-expert` skills work together in practice.

---

## The Prompt

**User**: "I've noticed I get really angry when people don't follow through on commitments. It feels disproportionate to the situation. Can you help me explore this from a Jungian perspective?"

---

## Step 1: Shadow Recognition

First, we identify that this intense emotional reaction is a classic shadow marker:

```
SHADOW RECOGNITION MARKERS ACTIVATED
════════════════════════════════════════════════════════════

    Your experience:                     What it indicates:
    ────────────────                     ──────────────────

    ┌─────────────────────────┐         ┌─────────────────────────┐
    │  "Really angry"         │────────►│  Disproportionate       │
    │                         │         │  affect = Shadow        │
    └─────────────────────────┘         └─────────────────────────┘

    ┌─────────────────────────┐         ┌─────────────────────────┐
    │  "Disproportionate      │────────►│  You recognize it       │
    │   to the situation"     │         │  doesn't match reality  │
    └─────────────────────────┘         └─────────────────────────┘

    ┌─────────────────────────┐         ┌─────────────────────────┐
    │  About others not       │────────►│  Projection onto        │
    │  following through      │         │  external figures       │
    └─────────────────────────┘         └─────────────────────────┘

             │
             ▼
    ┌────────────────────────────────────────────────────────┐
    │  HYPOTHESIS: Something about "not following through"   │
    │  lives in YOUR shadow and is being projected.          │
    └────────────────────────────────────────────────────────┘
```

---

## Step 2: Mapping the Complex

We create a complex diagram to explore the structure:

```
COMPLEX ANALYSIS: The "Unreliable One"
════════════════════════════════════════════════════════════

              ┌─────────────────────────────┐
              │      ARCHETYPAL CORE        │
              │                             │
              │   The Trickster / Puer      │
              │   (eternal youth, avoiding  │
              │    commitments, freedom)    │
              └──────────────┬──────────────┘
                             │
              ┌──────────────▼──────────────┐
              │      PERSONAL SHELL         │
              │                             │
              │   Early experiences:        │
              │   • Parent who broke        │
              │     promises?               │
              │   • Times YOU didn't        │
              │     follow through?         │
              │   • Being called            │
              │     "unreliable"?           │
              └──────────────┬──────────────┘
                             │
              ┌──────────────▼──────────────┐
              │     AFFECTIVE CHARGE        │
              │                             │
              │   Intensity: 8/10           │
              │                             │
              │   Body: Jaw clenches        │
              │         Chest tightens      │
              │         Heat rises          │
              └─────────────────────────────┘

    TRIGGER PATTERN:

        External event        →       Internal response
        ───────────────────           ────────────────────

        Someone cancels       →       Rage (8/10)
        late notice

        Deadline missed       →       Contempt + anger
        by colleague

        Partner forgets       →       "You can't rely on
        something                     anyone" (despair)
```

---

## Step 3: The Shadow Inquiry

Now we explore: what might YOU be denying about unreliability?

```
SHADOW INQUIRY: What's Being Projected?
════════════════════════════════════════════════════════════

         THE QUESTION TO SIT WITH:
    ┌────────────────────────────────────────────────────────┐
    │                                                        │
    │  "Where in YOUR life do YOU not follow through?"       │
    │                                                        │
    │  OR                                                    │
    │                                                        │
    │  "Where do you WISH you could be less reliable?"       │
    │  (The gold in the shadow)                              │
    │                                                        │
    └────────────────────────────────────────────────────────┘

POSSIBLE SHADOW CONTENTS:
┌─────────────────────────────────────────────────────────────┐
│                                                             │
│   NEGATIVE SHADOW:                                          │
│   ─────────────────                                         │
│   • Times you've broken commitments (and felt shame)        │
│   • Promises to yourself you don't keep                     │
│   • Areas where you're actually unreliable                  │
│   • Fear that YOU are fundamentally unreliable              │
│                                                             │
│   GOLDEN SHADOW:                                            │
│   ─────────────────                                         │
│   • Desire for more freedom/flexibility                     │
│   • Envy of those who live more spontaneously              │
│   • Exhaustion from always being "the reliable one"         │
│   • Need to say "no" more often                            │
│   • Permission to change your mind                          │
│                                                             │
└─────────────────────────────────────────────────────────────┘

         ┌────────────────────────────────────────┐
         │  The shadow always contains BOTH.      │
         │                                        │
         │  What we reject in others is what      │
         │  we cannot accept in ourselves—        │
         │  whether dark OR light.                │
         └────────────────────────────────────────┘
```

---

## Step 4: Parts Work Map

We map the inner figures involved:

```
PARTS WORK MAP: Who's Inside This Reaction?
════════════════════════════════════════════════════════════

                    ┌───────────────────────────┐
                    │        WISE SELF          │
                    │                           │
                    │   "I can hold all these   │
                    │    parts with compassion"  │
                    │                           │
                    └─────────────┬─────────────┘
                                  │
              ┌───────────────────┴───────────────────┐
              │                                       │
              ▼                                       ▼
   ┌────────────────────┐               ┌────────────────────┐
   │    THE JUDGE       │               │   THE CHILD        │
   │                    │               │                    │
   │  "People should    │               │  "When they don't  │
   │   keep their       │               │   show up, it      │
   │   word!"           │               │   means I don't    │
   │                    │               │   matter"          │
   │  Wants: Order,     │               │                    │
   │   predictability,  │               │  Wants: To be      │
   │   control          │               │   important enough │
   │                    │               │   to show up for   │
   └──────────┬─────────┘               └──────────┬─────────┘
              │                                    │
              │         ┌────────────────┐         │
              │         │                │         │
              └────────►│  THE SHADOW    │◄────────┘
                        │  (unreliable   │
                        │   one)         │
                        │                │
                        │  Hidden needs: │
                        │  • Freedom     │
                        │  • Flexibility │
                        │  • Permission  │
                        │    to fail     │
                        └────────────────┘

   DIALOGUE POSSIBILITY:
   ┌─────────────────────────────────────────────────────────┐
   │  Judge → "You must always follow through!"             │
   │  Shadow → "That's exhausting. Sometimes I can't."       │
   │  Child → "But if I don't, no one will love me."        │
   │  Wise Self → "What if reliability isn't love? What if  │
   │              you could be imperfect and still worthy?" │
   └─────────────────────────────────────────────────────────┘
```

---

## Step 5: Active Imagination Exercise

We suggest a specific active imagination dialogue:

```
ACTIVE IMAGINATION PROMPT
════════════════════════════════════════════════════════════

    Recall a recent incident when someone didn't follow through
    and you felt that disproportionate anger.

    Now, in your imagination:

    1. See the person who didn't follow through

    2. Notice: they have YOUR face
       (This is the shadow figure)

    3. Ask this figure:

       ┌─────────────────────────────────────────────────────┐
       │  "What do you need?"                               │
       │  "What are you trying to escape from?"             │
       │  "What would you do if you were free?"             │
       │  "What are you protecting me from knowing?"        │
       └─────────────────────────────────────────────────────┘

    4. Write down what you hear

    5. Ask yourself: "What part of this might be true about me?"

───────────────────────────────────────────────────────────────

CAUTION: If this brings up intense material, stop and ground.
If overwhelming, seek support from a Jungian analyst.
```

---

## Step 6: Integration Path

We map the path forward:

```
INTEGRATION PATHWAY
════════════════════════════════════════════════════════════

    WEEK 1                WEEK 2-3              ONGOING
    ──────                ────────              ───────
       │                     │                     │
       ▼                     ▼                     ▼
┌─────────────────┐  ┌─────────────────┐  ┌─────────────────┐
│   AWARENESS     │  │   COMPASSION    │  │   INTEGRATION   │
│                 │  │                 │  │                 │
│ • Notice when   │  │ • When anger    │  │ • Ask: Where    │
│   anger arises  │  │   arises, pause │  │   might I need  │
│   about this    │  │                 │  │   more freedom? │
│                 │  │ • Ask: "What    │  │                 │
│ • Track         │  │   part of me    │  │ • Practice      │
│   intensity     │  │   is this?"     │  │   saying "no"   │
│   (journal)     │  │                 │  │   occasionally  │
│                 │  │ • Speak kindly  │  │                 │
│ • Notice body   │  │   to the shadow │  │ • Allow         │
│   sensations    │  │   part          │  │   imperfection  │
│                 │  │                 │  │                 │
└─────────────────┘  └─────────────────┘  └─────────────────┘
       │                     │                     │
       │                     │                     │
       └─────────────────────┼─────────────────────┘
                             │
                             ▼
              ┌──────────────────────────────────┐
              │  INDICATOR OF PROGRESS:          │
              │                                  │
              │  When someone doesn't follow     │
              │  through, you still feel         │
              │  something—but it's proportionate│
              │  to the situation, and you can   │
              │  respond rather than react.      │
              └──────────────────────────────────┘
```

---

## Key Jungian Insights Applied

1. **Projection**: The intensity of your reaction indicates projection—something in you is being cast onto others.

2. **Shadow**: Both negative (your own unreliability) and positive (desire for freedom) shadow content may be present.

3. **Complex**: The reaction has an archetypal core (Trickster/Puer) and a personal shell (your history with reliability).

4. **Parts Work**: Multiple inner figures are involved, each with valid needs.

5. **Integration**: The goal isn't to stop feeling—it's to feel *proportionately* and respond consciously.

---

## Skills Used

- **jungian-psychologist**: Complex analysis, shadow work theory, active imagination protocol
- **diagramming-expert**: Visual mapping of psyche structure, parts relationships, integration pathways

---

*Remember: This is educational self-exploration, not therapy. If this material feels overwhelming or triggers significant distress, seek support from a qualified Jungian analyst.*
