# Structure of the Psyche

## Comprehensive Psyche Model

```
                    ┌─────────────────────────────────────────┐
                    │           COLLECTIVE UNCONSCIOUS         │
                    │                                         │
                    │    ┌─────────────────────────────┐     │
                    │    │       ARCHETYPES            │     │
                    │    │                             │     │
                    │    │  Self ─── Shadow ─── Anima  │     │
                    │    │    │         │        /     │     │
                    │    │  Wise Old   Trickster Animus│     │
                    │    │   Figure       │            │     │
                    │    │    │       Great Mother     │     │
                    │    │  Divine    /      \         │     │
                    │    │  Child   Hero    Puer/      │     │
                    │    │               Senex         │     │
                    │    └─────────────────────────────┘     │
                    │                                         │
├───────────────────┴─────────────────────────────────────────┤
│                    PERSONAL UNCONSCIOUS                      │
│                                                              │
│   ┌──────────────────────────────────────────────────────┐  │
│   │                   COMPLEXES                          │  │
│   │                                                      │  │
│   │  [Mother Complex] [Father Complex] [Inferiority]     │  │
│   │                                                      │  │
│   │  Each complex has:                                   │  │
│   │  - Archetypal core (universal)                       │  │
│   │  - Personal shell (individual experience)            │  │
│   │  - Emotional charge (affective tone)                 │  │
│   │  - Autonomy (can "possess" ego)                      │  │
│   └──────────────────────────────────────────────────────┘  │
│                                                              │
├──────────────────────────────────────────────────────────────┤
│                          EGO                                 │
│                                                              │
│   The center of consciousness. NOT the whole Self.           │
│   Maintains continuity of identity.                          │
│   Mediates between inner and outer worlds.                   │
│                                                              │
├──────────────────────────────────────────────────────────────┤
│                        PERSONA                               │
│                                                              │
│   The mask worn for social adaptation.                       │
│   Necessary but dangerous if identified with.                │
│   "Persona" = Latin for theatrical mask.                     │
│                                                              │
└──────────────────────────────────────────────────────────────┘
```

## The Shadow (Beyond Simplification)

Jung's shadow is not simply "the dark side" - it's far more nuanced:

```
THE SHADOW CONTAINS:

1. REPRESSED NEGATIVE QUALITIES
   └── What we deny in ourselves and project onto others
   └── "I'm not angry, YOU'RE angry"

2. REPRESSED POSITIVE QUALITIES (Gold in the Shadow)
   └── Capacities we've disowned
   └── Creativity, power, sexuality, spontaneity
   └── Often more threatening than negative qualities

3. UNLIVED LIFE
   └── Roads not taken
   └── The person we might have been
   └── Accumulated unlived potential

4. COLLECTIVE SHADOW
   └── Cultural repressions shared by groups
   └── Historical atrocities, systemic injustice
   └── "Nice" cultures often have brutal shadows

SHADOW RECOGNITION MARKERS:
├── Intense emotional reaction (attraction OR repulsion)
├── Projection onto others ("I can't stand people who...")
├── Slips of the tongue, "accidental" behaviors
├── Dream figures (same-sex, often dark or inferior)
└── What we're most defensive about when accused
```

## Anima/Animus (Updated Framework)

Jung's original formulation was binary and heteronormative. Contemporary Jungian thought has evolved:

```
CLASSICAL MODEL (Jung, 1927)
├── Anima: Man's inner feminine
│   └── Stages: Eve → Helen → Mary → Sophia
├── Animus: Woman's inner masculine
│   └── Stages: Physical power → Romance → Word → Meaning

CONTEMPORARY UNDERSTANDING
├── Contrasexual archetype exists in all psyches
├── Not bound by biological sex or gender identity
├── Represents the "Other" in relationship/creativity
├── Syzygy: Divine marriage of opposites within Self

PRACTICAL INDICATORS
├── Anima possession: Moodiness, sentimentality, resentment
├── Animus possession: Opinionatedness, argumentativeness
├── Integration: Creative capacity, soul connection
└── Projections: Who we fall in love with shows our anima/animus
```

## The Individuation Process

```
INDIVIDUATION: "The process by which a person becomes a psychological
               individual, a separate indivisible unity or whole."
               - CW9i, para 490

STAGES (not linear - spiral)

1. PERSONA DISSOLUTION
   ├── Crisis that reveals persona is not the whole self
   ├── Often triggered by failure, loss, illness
   └── "Midlife crisis" is classic but can happen anytime

2. SHADOW ENCOUNTER
   ├── Meeting the rejected aspects of self
   ├── "Where there is light, there is shadow"
   ├── Integration, not elimination, is the goal
   └── Shadow becomes ally and source of vitality

3. ANIMA/ANIMUS INTEGRATION
   ├── Working through projections in relationships
   ├── Accessing contrasexual creative energy
   └── Inner marriage preparation

4. SELF ENCOUNTER
   ├── Experience of the organizing center of psyche
   ├── Ego relativized but not destroyed
   ├── Paradox: Ego must be strong to surrender to Self
   └── Symbols: Mandala, divine child, philosopher's stone

5. SELF-REALIZATION (ongoing)
   ├── Never complete in lifetime
   ├── Becoming who you were meant to be
   ├── Tension of opposites held consciously
   └── Service to collective becomes possible
```

## Complex Theory

```
COMPLEX: "A feeling-toned group of representations in the unconscious"
         - CW 2, para 331

ANATOMY OF A COMPLEX

         ┌─────────────────────────────────────────┐
         │          COMPLEX STRUCTURE              │
         │                                         │
         │   ┌───────────────────────────────┐   │
         │   │     ARCHETYPAL CORE           │   │
         │   │   (Universal, numinous)       │   │
         │   └───────────────┬───────────────┘   │
         │                   │                    │
         │   ┌───────────────▼───────────────┐   │
         │   │     PERSONAL SHELL            │   │
         │   │  (Individual experiences,     │   │
         │   │   memories, associations)     │   │
         │   └───────────────┬───────────────┘   │
         │                   │                    │
         │   ┌───────────────▼───────────────┐   │
         │   │    AFFECTIVE CHARGE           │   │
         │   │  (Emotional intensity,        │   │
         │   │   autonomy, possession        │   │
         │   │   potential)                  │   │
         │   └───────────────────────────────┘   │
         │                                         │
         └─────────────────────────────────────────┘

COMPLEX INDICATORS
├── Strong affect disproportionate to situation
├── Loss of ego control (doing/saying things "not like me")
├── Projection (seeing the complex in others)
├── Somatic symptoms (body holds complex)
├── Parapraxes (slips, forgetting, accidents)
└── Dreams featuring complex personified

WORKING WITH COMPLEXES
├── Recognize the complex is activated (somatic awareness)
├── Differentiate ego from complex ("I have this complex")
├── Explore the personal history (where did this begin?)
├── Connect to archetypal core (what universal pattern?)
├── Dialogue with personified complex (active imagination)
└── Integration (complex becomes available energy)
```

---

## The Ego-Self Axis

The ego-Self axis is one of the most clinically significant concepts in Jungian psychology, developed extensively by Edward Edinger. It describes the vital connection between the ego (center of consciousness) and the Self (the totality of the psyche).

```
THE EGO-SELF AXIS
════════════════════════════════════════════════════════════

                    ┌─────────────────┐
                    │      SELF       │
                    │   (Totality,    │
                    │   Organizing    │
                    │   Center)       │
                    └────────┬────────┘
                             │
                    THE AXIS │ (connection)
                             │
                    ┌────────▼────────┐
                    │      EGO        │
                    │   (Center of    │
                    │   Consciousness)│
                    └─────────────────┘

HEALTHY AXIS:
├── Ego receives guidance from Self
├── Ego maintains appropriate humility
├── Meaning and purpose flow through axis
├── Resilience in face of challenges
└── Access to deeper wisdom

DAMAGED AXIS:
├── Ego cut off from Self (alienation)
├── Or ego identified with Self (inflation)
├── Loss of meaning, depression, addiction
├── Compensatory behaviors to fill void
└── Existential emptiness
```

### Developmental Phases (Edinger)

```
EGO-SELF AXIS DEVELOPMENT
════════════════════════════════════════════════════════════

FIRST HALF OF LIFE: Separation

    INFANCY                    ADULTHOOD
        │                          │
        ▼                          ▼
    ┌───────┐                  ┌───────┐
    │ SELF  │                  │ SELF  │
    │┌─────┐│                  │       │
    ││ ego ││   ────────►      │       │
    │└─────┘│   Separation     └───┬───┘
    └───────┘                      │
                               ┌───▼───┐
    Ego emerges FROM Self      │  EGO  │
    Originally contained       │       │
                               └───────┘
                               Ego distinct,
                               axis maintained

SECOND HALF OF LIFE: Reunion

    MIDLIFE CRISIS              SELF-REALIZATION
        │                           │
        ▼                           ▼
    ┌───────┐                   ┌───────┐
    │ SELF  │                   │ SELF  │
    │       │                   │┌─────┐│
    └───┬───┘   ────────►       ││ ego ││
        ╳ (broken)              │└─────┘│
    ┌───▼───┐   Restoration     └───────┘
    │  EGO  │                   Ego returns to Self
    │(lost) │                   but now CONSCIOUS
    └───────┘                   of relationship
```

### Axis Pathology

```
DAMAGED EGO-SELF AXIS PRESENTATIONS
════════════════════════════════════════════════════════════

1. ALIENATION (Axis Severed)
   ┌─────────────────────────────────────────────────────┐
   │                                                     │
   │   SELF                                              │
   │   ┌───┐                                             │
   │   │   │ ←── No connection                           │
   │   └───┘                                             │
   │                                                     │
   │         ╳ ╳ ╳  (broken axis)                        │
   │                                                     │
   │   EGO                                               │
   │   ┌───┐                                             │
   │   │   │ ←── Cut off, alone, meaningless            │
   │   └───┘                                             │
   │                                                     │
   │   Presents as: Depression, emptiness, nihilism,     │
   │   addiction (substitute for Self-connection),       │
   │   chronic meaninglessness                           │
   │                                                     │
   └─────────────────────────────────────────────────────┘

2. INFLATION (Ego Identified with Self)
   ┌─────────────────────────────────────────────────────┐
   │                                                     │
   │   ┌─────────────────┐                               │
   │   │      SELF       │                               │
   │   │   ┌─────────┐   │                               │
   │   │   │   EGO   │   │ ←── Ego THINKS it IS Self    │
   │   │   │  "I am  │   │                               │
   │   │   │  God"   │   │                               │
   │   │   └─────────┘   │                               │
   │   └─────────────────┘                               │
   │                                                     │
   │   Presents as: Grandiosity, messianic complex,      │
   │   addiction to power, narcissism, inability to      │
   │   accept limitations, "chosen" feelings             │
   │                                                     │
   └─────────────────────────────────────────────────────┘

3. ADDICTION (Substitute Axis)
   ┌─────────────────────────────────────────────────────┐
   │                                                     │
   │   SELF (inaccessible)                               │
   │   ┌───┐                                             │
   │   │░░░│ ←── Blocked                                 │
   │   └───┘                                             │
   │         ╳                                           │
   │                     SUBSTANCE/BEHAVIOR              │
   │   EGO ────────────► ┌───────────────┐              │
   │   ┌───┐             │ Pseudo-Self   │              │
   │   │   │ ──────────► │ (false axis)  │              │
   │   └───┘             └───────────────┘              │
   │                                                     │
   │   The substance provides temporary "Self" contact   │
   │   but ultimately deepens the alienation            │
   │                                                     │
   └─────────────────────────────────────────────────────┘
```

### Axis Restoration

```
RESTORING THE EGO-SELF AXIS
════════════════════════════════════════════════════════════

PHASE 1: RECOGNITION
├── Acknowledge the disconnection
├── Feel the emptiness consciously
├── Stop filling void with substitutes
└── "I am cut off from something vital"

PHASE 2: SURRENDER
├── Ego admits it is not the whole
├── Acceptance of limitation
├── Opening to something greater
└── "I cannot do this alone"

PHASE 3: BREAKTHROUGH
├── Numinous experience (dream, synchronicity, crisis)
├── Glimpse of Self (often through suffering)
├── Ego relativized but not destroyed
└── "Something larger is at work"

PHASE 4: ONGOING RELATIONSHIP
├── Regular dialogue (dreams, active imagination)
├── Ego serves Self's purposes
├── Meaning flows through axis
├── Suffering becomes meaningful
└── "I am part of something whole"

                    ┌─────────────────┐
                    │      SELF       │
                    │                 │
                    └────────┬────────┘
                             │
                    ═════════╪═════════  Restored axis
                             │          (conscious now)
                    ┌────────▼────────┐
                    │      EGO        │
                    │  (humbled but   │
                    │   connected)    │
                    └─────────────────┘
```

---

## Persona Development

The persona ("mask" in Latin) is the social face we present to the world. It's necessary for adaptation but becomes problematic when mistaken for the whole self.

```
PERSONA FORMATION ACROSS THE LIFESPAN
════════════════════════════════════════════════════════════

CHILDHOOD (0-12):
├── Persona emerges from family expectations
├── "Good child," "smart one," "troublemaker"
├── Adaptive masks for survival
└── Usually unconscious

ADOLESCENCE (12-25):
├── Persona experimentation
├── Trying on identities
├── Peer-based persona development
├── Often dramatic shifts
└── Beginning of persona-ego confusion

EARLY ADULTHOOD (25-40):
├── Professional persona crystallizes
├── Social roles solidify
├── Marriage/parent persona layers add
├── Height of persona-identification risk
└── "I am my job/role"

MIDLIFE (40-60):
├── Persona often CRACKS
├── "Is this all there is?"
├── Roles no longer satisfy
├── Shadow erupts, persona inadequate
└── Crisis OR individuation opportunity

LATER LIFE (60+):
├── Persona naturally softens
├── Less investment in image
├── Or tragic rigidification
├── Wisdom: persona as tool, not identity
└── "I wear masks, but I am not my masks"
```

### Healthy vs. Unhealthy Persona

```
PERSONA HEALTH SPECTRUM
════════════════════════════════════════════════════════════

HEALTHY PERSONA                    UNHEALTHY PERSONA
───────────────                    ─────────────────

Flexible                           Rigid
├── Can adapt to context           ├── Same mask everywhere
├── Multiple personas available    ├── One persona only
└── Chosen consciously             └── Unconsciously stuck

Connected to True Self             Disconnected from True Self
├── Persona expresses self         ├── Persona hides self
├── Feels authentic                ├── Feels fake
└── Inner/outer congruent          └── Inner/outer split

Protective                         Defensive
├── Shields vulnerability          ├── Walls off ALL feeling
│   appropriately                  ├── Cannot be vulnerable
└── Can be lowered with trust      └── Never comes down

Adaptive                           Compensatory
├── Serves social function         ├── Covers inferiority
├── Facilitates connection         ├── Prevents connection
└── Reality-based                  └── Fantasy-based

PERSONA RIGIDITY INDICATORS:
├── Cannot behave differently in different contexts
├── Devastation when persona is threatened
├── Identity crisis if role is lost (retirement, divorce)
├── Others experience you as "fake" or "surface"
├── Exhaustion from maintaining image
└── Dreams of masks, costumes, or being "seen through"
```

### Persona Crisis

```
PERSONA CRISIS DYNAMICS
════════════════════════════════════════════════════════════

              TRIGGER EVENT
              (job loss, divorce, failure,
               illness, success overwhelm)
                      │
                      ▼
         ┌────────────────────────────┐
         │    PERSONA CRACKS          │
         │                            │
         │    "Who am I really?"      │
         │    "This isn't me"         │
         │    "I don't know myself"   │
         └────────────┬───────────────┘
                      │
          ┌───────────┼───────────┐
          │           │           │
          ▼           ▼           ▼
    ┌──────────┐ ┌──────────┐ ┌──────────┐
    │ NEGATIVE │ │ PERSONA  │ │ POSITIVE │
    │  RESTORE │ │  ABSENCE │ │  RESTORE │
    │          │ │          │ │          │
    │ Rebuild  │ │ Lost,    │ │ More     │
    │ same     │ │ confused,│ │ authentic│
    │ rigid    │ │ identity │ │ flexible │
    │ persona  │ │ diffusion│ │ persona  │
    │          │ │          │ │ emerges  │
    │ (denial) │ │ (crisis) │ │ (growth) │
    └──────────┘ └──────────┘ └──────────┘

Jung warned: "One could say, with a little exaggeration,
that the persona is that which in reality one is not,
but which oneself as well as others think one is."
                                        - CW 9i, para. 221
```

---

## The Transcendent Function

The transcendent function is Jung's term for the psyche's capacity to reconcile opposites through symbol formation. It's central to psychological growth.

```
THE TRANSCENDENT FUNCTION
════════════════════════════════════════════════════════════

"The transcendent function arises from the union of
conscious and unconscious contents."
                                        - CW 8, para. 131

STRUCTURE:

        THESIS                          ANTITHESIS
    (Conscious position)            (Unconscious position)
            │                               │
            │         TENSION               │
            └───────────►◄──────────────────┘
                         │
                         │ Held consciously
                         │ (not resolved logically)
                         │
                         ▼
                    ┌─────────┐
                    │ SYMBOL  │
                    │ emerges │
                    └────┬────┘
                         │
                         │ Neither thesis nor antithesis
                         │ but something NEW
                         │
                         ▼
                    SYNTHESIS
               (Third position)

This is NOT compromise or middle ground.
It's emergence of a genuinely new perspective.
```

### Why Symbol, Not Logic?

```
SYMBOL vs. LOGICAL RESOLUTION
════════════════════════════════════════════════════════════

LOGICAL APPROACH (fails for psyche):

    Thesis + Antithesis = Compromise

    "I want freedom" + "I need security"
         │                    │
         └────────►◄──────────┘
                   │
                   ▼
         "Some freedom, some security"
         (Neither fully satisfied)
         (Tension unresolved)
         (Problem returns)

SYMBOLIC APPROACH (transcendent function):

    "I want freedom" ◄───tension───► "I need security"
                          │
                    [HELD, not solved]
                          │
                          ▼
              ┌───────────────────────┐
              │   SYMBOL EMERGES:     │
              │                       │
              │   "The Wandering      │
              │    Monk" (example)    │
              │                       │
              │   A figure who has    │
              │   absolute freedom    │
              │   WITHIN structure    │
              └───────────────────────┘
                          │
                          ▼
            New attitude: security-in-motion
            The opposition TRANSCENDED
            Not compromised but transformed
```

### Holding the Tension

```
THE WORK OF HOLDING TENSION
════════════════════════════════════════════════════════════

When opposites are activated, we want to ESCAPE:

ESCAPE ROUTES (avoid these):
┌─────────────────────────────────────────────────────────┐
│                                                         │
│  1. IDENTIFY with one side                             │
│     "I'm a freedom person, security is for cowards"    │
│                                                         │
│  2. REPRESS one side                                   │
│     Push it into shadow, pretend it doesn't exist      │
│                                                         │
│  3. RATIONALIZE a compromise                           │
│     "I'll be free on weekends"                         │
│     (tension still lives underneath)                   │
│                                                         │
│  4. PROJECT one side                                   │
│     "My partner is too needy for security"             │
│     (it's YOUR need, disowned)                         │
│                                                         │
│  5. DISTRACT from the tension                          │
│     Substances, busyness, entertainment                │
│     (avoidance, not resolution)                        │
│                                                         │
└─────────────────────────────────────────────────────────┘

THE WORK:
┌─────────────────────────────────────────────────────────┐
│                                                         │
│  1. ACKNOWLEDGE both sides fully                       │
│     "Part of me wants X. Part of me wants Y."          │
│                                                         │
│  2. FEEL the discomfort of opposition                  │
│     Let it be painful. Don't fix it.                   │
│                                                         │
│  3. WAIT without acting                                │
│     The unconscious needs time to work.                │
│                                                         │
│  4. ATTEND to dreams, images, synchronicities          │
│     The symbol may arrive from unconscious.            │
│                                                         │
│  5. RECEIVE the third thing when it comes              │
│     Often subtle. May arrive in dream or insight.      │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

---

## Psychic Energy (Libido)

Jung used "libido" differently than Freud—not as sexual energy but as general psychic energy or life force.

```
JUNG'S LIBIDO vs. FREUD'S LIBIDO
════════════════════════════════════════════════════════════

FREUD:                          JUNG:
Libido = Sexual energy          Libido = Life energy
                                       (neutral, like electricity)

Specifically erotic             Can be sexual, creative,
                                spiritual, intellectual

Seeks discharge                 Seeks expression and
                                transformation

One direction                   Multiple channels possible
(toward pleasure)               (canalization)

                    CW 8: "The Structure and Dynamics
                           of the Psyche"
```

### Energy Flow: Progression and Regression

```
LIBIDO FLOW PATTERNS
════════════════════════════════════════════════════════════

PROGRESSION (Energy flows outward):
┌─────────────────────────────────────────────────────────┐
│                                                         │
│   UNCONSCIOUS ─────────► CONSCIOUSNESS ─────────► WORLD │
│                                                         │
│   Energy moves from inner to outer                      │
│   Adaptation to external reality                        │
│   Achievement, goal-directed activity                   │
│   First half of life emphasis                           │
│                                                         │
│   HEALTHY: Engagement with life                         │
│   EXCESSIVE: Overwork, burnout, neglect of soul         │
│                                                         │
└─────────────────────────────────────────────────────────┘

REGRESSION (Energy flows inward):
┌─────────────────────────────────────────────────────────┐
│                                                         │
│   WORLD ─────────► CONSCIOUSNESS ─────────► UNCONSCIOUS │
│                                                         │
│   Energy moves from outer to inner                      │
│   Withdrawal from external demands                      │
│   Introversion, fantasy, reflection                     │
│   Second half of life emphasis                          │
│                                                         │
│   HEALTHY: Renewal, insight, dream work                 │
│   EXCESSIVE: Depression, withdrawal, stagnation         │
│                                                         │
└─────────────────────────────────────────────────────────┘

NATURAL CYCLE:
┌─────────────────────────────────────────────────────────┐
│                                                         │
│       PROGRESSION                                       │
│            │                                            │
│    ┌───────┴───────┐                                    │
│    │               │                                    │
│    ▼               │                                    │
│  OUTER    ◄────────┼────────►    INNER                  │
│  WORLD             │             WORLD                  │
│    │               │                                    │
│    │               ▲                                    │
│    └───────┬───────┘                                    │
│            │                                            │
│       REGRESSION                                        │
│                                                         │
│   Healthy psyche cycles between these                   │
│   Problems arise when stuck in either                   │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

### Canalization of Libido

```
CANALIZATION: Transforming Instinct into Culture
════════════════════════════════════════════════════════════

RAW INSTINCT                    CULTURAL FORM
    │                               ▲
    │                               │
    ▼                               │
┌─────────┐      SYMBOL         ┌───┴───┐
│ HUNGER  │ ──────────────────► │ RITUAL│
│         │    (transforms)     │ MEAL  │
└─────────┘                     └───────┘

┌─────────┐                     ┌───────┐
│ SEXUAL  │ ──────────────────► │ ART,  │
│ INSTINCT│    (transforms)     │ LOVE  │
└─────────┘                     └───────┘

┌─────────┐                     ┌───────┐
│AGGRESSION│ ─────────────────► │SPORT, │
│         │    (transforms)     │DEBATE │
└─────────┘                     └───────┘

The symbol acts as a TRANSFORMER—
like a waterfall (instinct) harnessed
by a turbine (symbol) to create
electricity (cultural energy).

"The symbol is not a sign that disguises something
generally known... it is an attempt to elucidate,
by means of analogy, something that still belongs
entirely to the domain of the unknown."
                                        - CW 15, para. 105
```

### Introversion and Extraversion as Energy Directions

```
ATTITUDE TYPES (Energy Direction)
════════════════════════════════════════════════════════════

EXTRAVERSION:                   INTROVERSION:
┌─────────────────────┐         ┌─────────────────────┐
│                     │         │                     │
│   Energy flows      │         │   Energy flows      │
│   OUTWARD to        │         │   INWARD to         │
│   objects           │         │   subject           │
│                     │         │                     │
│   ┌─────┐           │         │           ┌─────┐   │
│   │ EGO │───────►   │         │   ◄───────│ EGO │   │
│   └─────┘   World   │         │   Inner   └─────┘   │
│                     │         │   World             │
│                     │         │                     │
│   Object determines │         │   Subject determines│
│   response          │         │   response          │
│                     │         │                     │
│   Adapts to         │         │   Adapts outer to   │
│   environment       │         │   inner needs       │
│                     │         │                     │
└─────────────────────┘         └─────────────────────┘

BOTH attitudes exist in everyone.
The dominant conscious attitude is compensated
by the opposite attitude in the unconscious.

Extravert's shadow = introversion
Introvert's shadow = extraversion
```

---

## The Self (Expanded)

The Self is the most important archetype in Jung's system—the totality of the psyche and its organizing center.

```
SELF vs. EGO: Critical Distinction
════════════════════════════════════════════════════════════

COMMON CONFUSION: People often use "self" to mean ego
(as in "self-esteem," "self-improvement")

JUNGIAN DISTINCTION:

┌─────────────────────────────────────────────────────────┐
│                                                         │
│                        SELF                             │
│                  (The Whole Psyche)                     │
│                                                         │
│   ┌─────────────────────────────────────────────────┐  │
│   │                 UNCONSCIOUS                     │  │
│   │   ┌───────────────────────────────────────┐    │  │
│   │   │         CONSCIOUSNESS                 │    │  │
│   │   │                                       │    │  │
│   │   │           ┌───────┐                   │    │  │
│   │   │           │  EGO  │                   │    │  │
│   │   │           └───────┘                   │    │  │
│   │   │         (tiny part)                   │    │  │
│   │   │                                       │    │  │
│   │   └───────────────────────────────────────┘    │  │
│   │                                                │  │
│   └────────────────────────────────────────────────┘  │
│                                                         │
└─────────────────────────────────────────────────────────┘

EGO:
├── Center of consciousness only
├── What we usually mean by "I"
├── Partial, limited, mortal
└── Can be inflated or deflated

SELF:
├── Totality of conscious + unconscious
├── Both center AND circumference
├── The "God within" (not identical to God)
├── Paradoxical: both personal and transpersonal
└── Goal of individuation
```

### Self Symbols

```
SYMBOLS OF THE SELF
════════════════════════════════════════════════════════════

1. MANDALA (Most Common)
   ┌─────────────────────────────────────┐
   │                                     │
   │           ╭───────────╮             │
   │        ╭──┤           ├──╮          │
   │       │   │     ●     │   │         │
   │        ╰──┤           ├──╯          │
   │           ╰───────────╯             │
   │                                     │
   │   Circle with center                │
   │   Wholeness, unity                  │
   │   Often appears spontaneously       │
   │   in dreams during crisis           │
   │                                     │
   │   CW 9i: "Archetypes and the        │
   │          Collective Unconscious"    │
   │                                     │
   └─────────────────────────────────────┘

2. QUATERNITY (Four-fold)
   ┌─────────────────────────────────────┐
   │                                     │
   │              ┌───┐                  │
   │              │ N │                  │
   │         ┌────┴───┴────┐             │
   │         │             │             │
   │    ┌───┐│             │┌───┐        │
   │    │ W ├┤      ●      ├┤ E │        │
   │    └───┘│             │└───┘        │
   │         │             │             │
   │         └────┬───┬────┘             │
   │              │ S │                  │
   │              └───┘                  │
   │                                     │
   │   Four functions, four directions   │
   │   Cross, square, diamond            │
   │   Represents wholeness through      │
   │   integration of opposites          │
   │                                     │
   └─────────────────────────────────────┘

3. DIVINE CHILD
   ┌─────────────────────────────────────┐
   │                                     │
   │   Christ child, Horus, miraculous   │
   │   baby in dreams                    │
   │                                     │
   │   Represents:                       │
   │   ├── New beginning                 │
   │   ├── Potential wholeness           │
   │   ├── Union of opposites            │
   │   ├── The Self being born           │
   │   └── Future development            │
   │                                     │
   │   "The 'child' is all that is       │
   │   abandoned and exposed and at      │
   │   the same time divinely powerful"  │
   │                          - CW 9i    │
   │                                     │
   └─────────────────────────────────────┘

4. PHILOSOPHER'S STONE (Lapis)
   ┌─────────────────────────────────────┐
   │                                     │
   │   Alchemical goal—transforming      │
   │   base matter into gold             │
   │                                     │
   │   Psychologically:                  │
   │   ├── The integrated Self           │
   │   ├── Opus (the work) completed     │
   │   ├── Lead of ego → Gold of Self    │
   │   └── Never fully achieved          │
   │                                     │
   │   CW 12: "Psychology and Alchemy"   │
   │                                     │
   └─────────────────────────────────────┘

5. OTHER SELF SYMBOLS:
   ├── Wise old man/woman (personified Self)
   ├── King/Queen (ruling principle)
   ├── Christ, Buddha (archetypal Self)
   ├── Sun (center of system)
   ├── Diamond, pearl, treasure
   ├── Mountain (axis mundi)
   ├── Tree of life
   └── Sacred marriage (coniunctio)
```

### Experiencing the Self

```
HOW THE SELF IS EXPERIENCED
════════════════════════════════════════════════════════════

IN DREAMS:
├── Mandala, circle, or four-fold images
├── Divine or royal figures
├── Wise guides offering direction
├── Animals of wholeness (lion, eagle, elephant)
├── Numinous places (temples, mountains, centers)
├── Experiences of "more than I"
└── Big dreams with lasting impact

IN WAKING LIFE:
├── Synchronicities (meaningful coincidences)
├── Peak experiences (Maslow)
├── Mystical experiences
├── Creative inspiration from "beyond ego"
├── Sense of calling or vocation
├── Deep intuitions that prove true
└── Moments of profound meaning

IN SUFFERING:
├── "The Self is also the suffering"
├── Illness as initiatory experience
├── Depression as call from Self
├── Addiction as misguided Self-seeking
├── Loss that opens to deeper life
└── What destroys ego can serve Self

IN RELATIONSHIP:
├── Projection of Self onto beloved
├── Recognizing the divine in another
├── Love that transforms both
├── The "between" that is greater than two
└── Community as carrier of Self
```

### Self-Realization vs. Self-Actualization

```
SELF-REALIZATION (Jung) vs. SELF-ACTUALIZATION (Maslow)
════════════════════════════════════════════════════════════

SELF-ACTUALIZATION (Humanistic):
┌─────────────────────────────────────────────────────────┐
│                                                         │
│   Becoming your best self                               │
│   Fulfilling potential                                  │
│   Peak experiences                                      │
│   Growth, achievement, creativity                       │
│                                                         │
│   Focus: Ego development                                │
│   Goal: Optimal functioning                             │
│   Path: Upward, toward light                            │
│                                                         │
└─────────────────────────────────────────────────────────┘

SELF-REALIZATION (Jungian):
┌─────────────────────────────────────────────────────────┐
│                                                         │
│   Becoming WHOLE (not "best")                           │
│   Integrating shadow, not just light                    │
│   Includes suffering, failure, shadow                   │
│   Ego relativized to serve Self                         │
│                                                         │
│   Focus: Ego-Self relationship                          │
│   Goal: Wholeness (not perfection)                      │
│   Path: Downward into depths, then return              │
│                                                         │
│   "I'd rather be whole than good."                     │
│                            - attributed to Jung         │
│                                                         │
└─────────────────────────────────────────────────────────┘

KEY DIFFERENCE:
Self-actualization → Ego becomes its best
Self-realization → Ego discovers it is not the center
```

---

## References

- CW 2: "Experimental Researches" - Complex theory
- CW 6: "Psychological Types" - Persona, attitudes, functions
- CW 7: "Two Essays on Analytical Psychology" - Ego, persona, individuation
- CW 8: "The Structure and Dynamics of the Psyche" - Transcendent function, energy
- CW 9i: "Archetypes and the Collective Unconscious" - Shadow, anima/animus, Self
- CW 9ii: "Aion" - Self, ego-Self axis
- CW 12: "Psychology and Alchemy" - Self symbols, individuation imagery
- Edinger, Edward: "Ego and Archetype" - Ego-Self axis development
